; TICKLE - floppy cache tickler / read ahead
; public domain by Eric Auer eric -at- coli.uni-sb.de 2003.

; use this only with an int 13 floppy read cache loaded, like
; LBAcache with the FLOP command line option. Tickle should
; "tickle" the cache and speed up floppy access then. Without
; loaded cache, floppy access will be slowed down by tickle!

%define ticklebuf (ticklelist + 80)

	org 100h	; a .com file
	jmp install


ntickle:
	pushf
	call far [cs:i13old]	; *** call normal handler now
	jnc nerror
	cmp ah,6		; disk change?
	jnz nchanged
	jmp diskchange		; flush list, return disk change
nchanged:
	stc
nerror:	retf 2


nntickle:
	jmp far [cs:i13old]	; *** normal handler only


i13new:	cmp dl,3	; first 4 floppy drives?
	ja nntickle
	cmp ah,2	; read?
	jnz ntickle
	cmp ch,80	; only tickle first 80 cylinders
	jae ntickle
	cmp dh,0	; first head?
	jnz ytickle
	cmp cx,0001	; do NOT tickle boot sector: reading the
	jz ntickle	; boot sector can mean an update of the
ytickle:		; current geometry...
	push ax
	push bx
	mov bh,0
	mov bl,ch	; cylinder
	call getmask	; get bit for this drive / head
	test [cs:ticklelist+bx],al	; already tickled that one?
	pushf
	or [cs:ticklelist+bx],al	; will tickle that one
	popf
	pop bx
	pop ax
	jnz ntickle	; already tickled that one


tickle: mov byte [cs:ticklestat],0
	push es
	push bx
	push ax
	push cx

	push cx
	push dx
	push di
; -	; sometimes int 13.8 does not set ES:DI at all...
; -	mov di,cs
; -	mov es,di
; -	mov di,dummyddpt	; if BIOS does not set ES:DI...
	xor ax,ax
	mov es,ax
	les di,[es:78h]		; INT 1e vector (DDPT)
	; -
	mov ax,855h		; get drive parameters ("55" unused)
	; int 13h
	pushf
	call far [cs:i13old]	; *** get drive parameters
	mov ah,[es:di+4]	; DDPT (int 1e) sectors / track
; -	mov [cs:lastES],es
; -	mov [cs:lastDI],di
	pop di
	pop dx
	mov al,cl	; 6 lsb are "sectors per cylinder" value
	pop cx
	jc ticklebug	; do not tickle if that did not work
	and al,3fh	; max. sectors per cylinder for drive
	jz ticklebug	; do not tickle if no geometry known
	cmp ah,8
	jb ticklebug	; current sect. / cyl. at least 8 ?
	cmp ah,al
	ja ticklebug	; int 1e +4 (current sectors per cylinder) ok?
	mov al,ah	; prefer "current" over "max" sect. / cyl.
	; ES:DI AX BX CX DX returned by int 13.8: CX DX is geometry,
	; ES:DI int 1e (floppy params), AX 0, BL drive type
	cmp al,18
	jbe nmaxed
	mov al,18	; tickle only first 18 sectors
nmaxed: mov ah,2	; read to tickle
	mov bx,cs
	mov es,bx
	mov bx,ticklebuf
	mov cl,1	; from first sector on
	; DX and CH are still user values
	pushf
	call far [cs:i13old]	; *** call original handler
	jnc ticklenostat
	mov [cs:ticklestat],ah
ticklenostat:
	jmp short ticklenobug

ticklebug:
	mov cx,ax
	mov bx,ticklebugmsg1
	call printstring
	mov al,ch
	call printAL
	mov bx,ticklebugmsg2
	call printstring
	mov al,cl
	call printAL
	mov bx,ticklebugmsg3
	call printstring
	pop cx
	push cx
	mov al,ch
	call printAL
	mov al,cl
	call printAL
	mov bx,ticklebugmsg4
	call printstring

ticklenobug:
	pop cx
	pop ax
	pop bx
	pop es
	cmp byte [cs:ticklestat],6	; disk changed?
	jz diskchange
	jmp ntickle			; (other errors are ignored)


printstring:
	mov al,[cs:bx]
	cmp al,0
	jz printed
	inc bx
	int 29h	; fast DOS TTY
	jmp short printstring
printed:
	ret

printAL:
	push bx
	push ax
	shr al,1
	shr al,1
	shr al,1
	shr al,1
	and ax,15
	mov bx,ax
	mov al,[cs:hexdigits+bx]
	int 29h	; fast DOS TTY
	pop ax
	push ax
	and ax,15
	mov bx,ax
	mov al,[cs:hexdigits+bx]
	int 29h	; fast DOS TTY
	pop ax
	pop bx
	ret

diskchange:
	push ax
	call getmask	; get bit for this drive / head
	mov ah,al
	xor dh,1	; other head
	call getmask
	or al,ah
	xor dh,1	; normal head again
	not al		; invert mask (clear bits)
	push bx
	mov bx,ticklelist
ticklelistclear:
	and byte [cs:bx],al
	inc bx
	cmp bx,ticklebuf
	jb ticklelistclear
	pop bx
	pop ax
	;
	mov ah,6	; disk change
	stc
	retf +2


getmask:		; get bit corresponding to drive/head
	push cx
	mov cl,dl	; drive
	add cl,cl
	test dh,1	; head
	jz side0
side1:	inc cl
side0:	mov al,1
	shl al,cl
	pop cx
	ret


instdone:
	mov bx,ticklelist	; list AND buffer
	mov cx, (18 * 512) + 80
	xor ax,ax
clbuf:	mov [cs:bx],al
	inc bx
	loop clbuf
	;
	mov cl,4
	mov ax,3100h	; no errors
	mov dx,ticklelist + (18 * 512) + 80 + 15
	shr dx,cl	; get size in paragraphs
	int 21h		; go TSR
	

i13old		dd 0	; pointer to old int 13 handler
ticklestat	db 0	; status of last int 13 call

; - dummyddpt	db 0,0,0,0, 1,0,0,0, 0,0,0,0, 0	; empty dummy DDPT
; - lastDI	dw 0	; for debugging
; - lastES	dw 0	; for debugging

ticklebugmsg1	db 13,10,"TICKLE: DDPT[4]=",0
ticklebugmsg2	db " INT 13.8 CL&63=",0
ticklebugmsg3	db " INT 13.2 CX=",0
ticklebugmsg4	db " please tell eric -at- coli.uni-sb.de",13,10,0
hexdigits	db "0123456789abcdef"

	align 16
ticklelist	db 0	; status buffer for tickling,
		; 80 * (2*4) bits
; ticklebuf	; then data buffer for tickling,
		; 18 * 512 bytes

install:
	mov cl,4
	mov ax,cs
	shl ax,cl
	add ax,ticklebuf
	push ax		; 16 lsb of linear address of buffer start
	mov ax,cs
	shl ax,cl
	add ax,ticklebuf + (18 * 512)
	; 16 lsb of linear address of buffer end
	pop cx		; (pushed as ax above)
	sub ax,cx	; end-start
	test ax,ax
	js wrongpoint	; end-start negative? bad sign...

	mov dx,normalmsg
	mov ah,9	; show string
	int 21h
	;
	mov ax,3513h	; get old int 13 vector
	int 21h
	mov [cs:i13old],bx
	mov [cs:i13old+2],es
	;
	mov ax,2513h	; set new int 13 vector
	mov dx,cs
	mov ds,dx
	mov dx,i13new	; new handler
	int 21h
	;
	mov ax,cs
	mov ds,ax
	mov es,ax
	jmp instdone

wrongpoint:
	mov dx,wrongmsg
	mov ah,9	; show string
	int 21h
	mov ax,4c01h	; end with error
	int 21h

normalmsg	db "Floppy cache tickler loaded as TSR.",13,10
		db "This should speed up floppy reads IF loaded",13,10
		db "after an int 13 based floppy cache like",13,10
		db "LBACACHE FLOP ...",13,10,"$"

wrongmsg	db "9k tickle buffer crosses 64k DMA boundary,",13,10
		db "please load to another point in RAM.",13,10
		db "Not going TSR - aborting.",13,10,"$"
