/*  Replace

    Copyright (c) Express Software 1997.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <bios.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define EXIST 80

// G L O B A L S ////////////////////////////////////////////////////////////

char newpath[MAXPATH], pathname[MAXPATH],newname[MAXPATH], oldname[MAXPATH];
char drive[MAXDRIVE], subdir[MAXDIR], file[MAXFILE], ext[MAXEXT];
char helpname[MAXPATH], sourcename[MAXPATH];
enum ATTRIB { NORMAL, RDONLY, HIDDEN, SYSTEM = 4};

struct ffblk dta;

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[]);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    int len, done, count=0, wassubdir=1, loop, gavename=0, star=0, n_options, n_files, index, help_flag=0, aopt=0, popt=0, ropt=0, wopt=0, uopt=0, ch, find, result1, result2, xxx, yyy, src, dest;
    struct diskinfo_t di;
    struct diskfree_t space;
    struct stat buf1, buf2;
    struct find_t wr1, wr2;
    char *fileargs[64], *optargs[64], target[MAXPATH];
    unsigned attrib, drv;
    long freespace, src_len, dest_len;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options;
    ch=ch; di=di; xxx=xxx; yyy=yyy; result1=result1; result2=result2;

    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'A' || optargs[index][0] == 'a') goto resume;
        else if (optargs[index][0] == 'P' || optargs[index][0] == 'p') popt=1;
        else if (optargs[index][0] == 'R' || optargs[index][0] == 'r') ropt=1;
        else if (optargs[index][0] == 'W' || optargs[index][0] == 'w') wopt=1;
        else if (optargs[index][0] == 'U' || optargs[index][0] == 'u') uopt=1;
        else if (aopt && uopt)
            {
            printf("Cannot have /A and /U on the same command line\n");
            return 11;
            } // end else.
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            return 11;
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("Replaces files in a destination directory with files in a source directory\n"
               "that have the same name.\n\n"
               "Syntax: REPLACE [drive1:][path1]filename [drive2:][path2] [/A] [/P] [/R] [/W]\n"
               "  drive1:[path1]filename Specifies source or set of files\n"
               "  drive2:[path2]         Specifies the destination file\n"
               "  /A                     Adds new files to destination directory\n"
               "  /P                     Prompts for confirmation\n"
               "  /R                     Replaces read-only and unprotected files\n"
               "  /W                     Waits for you to insert a disk before copying\n"
               "  /U                     Replaces (updates) only those files on the\n"
               "                         destination directory that are older than those\n"
               "                         in the source directory\n");
        exit(1);
        } // end if.

    if (n_files < 2)
        {
        printf("Source path required\n");
        return 3;
        } // end if.

    if (aopt)
        {
        goto resume;
        } // end if.

    if (popt)
        {
        goto resume;
        } // end if.

    if (ropt)
        {
        _dos_getfileattr(fileargs[1], &attrib);
        if (attrib & _A_RDONLY)
            goto resume;
        else
            {
	    fprintf(stderr, "File is not read-only.  Cannot replace files.\n");
            return 5;
            } // end else.

        } // end if.

    if (wopt)
        {
        if ((di.drive = toupper(optargs[index][0]) - 'A') > 1)
            {
            printf("Drive specified is not a floppy disk drive\n");
            exit(1);
	    } // end if.
        else
            {
            printf("Insert diskette and press\nany key to continue...\n");
            ch = getch();
            goto resume;
            } // end else.

        } // end if.

    if (uopt)
        {
	goto resume;
	} // end if.

resume:
    strcpy(sourcename, fileargs[1]);
    strcpy(newpath, fileargs[2]);
    strcpy(subdir, fileargs[2]);
    strcpy(helpname, fileargs[2]);
    len = strlen(newpath);

    if (newpath[len-1] == 92)
        {
        wassubdir=0;
        if (len > 1)
            subdir[len-1] = 0;

        } // end if.
    else
        {
        newpath[len] = 92;
        newpath[len+1] = 0;
	} // end else.

    getcwd(newname,MAXPATH);

    // Suppose that user wants to rename a file.
    if (chdir(subdir) * wassubdir)
        {
        fnsplit(helpname,drive,subdir,file,ext);
        gavename=1;
        newpath[len] = 0;
        strcat(file,ext);
        len=strlen(subdir);
        subdir[len-1] = 0;
	wassubdir=0;
        for (loop=0;sourcename[loop]!=0;loop++)
            {
            if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                star++;

	    } // end for.

        for (loop=0;file[loop]!=0;loop++)
            {
            if ((file[loop]=='*') || (file[loop]=='?'))
                star++;

            } // end for.

        if (star)
            {
            printf("Invalid file argument\n");
            return 11;
            } // end if.

        } // end if.

    // This line is new for the second modification.
    chdir(newname);
    if (chdir(subdir) * wassubdir)
	{
        printf("Error changing directories\n");
        return 1;
        } // end if.

    chdir(newname);
    fnsplit(fileargs[1],drive,subdir,file,ext);
    sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));
    done = findfirst(fileargs[1],&dta,47);
    chdir(fileargs[2]);
    find = findfirst(fileargs[1], &dta, 47);
    if (find)
	{
	printf("No files replaced\n");
	chdir(newname);
	return 0;
	} // end if.
    else
	{
        // Check for available space if replacing.
        src = open(oldname,O_RDONLY);
        dest = open(newname,O_RDONLY);
        if (src != -1 && dest != -1)
            {
            src_len = filelength(src);
            dest_len = filelength(dest);
            drv = target[0] - 'A' + 1;
            _dos_getdiskfree(drv, &space);

            // Compute free space on disk.
            freespace = space.bytes_per_sector * space.sectors_per_cluster * (long)space.avail_clusters;

            // Check free space against space needed.
            if (src_len - dest_len > freespace)
                {
                // Print error and exit if not enough space.
                fprintf(stderr, "Destination disk is full\n");
                close(src);
                close(dest);
                return 8;
                } // end if.

            close(src);
            close(dest);
            } // end if.

	chdir(newname);
	while (!done)
	    {
	    if (popt)
		{
cont:
                printf("Add %s? (Y/N) ", strupr(fileargs[1]));
                ch = bdos(1, 0, 0) & 0x00ff;
                if ((ch == 'y') || (ch == 'Y'))
                    {
		    strcpy(oldname,pathname);   // Start "creating" the old filename.
                    strcat(oldname,dta.ff_name);
                    strupr(oldname);            // Make it all upper case for DOS.
                    strcpy(newname,newpath);    // Start "creating" destination filename.

                    if (!gavename)              // Real moving without rename.
                        {
                        strcat(newname,dta.ff_name);
                        } // end if.

                    strupr(newname);
                    if (rename(oldname,newname) == 0) // Try to rename the file.
			{
                        count++;                // Increment total files replaced.
                        printf("\n%s added\n", strupr(oldname));
			done=findnext(&dta);    // Look for next one.
			continue;
			} // end if.

		    if (_chmod(newname,1,0))
			printf("\nCannot replace files\n");
		    else
			if (remove(newname))
			    printf("\nError replacing files\n");
			else
			    continue;

		    done=findnext(&dta);
                    goto cont;
                    } // end if.
                else
                    {
                    printf("\n%s not added\n", strupr(fileargs[1]));
                    chdir(newname);
                    return 0;
		    } // end else.

		} // end if.

	    if (uopt)
		{
                // Get information about the two files.
                result1 = stat(oldname, &buf1);
                result2 = stat(newname, &buf2);
                xxx = _dos_findfirst(oldname, _A_NORMAL, &wr1);
                yyy = _dos_findfirst(newname, _A_NORMAL, &wr2);

                // If src.date < dest.date OR src.date == dest.date AND
                // src.time <= dest.time -- do nothing.
                if ((wr1.wr_date < wr2.wr_date) || ((wr1.wr_date == wr2.wr_date) && (buf1.st_atime <= buf2.st_atime)))
                    {
                    printf("There were no files to update\n");
                    return 0;
                    } // end if.

		} // end if.

	    strcpy(oldname,pathname);
	    strcat(oldname,dta.ff_name);
	    strupr(oldname);
	    strcpy(newname,newpath);
	    if (!gavename)
		{
		strcat(newname,dta.ff_name);
		} // end if.

	    strupr(newname);
	    if (rename(oldname,newname) == 0)
		{
		count++;
                printf("%s added\n", strupr(oldname));
		done=findnext(&dta);
		continue;
		} // end if.

	    if (_chmod(newname,1,0))
		printf("Cannot replace files\n");
            else
		if (remove(newname))
		    printf("Error replacing files\n");
		else
                    continue;

            done=findnext(&dta);
	    } // end while.

        } // end else.

    if (count == 0)
        {
        printf("File not found\n");
        return 2;
        } // end if.

    return 0;

} // end main.
