
/* gop
 * Gets options, similar to 'getopt'
 * Copyright (C) 1996, James Hall
 */

#include <stdio.h>

/* Symbolic constants. */

#define GOP_BAD (int) '?'	/* Return when option is bad. */
#define GOP_END (int) EOF	/* Return when end of options. */

#define GOP_SWITCH (int) '/'	/* Switch to turn "on" options. */
#define GOP_NULL (int) NULL	/* NULL */

/* Globals. */

int gop_ind = 1;		/* Which argv to investigage. */
int gop_char = 0;		/* Which argv[i] character. */

int 
gop (int argc, char **argv, const char *optstring)
{
  /* Variables. */

  int i;

  /* Investigate command line. */

  while (1)
    {

      /* Make sure we are looking at something. */

      if (argv[gop_ind][gop_char] == GOP_NULL)
	{
	  if ((gop_char > 0) && (argv[gop_ind][gop_char - 1] == GOP_SWITCH))
	    {
	      fprintf (stderr, "Incomplete argument list.\n");
	      return (GOP_BAD);
	    }
	  else
	    {
	      gop_ind++;
	      gop_char = 0;
	    }
	}

      /* Check against END conditions. */

      if (gop_ind >= argc)
	{
	  return (GOP_END);
	}

      if ((gop_char == 0) && (argv[gop_ind][gop_char] != GOP_SWITCH))
	{
	  return (GOP_END);
	}

      /* Check for a switch. */

      if (argv[gop_ind][gop_char] == GOP_SWITCH)
	{
	  gop_char++;
	}

      /* Look for an option. */

      if (argv[gop_ind][gop_char])
	{
	  for (i = 0; optstring[i]; i++)
	    {
	      if (argv[gop_ind][gop_char] == optstring[i])
		{
		  return (argv[gop_ind][gop_char++]);
		}
	    }

	  /* Not found. */

	  fprintf (stderr, "Bad option on command line.\n");
	  return (GOP_BAD);
	}
    }
}
