 ; This file is part of LBAcache, the 386/XMS DOS disk cache by
 ; Eric Auer (eric@coli.uni-sb.de), 2001-2003.

 ; LBAcache is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; LBAcache is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with LBAcache; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).

; LBAcache - a hard disk cache based on XMS, 386 only, 
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2003



	; Some of the status messages use meep: This uses
	; int 21 while running < 1 and int 10 tty otherwise.

	; parse command line and display it
	; input: pointer to "that device thing"

	; recognizes words:
	; / -> skipped
	; 1-2 digits -> set size in units of half ksectors
	;     *** NEW 11/2002 - was 1 digit, units of ksectors
	; BUF digit -> as digit
	; DRV letters -> enable caching only for letters
	;     (C..F, aliases are 0..3, unknown are ignored)
	; ?:\anything -> ignored (e.g. the first argument in
	;     .sys mode will be c:\path\to\lbacache.sys)
	; HELP or HLP or ? -> show help message
	; FLOP -> enable floppy caching for those of (A: B:)
	;     that have a change line (change detection)
	; STAK -> enable local stack (if the outside stack is
	;     very small, e.g. less than 200 bytes)
	; *** NEW 11/2002: stack is always enabled, arg is
	;     still parsed for backward compatibility...

	; new arguments to trigger former uncache functionality:
	; SYNC -> flush (empty) the stack for 0,1,0x80..0x87
	; INFO -> show some informations and statistics
	; STOP -> remove all instances as completely as possible
	; if one of those is given, the cache will not stay TSR,
	; but only do the requested task. Stop implies info.

	; anything else -> error message

	; defaults are using the size from datahead.asm sectors
	; and to cache all drives 0x80..0x87

args	dw 0x8000	; bits: 4 flush 2 info 1 stop , 8000 stack
			; 8 is "do nothing" (after showing help!)
	; *** NEW 11/2002: pre-enabled STAK. May add a DISABLE stack
	; command line argument at some time...


parsecommandline:
	push es
	push bx
	push eax
	push si
	les bx,[es:bx+0x12]	; here comes our pointer :-)
	push bx		; Sigh! StrTTY trashes registers, I forgot...
			; BX AX SI and maybe others...
	mov si,clmsg
		call strtty	; show a message on CS:SI
	pop bx

%ifdef DBGclptr
		mov ax,es
		push word clbufend	; empty silence *offset*
		call meep		; show es
		mov ax,bx
		push word clbufend	; empty silence *offset*
		call meep		; show bx
%endif

; -------------

	mov si,clbuf
clnextchar:
	mov al,[es:bx]	; read a char
	cmp al,10	; DOSsy EOF (sys) ?
	jz endcmdline
	cmp al,13	; DOSsy EOF (com/exe) ?
	jz endcmdline
	cmp al,0	; other EOF ?
	jz endcmdline
	cmp si,clbufend	; byte reserved for EOF ?
	jz endcmdline	; BAD LUCK for this char and the rest!

	cmp al,'a'	; upcase while copying
	jb clnoupcase
	cmp al,'z'
	ja clnoupcase
clupcase:
	sub al,32	; 'a'-'A'
clnoupcase:
	cmp al,9
	jnz clnomod	; <- ugh.. jNz of course!
	mov al,' '	; convert tab to space
clnomod:

	cmp al,' '	; compress N spaces to one
jnz clnospc
cmp [cs:si-1],al	; previous also a space?
jnz clnospc
	dec si	; simply move new space to old one
clnospc:
	mov [cs:si],al	; store that char
	inc si
	inc bx
	jmp short clnextchar

endcmdline:
	cmp si,clbuf	; check for trailing space only if
			; there is any command line!
	jbe clnotrail
	cmp byte [cs:si-1],' '	; remove the max 1
	jnz clnotrail	; (compressed) trailing space
	dec si
clnotrail:
	xor ax,ax
	mov [cs:si],ax	; terminate buffer (strongly!)

; --------------

clfeedback:	; show the user the command line
	mov si,clbuf
	call strtty	; print that buffer!
	mov si,crlfmsg
		call strtty	; print CRLF

	mov si,clbuf	; start parsing

; -------------

clnextword:
	mov eax,[cs:si]	; think big...
	shr eax,8	; remove 1st char
	cmp ax,':\'	; ignore those
	jz near clignored2
	mov eax,[cs:si]	; think big again
	inc si			; parse on... (skip " " etc.)
	cmp al,0	; eof?
	jz near clparsedone

	cmp al,'/'	; "/option" is the same as "option"
	jz clnextword

	cmp al,' '	; space?
	jz clnextword	; skip over space
	cmp ah,0
	jnz clnw
	mov ah,' '	; simplify this
clnw:
	cmp ax,'? '	; "?" help request?
	jz near clhelp
	cmp ah,' '	; one-letter/digit argument?
	jz near clonedigit
	cmp eax,'HELP'	; HELP request?
	jz clhelp2
	cmp eax,'HLP '
	jz clhelp2	; HLP request?
	cmp eax,'HLP'
	jz clhelp2	; same, but with a zero rather than a space

	cmp eax,'FLOP'
	jz clflop	; FLOP floppy cache enable?

	cmp eax,'STAK'
	jz clstak	; STAK local stack activate?

	cmp eax,'INFO'
	jz clinfo	; INFO (uncache) show info and statistics?
	cmp eax,'SYNC'
	jz clsync	; SYNC (uncache) flush and sync caches?
	cmp eax,'STOP'
	jz clstop	; STOP (uncache) remove all caches? (+info)

	cmp byte [cs:si+4-1],0	; end right after our 4 chars?
	jz cltowrongarg	; at eof while only arg expecting arg possible
	cmp byte [cs:si+4-2],0	; end right after only 3 chars?
	jz cltowrongarg	; argument with an argument but at end of
			; command line -> error!
clnonfin:
	cmp eax,'BUF '	; BUF digit behaves just as digit
	jz cl2onedigit
	cmp eax,'DRV '
	jz near cldrvsel	; DRV definition list
				; which drives to cache?
cltowrongarg:
	dec si		; show full arg
	jmp clwrongarg	; reject any other arguments

; --------------

clstak:	mov ax,0x8000
	jmp short clcommon4
clsync: mov ax,4
	jmp short clcommon4
clstop: mov ax,3
	jmp short clcommon4
clinfo: mov ax,2
clcommon4:
	or [cs:args],ax	; store the flag change
	add si,4-1	; skip the keyword
	jmp clnextword

; --------------

clhelp2:
	add si,4-1	; skip the "HELP"
clhelp:
	inc word [cs:clhelpflag]	; note the help request
	or word [cs:args],8		; do not go TSR then!
clhx:	jmp clnextword

; --------------

clflop:
	add si,4-1	; skip the "FLOP"
	or word [cs:fddstat],3		; wish: cache A: -and- B:
					; findgeom may disable this later
					; in setup if no good drives found!
	mov ax,si	; save
	mov si,clfddmsg			; tell that floppies will be cached
		call strtty		; show string
	mov si,ax	; restore
	jmp clnextword_cr

; --------------

clignored2:
	add si,3	; skip "X:\"
clignored:
	mov al,[cs:si]
	cmp al,' '		; ... until space ...
	jz clhx
	cmp al,0
	jz clhx			; ... or end of line encountered
	inc si
	jmp short clignored	; parse on

; --------------

cl2onedigit:
	add si,4+1-1	; skip the "BUF "
clonedigit:		; VERY simple argument: factor 0..99 for
			; 0..99 * 512 sectors buffer (0->special)
	dec si		; <- rewind to arg!
	mov bx,29*2048	; *** NEW MAX sect. value for arg=0 (was 512)
	mov ax,[cs:si]
	cmp ah,'0'
	jb singledigit	; no digit follows - only one digit found
	cmp ah,'9'
	ja singledigit	; no digit follows - only one digit found
twodigits:		; *** NEW 11/2002: allow two digits
	sub ax,'00'
	cmp al,9
	ja clwrongarg	; second was a digit but first was not
	xchg al,ah	; low byte is first, more significant digit!
	aad 10		; AAD: ah = 0, al = ah*10 + al
	jmp short digitfactor

singledigit:
	cmp al,'0'
	jb clwrongarg
	cmp al,'9'
	ja clwrongarg
	sub al,'0'	; digit to number
digitfactor:
	or al,al	; % value 0 has predefined meaning!
	jz clonegoodarg	; % use predefined (not default) special value
			; % (currently 29*2048 sectors, see above)
	mov ah,0
	shl ax,9	; *** factor is 512 (was 1024)
	mov bx,ax	; the selected cache size
clonegoodarg:
	mov [cs:sectors],bx	; write the new buffer size,
				; overriding the default size
	inc si		; skip optional unit description
	jmp clignored	; skip until space/eof

; --------------

clwrongarg:			; we did not understand this one!
	push si

%ifdef CLDBG
	mov ax,[cs:si]		; really verbose...
		push word clrejmsg	; *offset*
		call meep	; complain about syntax
		mov si,crlfmsg	; start a new line
		call strtty
%else
	mov si,clrejmsg
		call strtty	; complain about syntax
%endif

	pop si
clwalp:
	mov al,[cs:si]
	cmp al,' '		; arg sep...
	jz clwadone
	cmp al,0
	jz clwadone		; ...or line end
	push bx
	mov bx,0007
	mov ah,0x0e
		int 0x10	; show one char using TTY
	pop bx
	inc si			; next char
	jmp short clwalp	; show the illegal arg char by char
clwadone:
	mov ax,si	; save si
	mov si,crlfmsg
		call strtty	; CRLF
	mov si,ax	; restore si
	inc word [cs:clhelpflag]	; wrong argument -> show help!
	or word [cs:args],8	; *** do not go TSR, only show help. 7/03
	jmp clnextword		; parse on anyway, check for more errors.

; --------------

cldrvsel:			; cache only drives in (list)
	add si,4-1		; list starts here, skip "DRV "
	xor ax,ax
	mov [cs:drvselmask],ax	; assume NO drives cached,
cldslp:				; add drives from user list
	mov al,[cs:si]
	inc si			; parse on
	cmp al,' '
	jz cldsdone		; list ends here
	cmp al,0
	jz cldsdone		; ...or here
	cmp al,'0'
	jb cldslp		; ignore < '0'
	cmp al,'J'
	ja cldslp		; *** ignore > 'J' (was F)
	cmp al,'7'
	jbe cldsdig		; *** 0..7 digit (was ..3)
	cmp al,'C'
	jb cldslp		; ignore between digits and 'B'
	sub al,'C'
	add al,'0'
cldsdig:
	sub al,'0'		; digit to byte (0..3)
	push cx
	mov cl,al
; ***	shl cl,2		; old: 4 bits per drive
; ***	mov ax,0x1000		; old: 0x80...
; ***	shr ax,cl		; old: select drive in mask
	mov ax,1		; *** new: start with LSB
	shl ax,cl		; *** LSB=0x80 .. MSB=0x8F
	pop cx
	or [cs:drvselmask],ax	; activate caching for this drive
					; *** ... if cacheable!
	jmp short cldslp	; go on with list

cldsdone:
	mov ax,[cs:drvselmask]
; ***		push word cldrvmsg
; ***		call meep	; tell user about drive list
; *** NEW 11/2002: use a bitmask
	push si
	push bx
	mov si,cldrvmsg
	test ax,0x00ff		; ANY drive?
	jz clnodriveatall
		call strtty
	mov si,ax		; bitmask
	mov al,'C'		; name of lowest bit
cldrivedisploop:
	test si,1		; this bit set???
	jz clnotthisdrive
	mov bx,7	; print a char using the bios
	mov ah,0x0e	; TTY
		int 0x10
clnotthisdrive:
	shr si,1		; next bit
	inc al			; next name
	cmp al,'J'		; all drives done?
	jbe cldrivedisploop	; loop
	jmp short cllisteddrives
clnodriveatall:
	mov si,clnodrvmsg
		call strtty	; DRV NULL selected...
cllisteddrives:
	pop bx
	pop si
; *** END of 11/2002 display enhancement


clnextword_cr:
	mov ax,si	; save si
	mov si,crlfmsg
		call strtty	; CRLF
	mov si,ax	; restore si
	jmp clnextword		; parse on

; --------------

clparsedone:
	mov ax,[cs:clhelpflag]
	or ax,ax		; do we have to educate the user?
	jz clpd
	mov si,clhelpmsg
		call strtty	; show help message
clpd:
	pop si
	pop eax
	pop bx
	pop es
	ret

clmsg		db "LBAcache command line: ",0

clspc		db "X "	; a nonspace and a space for the space
			; compressor also removes leading spaces!
clbuf		db "C:\PFAD\LBACACHE.SYS 3KSECTORS DRV CF "
		db "BUF 4KSECTORS... X:\stupid-comment-trick"
clbufend	db 0,0	; dos uses an 0a char as eof, but we write 00

cldrvmsg	db "Caching drives: ",0
	; drvselmask was 0x1111 for CDEF, LSB for F:...
	; *** NEW 11/2002: drastically changed drvselmask.
	; Now LSB stands for C:, next bit for D:, and so on.
clnodrvmsg	db "No harddisks cached.",0
	; *** NEW 11/2002

clfddmsg	db "Caching floppies.",0
	; see above - fddstat word - and dispatch.asm and setup.asm
	; *** 11/2002: shortened.

clrejmsg	db "Unknown command line option: ",0

clhelpflag	dw 0	; set to display help

clhelpmsg:	; changed 7/2003 based on a suggestion by Aitor S. Merino
	db "To load:     LBACACHE  [[BUF] size]  [DRV drivelist] [FLOP]",13,10
	db "When loaded: LBACACHE  [INFO] [SYNC] [STOP]",13,10
	db "To get help: LBACACHE  [HELP] [/?]",13,10
	db "Options:",13,10
	db "  BUF size  Specifies the buffer size. Maximum value: 99 Default: 8.",13,10
	db "            Unit is 256k (in XMS), so default is to use 2 MB XMS.",13,10
	db "  DRV list  Selects which harddisks are cached. NULL means none. Examples:",13,10
	db "            C     caches all partitions on the first harddisk only.",13,10
	db "            023   caches BIOS drives 80h, 82h, 83h - first, third and",13,10
	db "                  fourth harddisk (hda, hdc, hdd in Linux terminology).",13,10
        db "            Allowed drives are 0..7 (BIOS 80h..87h). Alias names: C..J.",13,10
	db "  FLOP      Enable the floppy cache (A: and B:, autodetected). To speed up",13,10
	db "            floppy use, load TICKLE, too! Please report if FLOP has bugs.",13,10
	db "  INFO      Shows cache statistics and details about resident LBAcaches.",13,10
	db "  SYNC      Synchronizes all running LBAcache buffers for all drives. As",13,10
	db "            LBAcache never delays writes, SYNC only is 'forget cached data'.",13,10
	db "  STOP      Shuts down all running LBAcache instances and frees allocated",13,10
	db "            XMS. DOS RAM only freed for .com instances, not for .sys ones.",13,10
	db 0

	; NEW 11/2002: buffer size is now up to 99*512 sectors, was 9*1024.
	; db ">>> Arguments like X:\YYY\ZZZ... are ignored.",13,10
	; db ">>> Number of wrong args and help requests=",0
	; *** NEW 11/2002: talk about 8 drives everywhere
