; LBAcache - a hard disk cache based on XMS, 386 only, 
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2002




; The main NEWI13 dispatcher which calls
; hdread and hdwrite which now come in two versions,
; one for LBA and one for CHS - {hd,lba}{read,write}
; we can return from those to either enderr, endok, or oldint
; for now, several functions cause the cache to be flushed or shut
; down completely - no support for flushing only one drive yet!
; also contains callold, which calls the original int 0x13


%ifdef DBG
gtmsg	db '>',0
%endif

lbagenerr	db "LBA: secnum past 4G or >127 sectors or...",0
staknesterr	db "LBACACHE: int. STAK nest!? otherss=",0

fddstat		dw 0x0000	; 1/2 enable a/b caching,
				; 10/20 signal a/b changed
				; 100/200 a/b caching allowed mask

localsp	dw 0	; is nonzero if we have a local stack
localss	dw 0	; local ss (is nonzero while stack is busy)
othersp dw 0
otherss dw 0

enderr:	mov ah,4
	stc
	jmp i13retf	; LEAVE


	; the new INT 0x13 handler follows (only for 80386+XMS),
	; it is reached from the real hook which is as early in
	; CS as possible (int13new)
NEWI13:	or dl,dl	; only cache hard drives for now
	js short to_hard

	cmp dl,1	; FLOPPY: cache floppy B ?
	ja t_old_
	jb to_drv_a
	test word [cs:fddstat],2	; B enabled?
	jnz carefordrive
t_old_:	jmp oldint_pure			; 2..7f or disabled
					; do NOT use after local
					; cache setup!
to_drv_a:
	test word [cs:fddstat],1	; A enabled?
	jz t_old_
	jmp short carefordrive	; yes, A cached

to_hard:		; harddisk...

	cmp dl,0x87	; *** only cache first 8 drives (3 bits...)
	ja short t_old_	; *** was 4 drives, 2 bits

drvcheck:		; check our what-to-cache-mask
	push cx
	push ax
; ***	mov ax,0x1000	; 0x80...
	mov ax,1	; *** LSB = drive 0x80
	mov cl,dl
	and cl,7	; *** 8 drives to be handled (was 4)
; ***	shl cl,2	; 4 bits per drive
; ***	shr ax,cl	; select drive in mask
	shl ax,cl	; *** select drive in mask
	test [cs:drvselmask],ax
	pop ax
	pop cx
	jz short t_old_	; no drive we care for



carefordrive:
	test word [cs:localsp],0xffff	; local stack available?
	jz care_nostack
	test word [cs:localss],0xffff	; local stack already busy?
	jz care_stack
		push ax
		mov ax,[cs:otherss]
		push word staknesterr
		call meep
		pop ax
	mov ah,0x80	; BUSY (0xAA for hard disks?)
	stc
	RETF +2		; that was quite unfriendly...

care_stack:
	mov [cs:localss],cs		; prepare...
	mov [cs:otherss],ss		; ...to use...
	mov [cs:othersp],sp		; ...our local...
	lss sp,[cs:localsp]		; ...stack!

care_nostack:

	test dl,0x80		; floppy or hard disk?
	jnz care_hard

care_flop:			; only reached for A and B
	push ax
	mov ax,0x1600		; disk changed? test always...
		call callold	; call old int 13
	pop ax
	jnc cared4flop		; NC: disk not changed

%ifndef NOFLUSHFDD

		call flushone	; flush cache if disk changed



; ***		push word fisherr	; warn about flushing/disk change
; ***		call meep		; (for floppy debugging)

%endif

	push ax
	mov ax,0x10		; A changed
	cmp dl,0
	jz a_chg
	mov ax,0x20		; B changed
a_chg:	or word [cs:fddstat],ax	; store the disk change info for the user!
	pop ax
cared4flop:
	cmp ah,5
	jb near rwmaybe	; 0..4 are most normal
	jz near fishy	; flush if format request (5)
	cmp ah,8
	jb near fishyfishy	; bailout if other odd format requests (6,7)

		; int 13.05 and 13.09 can modify the GEOMETRY
		; (from tables on int 1e,41,46) implicitly,
		; int 13.17, 13.18, (13.06 ?) explicitly
		; modify the geometry (but 13.17 never beyond 1.44m)

	jz near UNSTACK_oldint
	jmp short cared_flop


care_hard:
	cmp ah,5        ; block format requests (5/6/7)
	jb near rwmaybe	; 0..4 are most normal
	cmp ah,8	; another format thing
	jb near enderr		; *** make format things return an error!
	jz near UNSTACK_oldint



cared_flop:
	cmp ah,9
	jz short fishyfishy	; REALLY bail out if geometry is changed!
	cmp ah,0x0b
	jz short fishy	; flush cache if somebody writes long (with ECC)!


	cmp ah,0x16		; floppy change info request
	jnz no_chg_chk
	cmp dl,1
	ja no_chg_chk
	jb a_chg_chk
b_chg_chk:
	test word [cs:fddstat],0x20	; B changed?
	jz no_chg_chk			; bios can say no (or yes!) itself
	and word [cs:fddstat],0xffdf	; not(0x20)
chged:	
	mov ah,6		; this is reported only once per event,
	stc			; even if repeatedly asked for
	jmp i13retf		; LEAVE, tell that the disk
				; has been changed
a_chg_chk:
	test word [cs:fddstat],0x10	; A changed?
	jz no_chg_chk			; bios can say no (or yes!) itself
	and word [cs:fddstat],0xffef	; not(0x10)
	jmp short chged

no_chg_chk:

	cmp ah,0x18		; set media type for format: better bail out?
	jz short fishyfishy	; func 0x18 is also used for harmless stuff
	cmp ah,0x22
	jz short fishy  	; PS/2 write incompatible to NEXTSEC
	cmp ah,0x21
	jz short fishy  	; PS/2 read incompatible to NEXTSEC
				; int 13 extensions: int 13.41.(bx)55aa.dl
				; 1 - func 42 43 44 47 48 (64bit lba)
				; 2 - func 45 46 48 49 (removable media)
				;     (... int 15.52.dl before eject ...)
				; 4 - func 48 4e (edd: set pio/dma mode...)
	cmp ah,0x42			; 64bit LBA read
	jz short lbacheck
	cmp ah,0x43			; 64bit LBA write
	jz short lbacheck
				; 44: verify 45: lock/unlock (counting)
				; 46: eject 47: seek 48: get drive param
				; (to buffer at dssi, init with: W size,
				; W flags=0, ... - size is 1a/1e/42,
				; flag will be OR of ... 4 removable ...)
	cmp ah,0x46
	jz short fishy	; flush cache if media is ejected (int 13 ext)
				; also related to our 64bit LBA stuff!
	cmp ah,0x4a
	jz short fishyfishy	; STOP cache if CD emulates boot drive
	cmp ah,0x4c
	jz short fishyfishy	; STOP cache if CD emulates boot drive
	cmp ah,0x50		; <- AH
	jae short fishyfishy	; stop cache completely any undocumented stuff
	jmp UNSTACK_oldint	; other mixed stuff is not even worth flushing
	; *** this "dangerous function enumeration" is potentially dangerous

; --------------

fishyfishy:	; UNINSTALL because resetting the drive params may bend geom
		; or because of other weird things happening
	mov word [cs:running],2	; SHUT DOWN cache completely
				; (no need to modify any enable masks)
		push word fish2err
		call meep	; complain a bit...
	jmp UNSTACK_oldint	; [running] may be reset with a debugger,
				; so XMS and DOS RAM are not released

; --------------

fishy:		; FLUSH because a call with maybe unpredictable side effects
		; was detected!
		call flushone	; only flush ONE drive
		push word fisherr
		call meep	; complain again!
	jmp UNSTACK_oldint

; --------------

rwmaybe:
			; add call meep here if you are REALLY curious
%ifdef DBG
		push word gtmsg	; DBG *offset*
		call meep	; DBG *** REALLY CURIOUS ***
%endif
	cmp ah,3
	jz near hdwrite	; copy to cache if write
	cmp ah,2
	jz near hdread	; read, maybe from cache
	jmp UNSTACK_oldint	; other 0..4 are safe

; --------------

lbacheck:		; check if we can handle this kind of LBA call
	cmp dword [ds:si+4],-1
	jz short fishyLBA	; the buffer pointer is a 64bit flat
			; pointer rather than a DOS pointer -> FLUSH
	cmp dword [ds:si+12],0
	jnz short fishyLBA	; the sector number is above 4 G,
			; our 32bit LBA code cannot handle it: FLUSH
	test word [ds:si+2],0xff80
	jnz fishyLBA		; do not allow more than 0x7f sectors
			; in one call, at least not yet!
	push eax
	movzx eax,word [ds:si+2]	; number of blocks
	add eax,[ds:si+8]		; sector number (low part)
	pop eax
	jc short fishyLBA	; will hit the 4 G 32bit boundary
	jz short fishyLBA	; ... exactly, so we FLUSH
%ifdef DBG
		push word gtmsg	; DBG *offset*
		call meep	; DBG *** REALLY CURIOUS ***
%endif
	cmp ah,0x42
	jz near lbaread		; 64bit LBA read
	; cmp ah,0x43
	; jz near lbawrite	; 64bit LBA write
	; jmp UNSTACK_oldint
	jmp lbawrite		; if it is no read, it is a write!

fishyLBA:
		push word lbagenerr
		call meep	; warn user...
	jmp fishy		; go to FLUSH

; --------------

oldint_pure:	jmp far [cs:oldvec]

; --------------

callold:
        pushf	; calls the original int 0x13
	call far [cs:oldvec]
	ret

; --------------

i13retf:	; must use THIS to do the local stack handling properly!
	pushf
	test word [cs:localss],0xffff	; are we using the local stack?
	jz short i13r_nostack
	popf
	mov word [cs:localss],0		; mark local stack as free
	lss sp,[cs:othersp]		; continue with caller stack
	RETF +2

i13r_nostack:
	popf
	RETF +2

UNSTACK_oldint:				; close the local stack before
	pushf				; continuing with oldint!!!
	test word [cs:localss],0xffff	; are we using the local stack?
	jz short oldi_nostack
	popf
	mov word [cs:localss],0		; mark local stack as free
	lss sp,[cs:othersp]		; continue with caller stack
	jmp short oldint_pure

oldi_nostack:
	popf
	jmp short oldint_pure

; --------------

	;   a (read long), c (seek), d (recalib+reset), 10 (ready?), 
	;   11 (recalib), 12 (ram diag), 13 (disk diag), 14 (ctrl diag)
	; e/f are r/w XT sector buffer, used for diagnostic and format...
	; 19: park - would be a good time to flush if we had a write cache
	; 1a: esdi format, but also harmless stuff. 1b...: mixed
	; 1f: syquest lock door... 20...: atapi stuff and mixed, very mixed!
	; 21/22: read/write multiple (ps/2): dh lsb are 2 more cyl bits!

	; 41... are the next REAL (generic) functions: int 13 ext
	; 42 - reading with 64bit LBA - is kind of harmless for us, ignored!
	; (43 write, 44 verify, 45 lock/unlock, 46 eject, 47 seek, 48 info,
	;  49 changed?, 4a..4d bootable cdrom, 4e set dma/pio)
	; above 4f is again very mixed

