; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2002

; CHS-only version has been discontinued in 2002.



; %define DBGbinsel 1	; debug binsel!

	; status table handling functions
	; DUMB BUT FAST experimental version:
	; bin is always equal sector number modulo sectors (or none)!

	; NEW 27.11.2001: shrink table by using one entry for more
	; than one sector! (2..16 - MS SmartDrv has the same range)
	; BUGFIX 24.01.2002: flush* were the wrong size!

	; *** NEW 09.11.2002: shrink factor changed from 4 to 8


%define BINSHR 3	; *** 8 sectors per bin
%define BINMASK 0xf8	; *** 8 sectors per bin -> NOT ((1<<BINSHR)-1)
%define BINBITS 7	; *** 8 sectors per bin -> (1<<BINSHR) - 1
%define BINTABFORM 0x0303	; *** encoding THIS table format:
	; ^- HI is log2(sectors/bin), LO is log2(bytes/bin)
	; *** values for 4 s/bin were 2,0xfc,3,0x0203 (*** was 0x202)
	; *** values for 8 s/bin are  3,0xf8,7,0x0303


%imacro BINBCHECK 1	; takes the command as arg, works on bitfield
	push ax		; Byte SI+6, Bit AL
	push cx
	and al,BINBITS	; <- ADJUST
	mov cl,al
	mov ax,1
	shl ax,cl	; select the bit in the bitmask
	%1 [ds:si+6],ax	; or: fill bin
			; test: return NZ if bin is filled
	pop cx
	pop ax
%endmacro


	; Format is - per entry - D sector low, B drive, B LRU,
	; W bitfield: lsb for first sector in group

        ; Input is sector number EAX drive DL, output (xms) bin AX            
	; findbin:  finds a bin for a location (stc if not found),
	; newbin:   allocates a new bin for a given location,
	;           flushing old bins if needed.
	;           (main bin selection "intelligence" !)
	; flush:    empties all slots
	; flushone: empties all slots for drive DL only
	; telltabsize: (returns carry on error)
	;           tells in AX how big a table for AX sectors will be
	;           WARNING: sectors > fff0 will break other things!

%ifdef DBGbinsel
fndbin1msg	db '@?',0
fndbinmsg	db '@',0
newbin1msg	db '!?',0
newbinmsg	db '!',0
bitsetmsg	db '+',0
%endif

telltabsize:	; calculate size of the table for THIS format
	mov word [cs:tabsz],BINTABFORM	; encoding THIS table format:
;	cmp ax,8191	;   ^- HI: shr BINSHR, LO: add 8>>BINSHR
;	ja ttsx		; clipping: for BINSHR 0: 7500, else more
	movzx eax,ax	; *** NEW 24.01.2002
	add eax,BINBITS		; <- round up!
	shr eax,BINSHR		; <- ADJUST
	shl eax,3		; 8 bytes per table entry
	cmp eax,0xf000		; maximum allowed size (CY if more)
	cmc			; complement carry: "jb NC / jnb CY"
	ret

; -------------

hashme: 	; find si as pointer into [table], given
		; table length [sectors] entries, 8 (EIGHT) bytes
	push edx	; each, for sector number EAX and drive DL
	push eax
	push ecx
	;
	cmp dl,0x80	; compress bits of drive number a bit
	jb hshdsk
	and dl,0x7f
	add dl,4	; (ca. 4 floppies)
hshdsk:	movzx edx,dl	; derived from drive number
	shl edx,9	; move to some part of those 32bits
	xor eax,edx	; XOR in drive into the sector number
	;
	shr eax,BINSHR	; all entries of one main entry hash same!
	movzx ecx,word [cs:sectors]	; usually 512*N,
	shr ecx,BINSHR	; <- ADJUST!
	xor edx,edx	; N in 1,2,4,6,8,10,12,14,16,18 (>100 thus)
	dec ecx		; ... has more interesting prime factors(*)
	div ecx		; MODULO sectors as "HASH" (edx:eax<0x10000!)
	;
			;  ... use remainder as index ...
	lea edx,[table+edx*8]	; 8by (EIGHT) per MAIN entry
			; still 8 byte per main entry, but 1<<BINSHR
			; sub entries now share one main entry!
	mov si,dx	; pointer to MAIN entry
	;
	pop ecx
	pop eax
	pop edx		; (*) note: 1 bin left unused, we may as well
	ret		; do a sectors-- on install...

; -------------

findbin:	; find bin matching location EAX DL,
	push ds	; return carry or bin in AX (and update LRU)
	  push cs
	  pop ds
	push si
%ifdef DBGbinsel
		push word fndbin1msg
		call meep
%endif
	  push ax
	and al,BINMASK		; <- ADJUST
	call hashme		; EAX.DL -> SI (main entry)
	cmp eax,[ds:si]		; sector number HI the same?
	  pop ax
	jnz short fbmiss
	cmp dl,[ds:si+4]	; drive the same?
	jnz short fbmiss

fb_inbin:		; it is the right bin, but is it filled?
	BINBCHECK test	; <- a macro... return NZ if bin is filled
	jz short fbmiss

	cmp byte [ds:si+5],0xfe	; check LRU / importance and
	jae fbmax		; increase it (with saturation at -2)
	inc byte [ds:si+5]
fbmax:	sub si,table
	shr si,3	; each table entry is 8 (EIGHT) byte, 64 bit
	shl si,BINSHR	; main entries -> sub entries (shl is correct)
	and ax,BINBITS	; bin LSB are taken from sector number
	add ax,si	; now we have the correct SUB ENTRY / BIN
	clc		; indicate success
	jmp short fbout	; return the bin found (in AX)
fbmiss:
	mov ax,-1	; (should not be used anyway)
	stc		; indicate failure
fbout:
	pop si
	pop ds
%ifdef DBGbinsel
		push word fndbinmsg	; DBG *offset*
		call meep		; DBG
%endif
	ret

; -------------

newbin:		; find a new free bin or reuse a bin
		; for location EAX DL. update LRU, return bin in AX
	push ds
	  push cs
	  pop ds
	push si
%ifdef DBGbinsel
		push word newbin1msg
		call meep
%endif
	  push ax
	and al,BINMASK		; <- ADJUST
	call hashme		; EAX.DL -> SI - dumb but fast:
				; ALWAYS throw away existing sectors
	cmp [ds:si],eax		; right sector range?
	  pop ax
	jnz nbreallynew		; else overwrite entry completely
	cmp byte [ds:si+4],dl	; right drive?
	jnz nbreallynew		; else overwrite entry completely

nbonlybitset:			; <- the bin is there but not filled
%ifdef DBGbinsel
		push word bitsetmsg
		call meep
%endif
nbsetthatbit:
	cmp byte [ds:si+5],0xfe	; so we inc the LRU / importance
	jae short nbsat		; with saturation at -2
	inc byte [ds:si+5]
nbsat:	BINBCHECK or		; <- SET the bit in the fill-list
	jmp short nbdone

nbreallynew:			; use a completely fresh entry
	mov [ds:si],eax		; store sector number in table
	and byte [ds:si],BINMASK	; <- ADJUST
	mov [ds:si+4],dl	; store drive number in table
	mov byte [ds:si+5],1	; initialize LRU / importance with 1
	mov word [ds:si+6],0	; initialize reserved word with 0
	jmp short nbsetthatbit	; do not forget to fill THIS sector
				; into the newly created bin!

nbdone:
	sub si,table
	shr si,3	; each table entry is 8 (EIGHT) byte, 64 bit !
	shl si,BINSHR	; main entries -> sub entries (shl is correct)
	and ax,BINBITS	; bin LSB are taken from sector number
	add ax,si	; now we have the correct SUB ENTRY / BIN
%ifdef DBGbinsel
		push word newbinmsg	; DBG *offset*
		call meep		; DBG
%endif
	pop si
	pop ds
	ret

; -------------

flushone:	; flushing only one drive (DL)
	push ds	; mark all table entries for that
	push di	; drive as empty, using THIS table format
	push cx
	push eax
	mov cx,cs
	mov ds,cx
	mov cx,[ds:sectors]
	add cx,BINBITS	; <- ADJUST: round up
	shr cx,BINSHR	; <- ADJUST: sub entries -> main entries
	mov di,table
	xor eax,eax
flolp:	cmp [di+4],dl
	jnz flon	; do not flush other drives
	dec eax
	mov [di],eax	; sector -1
	inc eax
	mov [di+4],eax	; drive/LRU/bits 0
flon:	add di,8
	loop flolp
	pop eax
	pop cx
	pop di
	pop ds
	ret

; -------------

flush:	push ds ; flushing/initializing the whole table
	push di	; marks every table entry as empty
		; using THIS table format now!
	push cx
	push eax
	mov cx,cs
	mov ds,cx
	mov cx,[ds:sectors]
	add cx,BINBITS	; <- ADJUST: round up
	shr cx,BINSHR	; <- ADJUST: sub entries -> main entries
	mov di,table
	xor eax,eax
flloop:	dec eax
	mov [ds:di],eax	; sector -1
	add di,4
	inc eax
	mov [ds:di],eax	; drive 0, LRU 0 (unused), bits 0
	add di,4
	loop flloop
	pop eax
	pop cx
	pop di
	pop ds
	ret

