{$A-,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{$M 1024,0,0}
Program ScanKeyboard;
{
 Programm zur automatischen Erstellung einer Tastatur-bersetzungstabelle.
}
Uses Inter2,Crt;

Var    ScanCode    : Byte;
       IntHand     : IntHandObj;
       TransTab    : Text;
       TastStat    : Byte absolute 0:$417;
       TastStat2   : Byte;
       Taste       : Byte;
       Shift1,Shift2,
       Ctrl,Alt,Scroll,
       Num,Caps,Ins: Byte;
       Regs        : Registers;
       SaveStat    : Byte;
       Int15Called : Boolean;

{$F+}
Procedure SetScanCode(Var R : Registers);
Begin
   With R Do
      If AH=$4F Then AL:=ScanCode;
   Int15Called:=True;
End;
{$F-}

Procedure PutChar;
Var    S           : Byte;
Begin
   Int15Called:=False;
   S:=ScanCode;
   Intr($9,Regs);
   TastStat2:=TastStat;
   ScanCode:=S or $80;
   Intr($9,Regs);
   ScanCode:=57;                       { Send one space. }
   Intr($9,Regs);
   ScanCode:=ScanCode or $80;
   Intr($9,Regs);
   ScanCode:=S;
   If not Int15Called Then Writeln('malfunction: int 15h not called by keyboard driver. ');
End;

Procedure SetAltGr;
Var    S           : Byte;
Begin
   S:=ScanCode;
   ScanCode:=224;
   Intr($9,Regs);
   ScanCode:=56;
   Intr($9,Regs);
   ScanCode:=S;
End;

Procedure ResetAltGr;
Var    S           : Byte;
Begin
   S:=ScanCode;
   ScanCode:=224;
   Intr($9,Regs);
   ScanCode:=56+128;
   Intr($9,Regs);
   ScanCode:=S;
End;

Function GetKey : Char;
Var    C           : Char;
Begin
   C:=ReadKey;
   If (C=' ') and not Keypressed Then GetKey:=#0
   Else
   Begin
      GetKey:=C;
      While Keypressed Do C:=ReadKey;
   End;
End;

Procedure Scankey(Key : Byte);
Var    Chars       : Array[0..4] of Char;
       B           : Byte;
       N,C,S       : Boolean;
       NCS         : String;
Begin
   TastStat:=0;                        { No Shifts set. }
   ScanCode:=Key;
   PutChar;
   If Not Int15Called Then Exit;
   If TastStat2>0 Then                 { Test if key is shiftkey. }
   Begin
      If Odd(TastStat2 shr 7) Then Ins:=Key
      Else If Odd(TastStat2 shr 6) Then Caps:=Key
      Else If Odd(TastStat2 shr 5) Then Num:=Key
      Else If Odd(TastStat2 shr 4) Then Scroll:=Key
      Else If Odd(TastStat2 shr 3) Then Alt:=Key
      Else If Odd(TastStat2 shr 2) Then Ctrl:=Key
      Else If Odd(TastStat2 shr 1) Then Shift2:=Key
      Else If Odd(TastStat2) Then Shift1:=Key;
      Char(B):=GetKey;
   End
   Else
   Begin
      If Keypressed Then Chars[0]:=getkey     { store ascii code if no shiftkey. }
                    Else Chars[0]:=#0;
      TastStat:=2;
      For B:=1 To 4 Do                 { read ascii codes with different shifts. }
      Begin
         PutChar;
         If Keypressed Then Chars[B]:=getkey
                       Else Chars[B]:=#0;
         TastStat:=TastStat shl 1;
         If B=3 Then
         Begin
            TastStat:=0;
            SetAltGr;
         End;
      End;
      ResetAltGr;

      Write(TransTab,Key:3);

      If Keypressed Then Char(B):=GetKey;

      TastStat:=$10;                      { test if key is influenced by CAPS,NUM or SCROLL. }
      PutChar;
      S:=Keypressed and (getkey<>Chars[0]);
      TastStat:=$20;
      PutChar;
      N:=Keypressed and (getkey<>Chars[0]);
      TastStat:=$40;
      PutChar;
      C:=Keypressed and (getkey<>Chars[0]);

      NCS:='';
      If N Then NCS:=NCS+'N';
      If C Then NCS:=NCS+'C';
      IF S Then NCS:=NCS+'S';
      Write(TransTab,NCS);
      For B:=0 To 4 Do
      Begin
         If (Chars[B]>#35) Then Write(TransTab,Chars[B]:2)
                           Else Write(TransTab,' #',Byte(Chars[B]));
      End;
      Writeln(TransTab);
   End;
End;

Begin
   num:=0; caps:=0; scroll:=0; alt:=0; ctrl:=0; shift1:=0; shift2:=0; ins:=0;
   SaveStat:=TastStat;
   Assign(TransTab,Paramstr(1)+'.KEY');
   Rewrite(TransTab);
   Writeln(TransTab,'[KEYS]');
   IntHand.Enqueue($15,SetScanCode,DSeg);
   Taste:=1;
   Repeat
      Write('Reading key: ',Taste:3,#13);
      ScanKey(Taste);
      Inc(Taste);
   Until (Taste=100) or not Int15Called;
   IntHand.Dequeue;
   Writeln(TransTab,'[SHIFTS]');
   Writeln(TransTab,Shift1,Shift2:4,Ctrl:4,Alt:4,Scroll:4,Num:4,Caps:4,Ins:4);
   Close(TransTab);
   TastStat:=SaveStat;
End.