{$Define Turbo6} { Remove this line if using earlier version! }
Unit XKeyb_PI;
{$S-,R-,G+}
{
ͻ
                                                                    
  Unit for the simple use of the program interface of XKeyb.        
                                                                    
  For Turbo Pascal by 5.5 and XKeyb by 1.10.                        
                                                                    
  (C) 1992 Dietmar Hhmann.                                         
                                                                    
ͼ
}

Interface

Var    Fehler      : Word;                  { Error number. 0 if no error. }
                                            { Possible errors: }
                                            {   1 : XString number not allowed. }
                                            {   2 : XString memory is full. }
                                            {   3 : Searched XString not defined. }
                                            {   4 : Illegal key number. }
                                            {   5 : Key buffer full. }
                                            {   6 : No XFunction free. }
                                            {   7 : Illegal calling convention. }
                                            {   8 : XFunction not occupied. }
                                            {   9 : Illegal mapping code. }
                                            {  10 : Unknown command. }
       StPtr,StSeg : Word;

Function TestInstalled : Word;
{ 0=No keyboard driver, 1=Not XKeyb, >2 XKeyb Version number ($110 = 1.10). }

Procedure XKeybOn(B : Boolean);
{ False: Disable XKeyb, keyboard translation will be taken by BIOS. }
{ True : Keyboard translation will be done by XKeyb. }

Procedure SetKey(KeyNum,Normal,Shift,Control,Alt,AltGr,Status : Byte);
{ Remap key KeyNum. }
{ Normal,Shift,Control,Alt,AltGr : Mappings for the 5 keyboard levels. }
{ Status: Bit 0:  1 = Key is influenced by SCROLL-Lock. }
{         Bit 1:  1 = Key is influenced by NUM-Lock. }
{         Bit 2:  1 = Key is influenced by CAPS-Lock. }
{         Bit 3:  1 = Key is occupied on level 5 (with Alt Gr) with an extension string. }
{         Bit 4:  1 = Key is occupied on level 4 (with Alt) with an XStr. }
{         Bit 5:  1 = Key is occupied on level 3 (with Control) with an XStr. }
{         Bit 6:  1 = Taste ist auf Ebene 2 (mit Shift / Num-/Caps-/Scroll-Lock) with an XStr. }
{         Bit 7:  1 = Taste ist auf Ebene 1 (ohne Alles) mit XStr belegt. }

{ Je nach dem entsprechenden Bit in Status enthalten Normal,Shift,Control ... }
{ ASCII-Werte oder Nummern von XStrings / XFunctions. }

Procedure GetKey(KeyNum:Byte; Var Normal,Shift,Control,Alt,AltGr,Status : Byte);
{ Gegenstck zu SetKey. }

Procedure WaitForKey(Var VScan,PScan,Ascii,Keystat,Ebene : Byte);
{ Wartet auf einen Tastendruck. (Ungeachtet der Tasten, die evtl. noch im Buffer warten.) }
{ Liefert den virtuellen Scancode (VScan), den physikalischen Scancode (PScan), }
{ der mit der Tastennummer identisch ist, den Ascii-Wert (Ascii), mit dem die Taste belegt ist, }
{ den Tastaturstatus (KeyStat) zum Zeitpunkt des Tastendrucks und die Tastaturebene (Ebene) zurck. }

Procedure PutKey(Ascii,Scan : Byte);
{ Legt das bergebene Ascii-Zeichen und den Scancode im Tastaturbuffer ab. }

Procedure SetXStr(Num : Byte; XStr : String);
{ Definiert den XString mit der Nummer Num. Dabei werden KEINE Sonderzeichen }
{ (\n,\[CD] etc.) bersetzt! }
{ Im Normalfall werden alle Zeichen im XString als Ascii-Zeichen interpretiert. }
{ Der dazugehrige Scancode ist NICHT im String enthalten. }
{ Enthlt der String das Zeichen #0, so wird das darauffolgende Zeichen als }
{ Scancode interpretiert. }
{ Fr Num sind die Werte 1-200 zulssig. }

Procedure GetXStr(Num : Byte; Var XStr : String);
{ Gegenstck zu SetXStr. }

Procedure SetXFunc(Var Num : Byte; CallConv : Byte; Adresse : Pointer);
{ Definiert eine XFunction. }
{ Num enthlt die Nummer der XFunction sie mu im Bereich von 201-240 liegen. }
{ Alternativ kann als Nummr 0 angegeben werden, dann verwendet XKeyb eine freie }
{ XFunction (sofern vorhanden) und gibt deren Nummer zurck. }
{ Wenn Num ungleich 0 ist wird NICHT berprft, ob die entsprechende XFunction frei ist! }

{ CallConv enthlt die Aufrufkonvention. Sie bedeutet: }
{  0 : Funktion sofort aufrufen. }
{  1 : Funktion beim nchsten Int16 (Tastaturinterrupt) aufrufen. }
{  2 : Kein Aufruf. Nur Flag setzen. }

{ Adresse enthlt entweder (CallConv 0 oder 1) die Adresse einer Routine, die }
{ beim Auslsen der XFunction aufgerufen wird, oder (CallConv = 2) die Adresse }
{ eines Words, in das beim Auslsen der XFunction der Scancode (V) der Taste und }
{ der Tastaturstatus eingetragen werden. ( HI = Scancode, Lo = KeyStat) }
{ Wenn eine Routine aufgerufen wird, so werden Scancode und Tastaturstatus als }
{ Parameter bergeben. Die Routine solte folgendermaen definiert sein: }
{ {$F+}
{ Procedure XYZ(ABCD : Word);     }
{ Begin                           }
{    ...                          }
{ End;                            }

{ oder:                           }
{ Type AbcRec = Record            }
{                  Stat,Scan : Byte; }
{               End;              }
{ {$F+}
{ Procedure XYZ(ABCD : AbcRec);   }
{ Begin                           }
{    ...                          }
{ End;                            }


Procedure ClearXFunc(Num : Byte);
{ Lscht die XFunction-Definition mit der Nummer Num. }

Procedure SetTable(P : Pointer);
{ Setzt die Adresse der bersetzungstabelle. Damit ist es mglich, mehrere Tastaturbelegungen }
{ im Speicher zu halten und bei Bedarf umzuschalten. }
{ Die Tabelle ist 600 Byte gro und hat folgenden Aufbau: }
{ 100 Eintrge (Tasten 1-100)  6 Byte. }
{ Jeder Eintrag besteht aus den Belegungen fr die 5 Tastaturebenen, angefangen }
{ bei Ebene 1 und dem Statusbyte als letztem Byte im Eintrag. }
{ Vor dem Umschalten sollte ggf. die Adresse der internen Tabelle gesichert werden. }

Function TableAdr : Pointer;
{ Liefert die Adresse der aktuellen bersetzungstabelle. }

Function LastXStr : Byte;
{ Ermittelt die Nummer des letzten definierten XStrings. }

Function ShiftTabAdr : Pointer;
{ Ermittelt die Adresse der Liste mit den Scancodes der Shifttasten. }
{ Diese Liste enthlt sieben Bytes mit den Scancodes: }
{ Shift1 Shift2 Control Alt Scroll Num Caps Insert }

Function CombiTabAdr : Pointer;
{ Adresse der Tabelle mit den Kombinationszeichen holen. }
{ Die Tabelle besitzt folgenden Aufbau: }
{ 1. Eintrag }
{      Erstes Zeichen der Kombination (z.B. `) }
{      Anzahl der folgenden Kombinationen (z.B. 2) }
{      1. Kombination }
{           Zweites Zeichen der Kombination (z.B. a) }
{           Resultierendes Zeichen (z.B. ) }
{      2. Kombination }
{           Zweites Zeichen der Kombination (z.B. i) }
{           Resultierendes Zeichen (z.B. ) }
{ 2. Eintrag }
{      ... }
{ Nach dem letzten Eintrag folgt ein Null-Byte. }

{ Die Gre der Tabelle betrgt, einschlielich Null-Byte, 192 Byte. }


{$IfDef Turbo6}         { Enter und Leave stehen nur bei Turbo 6.0 bereit! }
Procedure Enter;
{ XFunktions mssen, wenn sie auf ihre Variablen zugreifen wollen, das DS-Register }
{ auf den Anfang des eigenen Datensegments setzen. Auerdem ist es sinnvoll, }
{ auf einen eigenen Stack umzuschalten. Beides erledigt Enter. Dabei wird der }
{ Stack auf den normalen TP-Stack initialisiert. }

Procedure Leave;
{ Eine XFunction, die beim Eintritt Enter aufgerufen hat, mu vor dem Rcksprung }
{ Leave aufrufen, um DS und SS:SP wieder auf die alten Werte zu setzen. }
{$EndIf}


Implementation

Uses Dos;

Var    Regs        : Registers;
Type   PtrTyp      = Record
                        Ofs,Seg : Word;
                     End;

Function TestInstalled : Word;
Begin
   With Regs Do
   Begin
      AX:=$AD80;
      Intr($2F,Regs);
      If AL<>$FF Then
      Begin
         TestInstalled:=0;                  { Kein Tastaturtreiber installiert, bzw. keiner, der sich auf diesem Weg meldet. }
         Exit;
      End;
      If BX=$584B Then TestInstalled:=CX    { XKeyb installiert. CX enthlt die Versionsnummer. }
                  Else TestInstalled:=1;    { Anderer Tastaturtreiber installiert. (Vermutlich KEYB.COM) }
   End;
End;

Procedure XKeybOn;
Begin
   With Regs Do
   Begin
      AX:=$AD82;
      If B Then BL:=$FF
           Else BL:=0;
      Intr($2F,Regs);
      If Odd(Flags) Then Fehler:=9          { XKeyb liefert den Fehlercode in AX, nicht jedoch KEYB.COM ! }
                    Else Fehler:=0;
   End;
End;

Procedure SetKey;
Begin
   With Regs Do
   Begin
      AX:=$AD90;
      DI:=KeyNum;
      BH:=Status;
      BL:=Normal;
      CH:=Shift;
      CL:=Control;
      DH:=Alt;
      DL:=AltGr;
      Intr($2F,Regs);
      Fehler:=AX;
   End;
End;

Procedure GetKey;
Begin
   With Regs Do
   Begin
      AX:=$AD91;
      DI:=KeyNum;
      Intr($2F,Regs);
      Status:=BH;
      Normal:=BL;
      Shift:=CH;
      Control:=CL;
      Alt:=DH;
      AltGr:=DL;
      Fehler:=AX;
   End;
End;

Procedure WaitForKey(Var VScan,PScan,Ascii,Keystat,Ebene : Byte);
Begin
   With Regs Do
   Begin
      AX:=$AD94;
      Intr($2F,Regs);
      VScan:=AH;
      PScan:=BH;
      Ascii:=AL;
      KeyStat:=BL;
      Ebene:=DH;
      Fehler:=0;
   End;
End;

Procedure PutKey;
Begin
   With Regs Do
   Begin
      AX:=$AD95;
      BH:=Scan;
      BL:=Ascii;
      Intr($2F,Regs);
      Fehler:=AX;
   End;
End;

Procedure SetXStr;
Begin
   With Regs Do
   Begin
      AX:=$AD96;
      BL:=Num;
      ES:=Seg(XStr);
      DI:=Ofs(XStr);
      Intr($2F,Regs);
      Fehler:=AX;
   End;
End;

Procedure GetXStr;
Begin
   With Regs Do
   Begin
      AX:=$AD97;
      BL:=Num;
      ES:=Seg(XStr);
      DI:=Ofs(XStr);
      Intr($2F,Regs);
      Fehler:=AX;
   End;
End;

Procedure SetXFunc;
Begin
   With Regs Do
   Begin
      AX:=$AD98;
      BL:=Num;
      BH:=CallConv;
      ES:=PtrTyp(Adresse).Seg;
      DI:=PtrTyp(Adresse).Ofs;
      Intr($2F,Regs);
      Fehler:=AX;
      Num:=BL;
   End;
End;

Procedure ClearXFunc;
Begin
   With Regs Do
   Begin
      AX:=$AD99;
      BL:=Num;
      Intr($2F,Regs);
      Fehler:=AX;
   End;
End;

Procedure SetTable;
Begin
   With Regs Do
   Begin
      AX:=$AD9A;
      ES:=PtrTyp(P).Seg;
      DI:=PtrTyp(P).Ofs;
      Intr($2F,Regs);
      Fehler:=Ax;
   End;
End;

Function TableAdr : Pointer;
Begin
   With Regs Do
   Begin
      AX:=$AD9B;
      Intr($2F,Regs);
      Fehler:=AX;
      TableAdr:=Ptr(ES,DI);
   End;
End;

Function LastXStr : Byte;
Begin
   With Regs Do
   Begin
      AX:=$AD9C;
      Intr($2F,Regs);
      LastXStr:=BL;
      Fehler:=0;
   End;
End;

Function ShiftTabAdr : Pointer;
Begin
   With Regs Do
   Begin
      AX:=$AD9E;
      Intr($2F,Regs);
      Fehler:=AX;
      ShiftTabAdr:=Ptr(ES,DI);
   End;
End;

Function CombiTabAdr : Pointer;
Begin
   With Regs Do
   Begin
      AX:=$AD9D;
      Intr($2F,Regs);
      Fehler:=AX;
      CombiTabAdr:=Ptr(ES,DI);
   End;
End;

{$IfDef Turbo6}
{$F+}
Procedure Enter;
Begin
   ASM
      Pop BP
      Pop Ax            { Rcksprungadresse nach BX:AX. }
      Pop Bx

      Mov SI,[BP+6]     { Parameter d. XFunc-Routine. }

      Push DS           { Datensegment sichern. }

      Push SS           { Akt. Stackadresse nach ES:DI. }
      Pop  ES
      Mov  DI,SP

      CLI               { Jetzt keine Interrupts. }
      Mov Cx,Seg @Data
      Mov DS,Cx
      Mov SS,StSeg
      Mov SP,StPtr
      STI               { Neuer Stack bereit, es kann weitergehen. }

      Push Es
      Push Di           { Alte Stackadresse sichern. }

      Push SI           { Parameter d. XFunc-Routine. }
      Push 0            { [Rcksprungadr. d. XFunc-Routine]. }
      Push 0
      Push BP
      Mov  BP,SP

      Push Bx           { Rcksprungadresse zur XFunc-Routine. }
      Push Ax
      Ret               { Und zurck. }
   End;
End;

Procedure Leave;
Begin
   ASM
      Pop BP

      Pop AX            { Rcksprungadresse nach XFunc-Routine in BX:AX. }
      Pop BX

      Pop BP

      Pop CX            { 2 Dummy - Words & Parameter d. XFunc-Routine. }
      Pop CX
      Pop CX

      Pop Di            { Alte Stackadresse. }
      Pop Es


      CLI
      Push Es
      Pop  SS
      Mov  SP,Di
      STI               { Wieder alter Stack. }

      Pop  DS           { Altes Datensegment. }

      Push Bx
      Push Ax
      Ret
   End;
End;
{$F-}
{$EndIf}

Begin
   StPtr:=SPtr; StSeg:=SSeg;      { Stackadresse fr Enter sichern. }
End.