/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  savefs.c
// Module Description:  Save File System Function
*/


#include "format.h"
#include "floppy.h"
#include "driveio.h"
#include "btstrct.h"


/* Convert Huge number into 4 LMB integer values */
void Convert_Huge_To_Integers(unsigned long number)
{
  integer1=(unsigned)((number >> 0 ) & 0xff);
  integer2=(unsigned)((number >> 8 ) & 0xff);
  integer3=(unsigned)((number >> 16) & 0xff);
  integer4=(unsigned)((number >> 24) & 0xff);
}

/* Save the old file system for possible recovery with unformat */
void Save_File_System()
{
  int bad_boot_sector=TRUE;
  int end_of_root_directory_flag;

  unsigned  loop=512;

  unsigned char mirror_map[5120];

  unsigned pointer=0;

  unsigned long offset_from_end=5;

  unsigned long destination_sector;
  unsigned long source_sector;

  unsigned long mirror_beginning;
  unsigned long mirror_map_beginning;
  unsigned long mirror_map_size;
  unsigned long mirror_size;
  unsigned long number_of_bytes_in_mirror_map;
  unsigned long number_of_logical_sectors_on_drive;
  unsigned long number_of_root_directory_entries;

  unsigned long beginning_of_fat;
  unsigned long beginning_of_root_directory;

  unsigned long sectors_per_fat;

  unsigned long end_of_root_directory;

  unsigned long temp_buffer_1=0;
  unsigned long temp_buffer_2=0;
  unsigned long temp_buffer_3=0;
  unsigned long temp_buffer_4=0;

  unsigned int sector_flag[] = {
  'A','M','S','E','S','L','I','F','V','A','S',
  'R','O','R','I','M','E','S','A','E','P'};

  unsigned int mirror_map_header[] = {
  ':','\\','M','I','R','R','O','R','.','F','I','L'};

  if(param.drive_type==HARD) offset_from_end=20;

  /* Get the boot sector, compute the FAT size, compute the root dir size,*/
  /* and get the end of the logical drive. */
  Drive_IO(READ,0,1);

  if(  (sector_buffer[510]==0x55) && (sector_buffer[511]==0xaa) )
    {
    temp_buffer_1=sector_buffer[17];
    temp_buffer_2=sector_buffer[18];
    number_of_root_directory_entries=temp_buffer_1|(temp_buffer_2<<8);

    temp_buffer_1=sector_buffer[19];
    temp_buffer_2=sector_buffer[20];
    number_of_logical_sectors_on_drive=temp_buffer_1|(temp_buffer_2<<8);

    if(number_of_logical_sectors_on_drive==0)
      {
      temp_buffer_1=sector_buffer[32];
      temp_buffer_2=sector_buffer[33];
      temp_buffer_3=sector_buffer[34];
      temp_buffer_4=sector_buffer[35];

      number_of_logical_sectors_on_drive=temp_buffer_1|(temp_buffer_2<<8)
       |(temp_buffer_3<<16)|(temp_buffer_4<<24);
      }

    temp_buffer_1=sector_buffer[22];
    temp_buffer_2=sector_buffer[23];
    sectors_per_fat=temp_buffer_1|(temp_buffer_2<<8);

    bad_boot_sector=FALSE;
    }

  /* If the boot sector is not any good, don't save the file system. */
  if(bad_boot_sector==FALSE)
    {
    printf(" Saving UNFORMAT information\n");

    /* Compute the beginning sector of the mirror map and the size of */
    /* the mirror image.     */
    mirror_size=1+sectors_per_fat+(number_of_root_directory_entries/16);

    mirror_map_size=(mirror_size/64)+1;

    mirror_beginning=(number_of_logical_sectors_on_drive-mirror_size)-offset_from_end;
    mirror_map_beginning=mirror_beginning-mirror_map_size;

    /* Compute the locations of the first FAT and the root directory */
    beginning_of_fat=sectors_per_fat+1;

    beginning_of_root_directory=(sectors_per_fat*2)+1;
    end_of_root_directory=beginning_of_root_directory+(number_of_root_directory_entries/16)-1;

    /* Write the mirror map pointer to the last sectors of the logical drive. */
    Clear_Sector_Buffer();

    Convert_Huge_To_Integers(mirror_map_beginning);

    sector_buffer[0]=integer1;
    sector_buffer[1]=integer2;
    sector_buffer[2]=integer3;
    sector_buffer[3]=integer4;

    pointer=4;

    do                                 /* Add pointer sector flag */
      {
      sector_buffer[pointer]=sector_flag[pointer-4];
      pointer++;
      }while(pointer<=24);

    if(debug_prog==TRUE)
      {
      printf("[DEBUG]  Writing mirror map pointer to sector->  %ld\n",
       (number_of_logical_sectors_on_drive-offset_from_end));
      printf("[DEBUG]  Writing mirror map beginning at sector->  %ld\n",mirror_map_beginning);
      }

    Drive_IO(WRITE,(number_of_logical_sectors_on_drive-offset_from_end),1);

    /* Create the mirror map and copy the file system to the mirror.  */
    Clear_Sector_Buffer();

    pointer=0;

    do                                 /* Clear mirror_map buffer */
      {
      mirror_map[pointer]=0;
      pointer++;
      }while(pointer<=5119);

    mirror_map[0]=param.drive_letter[0];

    pointer=1;

    do                                 /* Add mirror map header */
      {
      mirror_map[pointer]=mirror_map_header[pointer-1];
      pointer++;
      }while(pointer<=12);

				       /* Main mirror map creation */
				       /* and copying loop.        */
    pointer=84;
    source_sector=0;
    destination_sector=mirror_beginning;

    end_of_root_directory_flag=FALSE;
    number_of_bytes_in_mirror_map=0;

    do
      {
      if( (source_sector>0) && (source_sector<beginning_of_fat) )
       source_sector=beginning_of_fat;

      /* Copy mirror image one sector at a time */
      Drive_IO(READ,source_sector,1);

      Drive_IO(WRITE,destination_sector,1);

      /* Enter mapping information into mirror map buffer */

      Convert_Huge_To_Integers(source_sector);

      mirror_map[pointer+0]=integer1;
      mirror_map[pointer+1]=integer2;
      mirror_map[pointer+2]=integer3;
      mirror_map[pointer+3]=integer4;

      Convert_Huge_To_Integers(destination_sector);

      mirror_map[pointer+4]=integer1;
      mirror_map[pointer+5]=integer2;
      mirror_map[pointer+6]=integer3;
      mirror_map[pointer+7]=integer4;

      source_sector++;
      destination_sector++;
      pointer=pointer+8;
      number_of_bytes_in_mirror_map=pointer;

      if(source_sector>=end_of_root_directory) end_of_root_directory_flag=TRUE;

      }while(end_of_root_directory_flag==FALSE);

    /* Write trailer in mirror map */

    mirror_map[pointer+0]=0;
    mirror_map[pointer+1]=0;
    mirror_map[pointer+2]=0;
    mirror_map[pointer+3]=0;

    /* Write the mirror map onto the disk.   */

    pointer=0;
    destination_sector=mirror_map_beginning;

    do
      {
      loop=0;

      do                               /* Load the sector buffer */
	{
	sector_buffer[loop]=mirror_map[pointer+loop];

	loop++;
	}while(loop<512);

      Drive_IO(WRITE,destination_sector,1);      /* Write the mirror map   */
						 /* sector.                */
      destination_sector++;
      pointer=pointer+512;
      }while(pointer < number_of_bytes_in_mirror_map);

    }
  else
    {
    printf(" Drive appears unformatted, UNFORMAT information not saved.\n");
    }
}
