/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  recordbc.c
// Module Description:  Bad Sector Recording Functions
*/

#include "format.h"
#include "floppy.h"
#include "driveio.h"
#include "btstrct.h"


void Record_Bad_Clusters_FAT12();
void Record_Bad_Clusters_FAT16();
void Record_Bad_Clusters_FAT32();


int Is_Even(unsigned long number)
{
  if( (number&0x01)>0 ) return FALSE;

  return(TRUE);
}

void Record_Bad_Clusters()
{
  if(param.fat_type==FAT12) Record_Bad_Clusters_FAT12();
  if(param.fat_type==FAT16) Record_Bad_Clusters_FAT16();
  if(param.fat_type==FAT32) Record_Bad_Clusters_FAT32();
}

void Record_Bad_Clusters_FAT12()
{
  unsigned long bad_cluster;

  int index;
  int sector;
  int fat_index;

  /* Is the first bad sector in the boot sector, fat tables, or directory? */
  if(bad_sector_map[0]<param.first_data_sector)
    {
    /* Terminate the program...the disk is not usable. */

    /* NEEDS A BETTER ERROR THAN THIS! */
    printf("\nUnusable media...format terminated.\n");
    exit(1);
    }

  /* Clear the FAT12 FAT table buffer. */
  index=0;
  do
    {
    fat12_fat[index]=0;
    index++;
    }while(index<=6144);

  /* Create initial entries. */
  fat12_fat[0]=drive_specs[param.media_type].media_descriptor;
  fat12_fat[1]=0xff;
  fat12_fat[2]=0xff;

  /* Now, translate the bad sector map into the FAT12 table. */

  index=0;
  do
    {
    /* Translate the sector into a cluster number. */
    bad_cluster=( ( (bad_sector_map[index]-param.first_data_sector)
     +drive_specs[param.media_type].sectors_per_cluster)
     /drive_specs[param.media_type].sectors_per_cluster)+1;


    /* Determine if the cluster is even or odd and record the cluster  */
    /* in the FAT table buffer.                                        */
    if(TRUE==Is_Even(bad_cluster) )
      {
      fat12_fat[((bad_cluster*3/2)+0)]=0xf7;
      fat12_fat[((bad_cluster*3/2)+1)]=0x0f | fat12_fat[((bad_cluster*3/2)+1)];
      }
    else
      {
      fat12_fat[((bad_cluster*3/2)+2)]=0xff;
      fat12_fat[((bad_cluster*3/2)+1)]=0x70 | fat12_fat[((bad_cluster*3/2)+1)];
      }

    index++;
    }while(bad_sector_map[index]!=0);

  /* Finally, write the fat table buffer to the disk...twice. */
  index=0;
  sector=1;
  fat_index=0;
  do
    {
    index=0;
    do
      {
      sector_buffer[index]=fat12_fat[fat_index];

      index++;
      fat_index++;
      }while(index<512);

    if(debug_prog==TRUE) printf("[DEBUG]  Recording FAT Sector->  %3d\n",sector);
    Drive_IO(WRITE,sector,1);
    Drive_IO(WRITE,(sector+drive_specs[param.media_type].sectors_per_fat),1);
    sector++;
    }while(sector<(drive_specs[param.media_type].sectors_per_fat+1));
}

void Record_Bad_Clusters_FAT16()
{
  int bad_sector_map_index;
  int current_fat_sector;
  int dirty_sector_buffer;

  unsigned int cluster_range_low;
  unsigned int cluster_range_high;

  unsigned long bad_cluster;
  unsigned long last_bad_cluster;
  unsigned long sector_number_of_sector_buffer;

  /* Is the first bad sector in the boot sector, fat tables, or directory? */
  if(bad_sector_map[0]<param.first_data_sector)
    {
    /* Terminate the program...the disk is not usable. */

    /* NEEDS A BETTER ERROR THAN THIS! */
    printf("\nUnusable media...format terminated.\n");
    exit(1);
    }

  bad_cluster=0;
  last_bad_cluster=0;

  Clear_Sector_Buffer();

  bad_sector_map_index=0;
  dirty_sector_buffer=FALSE;
  current_fat_sector=1;
  do
    {
    cluster_range_low =(current_fat_sector*256)-256;
    cluster_range_high=(current_fat_sector*256);

    do
      {
      if(bad_sector_map[bad_sector_map_index]!=0)
	{
	bad_cluster=( (
	 ((bad_sector_map[bad_sector_map_index]+1)-param.first_data_sector)
	 +drive_specs[param.media_type].sectors_per_cluster)
	 /drive_specs[param.media_type].sectors_per_cluster)+1;
	}
      else bad_cluster=100000; /* Set to dummy value. */

      if( (bad_cluster!=last_bad_cluster) && (bad_cluster!=100000) )
	{
	drive_statistics.bytes_in_bad_sectors
	 =drive_statistics.bytes_in_bad_sectors
	 +(drive_specs[param.media_type].bytes_per_sector
	 *drive_specs[param.media_type].sectors_per_cluster);

	last_bad_cluster=bad_cluster;
	}

      if( (bad_cluster>=cluster_range_low)
       && (bad_cluster<cluster_range_high) )
	{
	sector_buffer[( (2 * (bad_cluster % 256) )     )] = 0xf7;
	sector_buffer[( (2 * (bad_cluster % 256) ) + 1 )] = 0xff;

	dirty_sector_buffer=TRUE;
	bad_sector_map_index++;
	}

      }while( (bad_cluster<cluster_range_high)
       && (bad_sector_map[bad_sector_map_index]!=0) );

    if(dirty_sector_buffer==TRUE)
      {
      if(current_fat_sector==1)
	{
	/* Create initial entries. */
	sector_buffer[0]=drive_specs[param.media_type].media_descriptor;
	sector_buffer[1]=0xff;
	sector_buffer[2]=0xff;
	sector_buffer[3]=0xff;
	}

      Drive_IO(WRITE,current_fat_sector,1);
      Drive_IO(WRITE,(current_fat_sector
       +drive_specs[param.media_type].sectors_per_fat),1);

      Clear_Sector_Buffer();
      dirty_sector_buffer=FALSE;
      }

    current_fat_sector++;
    }while(current_fat_sector<=drive_specs[param.media_type].sectors_per_fat);
}

void Record_Bad_Clusters_FAT32()
{
  /* Not supported yet... */

}
