/*
// Program:  Free FDISK
// Module:  PDISKIO.H
// Module Description:  PDISKIO.C Header File
// Written By:  Brian E. Reifsnyder
// Module Version:  1.6
// Copyright:  1998-2000 under the terms of the GNU GPL
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/

#ifdef PD_OTHER

  #define EMULATED_CYLINDERS   784
  #define EMULATED_HEADS       255
  #define EMULATED_SECTORS      63

  #define TRUE 1
  #define FALSE 0

  #define FOUR       4
  #define FIVE       5
  #define SIX        6
  #define W95        7
  #define W95B       72
  #define W98        8

  #define UNUSED    99

#endif

/*
/////////////////////////////////////////////////////////////////////////////
//  SPECIAL
/////////////////////////////////////////////////////////////////////////////
*/

#ifndef PDISKIO

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

/* Buffers */
extern unsigned char sector_buffer[512];
extern unsigned char huge_sector_buffer[(512*32)];

/* Brief partition type table buffer for computing drive letters. */
extern int brief_partition_table[8] [27];

/* Buffer containing drive letters. */
extern char drive_lettering_buffer[8] [27];

/* Integers converted from long numbers */
extern int integer1;
extern int integer2;


/* LBA Specific Global Variables */
extern unsigned char disk_address_packet[16];
extern unsigned char result_buffer[26];

extern unsigned long translated_cylinder;
extern unsigned long translated_head;
extern unsigned long translated_sector;

/*
/////////////////////////////////////////////////////////////////////////////
// GLOBAL STRUCTURES
/////////////////////////////////////////////////////////////////////////////
*/

/* Debugging Structure...Created 5/27/1999 */
typedef struct debugging_table_structure {
  int all;
  int command_line_arguments;
  int create_partition;
  int determine_free_space;
  int emulate_disk;
  int input_routine;
  int lba;
  int path;
  int read_sector;
  int write;
  } Debugging_Table;

/* Flags Structure...Created 5/27/1999 */
typedef struct flags_structure {

  char language[12];

  int allow_abort;
  int del_non_dos_log_drives;
  int display_name_description_copyright;
  int do_not_pause_help_information;
  int drive_number;
  int esc;
  int flag_sector;
  int fprmt;
  int use_freedos_label;
  int use_extended_int_13;
  int extended_options_flag;
  int fat32;
  int label;
  int monochrome;
  int maximum_drive_number;
  int more_than_one_drive;
  int partitions_have_changed;
  int partition_type_lookup_table;
  int reboot;
  int set_any_pri_part_active;
  int screen_color;
  int version;
  int use_ambr;
  } Flags;

/* Partition Table Structure...Created 5/6/1999 */
typedef struct part_table_structure {

  /* Hard disk Geometry */
  unsigned long total_cyl;
  unsigned long total_head;
  unsigned long total_sect;

  int ext_int_13;
  int ext_int_13_version;
  int device_access_using_packet_structure;

  /* Pre-computed hard disk sizes */
  long double total_hard_disk_size_in_log_sectors;
  unsigned long total_hard_disk_size_in_MB;

  int part_values_changed;
  int pri_part_exists;

    /* Primary Partition Table */

      /* Specific information that is stored in the partition table. */
      int active_status[4];

      int pri_part_num_type[4];
      char pri_part_vol_label[4] [13];

      long pri_part_start_cyl[4];
      long pri_part_start_head[4];
      long pri_part_start_sect[4];

      long pri_part_end_cyl[4];
      long pri_part_end_head[4];
      long pri_part_end_sect[4];

      unsigned long pri_part_rel_sect[4];
      unsigned long pri_part_num_sect[4];

      long pri_part_size_in_MB[4];

      int pri_part_created[4];
      /* General pre-computed information. */
      unsigned long pri_part_largest_free_space;

      long pp_largest_free_space_start_cyl;
      long pp_largest_free_space_start_head;
      long pp_largest_free_space_start_sect;

      long pp_largest_free_space_end_cyl;

      int pri_part_physical_order[4];

  int ext_part_exists;
  int num_of_ext_part;

    /* Extended Partition Table */
    long ext_part_size_in_MB;
    unsigned long ext_part_num_sect;
    long double ext_part_largest_free_space;

    long log_drive_largest_free_space_location;
    long log_drive_free_space_start_cyl;
    long log_drive_free_space_end_cyl;

    int num_of_log_drives;
    int num_of_non_dos_log_drives;
    int log_drive_num_type[23];
    char log_drive_vol_label[23] [13];

    long log_drive_start_cyl[23];
    long log_drive_start_head[23];
    long log_drive_start_sect[23];

    long log_drive_end_cyl[23];
    long log_drive_end_head[23];
    long log_drive_end_sect[23];

    unsigned long log_drive_rel_sect[23];
    unsigned long log_drive_num_sect[23];

    unsigned long log_drive_size_in_MB[23];

    int log_drive_created[23];

    int next_ext_exists[23];

    int next_ext_num_type[23];

    long next_ext_start_cyl[23];
    long next_ext_start_head[23];
    long next_ext_start_sect[23];

    long next_ext_end_cyl[23];
    long next_ext_end_head[23];
    long next_ext_end_sect[23];

    unsigned long next_ext_rel_sect[23];
    unsigned long next_ext_num_sect[23];

} Partition_Table;

extern Debugging_Table debug;
extern Flags flags;
extern Partition_Table part_table[8];

/*
/////////////////////////////////////////////////////////////////////////////
//  PROTOTYPES
/////////////////////////////////////////////////////////////////////////////
*/

extern int Determine_Drive_Letters();
extern int Read_Logical_Sectors(unsigned char drive_letter[2]
 , unsigned long logical_sector_number, int number_of_sectors);
extern int Read_Partition_Tables();
extern int Read_Physical_Sectors(int drive, long cylinder, long head, long sector, int number_of_sectors);
extern int Write_Logical_Sectors(unsigned char drive_letter[2]
 , unsigned long logical_sector_number, int number_of_sectors);
extern int Write_Partition_Tables();
extern int Write_Physical_Sectors(int drive, long cylinder, long head, long sector, int number_of_sectors);

extern unsigned long Decimal_Number(unsigned long hex1, unsigned long hex2, unsigned long hex3, unsigned long hex4);

extern void Check_For_INT13_Extensions();
extern void Clear_Sector_Buffer();
extern void Initialize_LBA_Structures();
extern void Load_Brief_Partition_Table();


#endif
