unit FdiskFix;

interface

uses MsaTools,PCstuff,CRT,FdiskUnit,DOS;

procedure FindAndFixFaults(Command : string);

implementation

procedure TestDrive(D : integer);
label skipit; {gasp! a label!}
var SaveDrive : integer; TotalSectors,Errors,LastError,LBA,T0 : longint;
    Buffer    : array[0..512] of char;
    TimeToFinish : real;
begin
PrepareScreen('Scanning '+nth(d+1)+' drive for bad blocks etc...');
SaveDrive:=Drive;
Errors:=0; LastError:=0;
Drive:=D;
GetDriveParameters($80 or D);
with reg do begin
            (* check for viruses, hardware diag, check for overlapping partitions, bad MBR etc *)
            end;
T0:=TimerTicks;
TotalSectors:=PhysicalCyl*longint(PhysicalHeads)*MaxPhysicalSector;
StatusLine('^C=Quit');
window(1,4,80,23);
for LBA:=0 to min(TotalSectors,20-1) do with pcstuff.reg do
    begin
    TextAttr:=Cyan;
    gotoXY(2,6);
    write('Testing Sector ',LBA:2,':    ',Lba2Chs(lba):13,' ');
    ReadLong(LBA,Buffer);
    if odd(flags)
       then begin TextAttr:=LightRed; writeln(' ERROR '+hex(ax)); inc(Errors); LastError:=LBA; end
       else write(^M);
    end;
TextAttr:=Cyan;
with pcstuff.reg do
 for LBA:=20 to TotalSectors do
     begin
     case byte(LBA) of
          20 : begin
               TextAttr:=Green; gotoXY(22,4);
               TimeToFinish:=(TimerTicks-T0)*0.05496*(TotalSectors-LBA)/LBA;
               if TimeToFinish>60 then writeln(TimeToFinish/60:5:1,' minutes to go ')
                                  else writeln(TimeToFinish:5:0,' seconds to go ');
               end;
          21 : if Errors>0
                  then begin TextAttr:=LightRed; gotoXY(1,4); write(Errors,' Errors'); end;
          22 : begin
               TextAttr:=Cyan; gotoXY(2,6);
               write('Testing Sector ',LBA:5,': ',Lba2Chs(lba):13,' ');
               end;
          99 : if keypressed then if BiosBreakFlag>0
                  then goto skipit;
          else begin gotoXY(16,6); write(LBA:6); end;
          end;
     ReadLong(LBA,Buffer);
     if odd(flags)
        then begin
             TextAttr:=Cyan; gotoXY(2,6);
             write('Testing Sector ',LBA:2,':    ',Lba2Chs(lba):13,' ');
             TextAttr:=LightRed; writeln(' ERROR '+hex(ax)); inc(Errors); LastError:=LBA;
             gotoXY(3,2); write(nth(Errors),' error at ',Lba2Chs(lba):13,': ',hex2(ah),'=',BiosError(ah));
             end;
     end;
skipit:
TextAttr:=Green; gotoXY(1,4); write('Finished! '); ClrEOL;
if Errors=0
   then writeln('No errors')
   else begin TextAttr:=LightRed; writeln(Errors,' ERRORS'); end;
TextAttr:=Green; writeln(' reading ',TotalSectors,' sectors.');
Drive:=SaveDrive;
window(1,1,80,25);
StatusLine('ESC=Quit');
if readkey=#0 then if Readkey=#0 then;
end;

const BadBlockOptions : OptionsType = (
      '1st hard disk',
      '2nd hard disk',
      '3rd hard disk',
      '4th hard disk',
      '5th hard disk',
      '6th hard disk',
      '7th hard disk',
      ''{ALL hard disks on the system'} );

procedure BadBlockTest(Command : string);
var i : integer;
begin
StatusLine('');
for i:=1 to NumberOfDrives do
    BadBlockOptions[i]:=copy(BadBlockOptions[i],1,length(BadBlockOptions[7]))+' ('+DriveDescription[i-1]+')';

if Command='' then Command:=Menu('Choose which disk to scan...',BadBlockOptions);
if Command[1] in ['1'..'9']
   then TestDrive(StringToInteger(Command)-1)
   else for i:=0 to max(0,NumberOfDrives-1) do TestDrive(i);
 
end;

procedure FindAndFixFaults(Command : string);
 type DIRSECT=array[1..16] of Dos_DirectoryEntry;
 var p,i : integer; j,k : longint;
     Fat,Fat2 : array[0..255] of word;
     Found_BootSector : Dos_Bootsector absolute FAT2;
     FoundMBR : MBRtype absolute FAT2;
     Search : string128;
     HowMAnyFound,SaveDrive : integer;
     FoundDir : array[1..200] of record Location : longint;
                                        Cluster : longint;
                                        Entry : ^DIRSECT;
                                        end;
     procedure Test(j : longint);
     begin
     ReadLong(j,FAT2);
     if Found_BootSector.Signature=#$55#$AA
        then begin
             st:='Partition Table or DOS Boot sector';
             writeln('Found ',st,' at sector ',j:7,' ',lba2chs(j));
             end
        else if FAT2[0]=$FFF8 then
             begin
             writeln('Found FAT at sector ',j:7,' ',lba2chs(j));
             end
        else if (chr(Fat2[0])='.') and (Fat2[16]=$2E2E)
         then with Dos_DirectoryEntry(addr(Fat2[0])^) do
             begin
             writeln('Found Subdirectory (cluster:',StartCluster:4,') at sector ',j:7,' ',lba2chs(j));
             inc(HowManyFound);
             if HowMAnyFound<=200 then with FoundDir[HowManyFound] do
                  begin
                  location:=j;
                  Cluster:=StartCluster;
                  new(Entry);
                  move(FAT2,Entry^,sizeof(Entry^));
                  end;
             end;
     end;

 procedure FixitMenu(Command : string);
 begin
 unimplemented;
 end;

 procedure HardwareDiags(Command : string);
 begin
 unimplemented;
 end;

 begin
 PrepareScreen('Simple Test of Partition Table...');
 gotoXY(1,3);
 Search:=''; st:='';
 SaveDrive:=Drive;
 if NumberOfHardDisks<>PhysicalHardDisks
    then write(NumberOfHardDisks:1,' or ');
 {if ATorBetter then st:=Model;}
 writeln(PhysicalHardDisks,' Hard disk drive(s). ',st);
 window(1,whereY,80,24);
 for drive:=0 to PhysicalHardDisks do
  begin
  GetDriveParameters(drive or $80);
  TextAttr:=9;
  ReadPartitionTable;
(*
  i:=CmosRam($12);
  case drive and 15 of
       0 : if (i>=$F0) then st:=DriveType(CmosRam($19))
                         else st:=DriveType(i shr 4);
       1 : if (i and $F)=$F then st:=DriveType(CmosRam($1A))
                         else st:=DriveType(i and $F);
       else st:='Hmm?';
       end;
*)
  st:=msatools.st;
  if (PhysicalCyl>0) and (st='no disk')
     then if MultiTasker>=Windows then st:=st+'; Windows is fibbing';
  if st='' then st:='Hmm?';
  writeln('DRIVE ',hex($80 or drive),': ',PhysicalCyl:4,' cyl, ',PhysicalHeads:2,' heads, ',MaxPhysicalSector:2,' sectors.',
          ' ('+st+')');
  ReadLong(0,FoundMBR);
  if odd(pcstuff.reg.flags)
   then writeln(' Error ',hex(pcstuff.reg.ax),' reading ',nth(drive+1),' hard disk drive')
   else for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p],rawentry do if System<>0 then
     begin
     ReadLong(FirstSector,Found_Bootsector);
     if system in DosPartitionTypes
        then if BootSector=nil
                then AddFault(Faults,'cannot read boot sector')
                else with Found_BootSector,BPB do
                     begin
                     if Signature<>#$55#$AA
                        then AddFault(Faults,'AA55 signature missing');
                     with BPB do if BytesPerSector<>512
                          then begin
                               if BytesPerSector=1024
                                        then AddFault(Faults,'Bytes/Sector=1024 - unusual!')
                                        else AddFault(Faults,'Bytes/Sector='+decimal(BytesPerSector));
                               if NumberOfFats<>2
                                  then if Signature=#$55#$AA
                                          then AddFault(Faults,'NOT a type '+decimal(System)+' partition!')
                                          else if Hop=$F6
                                               then AddFault(Faults,'Probably an unformatted partition')
                                               else begin
                                                    AddFault(Faults,'The DOS boot sector is junk!');
                                                    Search:=Search+chr(p);
                                                    end;
                               end
                          else if NumberOfFats<>2 then AddFault(Faults,decimal(NumberOfFats)+' FATs!')
                          else if not (SectorsPerCluster in [1,2,4,8,16,32])
                                  then AddFault(Faults,'Sectors/Cluster='+decimal(SectorsPerCluster))
                                  else if ReservedSectors<>1 then AddFault(Faults,'Reserved Sectors<>1!');

                     ReadLong(FirstSector+1,Fat);
                     if fat[0]<>$FFF8
                        then AddFault(Faults,'FAT seems to be corrupted');
                     if BPB.NumberOfFATs=2 then
                        begin
                        ReadLong(FirstSector+1+BPB.SectorsPerFAT,Fat2);
                        if string(addr(Fat2)^)<>string(addr(Fat)^)
                           then AddFault(Faults,'FAT1 <> FAT2');
                        end;
                     end;
     if system<>0 then
        begin
        TextAttr:=Cyan;
        write(p:2,': ',Description,' ':29-length(Description));
        if Faults='' then begin
                          TextAttr:=White;
                          if system in DosPartitionTypes
                             then begin
                                  write('FAT ');
                                  for i:=1 to 9 do ReadLong(FirstSector+i,FAT);
                                  writeln('OK');
                                  end
                             else writeln('OK')
                          end
                     else begin
                          TextAttr:=LightRed; writeln(copy(Faults,1,byte(pos(';',Faults)-1))); Search:=Search+chr(p);
                          end;
        end;
     end;
  (*
  if Search<>''
     then for i:=1 to length(Search) do
          begin
          HowManyFound:=0;
          p:=ord(Search[i]);
          TextAttr:=Yellow;
          write('Shall I search partition ',p,' for lost DOS files? ');
          if Readkey in ['Y','y'] then with PartitionsOn[Drive]^[p],RawEntry do
             begin
             TextAttr:=7; writeln;
             {
             for j:=1 to PhysicalHeads*MaxPhysicalSector-1 do
                 Test(j);
             for j:=1 to PhysicalCyl do
                 for k:=0 to 1 do
                     Test((j*PhysicalHeads+k)*MaxPhysicalSector);
             }
             TextAttr:=15;
             for j:=FirstSector to LastSector do
                 Test(j);
             end;
          end;
     *)
  end;
 repeat TextAttr:=yellow;
        window(1,1,80,25);
        if Search<>'' then st:='F6=Fix-it menu'
                      else st:='';
        StatusLine('F2=Bad block testF4=CMOSF5=Hardware diags'+st+'ESC=quit');
        gotoXY(1,24);
        ch:=upcase(ReadKey);
        case ch of
             'B' : BadBlockTest('');
             'C' : EditCmos('');
             'H' : HardwareDiags('');
             'F' : FixitMenu('');
             #0 : case ord(Readkey) of
                       F1 : Help('');
                       F2 : BadBlockTest('');
                       F4 : EditCmos('');
                       F5 : HardwareDiags('');
                       F6 : FixitMenu('');
                       F10: ch:=#27;
                       end;
             end;
        PrepareScreen('Find and Fix Faults...');
        window(1,2,80,23);
        crt.gotoXY(1,2);
        for i:=0 to pred(NumberOfDrives) do
            for j:=1 to 20 do with PartitionsOn[i]^[j] do
                if Faults<>''
                   then begin
                        TextAttr:=Cyan;
                        if CurrentDosName<>''
                           then st:=CurrentDosName
                           else st:='type '+hex2(rawentry.system);
                        write('Drive 0x',hex2($80 or i),' partition ',j:2,' ('+st+')':10,' ');
                        TextAttr:=LightRed;
                        k:=pos(';',Faults);
                        if k=0 then writeln(Faults)
                               else writeln(copy(faults,1,k),^M^J' ',copy(faults,k+1,255));
                        end;
        until ch in [^C,#27,'Q'];
 drive:=SaveDrive;
 window(1,1,80,25);
 GetDriveParameters(drive or $80);
 ReadPartitionTable;
 end;

begin
end.
