/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h> 
#include <string.h>
#include <conio.h>
#include <io.h>
#include "selemenu.h"
#include "common.h"
#include "fdisk.h"
#include "undo.h"
#include "global.h"

static sword BackupALL (void *pArg);
static sword oldWriteStatus = TRUE;

/*====================  d O _  b   UNDO  ======================*/
sword IsOpenUndo (void)
{
    return( g_Info.undoFP != NULL );
} /* end IsOpenUndo */


/*==========================   @  UNDO  ============================*/
sword CreateUndoFile (sbyte *fname)
{       
    sword  err;
    UNDO   undo;
 
    if ( g_Info.undoFP )
        return(-1);
 
    err = 0;
    if ( (g_Info.undoFP = new_fopen(fname, "wb+")) == NULL )
        err = -1;                                              /** ɥ **/
    else
    {
        memset(&undo, 0, sizeof(UNDO));
        strcpy(undo.mark, "SPFDisk UndoFile");                 /** 17 bytes **/
        /* strcpy(undo.mark, "SPF Boot Manager"); */
  
        undo.magicNum = MAGIC_CODE;
        undo.mainVer  = MAIN_VER;
        undo.subVer   = SUB_VER;
  
        if ( new_fwrite(&undo, 1, sizeof(UNDO), g_Info.undoFP) < sizeof(UNDO) )
        {
            new_fclose(g_Info.undoFP);
            err = -1;
        } /* end if */
    } /* end if */
 
    if ( err == 0 )
    {
        oldWriteStatus = GET_WRITE_SW();
        DISABLE_WRITE();                           /** disable write action **/
    } /* end if */
 
    return( err );
} /* end CreateUndoFile */


/*==========================   @  UNDO  ============================*/
sword CloseUNDO (void)
{         
    sword  err;
    byte   sum;
 
    err = 0;
    if ( g_Info.undoFP )
    {
        new_fseek(g_Info.undoFP, sizeof(UNDO), SEEK_SET);    /** Y **/
        sum = 0;
        while ( new_feof(g_Info.undoFP) == 0 )
            sum += new_fgetc(g_Info.undoFP);             /** p Check Sum **/
  
        new_fseek(g_Info.undoFP, sizeof(UNDO) - 1, SEEK_SET);/** ܥ[` **/
        if ( new_fputc(sum, g_Info.undoFP) == EOF )
            err = -1;                                          /** gJ~ **/
  
        new_fclose(g_Info.undoFP);
        g_Info.undoFP = NULL;
        
        SET_WRITE_SW(oldWriteStatus);                      /** ٭gJA **/
    } /* end if */
 
    return( err );
} /* end CloseUNDO */


/*============================= x s UNDO  ===============================*/
sword SaveUNDO (DiskDT *dk, dword cyl, dword head, dword sect, dword nSects)
{
    static UNDO_ADDR  addr;
    byte   buff[512];
    dword  begin;
    sword  err, i;
 
    err   = 0;
    begin = CHS_to_Sect(cyl, head, sect, dk);
 
    addr.disk   = dk->diskNO;
    addr.sector = begin;                                   /** sJƥm **/
    addr.nSects = (sword)nSects;
 
    if ( new_fwrite(&addr, 1, sizeof(UNDO_ADDR), g_Info.undoFP) != sizeof(UNDO_ADDR) )
        err = -1;
    else
        for ( i = 0 ; i < nSects ; i++ )
        { 
            if ( dk->drv->linearRead(dk, begin + i, 1, buff) )
            {
                err = -2;
                break;
            } /* end if */
         
            if ( new_fwrite(buff, 1, 512, g_Info.undoFP) < 512 )/** ƥϰ **/
            {
                err = -1;
                break;
            } /* end if */
        } /* end for */
 
    return( err );
} /* end SaveUNDO */


/*------------------------ ھڶǤJ禡إ Undo  ------------------------+
|  Ǧ^ȡG                                                                   |
|                                                                             |
|                          FALSE    ~Uh                              |
|                          TRUE                                       |
+----------------------------------------------------------------------------*/
sword PromptCreateUndoFile (UndoWork workfunc, void *pArg, sword pmtFlag)
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_CREATE_FILE  "O _   UNDO  H"
        #define CREATING_UNDO_MSG   " b   UNDO ɡDDD"
        #define CREATE_FAILURE_MSG  "     ѡI"
        #define CREATE_DONE_MSG     "     I"
        #define PROMPT_GIVE_UP_MSG  "UNDO      I\nO _ n   i  H"
        #define PROMPT_CONTINUE_MSG "UNDO      I\nO _ n ~  i  H"
    #else
        #define PROMPT_CREATE_FILE  "Do you want to create UNDO file ?"
        #define CREATING_UNDO_MSG   "It's building UNDO file....."
        #define CREATE_FAILURE_MSG  "Create file failure !"
        #define CREATE_DONE_MSG     "Create done !"
        #define PROMPT_GIVE_UP_MSG  "UNDO file create failure !\nDo you want to give up ?"
        #define PROMPT_CONTINUE_MSG "UNDO file create done !\nDo you want to continue save ?"
    #endif

    static sbyte fname[43];
    word   giveUp = FALSE; 
 
    if ( pmtFlag && !YN_box(TALK_BOX, PROMPT_CREATE_FILE) )
        giveUp = FALSE;                                  /** إ Undo  **/
    else
    {
        do
        {
            if ( Input_Filename(fname, 42) == FALSE )
                return( TRUE );                            /**  **/
        } while ( Is_Overwrite(fname) == FALSE );
  
        /*--------------------------------------+
        |    |إ Undo ɡAåBdIgJqD   |
        +--------------------------------------*/
        if ( CreateUndoFile(fname) )
            giveUp = TRUE;                              /** Undo ɫإߥ **/
        else
        {
            /*----------------------------------------+
            |       iJD{gJqDwQdI      |
            +----------------------------------------*/
            ShowMSG(CREATING_UNDO_MSG);

            if ( workfunc(pArg) )          /** uu@Hإ undo  **/
                giveUp = TRUE;

            ShowMSG(NULL);
            if ( CloseUNDO() )
                giveUp = TRUE;
        } /* end if */
  
        if ( giveUp )
        {
            new_unlink(fname);         
   
            if ( !pmtFlag )
                Prompt_Msg_Box(CREATE_FAILURE_MSG, NULL);
            else
            {
                if ( !YN_box(ERROR_BOX, PROMPT_GIVE_UP_MSG) )
                    giveUp = FALSE;                            /** ~ **/
            } /* end if */
        }
        else
        {
            if ( !pmtFlag )
                Prompt_Msg_Box(CREATE_DONE_MSG, NULL);
            else
                if ( !YN_box(TALK_BOX, PROMPT_CONTINUE_MSG) )
                    giveUp = TRUE;
        } /* end if */
    } /* end if */
 
    return( giveUp );
} /* end CreateUndoFile */


/*=================== N UNDO ɦ^swСAie| ==================*/
sword TryToRestoreUNDO (sbyte *fname)
{
    sword  status, err;

    /*--------------------------------------+
    |   ^sʧ@Aˬd UNDO ɬO_~  |
    +--------------------------------------*/
    status = GET_WRITE_SW();
    DISABLE_WRITE();                                   /** gJ\ **/
    err = RestoreUNDO(fname);
    SET_WRITE_SW(status);                              /** ٭gJA **/

    /*----------------------------------+
    |    YGL~hi^s   |
    +----------------------------------*/
    if ( err == 0 )
        err = RestoreUNDO(fname);

    return( err );
} /* end TryToRestoreUNDO */


/*======================= N UNDO  ^ s  w  =========================*/
sword RestoreUNDO (sbyte *fname)
{                 
    UNDO_ADDR addr;
    byte      buff[512];
    UNDO      header;
    dword     sector;
    FILE      *fptr;
    byte      sum;
    sword     err, i;
    DiskDT    *dk;
 
    err = 0;
    if ( (fptr = new_fopen(fname, "rb")) == NULL )
        err = -1;                                              /** }ɥ **/
    else if ( new_fread(&header, 1, sizeof(UNDO), fptr) != sizeof(UNDO) )
        err = -2;                                          /** YŪ~ **/
    else if ( header.magicNum != MAGIC_CODE || header.mainVer < MAIN_VER )
        err = -3;                                        /** O UNDO file **/
    else
    {
        /*--------------------------------+
        |    d Check Sum O _  T   |
        +--------------------------------*/
        sum = 0;
        while ( new_feof(fptr) == 0 )                    /** o Check Sum **/
            sum += new_fgetc(fptr);
      
        if ( sum != header.checkSum )
            err = -4;                                   /** Check Sum Error **/
        else
        {
            /*------------------------------+
            |    UNDO    ^ w    |
            +------------------------------*/
            new_fseek(fptr, sizeof(UNDO), SEEK_SET);           /** LY **/
   
            while ( new_fread(&addr, 1, sizeof(UNDO_ADDR), fptr) == sizeof(UNDO_ADDR) )
            {
                sector = addr.sector;
                for ( i = 0 ; i < addr.nSects ; i++,  sector++ )
                {
                    if ( new_fread(buff, 1, 512, fptr) != 512 )
                    {
                        err = -2;
                        goto END_RESTORE;
                    } /* end if */
 
                    dk = GetHardDiskDT(addr.disk - 0x7f);
                    if ( dk->drv->linearWrite(dk, sector, 1, buff) )
                    {   
                        err = -5;
                        goto END_RESTORE;
                    } /* end if */
                } /* end for */
            } /* end while */
   
            if ( new_feof(fptr) == 0 )                     /** ɮŪ~ **/
                err = -2;

        } /* end if */
    } /* end if */
 
    END_RESTORE:
 
    if ( fptr )
        new_fclose( fptr );
    
    return( err );
} /* end RestoreUNDO */


/*==========================    ^ s B z ===========================*/
void backup_restore (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define BACKUP_ALL_MSG          "1. ƥҦwФΪαҰʺϰ "
        #define RESTORE_UNDO_FILE_MSG   "2. ^s UNDO ɩγƥɨϺ "
        #define END_X                   58
    #else 
        #define BACKUP_ALL_MSG          "1. Backup All partition/boot sector "
        #define RESTORE_UNDO_FILE_MSG   "2. Restore Backup/UNDO file to disk "
        #define END_X                   62
    #endif
 
    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  sele;
 
    MenuBox(23, 13, END_X, 16, NULL);                    /** øsΤ **/
    
    g_Menu.enableCtrl(M_LOCK);
    g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
    g_Menu.prompt(25, 14, BACKUP_ALL_MSG, TRUE);           /** ]w椺e **/
    g_Menu.prompt(25, 15, RESTORE_UNDO_FILE_MSG, TRUE);

    sele = g_Menu.select(1);
    if ( sele == 1 )
        PromptCreateUndoFile(BackupALL, NULL, FALSE);
    else if ( sele == 2 )
        UNDO_Recovery(partnArr);
} /* end backup_restore */


/*======================= N UNDO  ^ s  w  =========================*/
void UNDO_Recovery (PARTN *partnArr)
{         
    #if ( DISPLAY == CHINESE )
        #define ARE_YOU_SURE_RESTORE  "T w n ^ s UNDO  H"
        #define RESTORING_FILE_MSG    " b ^ s UNDO   y ԡDDD"
        #define RELOAD_PARTITION_MSG  "^sAN䭫sŪΪI"
    #else
        #define ARE_YOU_SURE_RESTORE  "Are you sure to restore the UNDO\nfile ?"
        #define RESTORING_FILE_MSG    "It's restore the UNDO file, please wait...."
        #define RELOAD_PARTITION_MSG  "Restore done, press any key to\n" \
                                      "reload partition table !"
    #endif
    
    sbyte  fname[43];
    sword  err;
 
    if ( IsUpdatePartn() )                  /** Y partition ʥB|xs **/
        return;
 
    if ( Input_Filename(fname, 42) == FALSE )
        ; /*Cancel_Box(); */
    else if ( new_access(fname, 0) == -1 )
        ShowError(8);
    else if ( !YN_box(IMMEDIATE_BOX, ARE_YOU_SURE_RESTORE) )
        Cancel_Box();
    else
    {
        ShowMSG(RESTORING_FILE_MSG);
        err = TryToRestoreUNDO(fname);                 /** i undo ɦ^s **/
        ShowMSG(NULL);
  
        if ( err == 0 )
        {
            Prompt_Msg_Box(RELOAD_PARTITION_MSG, NULL);
            err = Get_Disk_Info(CUR_DK, partnArr, TRUE);

            if ( err )
            {
                Disk_Err_Msg(err);                         /** ܿ~T **/
                if ( (err & 0x08) && (g_Info.nHD == 1) )
                    Reset_Partn(partnArr);       /** w~Bu@w **/
            } /* end if */
        }
        else
        {
            ShowError( ( err == -1 ) ? 8 :                 /** ɮ׶}ҥ **/
                       ( err == -2 || err == -3 ) ? 10 :   /** ɮפe~ **/
                       ( err == -4 ) ? 16 : 17 );        /** Check Sum ~ **/
                                                           /** wмgJ~ **/
        } /* end if */
    } /* end if */
} /* end UNDO_Recovery */


/*====================             ==================*/
static sword BackupALL (void *pArg)
{
    byte   partn[512], bootSect[512];
    word   par, i;
    dword  sector;
    sword  offset;
    DiskDT *dk;

    (void)pArg;                             /* To avoid compile time warning */

    offset = 0;
    for ( i = 0 ; i < g_Info.nHD ; i++ )
    {
        dk     = GetHardDiskDT(i + 1);                   /** oϺаѼƪ **/
        par    = 0;
        sector = 0;
        while ( 1 )
        {
            par++;
            if ( par > 1 && par < 5 )
            {
                offset += 0x10;
                sector = *(dword *)&partn[offset + 8];
            }
            else
            {
                offset = GetPartnToBuffer(dk, par, &sector, partn);
                if ( offset < 0 )                            /** Τsb **/
                    break;

                /*----- xsΪAQмgƷ|sJ undo  -----*/
                if ( dk->drv->linearWrite(dk, sector, 1, partn) )
                    return(-1);
                sector += *(dword *)&partn[offset + 8];
            } /* end if */
            
            if ( partn[offset + 4] )                          /** System ID **/
            {
                /*----------- xsҰʺϰ ----------+
                |     gJʧ@|sJ undo      |
                +-----------------------------------*/
                if ( dk->drv->linearRead(dk, sector, 1, bootSect) == 0 )
                    if ( dk->drv->linearWrite(dk, sector, 1, bootSect) != 0 )
                        return(-1);
            } /* end if */
        } /* end while */
    } /* end for */
 
    return(0);
} /* end BackupALL */
