/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include "common.h"
#include "selemenu.h"
#include "keymap.h"

static void  MenuColor (sword non_light_bar, sword light_bar);
static void  Prompt (sword x, sword y, sbyte *mnu, sword use);
static void  ShowMenu (sword begin, sword nItem);
static void  MenuDestructor (void);
static void  ShowItem (MenuItem *item, sword sw);
static sbyte *AllocItemSpace (void);
static sword ItemColor (sword color);
/*static sword SetHotKey (sword key, sword (*func)(void), sword eat); */
static sword LastKey (void);
static sword Select (sword currItem);
static void  DisableCtrl (word sw);
static void  EnableCtrl (word sw);

/*---------------------+
|        l  |
+---------------------*/
SeleMenu g_Menu =
{
    { 0 },                                           /*   s椺ec */
#if 0   
    { 0 },                                           /*             s */
#endif   
    (GREEN << 4) + YELLOW,                           /*             C */
    (BLUE << 4) + WHITE,                             /*           DC */
    M_LOCK | M_ONESELE,                          /* ο汱Xw]ҥ */
    0,                                               /* ثenO` */
    0,                                      /*  s}ɳ̫U */
    0,                                               /* wtmrŶƶq */

    /*-----------------------*/
    /*        method         */ 
    /*-----------------------*/
    MenuDestructor,
    DisableCtrl,
    EnableCtrl,
    MenuColor,
    Prompt,
    ShowMenu,
 
    AllocItemSpace,
 /* SetHotKey,  */
    ItemColor,
    LastKey,
    Select
};

/*
 * FOҤ@wtmŶAGۦϥΤ@RA}C޲z
 */
static sbyte    gs_Space[M_ALLOC_ITEM][M_ITEM_SIZE]; /** tmŶΰ}C **/
static SeleMenu *this = &g_Menu;                                /* this  */


/*============================= ] w this   =============================*/
void SetMenuObjThisPtr (SeleMenu *obj)
{
    this = obj;
} /* end SetMenuObjThisPtr */


/*============================= 汱X =============================*/
static void DisableCtrl (word sw)
{
    this->flag &= ~sw;
} /* end DisableCtrl */


/*============================= ҥο汱X =============================*/
static void EnableCtrl (word sw)
{
    this->flag |= sw;
} /* end EnableCtrl */


/*======================== ] w    C   X =======================*/
static void MenuColor (sword non_light_bar, sword light_bar)
{
    this->defColor  = non_light_bar;
    this->seleColor = light_bar;
} /* end MenuColor */
 

/*============================= ] w   C  ===========================*/
static sword ItemColor (sword color)
{
    sword  tmp = this->defColor;
 
    this->defColor = color;
    return( tmp );
} /* end ItemColor */


/*=================  ^  }       U    ===============*/
static sword LastKey (void)
{
    return( this->last_key );
} /* end LastKey */


#if 0
/*=============================== ] w   ===============================*/
static sword SetHotKey (sword key, sword (*func)(void), sword eat)
{
    this->hotKey.key  = key;
    this->hotKey.func = func;
    this->hotKey.eat  = eat;
    return(0);
} /* end SetHotKey */
#endif /* 0 */


/*============= ѹwdϰtmrŶϵ{OҥiHtmŶ\ ============*/
static sbyte *AllocItemSpace (void)
{
    #if SPF_DEBUG
        sword  i;
        
        /*--------- ˬdO_tm ---------*/
        if ( this->nAllocItem >= M_ALLOC_ITEM )
        {
            Bug_Msg_Box("M_ALLOC_ITEM value too small\n"
                        "Please press ctrl-c to terminate", NULL);
            return( gs_Space[0] );
        } /* end if */
     
        /*------ ˬd}CO_D}a ------*/
        for ( i = 0 ; i < this->nAllocItem ; i++ )
            if ( gs_Space[i][M_ITEM_SIZE - 1] )
            {
                Error_Msg_Box("AllocSpace: gs_Space[] be destoryed,\n"
                              "please modify M_ITEM_SIZE value\n", NULL);
                return( gs_Space[0] );
            } /* end if */
     
        gs_Space[this->nAllocItem][M_ITEM_SIZE - 1] = 0;         /** Check Value **/
       
    #endif  /* end SPF_DEBUG */

    return( gs_Space[this->nAllocItem++] );
} /* end AllocItemSpace */


/*======================== n椺etmrŶ =====================*/
static void Prompt (sword x, sword y, sbyte *mnu, sword use)
{
    MenuItem  *ptr = this->item + this->nItem;
 
    if ( this->nItem < REC_LEN )
    {
        ptr->x = x;
        ptr->y = y;
        ptr->mnu = mnu;
        ptr->use = use;
        ptr->color = this->defColor;
        this->nItem++;
  
        c_gotoxy(x + strlen(mnu), y);
    } /* end if */

#if SPF_DEBUG
   else
       Bug_Msg_Box("Exceed menu item limit\n"
                   "Please press ctrl-c to terminate", NULL);
#endif

} /* end Prompt */


/*===================== ܿ椺eALΤεݿJ ====================*/
static void ShowMenu (sword begin, sword nItem)
{
    sword  end, i;
              
    if ( begin < 1 )
        begin = 0;
    else
        begin--;
 
    end = ( nItem == 0 ) ? this->nItem:
          ( nItem > (this->nItem - begin) ) ? this->nItem : begin + nItem;
 
    for ( i = begin ; i < end ; i++ )
        ShowItem(this->item + i, FALSE);           /** ̪ܳLΪ **/

} /* end ShowMenu */


/*======================== X {        =======================*/
static sword Select (sword currItem)
{
    sword  tmp, i, j;
 
    if ( (this->nItem < 2) && !IS_MENU_ONESELE(this->flag) )
    {
        tmp = this->nItem;
        MenuDestructor();                                      /** Ѻc禡 **/
        return( tmp );
    } /* end if */
 
    currItem = ((currItem > 0) && (currItem <= this->nItem)) ? currItem - 1 : 0;
 
    ShowMenu(1, FALSE);                            /** ̪ܳLΪ **/
 
    while ( 1 )
    {
        ShowItem(this->item + currItem, TRUE);                 /** X{ **/
        this->last_key = WaitKey();

#if 0
        /*------------ pGF -----------*/
        if ( this->last_key == this->hotKey.key )
        {
            if ( this->hotKey.func )
                this->hotKey.func();
            if ( this->hotKey.eat )
                continue;
        } /* end if */
#endif
      
        if ( this->last_key == '\r' )                        /** F Enter **/
        {
            if ( this->item[currItem].use )
                break;
            else
                continue;
        } /* end if */
 
        ShowItem(this->item + currItem, FALSE);                /** å **/
        if ( !IsFuncKey(this->last_key) )                /** pGO\ **/
        {
            for ( i = 0 ; i < this->nItem ; i++ )
            {
                /*==================*/
                /*     L     */
                /*==================*/
                j = -1;
                while ( this->item[i].mnu[++j] == ' ' );
                if ( (this->item[i].mnu[j] == this->last_key) || 
                     (IS_MENU_SENS(this->flag) &&
                     (toupper(this->item[i].mnu[j]) == toupper(this->last_key))) )
                {                                    /** Y^rjpg **/
                    currItem = i;
                    break;
                }
            } /* end for */
   
            if ( i < this->nItem )                   /** PYﶵĤ@rŦX **/
            {
                /*
                 * ݫ Enter 
                 */
                if ( IS_MENU_AUTOENTER(this->flag) && this->item[currItem].use )
                    break;
            }
            else
            {
                /*===============================================*/
                /*      Y     X  @ r         */
                /*===============================================*/
                if ( !IS_MENU_LOCK(this->flag) || (this->last_key == ESC_KEY) )
                {
                   MenuDestructor();
                   return(-1);                                     /**  **/
                } /* end if */
            } /* end if */
        }
        else
        {
            switch( this->last_key )                         /** Bz\ **/
            {
                case UP_KEY:
                case LEFT_KEY:
                    if ( --currItem < 0 )
                    {
                        if ( IS_MENU_WRAP(this->flag) || IS_MENU_LOCK(this->flag) )
                            currItem = IS_MENU_WRAP(this->flag) ? this->nItem - 1 : 0;
                        else
                        {
                            MenuDestructor();
                            return(0);
                        } /* end if */
                    } /* end if */
                    break;
             
                case DOWN_KEY:
                case RIGHT_KEY:
                    if ( ++currItem >= this->nItem )
                    {
                        if ( IS_MENU_WRAP(this->flag) || IS_MENU_LOCK(this->flag) )
                            currItem = ( IS_MENU_WRAP(this->flag) ) ? 0 : currItem - 1;
                        else
                        {
                            MenuDestructor();
                            return(0);
                        } /* end if */
                    } /* end if */
                    break;
             
                case HOME_KEY:
                    currItem = 0;
                    break;
             
                case END_KEY:
                    currItem = this->nItem - 1;
                    break;
             
                default:                               /** FXk **/
                    if ( !IS_MENU_LOCK(this->flag) )
                    {
                        MenuDestructor();
                        return(0);                               /** S **/
                    } /* end if */
            } /* end switch */
        } /* end if */
 
        ClrKeyBuffer();                                      /** M~ **/
    } /* end while */
 
    ShowItem(this->item + currItem, TRUE);                     /** Od **/
    MenuDestructor();                                           /** Ѻc禡 **/
    return( currItem + 1 );
} /* end Select */


/*============================    c   ============================*/
static void MenuDestructor (void)
{
    this->nItem = 0;
    this->nAllocItem = 0;
    c_textattr(DEFAULT_COLOR);
} /* end MenuDestructor */


/*==========================      @  ===========================*/
static void ShowItem (MenuItem *item, sword sw)
{
    /** Ω **/
    if ( sw )
        c_textattr( ( item->use ) ? this->seleColor : LG_NO_USE_COLOR );
    else
        c_textattr( (item->use ) ? item->color :
                                  (item->color & 0x70) + (NO_USE_COLOR & 0xf));
    c_printXY(item->x, item->y, item->mnu);              /** ܿ椧ﶵ **/
    c_textattr(this->defColor);                                /**  **/
} /* end ShowItem */

