/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------+
|    F    N    \  Q       ` B @A          |
|   ]  N      P         s ]                |
+----------------------------------------------------------------------------*/
#include <stdarg.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>

#include "common.h"

/*---------------------------------------------------------------------------*/
FILE *new_fopen (const sbyte *filename, const sbyte *mode)
{
    FILE   *fptr;
    sword  status;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    fptr = fopen(filename, mode);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( fptr );
} /* end new_fopen */


/*---------------------------------------------------------------------------*/
sword new_fclose (FILE *fp)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = fclose(fp);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /*end new_fclose */


/*---------------------------------------------------------------------------*/
size_t new_fread (void *ptr, size_t size, size_t n, FILE *fp)
{
    size_t  ret;
    sword   status;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = fread(ptr, size, n, fp);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_fread */


/*---------------------------------------------------------------------------*/
size_t new_fwrite (const void *ptr, size_t size, size_t n, FILE *fp)
{
    size_t  ret;
    sword   status;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = fwrite(ptr, size, n, fp);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_fwrite */


/*---------------------------------------------------------------------------*/
sword new_fgetc (FILE *fp)
{
    sword  status, ch;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ch = fgetc(fp);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ch );
} /* end new_fgetc */


/*---------------------------------------------------------------------------*/
sword new_fputc (sword c, FILE *fp)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = fputc(c, fp);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_fputc */


/*---------------------------------------------------------------------------*/
sword new_access (const sbyte *filename, sword amode)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = access(filename, amode);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_access */


/*---------------------------------------------------------------------------*/
sdword new_flength (FILE *fp)
{
    sword   status;
    sdword  len;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    len = filelength(fileno(fp));
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( len );
} /* end new_flength */


/*---------------------------------------------------------------------------*/
sword new_fseek (FILE *fp, sdword offset, sword whence)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = fseek(fp, offset, whence);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_fseek */


/*---------------------------------------------------------------------------*/
sword new_unlink (const sbyte *filename)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = unlink(filename);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_unlink */


/*---------------------------------------------------------------------------*/
sword new_feof (FILE *stream)
{
    sword  status, ret;
    
    status = Set_Disk_Extra_Status(DISK_XCHG);     /** }ҺϺХN\ **/
    ret = feof(stream);
    Disk_Extra_Ctrl(status);                           /** _eA **/
    return( ret );
} /* end new_feof */


/*---------------------------------------------------------------------------*/
sword new_fprintf (FILE *fp, const sbyte *format, ...)
{
    sword    bOutFile, status, ret;
    va_list  va_ptr;

    bOutFile = !(fp == stdout || fp == stderr);
    if ( bOutFile )
        status = Set_Disk_Extra_Status(DISK_XCHG); /** }ҺϺХN\ **/
    va_start(va_ptr, format);
    ret = vfprintf(fp, format, va_ptr);
    va_end(va_ptr);
    if ( bOutFile )
        Disk_Extra_Ctrl(status);                       /** _eA **/
    return( ret );
} /* end new_fprintf */


/*---------------------------------------------------------------------------*/
sword new_fflush (FILE *fp)
{
    sword  bOutFile, status, ret;

    bOutFile = !(fp == stdout || fp == stderr);
    if ( bOutFile )
        status = Set_Disk_Extra_Status(DISK_XCHG); /** }ҺϺХN\ **/
    ret = fflush(fp);
    if ( bOutFile )
        Disk_Extra_Ctrl(status);                       /** _eA **/
    return( ret );
} /* end new_fflush */
