/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <mem.h>
#include "fdisk.h"
#include "common.h"
#include "undo.h"
#include "global.h"

struct SavePara
{
    PARTN  *partnArr;
    sword  adjust, doom;
};

/*--------------------- xsΪ{ǰtXإ Undo ɥ --------------------*/
static sword Partn_Save_Process (void *pArg)
{
    struct SavePara  *para = (struct SavePara *)pArg;
    
    return( Write_Partn(para->partnArr, para->doom, para->adjust) );
} /* end Partn_Save_Process */


/*------------------------------ x s    ------------------------------+
|                                                                             |
|  g_Info.fd.modified > 0,                                                      |
|     To Setup para.adjust dos boot sector or destroy save                      |
|  g_Info.fd.modified == -1,                                                    |
|     To Setup System ID                                                      |
|  g_Info.fd.modified <= -2,                                                    |
|     Just setup ACTIVE                                                       |
+----------------------------------------------------------------------------*/
sword Save_Partn (PARTN *partnArr)
{           
#if ( DISPLAY == CHINESE )
    #define NO_CHG_MSG          "ΪèSܰʡAnixsܡH"
    #define NO_ACTIVE_MSG       "|]wҰʤΡATwnxsܡH"
    #define WARNING_MSG         "III  ` N III"
    #define TARGET_DISK_MSG     " n g J      O   %d   w "
    #define DISK_CORRECT_MSG    "T w  n x s  w   T  (y/n)H "
    #define USE_DOOM_SAVE_MSG   "n   } a  x s  (y/n)H "
    #define ADJ_BOOTSECT_MSG    "O _   DOS         e (y/n)H "
    #define SAVING_MSG          "x s i  A  y ԡDDD"
    #define SAVE_DONE_MSG       "Ϊ{bwxsI"

    static sbyte *doomMSG[] =
    {
        "Yί}aʪxsG",
        "    ﶵ۷ DOS  FDISKA ҥH|}aӤΪҰʺϰϡI",
        "YΫD}axsG",
        "    Pϥ Linux  FDISK @˥u|xsΰϸ(ϴ)I",
        "pGzإߪαNns榡ơAаȥ 'Y'",
        "oӿﶵuPsإߩΧRíتά"
    };
    static sbyte *adjMSG[] =
    {
        "o {    Q     ",
        "Y u O   L DOS    j pA    'Y'",
        "p G z  b i       A    'N'"
    };

#else
    #define NO_CHG_MSG          "Partiiton table not be modify !\nAre you sure to save ?"
    #define NO_ACTIVE_MSG       "Not found active partition,\nAre you sure to continue ? "
    #define WARNING_MSG         "!!!!!!  Warning  !!!!!!"
    #define TARGET_DISK_MSG     "  The fixed disk drive  %d  will be written"
    #define DISK_CORRECT_MSG    "Are you sure the target disk is currect (y/n)? "
    #define USE_DOOM_SAVE_MSG   "Would you like to choose destruct save (y/n)? "
    #define ADJ_BOOTSECT_MSG    "Would you like to adjust DOS boot sector(y/n)? "
    #define SAVING_MSG          "It's saving please wait......."
    #define SAVE_DONE_MSG       "Partition table save done!"

    static sbyte *doomMSG[] =
    {
        "If choose destruct save:",
        "    This choose will destroy the boot sector, like DOS's FDISK !",
        "If choose non-destruct save:",
        "    It will reserve the boot sector, like Linux's FDISK !",
        "If you will format the new create partition, please type 'Y'",
        "This option just effect the new create partition"
    };
    static sbyte *adjMSG[] =
    {
        "Found partition be adjust or remake",
        "If just adjust DOS partition size, please type 'Y'",
        "If you are recoverying partition table, please type 'N'"
    };       
#endif  /* end CHINESE */

    sword  active, noChg, i;
    struct SavePara para;
 
    if ( !IsAllowSavePartn() )                   /** ΪADTxs **/
        return(1);
 
    noChg = FALSE;
    if ( g_Info.fd.modified == 0 )
    {
        if ( !YN_box(TALK_BOX, NO_CHG_MSG) )   /** ΥܬO_ixs **/
        {
            Cancel_Box();
            return(1);
        } /* end if */
  
        noChg = TRUE;
        for ( i = 0 ; i < g_Info.fd.used ; i++ )
            if ( ChkSysID(partnArr[i].old_id, FAT12_16_32) )
                partnArr[i].adjust = TRUE;
  
        g_Info.fd.modified = 1;
    } /* end if */
 
    /*------ ˬdO_]wʤ ------*/
    active = FALSE;
    if ( CUR_DK->diskNO != 0x80 )
        active = TRUE;
    else if ( g_Info.fd.primary > 0 )
    {
        for ( i = 0 ; i < g_Info.fd.pri_use ; i++ )
            if ( partnArr[i].active == 0x80 )
            {
                active = TRUE;
                break;
            } /* end if */
    } /* end if */
 
    if ( !active && !YN_box(TALK_BOX, NO_ACTIVE_MSG) )   /** ]wʤ **/
    {
        Cancel_Box();
        return(1);
    } /* end if */
 
    para.partnArr = partnArr;
    para.doom     = TRUE;
    para.adjust   = FALSE;
 
    Redraw_Fdisk_Picture(TRUE);
    c_textattr(WARNING_COLOR);
                            
    c_printXY(30, 11, WARNING_MSG);
    c_textattr(PMT_LINE_COLOR);
    c_printXY(20, 14, TARGET_DISK_MSG, CUR_DK->diskNO - 0x7f);/** ܥتϺ **/
    c_textattr(DEFAULT_COLOR);
 
    if ( !Is_Yes(DISK_CORRECT_MSG) )                   /** تϺЬO_T **/
    {
        Cancel_Box();
        return(1);
    } /* end if */
    
    if ( g_Info.fd.modified > 0 )
    {
        if ( (noChg == FALSE) && ((g_Info.fd.used != 1) || (partnArr[0].no != 0)) )
        {
            Clr_Block(2, 3, 77, 20);
            for ( i = 0 ; i < 6 ; i++ )
                c_printXY(12, i * 2 + 7 + (i > 3), doomMSG[i]);
   
            if ( !Is_Yes(USE_DOOM_SAVE_MSG) )        /** Yϥί}axs **/
                para.doom = FALSE;
        } /* end if */
  
        for ( i = 0 ; i < g_Info.fd.used ; i++ )
            if ( partnArr[i].id &&
                 partnArr[i].adjust && (!para.doom || !partnArr[i].remake) )
            { 
                Clr_Block(2, 3, 77, 20);
                for ( i = 0 ; i < 3 ; i++ )
                    c_printXY(15, i * 2 + 11, adjMSG[i]);
    
                if ( Is_Yes(ADJ_BOOTSECT_MSG) )  /** O_ѽվҰʺϰϤe **/
                    para.adjust = TRUE;
                break;
            } /* end if */
  
        c_textattr(DEFAULT_COLOR);
    } /* end if */
    
    Clr_Block(2, 3, 77, 20);
    ShowMSG(NULL);
 
    /*------------------------+
    |     ܫإ UNDO     |
    +------------------------*/
    if ( PromptCreateUndoFile(Partn_Save_Process, &para, TRUE) )
    {
        Cancel_Box();
        return(1);                                             /**  **/
    } /* end if */
 
    /*--------------------+
    |    x s {  q   |
    +--------------------*/
    ShowMSG(SAVING_MSG);                                   /** xsT **/
 
    if ( Partn_Save_Process(&para) )
        return(-1);                                           /** gJѡI**/
 
    ShowMSG(NULL);
    if ( !active )
        ShowError( 1 );                                 /** S]ҰʤΡI**/
    else
        Prompt_Msg_Box(SAVE_DONE_MSG, NULL);             /** xs\T **/
 
    return(0);
} /* end Save_Partn */


/*========================== NѼনΪ ===========================*/
static void Set_Partn_Field (byte *table, PARTN *ptr, dword extStart, sword adjust)
{
    dword  startCyl, endCyl;
 
    if ( ptr->id == 0 )
    {
        memset(table, 0, 0x10);
        return;
    } /* end if */
 
    table[0] = ptr->active;                                     /* ACTIVE    */
    table[1] = ptr->side;                                       /* ҩl    */
    table[4] = ptr->id;                                         /* System ID */
    table[5] = (byte)CUR_DK->lgeo.maxHead;                      /*     */
 
    *(dword *)&table[8]  = GetStart(ptr) - extStart;            /* úϰ  */
    *(dword *)&table[12] = Get_nSector(ptr);             /* ήeq(ϰϼ) */
 
    startCyl = ptr->stCyl;
    endCyl   = ptr->endCyl;
 
    if ( ptr->no < 5 )
    {
        if ( startCyl > 1023 )
           startCyl = 1023;
 
        if ( endCyl > 1023 )
           endCyl = 1023;
    } /* end if */
                           
    Asm_Sect_Cyl(&table[2], ptr->sector, startCyl);                /** ҩl **/
    Asm_Sect_Cyl(&table[6], CUR_DK->lgeo.maxSect, endCyl);         /**  **/
 
    if ( adjust && ptr->adjust )                  /** վ DOS ҰʺϰϤe **/
    {
        Adjust_DOS_BootSector(ptr /*, extStart*/ );     /**  partnadj.c **/
        ptr->adjust = FALSE;
    } /* end if */
} /* end Set_Partn_Field */


/*============================== gJΪ =================================*/
sword Write_Partn (PARTN *partnArr, sword doom, sword adjust)
{
    static PARTN *ptr;
    byte   buff[512];
    dword  extStart;
    sword  err, adr, i, j;
 
    #if 0
        DISABLE_WRITE();                                          /** DEBUG **/
    #endif
 
    Disable_Ctrl_Break();                             /** \ Ctrl_Break **/

    /*-----------------------------+
    |         ŪDΪ         |
    +-----------------------------*/
    if ( linear_ReadWDK(0, 1, buff) )
    {
        Enable_Ctrl_Break();                            /** \ Ctrl_Break **/
        return(-1);                                           /** s~I**/
    } /* end if */
 
    Sort_Partn(partnArr, FOR_NUMBER);               /** partnArr HsƧ **/
    
    err = 0;
    adr = 0x1be;  
    ptr = partnArr;
    if ( g_Info.fd.modified <= -2 )             /** uO]w active partition **/
    {
        for ( i = 1 ; i < 5 ; i++,  adr += 0x10 )      /** ]w ACTIVE  **/
            if ( ptr->no == i )
            {
                buff[adr] = ptr->active;
                ptr++;
            }
            else
                buff[adr] = 0;
    }
    else                                     /** pGק{ץؤΪ **/
    {
        if ( GET_WRITE_SW() )
            g_Info.reboot_flag = TRUE;       /** ܭ}ܰTX **/
  
        if ( *(word *)&buff[510] != 0xaa55 )       /** LĤΪ~ MBR **/
        {
            Get_Pre_Loader( buff );                          /** J{X **/
            *(word *)&buff[510] = 0xaa55;
        } /* end if */
                   
        /*-------------------------+
        |       D       |
        +-------------------------*/
        extStart = 0;
        for ( i = 1 ; i < 5 ; i++,  adr += 0x10 )        /** y@DΪ **/
            if ( ptr->no != i )                                /** Ū **/
            {
                buff[i + 0x19f] = 0;               /** ƥä id m **/
                for ( j = 0 ; j < 16 ; j += 4 )
                    *(dword *)&buff[adr + j] = 0;
            }
            else
            {                                            /** JDθT **/
                Set_Partn_Field(&buff[adr], ptr, 0, adjust);
                buff[i + 0x19f] = ptr->old_id;      /** Jëe SYS_ID **/
    
                if ( Is_Extended(ptr->old_id) )          /** pGOXR **/
                    extStart = *(dword *)&buff[adr + 8];
                else
                    if ( ptr->remake && doom )
                        DestroyBootSect(ptr);
     /**            if ( ptr->remake && doom && DestroyBootSect(ptr) )
                       err = -1;
     **/
                if ( GET_WRITE_SW() )
                    ptr->remake = FALSE;
    
                ptr++;
 
            } /* end if */
  
        /*-------------------------+
        |       X R      |
        +-------------------------*/
        if ( extStart != 0 )
        {
            if ( g_Info.fd.logic_exist )
            {
                if ( Save_Extended(partnArr, extStart, doom, adjust) )
                    err = -1;
            }
            else                                       /** pGS޿ **/
            {
                if ( Fill_Sector(CUR_DK, GetStart(ptr), 1, 0xf6) )
                   err = -1;
            } /* end if */
        } /* end if */
    } /* end if */
 
    /*-----------------------------+
    |         gJDΪ         |
    +-----------------------------*/
    if ( linear_WriteWDK(0, 1, buff) )
        err = -1;
 
    Sort_Partn(partnArr, FOR_STCYL);                /** partnArr HϬWƧ **/
    if ( (err == 0) && GET_WRITE_SW() )
        g_Info.fd.modified = 0;
 
    Enable_Ctrl_Break();                                /** \ Ctrl_Break **/
    return( err );
} /* end Write_Partn */


/*============================= xs޿ ================================*/
static sword Save_Extended (PARTN *partnArr, dword extStart, sword doom, sword adjust)
{
    byte   buff[512];
    dword  saveSect;
    PARTN  tmp, *ptr;
    sword  i;
 
    memset(buff, 0, 512);                               /** initial buffers **/
    *(word *)&buff[510] = 0xaa55;
 
    saveSect = extStart;                               /** XRαҩlϰ **/
    ptr = partnArr + g_Info.fd.pri_use;          /** Vs̤p޿ **/
 
    for ( i = 4 ; i < g_Info.fd.maxParNO ; i++,  ptr++ )
    {
        Set_Partn_Field(&buff[0x1be], ptr, saveSect, adjust);   /** θT **/
        buff[0x1a0] = ptr->old_id;                     /** Jƥ SYS_ID **/
  
    /** if ( doom && ptr->remake && DestroyBootSect(ptr) )
            return(-1);
    **/
        if ( doom && ptr->remake )
            DestroyBootSect(ptr);
  
        if ( i < (g_Info.fd.maxParNO - 1) )          /** U޿Ϊsb **/
        {
            tmp = *(ptr + 1);
            tmp.side--;
            if ( tmp.side < 0 )
            {
                tmp.side = (sword)CUR_DK->lgeo.maxHead;
                tmp.stCyl--;
            } /* end if */
   
            tmp.id = tmp.old_id = 5;
            Set_Partn_Field(&buff[0x1ce], &tmp, extStart, 0);  /** θT **/
        }
        else
            memset(&buff[0x1ce], 0, 0x30);                 /** MT **/
  
        if ( linear_WriteWDK(saveSect, 1, buff) )
            return(-1);
  
        saveSect = GetStart(&tmp);                       /** UӤΪm **/
  
        if ( GET_WRITE_SW() )
            ptr->remake = FALSE;
    } /* end for */
 
    return(0);
} /* end Save_Extended */


/*========================== Destruct Boot Sector ===========================*/
static sword DestroyBootSect (PARTN *ptr)
{
    byte   buff[512];
    dword  begin;
    sword  ret, i;
    /*DOSBPB *bpb; */

    begin = GetStart(ptr);
    /*bpb   = (DOSBPB *)buff;*/

    ret = 0;
    if ( Fill_Sector(CUR_DK, begin++, 1, 0xf6) )
        ret = -1;
    else
        for ( i = 0 ; i < 8 ; i++,  begin++ )
            if ( linear_ReadWDK(begin, 1, buff) ||
                 (*(word *)&buff[510] == 0xaa55 && Fill_Sector(CUR_DK, begin, 1, 0xf6)) )
                ret = -1;
    return( ret );            
} /* end DestroyBootSect */


/*========================== s Pre_load { =============================*/
sword Update_MBR (DiskDT *dk)
{
    byte  buff[512];
 
    if ( dk->drv->chsRead(dk, 0, 0, 1, 1, buff) )          /** ŪJDΪ **/
        return(-1);

    Get_Pre_Loader( buff );         /** o pre_load {qb Pre_Load.asm **/
    return( dk->drv->chsWrite(dk, 0, 0, 1, 1, buff) );         /** gJ MBR **/
} /* end Update_MBR */


/*========================== o Pre_load { =============================*/
static sword Get_Pre_Loader (byte *buff)
{
    byte   FAR *codePTR = (byte FAR *)MBR_HEAD;
    sword  len, i;
 
    /*----------------------------------------+
    |    MBR_END & MBR_HEAD ŧib fdisk.h    |
    +-----------------------------------------+
    |  len variable must less than 0x1a0      |
    |  0x1a0 - 0x1a3 is address of backup ID  |
    +----------------------------------------*/
    len = (sword)((byte FAR *)MBR_END - (byte FAR *)MBR_HEAD);
    if ( len > HIDD_BAK )
        len = HIDD_BAK;
    for ( i = 0 ; i < len ; i++, codePTR++ )
        buff[i] = *codePTR; 
    for ( ; i < 0x1be ; i++ )
        if ( (i < HIDD_BAK) || (i > (HIDD_BAK + 3)) )
            buff[i] = 0;
    return( len );
} /* end Get_Pre_Loader */

