/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __GETOBJ_H_
#define __GETOBJ_H_

#ifndef __COMMON_H_
   #include "common.h"
#endif

#ifndef __KEYMAP_H_
  #include "keymap.h"
#endif

/*
#ifndef __KEYOBJ_H_
  #include "keyobj.h"
#endif
*/

/*==============================   w q  ==============================*/
#define _NUM_OF_ITEM_          100      /* i̤jơAi̻ݨD惡ƭ */
#define UNDO_BUFF_SIZE          80                         /* UnDo νwİϪŶ */

#define USED                     1
#define USING                    2
#define READONLY                 3
#define DEFAULT                  4

#define PASSWD_CHAR             '!'

#define G_USED_COLOR         WHITE  + (CYAN << 4)      /* is褧ذt */
#define G_USING_COLOR        YELLOW + (CYAN << 4)      /* s褧ذt */
#define G_RDONLY_COLOR       LIGHTGRAY + (CYAN << 4)     /* Ūؤt */


#define G_STOP               0x0001                           /* s赲X */
#define G_INSMODE            0x0002               /* ]wЪA(JBN) */

/*
 * 汱X
 */
#define G_WRAP               0x0004                         /* `} */
#define G_AUTOENTER          0x0008             /* JBɤ Enter */
#define G_MSGCENTER          0x0010                 /* ܰTܩӦC */
#define G_BEEP               0x0020                         /* ܹn} */
#define G_ALLOW              0x0040        /* s譺ɫW,Uis */
#define G_CURMEM             0x0080                           /* OдЦm */
#define G_USETAB             0x0100                      /* ]w Tab 䪺Nq */
#define G_CUR_RESET          0x0200                 /* Csв歺 */
#define G_ALLOWLEAVE         0x0400 /* b歺k䤹\ܤWΤU@ */
#define G_LOCK               0x0800         /* UXk\ɤs */

#define DEFAULT_CTRL_FLAGS   \
    (G_AUTOENTER | G_MSGCENTER | G_BEEP | G_CUR_RESET | G_LOCK)

#define CLR_EDIT_STOP_FLAG() do { this->ctrl &= ~G_STOP;   } while(0)
#define SET_EDIT_STOP_FLAG() do { this->ctrl |= G_STOP;    } while(0)
#define TOGGLE_INS_MODE()    do { this->ctrl ^= G_INSMODE; } while(0)

#define IS_EDIT_STOP()       (this->ctrl & G_STOP)
#define IS_EDIT_INS_MODE()   (this->ctrl & G_INSMODE)
#define IS_EDIT_WRAP()       (this->ctrl & G_WRAP)
#define IS_EDIT_AUTOENTER()  (this->ctrl & G_AUTOENTER)
#define IS_EDIT_MSGCENTER()  (this->ctrl & G_MSGCENTER)
#define IS_EDIT_BEEP()       (this->ctrl & G_BEEP)
#define IS_EDIT_ALLOW()      (this->ctrl & G_ALLOW)
#define IS_EDIT_CURMEM()     (this->ctrl & G_CURMEM)
#define IS_EDIT_USETAB()     (this->ctrl & G_USETAB)
#define IS_EDIT_CUR_RESET()  (this->ctrl & G_CUR_RESET)
#define IS_EDIT_ALLOWLEAVE() (this->ctrl & G_ALLOWLEAVE)
#define IS_EDIT_LOCK()       (this->ctrl & G_LOCK)


/*=============================   w q  ==============================*/
/*   U       */
/*--------------------*/
typedef struct ITEM_ATTR
{
     word   readOnly : 1;
     word   isPassword : 1;                             /* pGJKX */ 
     word   isNumeric : 1;
     word   hold : 5;

     sword  used_Color, using_Color, ignor_Color;
     sword  curAddr, useLen, msgX, msgY, len, X, Y;
     sbyte *title, *pict, *Msg, *var;

     sbyte *(*Work)(void);
     sword  (*Check)(sbyte *var);

     /* LoơAC䳣|Q */
     sword  (*Filter)(sword *key);

     /* ĲoơAC䳣|QABio@T */
     sword  (*INTR)(sword key, sbyte *var, sword offset, sword item, sword len);
} ATTR;


/*--------------------*/
/*   D n      */
/*--------------------*/
typedef struct GET_OBJECT
{
     /*------------------------*/
     /*                  */
     /*------------------------*/
     word    ctrl;                                                /* X */
     ATTR    items[_NUM_OF_ITEM_];                                    /* Cݩ */
     sbyte   undo_buff[UNDO_BUFF_SIZE + 1];         /* 줺e UnDo νwİϪŶ */
     sword   record;                                              /* wnƶq */
     sword   lastKey;                                       /* ̪@U */
     sword   nowEdit;                                       /* ثebs誺 */
     sword   tabLen;                                           /*  TAB ҸZ */
     sword   msgX, msgY;                                    /* ܰTܪm */ 
     sword   curAddr;                                             /* @PЦm */
     sword   used_Color;                                      /* is褧ذt */
     sword   using_Color;                                     /* s褧ذt */
     sword   ignor_Color;                                       /* Ūؤt */

     void   (*destructor) (void);
     void   (*endEdit)(sword key);
     void   (*disableCtrl)(word sw);
     void   (*enableCtrl)(word sw);
     void   (*setUsedColor) (sword color);
     void   (*setUseingColor) (sword color);
     void   (*setIgnorColor) (sword color);
     void   (*setMsgXY) (sword x, sword y);
     void   (*setTabLen) (sword len);
     sword  (*getInsMode) (void);
     sword  (*lastkey) (void);
     sword  (*edit) (sword begin);
     sword  (*s_get)(sword x, sword y,
                     sbyte *title, sword len, sbyte *var, sbyte *pict);
     sword  (*get) ( sword x, sword y, sbyte *title, sword len, sbyte *var,
                     sbyte *Msg, sbyte *pict,
                     sword readOnly,
                     sbyte *(*Work)(void),
                     sword  (*Check)(sbyte *var),
                     sword  (*Filter)(sword *key),
                     sword  (*INTR)(sword key, sbyte *var, sword offset, sword item, sword len));

#if 0
     sbyte  *(*rtrim) (sbyte *str);
     sbyte  *(*ltrim) (sbyte *str);
     sbyte  *(*alltrim) (sbyte *str);
#endif     

} GETOBJ;

/*extern GETOBJ g_GetObj;  */


void SetGetObjThisPtr (GETOBJ *obj);

#endif  /* __GETOBJ_H_ */
