/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <conio.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "getobj.h"

static sword  Is_accept (ATTR *ptr, sword *inkey);
static sword  IsRearItem (void);
static sword  User_Check_Func (ATTR *ptr);
static sbyte  *User_Work_Func (ATTR *ptr);
static void   PreProcess (void);
static void   EndProcess (void);
static void   ShowItem (ATTR *item, sword type, sword sw);
static void   Process_key(ATTR *ptr, sword key);
static void   Replace (ATTR *item, sbyte chr, sword offset);
static void   Insert (ATTR *item, sbyte chr, sword ins_offset);
static void   Delete (ATTR *item, sword del_offset, sword clreol_flag);
static void   FireBeep (void);
              
static void   DisableCtrl (word sw);
static void   EnableCtrl (word sw);
static void   EditDestructor (void);
static void   EndEdit (sword key);
static void   SetUsedColor (sword color);
static void   SetUsingColor (sword color);
static void   SetIgnorColor (sword color);
static void   SetMsgXY (sword x, sword y);
static void   SetTabLen (sword len);

static sword  GetInsMode (void);
static sword  Lastkey (void);
static sword  Edit (sword begin);
static sword  SimplifyGet (sword x, sword y,
                           sbyte *title, sword len, sbyte *var, sbyte *pict);
static sword  Get (sword x, sword y, sbyte *title, sword len, sbyte *var, sbyte *Msg,
                   sbyte *pict, sword readOnly,
                   sbyte *(*work)(void),
                   sword  (*check)(sbyte *var),
                   sword  (*filter)(sword *key),
                   sword  (*intr)(sword key, sbyte *var, sword offset, sword item, sword len) );

#if 0
    static sbyte *rtrim (sbyte *str);
    static sbyte *ltrim (sbyte *str);
    static sbyte *alltrim (sbyte *str);
#endif  /* 0 */

GETOBJ g_GetObj =
{
    /*------------------------+
    |       Xl      | 
    +------------------------*/
    DEFAULT_CTRL_FLAGS,

    { 0 },                                     /* OCӽs趵ݩʪ}C */
    { 0 },                                     /* 줺e UnDo νwİϪŶ */
    0,                                                       /* wnƶq */
    0,                                                 /* ̪@U */
    0,                                                 /* ثebs誺 */
    8,                                                    /*  TAB ҸZ */
    1, 23,                                             /* ܰTܪm */
    0,                                                       /* @PЦm */
    G_USED_COLOR,                                        /* is褧ذt */
    G_USING_COLOR,                                       /* s褧ذt */
    G_RDONLY_COLOR,                                        /* Ūؤt */

    /*-----------------------*/
    /*        method         */ 
    /*-----------------------*/
    EditDestructor,
    EndEdit,
    DisableCtrl,
    EnableCtrl,
    SetUsedColor,
    SetUsingColor,
    SetIgnorColor,
    SetMsgXY,
    SetTabLen,
    GetInsMode,
    Lastkey,
    Edit,
    SimplifyGet,
    Get
#if 0     
    , rtrim
    , ltrim
    , alltrim
#endif
};


static GETOBJ *this = &g_GetObj;                                 /* this  */


/*============================= ] w this   =============================*/
void SetGetObjThisPtr (GETOBJ *obj)
{
    this = obj;
} /* end SetGetObjThisPtr */


/*================================  c   ===============================*/
static void EditDestructor (void)
{ 
    memset(this->items, 0, sizeof(this->items));
    memset(this->undo_buff, 0, sizeof(this->undo_buff));
    this->ctrl    = DEFAULT_CTRL_FLAGS;
    this->record  =  0;
    this->tabLen  =  8;
    this->curAddr =  0;
    this->msgX    =  1;
    this->msgY    = 23;
} /* end EditDestructor */


/*============================= 汱X =============================*/
/* U bit NqаѦ getobj.h 汱X */
static void DisableCtrl (word sw)
{
    this->ctrl &= ~sw;
} /* end DisableCtrl */


/*============================= ҥο汱X =============================*/
/* U bit NqаѦ getobj.h 汱X */
static void EnableCtrl (word sw)
{
    this->ctrl |= sw;
} /* end EnableCtrl */


/*======================== ] w  TAB   D Z  =======================*/
static void SetTabLen (sword len)
{
    this->tabLen = len;                       /** ҥ G_USETAB ~Nq **/
} /* end SetTabLen */


/*========================== ] w   T    m ======================*/
static void SetMsgXY (sword x, sword y)
{
    if ( x > 0 )
        this->msgX = x;
    if ( y > 0 )
        this->msgY = y;
} /* end SetMsgXY */


/*====================== ] w D    b   C  ====================*/
static void SetUsedColor (sword color)
{
    this->used_Color = color;
} /* end SetUsedColor */


/*======================== ] w    b   C  =====================*/
static void SetUsingColor (sword color)
{
    this->using_Color = color;
} /* end SetUsingColor */


/*=========================== ] w  Ū   C  ========================*/
static void SetIgnorColor (sword color)
{
    this->ignor_Color = color;
} /* end SetIgnorColor */


/*==========================  o  e  J   =========================*/
static sword GetInsMode (void)
{
    return( IS_EDIT_INS_MODE() );
} /* end GetInsMode */


/*====================== o} Edit() ɩҫU ======================*/
static sword Lastkey (void)
{
    return( this->lastKey );
} /* end Lastkey */


/*================================   s  ===============================*/
static void EndEdit (sword key)
{
    SET_EDIT_STOP_FLAG();
    if ( key )
        this->lastKey = key;
} /* end EndEdit */


#if 0     /* mark ltrim(), rtrim() and alltrim() function */

/*=========================== R      ==============================*/
static sbyte *ltrim (sbyte *str)
{
    sbyte  *ptr;
    
    for ( ptr = str ; *ptr == ' ' ; ptr++ );
    return( strcpy(str, ptr) );
} /* end ltrim */


/*=========================== R  k    ==============================*/
static sbyte *rtrim (sbyte *str)
{
    sbyte  *ptr;
    
    ptr = str + strlen(str) - 1;
    for ( ; (ptr >= str) && (*ptr == ' ') ; ptr-- );
    *(ptr + 1) = '\0';
    return( str );
} /* end rtrim */


/*========================== R   k     =========================*/
static sbyte *alltrim (sbyte *str)
{
    ltrim(str);
    return( rtrim(str) );
} /* end alltrim */

#endif  /* 0 */


/*========================  ² ] w      =======================*/
/*   ѼƻG                                                              */
/*                                                                           */
/*    x            ]wsϪ x b                                         */
/*    y            ]wsϪ y b                                         */
/*    title        ]wsϪD                                          */
/*    len          ]wsϪס]rơ^At '\0' r                */
/*    *var         Qs誺rܼƦ}                                      */
/*    *pict        ˪rAwqUriJA]ҡGƦrBr^  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
static sword SimplifyGet (sword x, sword y,
                          sbyte *title, sword len, sbyte *var, sbyte *pict)
{
    return( Get(x, y, title, len, var, NULL, pict, FALSE, NULL, NULL, NULL, NULL) );
} /* end SimplifyGet */


/*===================== ] w    J      ====================*/
/*   ѼƻG                                                              */
/*                                                                           */
/*    x            ]wsϪ x b                                         */
/*    y            ]wsϪ y b                                         */
/*    title        ]wsϪD                                          */
/*    len          ]wsϪס]rơ^At '\0' r                */
/*    *var         Qs誺rܼƦ}                                      */
/*    *msg         в즹ɧƱܪܰT                      */
/*    *pict        ˪rAwqUriJA]ҡGƦrBr^  */
/*    readOnly     ]wŪ                                            */
/*    *work        в즹ɡA|۰ʩIs禡Щҫ禡        */
/*    *check       }ɡA|Is禡Щҫ禡ˬdܼƤe  */
/*    *filter      CJ@ӦrN|Is禡AiΨӹLo        */
/*    *intr        CJ@ӦrN|Is禡AiΨӧsЦmΧsT  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
static sword Get (sword x, sword y, sbyte *title, sword len, sbyte *var, sbyte *msg,
                  sbyte *pict, sword readOnly,
                  sbyte *(*work)(void),
                  sword  (*check)(sbyte *var),
                  sword  (*filter)(sword *key),
                  sword  (*intr)(sword key, sbyte *var, sword offset, sword item, sword len) )
{
    static sbyte numPict[] = "9H#";
    ATTR   *ptr;
    sword  i;
    
    if ( this->record >= _NUM_OF_ITEM_ )               /* WXe\n */
        return(-1);                              /* iվ getobj.h wq */
    
    ptr = &this->items[ this->record++ ];
    ptr->used_Color   = this->used_Color;
    ptr->using_Color  = this->using_Color; 
    ptr->ignor_Color  = this->ignor_Color;
    ptr->X            = x; 
    ptr->Y            = y;
    ptr->msgX         = this->msgX;
    ptr->msgY         = this->msgY;

    ptr->len          = (len > UNDO_BUFF_SIZE) ? UNDO_BUFF_SIZE : len;

    ptr->Msg          = msg;
    ptr->title        = title;
    ptr->readOnly     = ( readOnly != 0 );                       /* ŪX */
    
    ptr->Work         = work;                                  /* u@Ψ禡 */
    ptr->Check        = check;                                 /* Ψ禡 */
    ptr->Filter       = filter;
    ptr->INTR         = intr;
    ptr->var          = var;                                     /* ܼƦ} */
    var[ ptr->len ]   = '\0';

    /* ˬdO_Ʀr */
    for ( i = 0 ; pict[i] && i < ptr->len ; i++ )
        if ( !strchr(numPict, pict[i]) )
            break;
    if ( i >= ptr->len ||
         pict[0] == '@' && strchr(numPict, pict[1]) )
    {
        ptr->pict = pict;
        ptr->isNumeric = TRUE;                                     /* Ʀr */
    }    
    /* ˬdO_KXJ */
    else if ( strchr(pict, 'P') )
    {
        ptr->pict = NULL;
        ptr->isPassword = TRUE;
    }
    else                                                         /* ]w˪ */
    {
        ptr->pict = pict;
        ptr->isNumeric  = FALSE;
        ptr->isPassword = FALSE;
    } /* end if */

    c_gotoxy(x + len + strlen(title), y);                        /* ʴ */

    len = strlen(var);
    ptr->curAddr = ( len < ptr->len ) ? len : ptr->len - 1;

    return(0);
} /* end Get */


/*======================= } l i     e s  =======================
 *                   ESC   s   ^  _ h  ^ 
 *============================================================================*/
static sword Edit (sword begin)
{
    sword  preEdit = -1;
    sword  bakColor;
    ATTR   *ptr;

    bakColor = GetColor();                             /* ƥثe]wC */
    Ctrl_Cursor(TRUE);
    
    if ( begin > this->record )
        begin = 1;
    this->nowEdit = begin - 1;                                 /* ]wҩl */

    PreProcess();                /* seBzAܼƤeɥդμD */

    CLR_EDIT_STOP_FLAG();                              /* Ms誺X */
    ptr = this->items;
    this->curAddr = ptr->curAddr;
    this->lastKey = ENTER_KEY;
    
    while ( !IS_EDIT_STOP() )
    {
        ptr->curAddr = this->curAddr;
        ptr = this->items + this->nowEdit;               /* Vثes */
        ShowItem(ptr, USING, TRUE);
        if ( preEdit != this->nowEdit )
        {
            preEdit = this->nowEdit;
            if ( IS_EDIT_CUR_RESET() )                 /* pGҥδk */
                this->curAddr = 0;

            /*      e UNDO   */
            sprintf(this->undo_buff, "%-*.*s",
                    UNDO_BUFF_SIZE, UNDO_BUFF_SIZE, ptr->var);
        } /* end if */

     /* else if ( IS_EDIT_CURMEM() && */
        if ( IS_EDIT_CURMEM() && 
             this->lastKey != ENTER_KEY )          /* pGҥΰOдЦm */
        {
            this->curAddr = ptr->curAddr;
        } /* end if */

        if ( this->curAddr >= ptr->len )                     /* եЦm */
            this->curAddr = ptr->len - 1;
        else if ( this->curAddr < 0 )
            this->curAddr = 0;

        c_gotoxy(this->curAddr + ptr->X, ptr->Y); /* NвܤWs覹檺m */

        /*------------------------------------------------------------+
        |  ϥΪ̦n ptr->Work() ۩w~u@ơA              |
        |  hb User_Work_Func() ̷|sΦ۩w禡Jƨ즹A |
        |  ҦpGвܦɧƱX{@ӥοHѿ       |
        +------------------------------------------------------------*/
        if ( User_Work_Func(ptr) )
        {
            ShowItem(ptr, USED, TRUE);
            if ( this->lastKey != UP_KEY )
                this->lastKey = (IsRearItem() && !IS_EDIT_ALLOW() && !IS_EDIT_WRAP()) ? UP_KEY : DOWN_KEY;
            else
                this->lastKey = (this->nowEdit == 0 && !IS_EDIT_ALLOW() && !IS_EDIT_WRAP()) ? DOWN_KEY : UP_KEY;

            /*  [WBU]  */
            Process_key(ptr, this->lastKey);
        }
        else
        {
            /* èMwO_LoγBz */
            do
            {
                this->lastKey = WaitKey();
            } while ( ptr->Filter && ptr->Filter(&this->lastKey) ||
                      ptr->INTR   && ptr->INTR(this->lastKey, ptr->var, this->curAddr + 1, this->nowEdit + 1, ptr->len) );

            Process_key(ptr, this->lastKey);
        } /* end if */
    } /* end while */

    EndProcess();

    EditDestructor();
    c_textattr(bakColor);

    Ctrl_Cursor(FALSE);
    return( this->lastKey != ESC_KEY );
} /* end Edit */


/*----------------------------      e ------------------------------*/
static void ShowItem (ATTR *item, sword type, sword sw)
{
    sword  centerX, color, len;
    
    if ( sw && item->Msg )
    {
        centerX = (80 - strlen(item->Msg)) / 2;
        c_gotoxy( (IS_EDIT_MSGCENTER() ? centerX : this->msgX),  this->msgY);
        c_printf( item->Msg );
    } /* end if */

    c_gotoxy(item->X, item->Y);
    color = ( item->readOnly ) ? item->ignor_Color :
            ( type == USED )   ? item->used_Color  :
            ( type == USING )  ? item->using_Color : DEFAULT_COLOR;

    c_textattr(color);
    len = strlen(item->var);
    if ( item->isPassword )
        Repeat_Char(PASSWD_CHAR, len);
    else
        ShowRangeStr(32, 254, item->var, len, NULL);
    Repeat_Char(' ', item->len - len);
} /* end showItem */


/*-------------------------------- e m B z --------------------------------*/
static void PreProcess (void)
{
    sword  now;
    ATTR   *ptr;

    ptr = this->items;
    for ( now = 0 ; now < this->record ; now++,  ptr++ )
    {
        c_gotoxy(ptr->X, ptr->Y);
        if ( ptr->title )
        {
            c_textattr( (c_getattr() >> 8) & 0x00FF );
            c_printf( ptr->title );                          /* ܼDr */
            ptr->X += strlen( ptr->title );      /* yнվJتm */
        } /* end if */

        ShowItem(ptr, ((now == this->nowEdit) ? USING : USED), FALSE );
    } /* end for now */
} /* end PreProcess */


/*-------------------------------- e m B z --------------------------------*/
static void EndProcess (void)
{
    sword  now;
    ATTR   *ptr;

    ptr = this->items;
    for ( now = 0 ; now < this->record ; now++,  ptr++ )
    {
        c_gotoxy(ptr->X, ptr->Y);
        ShowItem(ptr, DEFAULT, FALSE);
    } /* end for now */
} /* end EndProcess */


/*--------------------------- B z     J --------------------------*/
static void Process_key (ATTR *ptr, sword key)
{
    switch( key )
    {
        case BACKSPACE_KEY:                            /* RЫe@Ӧr */
            if ( this->curAddr > 0 )
                this->curAddr--;
            Delete(ptr, this->curAddr, FALSE);
            break;

        case TAB_KEY:
            if ( IS_EDIT_USETAB() )
                this->curAddr += this->tabLen;
            else
                Process_key(ptr, DOWN_KEY);                /* F[U] */
            break;
        
        case C_ENTER_KEY:
        case ENTER_KEY:
            /*=========================================================
             *     Y     ]  w  d   h   
             *========================================================*/
            if ( User_Check_Func(ptr) )
            {
                ShowItem(ptr, USED, TRUE);                       /* _ */
                if ( IsRearItem() && !IS_EDIT_WRAP() ) /* pGثeş */
                    EndEdit(0);
                else
                    this->nowEdit++;
            } /* end if */
            this->curAddr = 0;
            break;
        
        case ESC_KEY:              /* }sAP F2 tbˬdY} */
            ShowItem(ptr, USED, TRUE);                           /* _ */
            EndEdit(0);
            break;
        
        case C_U_KEY:                                            /* UNDO */
            this->curAddr = 0;
            sprintf(ptr->var, "%-*.*s", ptr->len, ptr->len, this->undo_buff);
            break;
        
        case F2_KEY:                                       /* ˬdᵲs */
            if ( User_Check_Func(ptr) )
            {
                ShowItem(ptr, USED, TRUE);                       /* _ */
                EndEdit(0);
            } /* end if */
            break;
        
        case A_C_KEY:                                    /* Mثe줺e */
            Delete(ptr, 0, TRUE);
            this->curAddr = 0;
            break;
        
        case A_E_KEY:                    /* M줤ЩҦbmr */
            Delete(ptr, this->curAddr, TRUE);
            break;

        case INS_KEY:                                        /* JA */
            TOGGLE_INS_MODE();
            break;

        case DEL_KEY:                                    /* RЩҦbr */
            Delete(ptr, this->curAddr, FALSE);
            break;
        
        case HOME_KEY:                               /* в椺rꭺ */
            this->curAddr = 0;
            break;
        
        case END_KEY:                                /* в椺r */
            this->curAddr = strlen(ptr->var);
            if ( this->curAddr > ptr->len )
                this->curAddr = ptr->len - 1;
            break;

        case LEFT_KEY:
            if ( IS_EDIT_ALLOWLEAVE() && this->curAddr <= 0 )
                Process_key(ptr, UP_KEY);
            else
                this->curAddr--;
            break;

        case RIGHT_KEY:
            this->curAddr++;
            if ( IS_EDIT_ALLOWLEAVE() && this->curAddr >= ptr->len )
                Process_key(ptr, DOWN_KEY);
            break;

        case UP_KEY:
            /*========================================================
             *     Y     ]  w  d   h   
             *========================================================*/
            if ( User_Check_Func(ptr) )
            {
                ShowItem(ptr, USED, TRUE);                       /* _ */
                if ( this->nowEdit > 0 )           /* pGثeOs̭ */
                    this->nowEdit--;
                else if ( IS_EDIT_ALLOW() )    /* bWɤ\s */
                    EndEdit(0);
                else if ( IS_EDIT_WRAP() )                   /* Y}Ҵ` */
                    this->nowEdit = this->record - 1;
                else
                    FireBeep();                                    /* ĵin */
            } /* end if */
            break;
        
        case DOWN_KEY:
           /*========================================================
            *     Y     ]  w  d   h   
            *=======================================================*/
           if ( User_Check_Func(ptr) )
           {
               ShowItem(ptr, USED, TRUE);                        /* _ */
               if ( !IsRearItem() )                /* pGثeOş */
                   this->nowEdit++;
               else if ( IS_EDIT_ALLOW() )   /* b̧Uɤ\s */
                   EndEdit(0);
               else if ( IS_EDIT_WRAP() )                    /* Y}Ҵ` */
                   this->nowEdit = 0;
               else
                   FireBeep();                                     /* ĵin */
           } /* end if */
           break;
        
        case C_END_KEY:                                          /*  */
            this->nowEdit = this->record - 1;
            break;
        
        case C_HOME_KEY:                                         /* ܭ */
            this->nowEdit = 0;
            break;

        case S_TAB_KEY:
            if ( IS_EDIT_USETAB() )
                this->curAddr -= this->tabLen;       /* в tabLen Z */
            else
                Process_key(ptr, UP_KEY);    /* F[W]Aܫe */
            break;

        /*=========================================
         *     BzJrˬdO_ŦX˪
         *========================================*/
        default:
            if ( IsFuncKey(key) )
            {
                if ( !IS_EDIT_LOCK() )     /* UXk\䤹\s */
                    EndEdit(0);
            }
            else if ( Is_accept(ptr, &key) )         /* ˬdO_ŦX˪ */
            {
                sword  len = strlen(ptr->var);

                /* pGЦmWXrhɪť */
                if ( len <= this->curAddr )
                {
                    if ( ptr->isNumeric )
                        this->curAddr = len;
                
                    if ( len < this->curAddr )
                    {
                        for ( ; len < this->curAddr ; len++ )
                            ptr->var[len] = ' ';
                        ptr->var[this->curAddr] = '\0';
                    } /* end if */
                    
                    ptr->var[this->curAddr + 1] = '\0';
                } /* end if */

                if ( IS_EDIT_INS_MODE() )
                    Insert(ptr, key, this->curAddr);            /* JҦ */
                else
                    Replace(ptr, key, this->curAddr);           /* NҦ */

                /* жWXBҥ auto enter */
                if ( (++this->curAddr >= ptr->len) && IS_EDIT_AUTOENTER() )
                {
                    Process_key(ptr, ENTER_KEY);
                    this->lastKey = ENTER_KEY;
                } /* end if */
            } /* end if */

            break;
   
    } /* end switch */
} /* end Process_key */


/*-------------------------  d P   O _  X -----------------------*/
static sword Is_accept (ATTR *ptr, sword *inkey)
{
    sword  bAccept = TRUE;
    sword  type, key;

    key = *inkey;
    
    if ( ptr->readOnly )
        return( FALSE );

    if ( (key < 32) || (key > 255) )
        return( FALSE );
    
    if ( ptr->isPassword )
        return( TRUE );

    /*=====================================
     *  oйmir
     *  @ XirAܾi
     *  @ Ҵyzr, ex. "@C"
     *====================================*/
    type = ( ptr->pict == NULL )   ? 'C' :
           ( ptr->pict[0] == '@' ) ? ptr->pict[1] : ptr->pict[ this->curAddr ];

    switch ( type )
    {
        case 'C':                                           /* Nir */
            break;

        case 'L':                                           /* pg^r */
            bAccept = islower(key);
            break;
        
        case 'U':                                           /* jg^r */
            bAccept = isupper(key);
            break;
        
        case 'A':                                       /* jBpg^r */
            bAccept = isalpha(key);
            break;
        
        case 'F':                             /* Ҧ^r@নjg */
            bAccept = isalpha(key);
            if ( bAccept )
                key = toupper(key);
            break;

        case 'T':                             /* Ҧ^r@নpg */
            bAccept = isalpha(key);
            if ( bAccept )
                key = tolower(key);
            break;
        
        case '9':                                                   /*  0-9 */
            bAccept = isdigit(key);
            break;

        case 'H':                                              /*  0-9, A-F */
            bAccept = isxdigit(key);
            break;

        case '#':                                          /*  0-9  +, - */
            if ( key == '+' || key == '-' )
                bAccept = ( this->curAddr == 0 );
            else
                bAccept = isdigit(key);
            break;
        
        default:
            bAccept = FALSE;
            break;
    } /* end switch */
    
    *inkey = key;
    
    return( bAccept );
} /* end Is_accept */


/*------------------------------ o X ĵ i n ------------------------------*/
static void FireBeep (void)
{
    if ( IS_EDIT_BEEP() )
        Beep();
} /* end FireBeep */


/*----------------------- I s     w  d   --------------------
 *                  N  w     G       
 *----------------------------------------------------------------------------*/
static sbyte *User_Work_Func (ATTR *ptr)
{
    sbyte *str = NULL;
    
    if ( ptr->Work )
    {
        str = (ptr->Work)();                      /* IsϥΪ̳]w~u@ */
        sprintf(ptr->var, "%-*.*s", ptr->len, ptr->len, str);   /* ܭܼƤ */
    } /* end if */
    
    return( str );
} /* end User_Work_Func */


/*---------------------- I s     w  d   ---------------------
 *                  d  G  T  ^ TRUEA _ h  ^ FALSE
 *----------------------------------------------------------------------------*/
static sword User_Check_Func (ATTR *ptr)
{
    sword  ret = TRUE;
    
    if ( !(ptr->readOnly) && (ptr->Check) )      /* DŪB۩wˬd禡 */
        ret = ( (ptr->Check)( ptr->var ) != 0 );   /* IsϥΪ̦۩wˬd禡 */
    
    if ( ret == FALSE )
        FireBeep();              /* ϥΪ̦۩w禡PwJ쪺ƦD */

    return( ret );
} /* end User_Check_Func */


/*------------------------------  N r  --------------------------------*/
static void Replace (ATTR *item, sbyte chr, sword offset)
{
    item->var[offset] = ( (byte)chr > 31 && (byte)chr <= 255 ) ? chr : ' ';
} /* end Replace */


/*------------------------------  J r  --------------------------------*/
static void Insert (ATTR *item, sbyte chr, sword ins_offset)
{
    sword  i;

    for ( i = item->len - 2 ; i >= ins_offset ; i-- )
        item->var[i+1] = item->var[i];
    Replace(item, chr, ins_offset);
} /* end Insert_BootMenu_Rec */


/*------------------------------ R  r  --------------------------------*/
static void Delete (ATTR *item, sword del_offset, sword clreol_flag)
{
    if ( clreol_flag )
        item->var[del_offset] = '\0';
    else if ( del_offset < strlen(item->var) )
        strcpy(item->var + del_offset, item->var + del_offset + 1);
} /* end Delete */


/*---------------------  d   O _       ------------------*/
static sword IsRearItem (void)
{
    return( this->nowEdit >= (this->record - 1) );
} /* end IsRearItem */

