/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h> 
#include <string.h>
#include "selemenu.h"
#include "fdisk.h"
#include "common.h"
#include "undo.h"
#include "global.h"
#include "keymap.h"

#define ITEM_3_8    (ITEM3 | ITEM4 | ITEM_5_8)
                           
static void Show_Disk_Info (PARTN *partnArr);

/*============================   w  ==================================*/
sword Sele_HD (sword use_floppy, sword startItem)
{
    #if ( DISPLAY == CHINESE )
        #define HD_SELE_TITLE_STR  "wнs   `ϬW       e q"
        #define FIRST_FLOPPY_STR   "    @  n  "
        #define DETECT_FAIL_MSG    "<  >"
    #else 
        #define HD_SELE_TITLE_STR  "Hard_Disk  TOT_Cyl       SIZE"
        #define FIRST_FLOPPY_STR   "    First floppy driver"
        #define DETECT_FAIL_MSG    "< Detect failure >"
    #endif

    extern SeleMenu g_Menu;                                 /** ο檫 **/
    static sword    Sele = 1;
    sword           yOffset, bound, nItem, flag, i, x, y;
    sbyte           *unit, *pItem, *ptr;
    double          size;
    DiskDT          *dk;
 
    use_floppy = (use_floppy) ? 1 : 0;
    nItem      = g_Info.nHD + use_floppy;
 
    if ( nItem < 15 )
    {
        yOffset = 2;
        bound   = 7;
    }
    else
    {  
        yOffset = 1;
        bound   = 14;
    } /* end if */
 
    g_Menu.menuColor(DEFAULT_COLOR, LIGHT_BAR_COLOR);
    Redraw_Fdisk_Picture(FALSE);
 
    for ( i = (nItem <= bound) ? 0 : 1;  i >= 0;  i-- )
        c_printXY(i * 44 + 3, 4, HD_SELE_TITLE_STR);
 
    c_gotoxy(3, 5);
    Repeat_Char('-', 76);
 
    x = 5;
    y = 7;
    for ( i = 0 ; i < nItem ; i++ )
    {
        ptr = pItem = g_Menu.allocItemSpace();
  
        sprintf(ptr, "  %2d.  ", i - use_floppy + 1);
        ptr += 7;
  
        if ( use_floppy && (i == 0) )
        {
            flag = ( g_Info.nFP > 0 );
            strcpy(ptr, FIRST_FLOPPY_STR);
        }
        else
        {
            dk   = GetHardDiskDT(i - use_floppy + 1);
            flag = dk->flag & VALID_DISKDT;
   
            if ( flag == 0 )
                sprintf(ptr, "%21s", DETECT_FAIL_MSG);
            else
            {
                sprintf(ptr, "%8lu", dk->lgeo.maxCyl + 1);
                ptr += 8;
    
                size = (double)dk->lgeo.tnSector / 2.0;         /** KB size **/
                size = TranSizeUnit(size, &unit, KB_UNIT);
                sprintf(ptr, " %10.2f %s", size, unit);
            } /* end if */
        } /* end if */
  
        if ( i == bound )
        {
            x = 48;
            y = 7;
        } /* end if */
  
        g_Menu.prompt(x, y, pItem, flag);
  
        if ( ((i+1) / bound) < 2 )
            y += yOffset;
        else
            c_printf(" <=");
    } /* end for */
 
    g_Menu.disableCtrl( M_WRAP | M_ONESELE );
    g_Menu.enableCtrl( M_LOCK );
 
    if ( startItem > 0 )
        Sele = startItem;

    i = g_Menu.select( Sele );
    if ( i > 0 )
       Sele = i;
 
    g_Menu.enableCtrl( M_ONESELE );          /* u@ӿﶵɤܿ */
    return( i );
} /* end Sele_HD */


/*============================   w   T ============================*/
static void Show_Disk_Info (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        static sbyte titleStr[] = "    Ұ  ҩlϬW  ϬW    Mbytes   tID        tκ";
        static sbyte totalStr[] = "`eqG";
        static sbyte extStr[]   = "x XRΡG";
        static sbyte usedStr[]  = "wtG";
    #else 
        static sbyte titleStr[] = "   No.  Boot    Start      End      Mbytes   Sys_ID      File_system";
        static sbyte totalStr[] = "Total: ";
        static sbyte extStr[]   = "  |  Extended: ";
        static sbyte usedStr[]  = "Used: ";
    #endif

    double disk_size, ratio;
    dword  priUsed, extUsed;
    PARTN  tmp, *ptr;
    sbyte  *unit;
    sword  i;
 
    c_printXY(4, 4, titleStr);
 
    c_gotoxy(4, 5);
    Repeat_Char('-', 74);
 
    priUsed = 0;
    extUsed = ( (g_Info.fd.ext_head != -1) &&        /** YXRΫئb}Y **/
                (partnArr[ g_Info.fd.pri_use ].stCyl == g_Info.fd.ext_head + 1) ) ? 1 : 0;
 
    ptr = partnArr;
    for ( i = 0 ; i < g_Info.fd.used ; i++,  ptr++ )
        if ( ptr->id != 0 )
        {
            if ( ptr->no < 5 )
            {
                priUsed += GetNumCyl(ptr);
                if ( Is_Extended(ptr->id) && (ptr->stCyl == 1) )
                    priUsed++;
            }
            else
                extUsed += GetNumCyl(ptr);
        } /* end if */
 
    tmp.sector = 1;
    tmp.stCyl  = tmp.side = 0;
    tmp.endCyl = (sword)CUR_DK->lgeo.maxCyl;
    disk_size  = (double)Get_nSector(&tmp) / 2.0;               /**  KB **/
    ratio      = (double)priUsed * 100.0 / (CUR_DK->lgeo.maxCyl + 1);
 
    if ( ratio > 100.0 )
        ratio = 100.0;
 
    disk_size = TranSizeUnit(disk_size, &unit, KB_UNIT);
    c_printXY(3, 21, "%s%.2f%s", totalStr, disk_size, unit);
    c_printXY(25, 21, "%s%%%-5.1f", usedStr, ratio);
 
    ratio = disk_size = 0.0;
    if ( g_Info.fd.ext_head != -1 )                      /** DXRΤjp **/
    {
        tmp.stCyl  = g_Info.fd.ext_head;
        tmp.endCyl = g_Info.fd.ext_end;
        disk_size  = (double)Get_nSector(&tmp) / 2.0;
        ratio      = (double)extUsed * 100 / (g_Info.fd.ext_end - g_Info.fd.ext_head + 1);
  
        if ( ratio > 100.0 )
            ratio = 100.0;
    } /* end if */
                                   
    disk_size = TranSizeUnit(disk_size, &unit, KB_UNIT);
    c_printf("%s%.2f%s", extStr, disk_size, unit);
    c_printXY(65, 21, "%s%%%-5.1f", usedStr, ratio);
} /* end Show_Disk_Info */


/*====================   u  D    e ] w =====================*/
sword Sele_Partn (PARTN *partnArr, sword startItem, sword flags,
                  sword (*condition)(PARTN *partnArr, sword ndx))
{
    #if ( DISPLAY == CHINESE )
        #define LOGIC_PARTN_MSG       "[޿]"
        #define NON_ALLOC_MSG         "<tm>"
    #else
        #define LOGIC_PARTN_MSG       "[Logic]"
        #define NON_ALLOC_MSG         "<none>"
    #endif   

    extern SeleMenu  g_Menu;
    static sword     begin = 0, offset = 1;
    sword            old_color, sele, ndx, sw, i;
    double           disk_size;
    sbyte            *pItem;
    PARTN            *ptr;
 
    if ( (flags & NO_REDRAW_MENU) == 0 )
        Redraw_Fdisk_Picture(TRUE);
    Show_Disk_Info(partnArr);
 
    g_Menu.disableCtrl( M_WRAP | M_LOCK );     /** `BDk **/
    g_Menu.enableCtrl(M_ONESELE);            /* u@ӿﶵɤܿ */
 
    old_color = DEFAULT_COLOR;
    g_Menu.menuColor(old_color, LIGHT_BAR_COLOR);

    /* fixed by SPF, 2002.11.17 */
    if ( startItem > 0 )
    {
        if ( g_Info.fd.used < startItem )
            startItem = g_Info.fd.used;

        if ( startItem < PARTN_MENU_ITEMS )
            begin = 0;
        else if ( (g_Info.fd.used - startItem) > PARTN_MENU_ITEMS )
            begin = startItem - 1;
        else
            begin = g_Info.fd.used - PARTN_MENU_ITEMS;
        
        offset = startItem - begin;
    } /* end if */

    /* fixed by SPF, 2002.11.16 */
    if ( (begin + offset) > g_Info.fd.used )
    {
        begin  = 0;
        offset = 1;
    } /* end if */

    do
    {
        sw  = 1;
        ndx = begin;
        ptr = partnArr + ndx;
        for ( i = 0 ; (i < PARTN_MENU_ITEMS) && (ndx < g_Info.fd.used) ; i++, ndx++, ptr++ )
        {
            if ( (ndx > 0) &&
                 ( ((ptr->no >= 5 || ptr->no == -1) &&
                    ((ptr-1)->no < 5 || (ptr-1)->no == 0)) ||
                   (i == 0) && ((ptr->no > 4) || (ptr->no == -1)) ) )
            {             
                c_printXY(5, i + 6, LOGIC_PARTN_MSG);
                c_printf("%*c", 65, ' ');
                sw = 0;
            } /* end if */
   
            disk_size = (double)Get_nSector(ptr) / 2048;
   
            pItem = g_Menu.allocItemSpace();
   
            if ( ptr->id != 0 )
            {
                sprintf(pItem, "%4d %5c %8ld %9ld %11.2f     %02x      %-18s",
                               ptr->no,
                               ((ptr->active == 0x80) ? '' : ' '),
                               ptr->stCyl, ptr->endCyl, disk_size, ptr->id,
                               g_SysName[ptr->id]);
            }
            else
            {
                 sprintf(pItem, " ??? %5c %8ld %9ld %11.2f %10c %-19s",
                                ((ptr->active == 0x80) ? '*' : ' '),
                                ptr->stCyl,  ptr->endCyl,  disk_size,  ' ',
                                NON_ALLOC_MSG);
            } /* end if */
   
            if ( ptr->id == 0 )                        /** WΤC **/
                g_Menu.itemColor( UNUSED_PARTN_COLOR );
            else if ( ptr->problem )
                g_Menu.itemColor( PROBLEM_PARTN_COLOR );
         /* else if ( ptr->id == 0x20 )
                g_Menu.itemColor( BOOTMGR_PARTN_COLOR );
         */

            /** [JAå condition MwﶵO_Ū **/
            g_Menu.prompt(5, i + 6 + ((sw == 0) ? 1 : 0),
                          pItem, (*condition)(partnArr, begin + i));
                          /*pItem, (*condition)(partnArr, i)); */

            g_Menu.itemColor(old_color);                   /** ٭w]C **/
        } /* end for */
  
        c_textattr(BOOT_DEF_COLOR);                  /** ܽbYܥi½ **/
        c_printXY(73, 4, "%s%s", ((ndx < g_Info.fd.used) ? "[]" : "   "),
                                 ((begin > 0) ? "[]" : "   ") );
        c_textattr(DEFAULT_COLOR);

        sele = g_Menu.select( offset );  /** ΦAΰb offset  **/
        if ( sele > 0 )
            offset = sele;
        else
            switch( g_Menu.lastKey() )             /** }ɫU **/
            {
                case LEFT_KEY:
                case UP_KEY:
                    offset = 1;
                    if ( begin >= 1 )
                        begin--;
                    break;

                case RIGHT_KEY:
                case DOWN_KEY:
                    offset = i;
                    if ( ndx < g_Info.fd.used )
                        begin++;
                    break;
    
                case PAGE_UP_KEY:                                /** W@ **/
                    begin = ( (begin - PARTN_MENU_ITEMS) > 0 ) ? begin - PARTN_MENU_ITEMS : 0;
                    break;
    
                case PAGE_DOWN_KEY:                              /** U@ **/
                    if ( g_Info.fd.used > PARTN_MENU_ITEMS )
                    {
                        if ( (g_Info.fd.used - ndx) < PARTN_MENU_ITEMS )
                            begin = g_Info.fd.used - PARTN_MENU_ITEMS;
                        else
                            begin = ndx;

                        if ( begin < 0 )
                            begin = 0;
                    } /* end if */
                    break;
    
                case C_HOME_KEY:                               /** ܭ **/
                    begin  = 0;
                    offset = 1;
                    break;
    
                case C_END_KEY:                                /** ܧ **/
                    if ( g_Info.fd.used >= PARTN_MENU_ITEMS )
                        begin = g_Info.fd.used - PARTN_MENU_ITEMS;
                    break;
    
                case TAB_KEY:
                case ESC_KEY:
                    return(-1);
    
            } /* end switch */
    } while ( g_Menu.lastKey() != ENTER_KEY );

    sele = begin + offset;

    /* added by SPF, 2002.11.17 */
    /** pGܧnNβܤU@ӿﶵ **/
    if ( (flags & MOVE_LIGHT_BAR) && (sele < g_Info.fd.used) )
    {
        if ( offset >= PARTN_MENU_ITEMS )
            begin++;
        else
            offset++;
    } /* end if */
 
    return( sele );
} /* end Sele_Partn */


/*====================   u  D    e ] w =====================*/
void Fdisk_Menu (PARTN *partnArr, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        #define ARE_SURE_DELE_PARTN_MSG  "T w n R     H"
        #define SET_ACTIVE_MSG           "2. ]w"
        #define CLR_ACTIVE_MSG           "2. "
        #define HIDDEN_OFF_MSG           "9. Ѱ"
        #define HIDDEN_ON_MSG            "9. ä"
        #define BOX_X                    63
        #define END_BOX_X                78
        static sbyte *Mnu[] =
        {
            "1. إߤ",           NULL,  "3. t΢ע",
            "4. R",  "5. վ",  "6. ",
            "7. ",  "8. ɦLϰ",           NULL,
            "0. DOS u"
        };
    
    #else  /* !CHINESE */
        #define ARE_SURE_DELE_PARTN_MSG  "Are you sure to delete partition ?"
        #define SET_ACTIVE_MSG           "2. Set Active"
        #define CLR_ACTIVE_MSG           "2. Clr Active"
        #define HIDDEN_OFF_MSG           "9. Hidden OFF"
        #define HIDDEN_ON_MSG            "9. Hidden ON"
        #define BOX_X                    62
        #define END_BOX_X                79
        static sbyte *Mnu[] =
        {
            "1. Create",    NULL,              "3. Modify ID",
            "4. Delete",    "5. Adjust",       "6. Exchange",
            "7. Check",     "8. Dump Sector",  NULL,
            "0. DOS Tools"
        };          
    #endif /* !CHINESE */

    extern  SeleMenu g_Menu;
    static  sword sele = 1;
    sword   flags, i;
    PARTN   *ptr;
 
    ptr    = partnArr + (ndx - 1);                       /** Vw **/
    Mnu[1] = ( ptr->active != 0x80 ) ? SET_ACTIVE_MSG : CLR_ACTIVE_MSG;
    Mnu[8] = ( IsHiddenPartn(ptr) )  ? HIDDEN_OFF_MSG : HIDDEN_ON_MSG;
 
    /*
     * BzΤﶵTBP]wA
     *  low bit }lU bit @ӿﶵA FALSE ̪ܸӿﶵŪ
     */
    if ( ptr->id == 0 )                                          /** Ť **/
    {
        flags = ITEM7 | ITEM8;                           /** BɦL **/
        if ( (ptr->no != 0) || (g_Info.fd.primary < 4) )
            flags |= ITEM1;                                    /** إߤ **/
    }
    else
    {
        flags = ITEM_3_8;                                    /* w]Pඵ */
  
        if ( ChkSysID(ptr->old_id, FAT12_16_32) )
            flags |= ITEM10;

        if ( g_Info.expertMode || !Is_Extended(ptr->old_id) )
        {
            flags |= ITEM9;                                    /** å\ **/
   
            /*
             * νsp󤭪̤~\ʤΪ]w
             */
            if ( ptr->no < 5 )
               flags |= ITEM2;                             /** ]wҰʤ **/
        } /* end if */
    } /* end if */
 
    /*
     * ͥο
     */
    g_Menu.menuColor( PAR_MENU_COLOR, LIGHT_BAR_COLOR );
    for ( i = 0 ; i < 10 ; i++,  flags >>= 1 )
    {
        g_Menu.itemColor( ((flags & 1) == 0) ? NON_SELE_COLOR : PAR_MENU_COLOR );
        g_Menu.prompt(BOX_X + 2,  i * 2 + 3, Mnu[i], flags & 1);
    } /* end for */
 
    g_Menu.enableCtrl( M_WRAP | M_LOCK );      /** `BDk **/

    MenuBox(BOX_X, 2, END_BOX_X, 22, NULL);              /** øsΤ **/
 
    i = sele;
    sele = g_Menu.select(sele);
 
    switch( sele )
    {
        case 1:                                    /** إߤ, partnmak.c **/
            CreateNewPartn(partnArr, ndx - 1);
            break;
  
        case 2:                                 /** ]w Active, in fdisk.c **/
            Set_Active_Partn(partnArr, ptr, TRUE);
            break;
  
        case 3:                                   /** tID, partnid.c **/
            Set_ID(partnArr, ndx - 1);
            Redraw_Fdisk_Picture(TRUE);
            break;
  
        case 4:                                    /** R, partndel.c **/
            if ( YN_box(TALK_BOX, ARE_SURE_DELE_PARTN_MSG) )
                Del_Partn(partnArr, ndx - 1);
            break;
  
        case 5:                                    /** վ, partnadj.c **/
            Adjust_partn(partnArr, ndx - 1);
            break;
   
        case 6:                                    /** մ, partnchg.c **/
            Exchange_partn(partnArr, ndx - 1);
            break;
  
        case 7:                                    /** , chk_disk.c **/
            SetHotKeySW(F5_KEY, FALSE);                    /** Ȱ F5  **/
            Chk_Surface(ptr->stCyl, ptr->endCyl, 0);
            SetHotKeySW(F5_KEY, TRUE);                     /** _ F5  **/
            break;
  
        case 8:                                /** ܱҰʺϰ, showsect.c **/
            ShowSector(ptr->stCyl, ptr->side, ptr->sector, HEX_DUMP);
            break;
  
        case 9:                                            /** áB **/
            Hidden_partn(ptr);
            break;
  
        case 10:                                   /** DOS u, dostools.c **/
            SetHotKeySW(F5_KEY, FALSE);                    /** Ȱ F5  **/
            Dos_Tools(partnArr, ndx);
            SetHotKeySW(F5_KEY, TRUE);                     /** _ F5  **/
            break;
  
        default:
            sele = i;
            break;
    } /* end switch */
 
    return;
} /* end Fdisk_Menu */


/*======================== FDISK D    e ] w =======================*/
void Fdisk_Tab_Menu (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )   
        #define ARE_SURE_RESET_MSG       "T w n  m    H"
        #define REMAKE_MBR_MSG           "Twnإثeu@Ъ ۢТ H"
        #define MBR_MAKE_DONE_MSG        " s   I"
        #define END_X                    22
        static sbyte *tabMenu[] =
        {
            "1. ɦLϰϤe", "2. mθ", "3. wЪ",
            "4. Bz}", "5. MaҦ", "6.   FAT32",
            "7.  ۢТ",  "8. ƥΦ^s",   "9. x s  ",
            "0. u@w"
        };
    
    #else  /* !CHINESE */
        #define ARE_SURE_RESET_MSG       "Are you sure to reset ?"
        #define REMAKE_MBR_MSG           "Are you sure to rebuild the MBR ? "
        #define MBR_MAKE_DONE_MSG        "MBR rebuild success !"
        #define END_X                    30
        static sbyte *tabMenu[] =
        {
            "1. Dump Physical Sector",  "2. Reset Partition Table",
            "3. The HD Surface Test",   "4. Process Boot Object",
            "5. Expert mode switch",    "6. Setup Support FAT 32",
            "7. Rebuild the MBR",       "8. Backup and Restore",
            "9. Save Partition Table",  "0. Change Work Hard Disk"
        };
    #endif /* !CHINESE */

    extern SeleMenu g_Menu;
    static sword sele = 1;
    sword  err, y, i;
 
    MenuBox(3, 2, END_X, 22, NULL);                      /** øsΤ **/
    g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
    y = 3;
    for ( i = 0 ; i < sizeof(tabMenu) / sizeof(sbyte *) - 2 ; i++,  y += 2 )
        g_Menu.prompt(5, y, tabMenu[i], TRUE);
    g_Menu.prompt(5, y,   tabMenu[i],   g_Info.fd.canSaveFlag);
    g_Menu.prompt(5, y+2, tabMenu[i+1], g_Info.nHD > 1);

    g_Menu.enableCtrl( M_WRAP | M_LOCK );      /** `BDk **/

    i    = sele;
    sele = g_Menu.select(sele);
 
    switch( sele )
    {
        case 1:                                /** ܹϰ, showsect.c **/
            Display_Sector();
            break;
  
        case 2:                                  /** Ϊm, partndel.c **/
            if ( YN_box(TALK_BOX, ARE_SURE_RESET_MSG) )
            {
                Reset_Partn(partnArr);
                g_Info.fd.modified = 2;
            } /* end if */
            break;
  
        case 3:                                    /** , chk_disk.c **/
            SetHotKeySW(F5_KEY, FALSE);                    /** Ȱ F5  **/
            Chk_Surface(0, (sword)CUR_DK->lgeo.maxCyl, 0);
            SetHotKeySW(F5_KEY, TRUE);                     /** _ F5  **/
            break;
  
        case 4:                                /** jMΪ, partnobj.c **/
            SetHotKeySW(F5_KEY, FALSE);                    /** Ȱ F5  **/
            Process_Partn_Object( partnArr );
            SetHotKeySW(F5_KEY, TRUE);                     /** _ F5  **/
            break;
  
        case 5:                                            /** ϥμҦ **/
            g_Info.expertMode = !g_Info.expertMode;
            break;
  
        case 6:                                /** O_䴩 FAT 32, fdisk.c **/
            g_Info.fd.use_fat32 = Set_Fat32_Support();
            break;
  
        case 7:                                    /**  MBR, partnsav.c **/
            if ( !YN_box(IMMEDIATE_BOX, REMAKE_MBR_MSG) )
                Cancel_Box();
            else
            {
               if ( Update_MBR(CUR_DK) == 0 )
                   Prompt_Msg_Box(MBR_MAKE_DONE_MSG, NULL);
               else
                   ShowError( 6 );                      /** ΪsѡI**/
            } /* end if */
            break;

        case 8:                                      /** ƥΦ^s, undo.c **/
            backup_restore(partnArr);
            break;
  
        case 9:                                    /** xs, partnsav.c **/
            if ( (err = Save_Partn(partnArr)) == 0 )
               g_Info.fd.modified = 0;
            else
            {
                Clr_Block(2, 3, 77, 20);
                if ( err == -1 )
                    ShowError( 6 );                           /** gJѡI**/
            } /* end if */
            break;
  
        case 10:                          /** 󴫤u@Ϻ, Chg_Work_Disk.c **/
            Chg_Work_Disk(partnArr);
            break;
  
        default:
            sele = i;
            break;
 
    } /* end switch */
} /* end Fdisk_Tab_Menu */
