/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"

static void  Swap_Element (void *elem1, void *elem2, sword elem_size);
static sword Find_Overlap (PARTN *ptr, PARTN *end);

/*========================== R X U   T ==============================*/
sword Find_Problem (PARTN *partnArr)
{
    PARTN  *cmp, *ext, *end;
    sword  errFlag = FALSE;
 
    end = partnArr + g_Info.fd.used;
    for ( cmp = partnArr ; cmp < end ; cmp++ )
        cmp->problem = FALSE;
 
    ext = NULL;
    end = partnArr + g_Info.fd.pri_use;
    for ( cmp = partnArr ; cmp < end ; cmp++ )         /** MDΰϭ| **/
        if ( cmp->id )
        {
            if ( Is_Extended(cmp->old_id) )
            {
                if ( ext )
                {
                    errFlag = TRUE;
                    cmp->problem = TRUE;
                }
                else
                    ext = cmp;
            } /* end if */
  
            if ( (cmp->stCyl > cmp->endCyl) || Find_Overlap(cmp, end) )
            {
                cmp->problem = TRUE;
                errFlag = TRUE;                                /** o{| **/
            } /* end if */
        } /* end if */
 
    if ( ext )
    {
        end = partnArr + g_Info.fd.used;
        for ( ; cmp < end ; cmp++ )                  /** M޿ΰϭ| **/
            if ( cmp->stCyl > cmp->endCyl || Out_of_ext(cmp) ||
                 Find_Overlap(cmp, end) || Is_Extended(cmp->old_id) )
            {
                cmp->problem = TRUE;
                errFlag = TRUE;                                /** o{| **/
            } /* end if */
    } /* end if */
 
    g_Info.fd.canSaveFlag = ( errFlag ) ? FALSE : TRUE;
 
    return( errFlag );
} /* end Find_Problem */


/*==========================  d O _  | ==============================*/
static sword Find_Overlap (PARTN *ptr, PARTN *end)
{
    PARTN  *cmp = ptr++;

/*  if ( cmp->endCyl > CUR_DK->lgeo.maxCyl )
        return( TRUE );
*/
    for ( ; ptr < end ; ptr++ )
        if ( cmp->endCyl >= ptr->stCyl )
            return( TRUE );                                    /** o{| **/
    return( FALSE );
} /* end Find_Overlap */


/*==========================  d O _  | ==============================*/
sword Find_Partn_No (PARTN *partnArr, sword no)
{
    sword  i;

    for ( i = 0 ; i < g_Info.fd.used ; i++ )
        if ( partnArr[i].no == no )
            return(i + 1);
    return(0);
} /* end Find_Partn_No */


/*============================       ============================*/
sword IsLegalBootSect (PARTN *ptr)
{
    byte  buff[512];
 
    if ( chs_ReadWDK(ptr->side, ptr->stCyl, ptr->sector, 1, buff) )
        return( FALSE );
 
    return( *(word *)&buff[510] == 0xaa55 );
} /* end IsLegalBootSect */


/*===================== ˬd buffer eO_æ޿ ====================*/
sword IsLikeExtPartn (void *buffer)
{
    byte   *buff = (byte *)buffer;
    sword  i;

    if ( *(word *)&buff[0x1fe] != 0xaa55 )
        return( FALSE );
    if ( buff[0x1be] || buff[0x1ce] )
        return( FALSE );
    for ( i = 0x1de ; i < 0x1fe ; i++ )            /** ˬd̫ **/
        if ( buff[i] )
            return( FALSE );
    for ( i = 0x1be ; i < 0x1ce ; i += 4 )           /** ˬdĤ@ **/
        if ( *(dword *)&buff[i] == 0 )
            return( FALSE );
    for ( i = 0x1ce ; i < 0x1de ; i += 4 )           /** ˬdĤG **/
        if ( *(dword *)&buff[i] )
            break;

    /** pGĤGOŪAΪ̤OŪ **/
    return( (i >= 0x1de) || Is_Extended(buff[0x1d2]) );
} /* end IsLikeExtPartn */


/*============================== Size Unit ==================================*/
double TranSizeUnit (double val, sbyte **retUnitStr, sword valUnit)
{
    static sbyte unitStr[][3] = { "KB", "MB", "GB", "TB", "PB", "EB" };
    sword  i;
 
    if ( valUnit > EB_UNIT )
        valUnit = EB_UNIT;
    else if ( valUnit < KB_UNIT )
        valUnit = KB_UNIT;
 
    for ( i = valUnit ; (i < EB_UNIT) && (val > 1024.0) ; i++ )
    {
        val /= 1024.0;
        valUnit++;
    } /* end for */
 
    *retUnitStr = unitStr[valUnit];
    return( val );
} /* end TranSizeUnit */


/*==================== Get allocate cyl of the partition ====================*/
dword GetNumCyl (PARTN *ptr)
{
    return( (dword)((ptr->stCyl <= ptr->endCyl ) ? (ptr->endCyl - ptr->stCyl) :
                                                   (ptr->stCyl - ptr->endCyl)) + 1 );
} /* end GetNumCyl */


/*==========================    l   ==============================*/
dword GetStart (PARTN *ptr)
{
    return( CHS_to_Sect(ptr->stCyl, ptr->side, ptr->sector, CUR_DK) );
} /* end GetStart */


/*==========================    l   ==============================*/
dword GetEnd (PARTN *ptr)
{
    return( CHS_to_Sect(ptr->endCyl, CUR_DK->lgeo.maxHead,
                        CUR_DK->lgeo.maxSect, CUR_DK) );
} /* end GetEnd */


/*======================= O _  Q      ========================*/
sword IsHiddenPartn (PARTN *ptr)
{
    return( IsHiddenID(ptr->id) );
} /* end IsHiddenPartn */


/*============================  o FAT    ===========================*/
sword IsFAT (byte *Bootrec)
{
    static sbyte *id_name[] ={ "FAT12", "FAT16", "FAT32"};
    sword  id;
 
    id = ( *(word *)&Bootrec[510] != 0xaa55 ) ? 3 : 0;
    for ( ; id < 3 ; id++ )
        if ( CompMEM(Bootrec + ((id < 2) ? 0x36 : 0x52), id_name[id], 5) == 0 )
            break;
 
    return( (id == 0) ? 12 :
            (id == 1) ? 16 :
            (id == 2) ? 32 : 0 );
} /* end IsFAT */


/*======================== զXϰϡBϬW 2 byte ==========================*/
void Asm_Sect_Cyl (byte *buff, dword sector, dword cyl)
{
    /** Xϭy 8,9 bit **/
    buff[0] = (byte)(sector & 0x3f) | ((cyl >> 2) & 0xc0);
 
    /** ϭyѤU 0 - 7 bit **/   
    buff[1] = (byte)cyl;
} /* end Asm_Sect_Cyl */


/*============================= pΦϰϼ ============================*/
dword Get_nSector (PARTN *ptr)
{
   dword begin = GetStart(ptr);
   dword end   = GetEnd(ptr);

   return( ((end > begin) ? end - begin : begin - end) + 1 );
} /* end compute_sects */


/*=========================== SHOW Capacity =================================*/
void Show_Capacity (sbyte *chi_title, double nSects, sword sw)
{
    static  sbyte unitStr[] = " KMGTPE";
    sbyte   *unit, *ptr;
    double  size;
 
    if ( chi_title )
        c_printf(chi_title);
 
    size = TranSizeUnit(nSects / 2, &unit, KB_UNIT);
    c_printf("%.2f %s", size, unit);
 
    if ( sw )
    {
        ptr = strchr(unitStr, *unit);
        c_printf(" (1%cB = 1024%cBytes)", *ptr, *(ptr - 1));
    } /* end if */
} /* end Show_Capacity */


/*=============================  M X R   ===========================*/
sword Find_EXT (PARTN *partnArr)
{
    sword  i;
 
    for ( i = 0 ; i < g_Info.fd.pri_use ; i++ )             /** MXR **/
        if ( Is_Extended(partnArr[i].old_id) )
            break;
    return( (i < g_Info.fd.pri_use) ? i : -1 );
} /* end Find_EXT */


/*============================== Swap two element ===========================*/
static void Swap_Element (void *elem1, void *elem2, sword elem_size)
{
    byte   *e1 = (byte *)elem1;
    byte   *e2 = (byte *)elem2;
    byte   tmp;

    while ( elem_size-- > 0 )
    {
        tmp   = *e1;
        *e1++ = *e2;
        *e2++ = tmp;
    } /* end while */
} /* end Swap_Element */


/*=============================== Selection sort ===========================*/
void Select_Sort (void *base, sword elem_num, sword elem_size,
                  sword (*fcmp)(const void *elem1, const void *elem2))
{
    byte   *curr, *walk, *min;
    sword  i, j;

    curr = (byte *)base;
    for ( i = 0 ; i < elem_num - 1 ; i++ )
    {
        min  = curr;
        walk = curr + elem_size;

        /*----------------- find minmum element -----------------*/
        for ( j = i + 1 ; j < elem_num ; j++ )
        {
            if ( (*fcmp)(min, walk) > 0 )
                min = walk;
            walk += elem_size;
        } /* end for */

        /*---------- swap element ----------*/
        if ( min != curr )
            Swap_Element(min, curr, elem_size);
             
        curr += elem_size;
    } /* end for */
} /* end Select_Sort */


/*======================== ϶(|۰ʧP_O_|) =====================*/
void CopyMem (void *target, const void *source, word size)
{
    byte  *sptr = (byte *)source;
    byte  *tptr = (byte *)target;
 
    if ( sptr != tptr )
    {
        if ( (tptr > sptr) && (tptr < (sptr + size)) )         /** Ŷ| **/
        {
            sptr += size;
            tptr += size;
            while ( --sptr >= (byte *)source )                 /** ϦV **/
                *(--tptr) = *sptr;
        }
        else
        {
            for ( ; size > 0 ; size-- )
               *tptr++ = *sptr++;
        } /* end if */
    } /* end if */
} /* end CopyMem */

