/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <mem.h>
#include "fdisk.h"
#include "bootmgr.h"
#include "undo.h"
#include "global.h"

/*==================== Nuʺϰন ѡ֡ w} =======================*/
void Sect_to_CHS (dword linearSect, dword *c, dword *h, dword *s, DiskDT *dk)
{
    /*
     * INT 13h ϥΪϺдXAäO ATA hϥΪ
     */
    if ( c )
        *c = linearSect / dk->lgeo.sectPerCyl;
    if ( h )
        *h = (linearSect % dk->lgeo.sectPerCyl) / dk->lgeo.maxSect;
    if ( s )
        *s = (linearSect % dk->lgeo.maxSect) + 1;
} /* end Sect_to_CHS */


/*==================== N ѡ֡ w}নuʺϰ =======================*/
dword CHS_to_Sect (dword c, dword h, dword s, DiskDT *dk)
{
    return( (c * (dk->lgeo.maxHead+1) + h) * dk->lgeo.maxSect + s - 1 );
} /* end CHS_to_Sect */


/*====================       l O _   =====================*/
sword IsValid (DiskDT *dk)
{
    return( dk && (dk->flag & VALID_DISKDT) );
}  /* end IsValid */


/*=========================== LBA w}gJu@ ============================*/
sword linear_WriteWDK (dword linearSect, dword nSects, void *buff)
{
    return( CUR_DK->drv->linearWrite(CUR_DK, linearSect, nSects, buff) );
} /* end linear_WriteWDK */


/*=========================== LBA w}Ūu@ ============================*/
sword linear_ReadWDK (dword linearSect, dword nSects, void *buff)
{
    return( CUR_DK->drv->linearRead(CUR_DK, linearSect, nSects, buff) );
} /* end linear_ReadWDK */


/*=========================== CHS w}gJu@ ============================*/
sword chs_WriteWDK (dword head, dword cyl, dword sect, dword nSects, void *buff)
                              
{
    return( CUR_DK->drv->chsWrite(CUR_DK, head, cyl, sect, nSects, buff) );
} /* end ChsWriteWDK */


/*=========================== CHS w}Ūu@ ============================*/
sword chs_ReadWDK (dword head, dword cyl, dword sect, dword nSects, void *buff)
{      
    return( CUR_DK->drv->chsRead(CUR_DK, head, cyl, sect, nSects, buff) );
} /* end ChsReadeWDK */


/*=========================== CHS w}u@ ============================*/
sword chs_CheckWDK (dword head, dword cyl, dword sect, dword nSects, void *buff)
{
    return( CUR_DK->drv->chsCheck(CUR_DK, head, cyl, sect, nSects, buff) );
} /* end chs_CheckWDK */


/*=============================== mu@ ================================*/
sword ResetWorkDisk (void)
{
    return( CUR_DK->drv->reset(CUR_DK) );
} /* end ResetWorkDisk */


/*=========================== NYrJsϰ ==========================*/
sword Fill_Sector (DiskDT *dk, dword NowSect, dword nSect, byte ch)
{
    static byte buff[512] = "";
    dword  i;
 
    if ( buff[0] != ch )                           /** CommBuff must static **/
        memset(buff, ch, 512);
  
    for ( i = 0 ; i < nSect ; i++,  NowSect++ )
        if ( dk->drv->linearWrite(dk, NowSect, 1, buff) )
            return(-1);
 
    return(0);
} /* end Fill_Sector */


/*=========================        ============================*/
sword CopySector (DiskDT *dk, dword Source, dword Target, dword nSects)
{           
    byte   CommBuff[512 * BUFF_nSECT];        /** BUFF_nSECT wqb fdisk.h **/
    long   offset;
    double Total;
    sword  Error = 0;
 
    #if ( DISPLAY == CHINESE )
        ShowMSG("w   --->");
    #else
        ShowMSG("Working  --->");
    #endif
 
    Total = (double)nSects;
 
    /*----------------------------------------+
    |   P w    V    \     |
    +----------------------------------------*/
    if ( Source < Target )
    {
        offset = -BUFF_nSECT;
        Source = Source + nSects - BUFF_nSECT;           /** qݰfV **/
        Target = Target + nSects - BUFF_nSECT;
    }
    else                                                       /** V **/
        offset = BUFF_nSECT;
 
    /*-----------------+
    |    i      |
    +-----------------*/
    for ( ; nSects > BUFF_nSECT ; nSects -= BUFF_nSECT )
    {  
        Error  |= (dk->drv->linearRead(dk, Source, BUFF_nSECT, CommBuff) |
                   dk->drv->linearWrite(dk, Target, BUFF_nSECT, CommBuff));
        Source += offset;
        Target += offset;
  
        if ( ((word)nSects & 0xFF) == 0 )
           c_printXY(27, 23, "%6.2f%%", ((Total - (double)nSects) / Total) * 100.0f );
    } /* end for */
 
    if ( nSects != 0 )
    {
        if ( offset < 0 )
        {
            Source = Source + BUFF_nSECT - nSects;       /** ưh **/
            Target = Target + BUFF_nSECT - nSects;
        } /* end if */
      
        Error |= dk->drv->linearRead(dk, Source, (sword)nSects, CommBuff);
        Error |= dk->drv->linearWrite(dk, Target, (sword)nSects, CommBuff);
    } /* end if */
 
    c_printf("100.00%%");
    return( Error );
} /* end CopySector */


/*---------------------------- onкϺаѼ ------------------------------+
|  ndx ܱoĴXnоѼƵc}Aq 1 }lϥ                    |
|  b SPFDisk UOHoӵc}ӫwƱsϺо                      |
+-----------------------------------------------------------------------------+
| ex.  DiskDT  *dk = GetFloppyDT(2);        // ĤGnо                   |
|      dk->drv->linearRead(dk, 0, 2, buff); // Ѳ 0 ϰŪ 2ӺϰϨ buff |
+----------------------------------------------------------------------------*/
DiskDT *GetFloppyDT (word ndx)
{
    if ( (ndx > 0) && (ndx <= g_Info.nFP) )
        return( &g_DTable[ndx - 1] );
    return( NULL );
} /* end GetFloppyDT */


/*---------------------------- owкϺаѼ ------------------------------+
|  ndx ܱoĴXwоѼƵc}Aq 1 }lϥ                    |
|  b SPFDisk UOHoӵc}ӫwƱsϺо                      |
+-----------------------------------------------------------------------------+
| ex.  DiskDT  *dk = GetHardDiskDT(2);      // ĤGwо                   |
|      dk->drv->linearRead(dk, 0, 2, buff); // Ѳ 0 ϰŪ 2ӺϰϨ buff |
+----------------------------------------------------------------------------*/
DiskDT *GetHardDiskDT (word ndx)
{
    if ( (ndx > 0) && (ndx <= g_Info.nHD) )
        return( &g_DTable[g_Info.nFP + ndx - 1] );
    return( NULL );
} /* end GetHardDiskDT */


/*---------------------------- wثeu@Ϻ ------------------------------+
|  b SPFDisk UOHoӵc}ӫwƱsϺо                      |
+-----------------------------------------------------------------------------+
|  ex.  DiskDT  *dk = GetHardDiskDT(2);    // ĤGwо                    |
|       SetWorkingDisk(dk);                // wu@                    |
|       linear_ReadWDK(0, 2, buff);        // Ѳ 0 ϰŪ 2 ӺϰϨ buff |
+----------------------------------------------------------------------------*/
void SetWorkingDisk (DiskDT *dk)
{
    CUR_DK = dk;
} /* end SetWorkingDisk */

