; A tool for APM power management in FreeDOS.
; Copyright Eric Auer 2003. Please do not spread - just send
; me (NASM) CODE to complete the project! When done, you will
; be credited and the project will be released under GPL 2.
; Please read apmnotes.txt for an outline of the workings.

; This file: hookhandlers - call to hook interrupt handlers.
; Returns CY set if POWER is already resident.
; To be used together with handlers.asm, of course. Like
; handlers, this is influenced by the UNIDLECHECK define.
; FUTURE extension: removetsr - call to remove existing TSR

removetsr:
	; *** ***
	; maybe add some "unhook / unload TSR" option here?
	; *** ***
	stc
	ret

; ---------------

hookhandlers:
	mov ax,5400h
	xor bx,bx
	int 2fh	; POWER install check
	cmp bx,504dh
	jnz goingTSR
	stc
	ret	; already TSR
goingTSR:
	cld
	mov si,hooktable
hookloop:
	lodsb	; int number
	or al,al
	jz hookdone
	mov dx,ax
	push es
	mov ah,35h
	int 21h	; get vector to ES:BX
	mov cx,es
	pop es
	lodsw	; storage pointer
	mov di,ax
	mov ax,bx
	stosw	; store old vector, offset
	mov ax,cx
	stosw	; store old vector, segment
	mov ax,dx
	mov ah,25h
	push ax
	lodsw	; handler offset
	mov dx,ax
	pop ax
	int 21h	; set vector to DS:DX
	jmp short hookloop
hookdone:
	clc
	ret

hooktable:
	db 16h
	dw oldi16,i16
	db 28h
	dw oldi28,i28
	db 2ah
	dw oldi2a,i2a
	db 2fh
	dw oldi2f,i2f
%ifdef UNIDLECHECK
	db 08h
	dw oldi08,i08
	db 10h
	dw oldi10,i10
	db 13h
	dw oldi13,i13
	db 14h
	dw oldi14,i14
	db 17h
	dw oldi17,i17
	db 21h
	dw oldi21,i21
%endif
	db 0

