/*    
   Dircount.c - count the number of entries in a directory.
   
   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/


#include "..\header\rdwrsect.h"
#include "..\header\direct.h"
#include "..\header\fat.h"
#include "..\header\subdir.h"
#include "..\header\bool.h"

struct PipeStruct {

     int  count;
     char attribute;

};

int counter(RDWRHandle handle, struct DirectoryPosition* pos, void** buffer)
{
    struct DirectoryEntry entry;

    struct PipeStruct* p = *((struct PipeStruct**) buffer);

    GetDirectory(handle, pos, &entry);

    if (entry.attribute & p->attribute) p->count++;

    return TRUE;
}

int low_dircount(RDWRHandle handle,
                 CLUSTER cluster,
                 char attribute)
{
    struct PipeStruct pipe, *ppipe = &pipe;

    pipe.count     = 0;
    pipe.attribute = attribute;

    if (IsRootDirPosition(handle, pos))
       if (TraverseRootDir(handle, counter, (void**) &pipe, TRUE))
          return pipe.count;
    else
    {
       if (!cluster) return -1;

       if (TraverseSubdir(handle, cluster, counter, (void**) &ppipe, TRUE))
          return pipe.count;
    }

    return -1;
}
