
;	Main data table for the assembler.

asmtab	db	16,139,255,248,64,55,255,248,63,234,255,18,243,255,6,5
	db	245,173,221,245,176,68,245,4,212,5,111,255,1,53,245,173
	db	67,245,175,170,245,0,4,0,159,255,10,213,245,174,119,245
	db	176,222,245,9,164,10,63,255,240,29,205,255,239,29,129,255
	db	241,133,148,255,241,133,225,255,249,242,137,49,255,241,126,17
	db	241,179,79,255,245,241,133,73,245,241,180,54,255,245,241,130
	db	225,245,241,179,233,255,245,241,128,121,245,241,179,156,255,69
	db	212,181,59,181,109,46,95,255,249,45,184,255,74,152,255,75
	db	204,255,75,50,255,240,78,206,255,73,177,255,244,98,99,255
	db	244,97,47,255,244,96,226,255,244,98,22,255,244,96,226,255
	db	244,97,124,255,244,100,203,255,244,100,49,255,244,99,228,255
	db	244,100,126,255,244,98,22,255,244,96,226,255,244,97,47,255
	db	244,98,99,255,244,97,47,255,244,97,201,255,244,100,126,255
	db	244,99,228,255,244,100,49,255,244,100,203,255,244,96,149,255
	db	244,99,151,255,244,98,253,255,244,97,201,255,244,96,72,255
	db	244,99,74,255,244,99,74,255,244,99,151,255,244,98,176,255
	db	244,97,124,255,18,13,175,94,177,197,16,220,17,119,255,49
	db	238,255,249,50,59,255,245,242,129,244,255,243,183,60,255,243
	db	125,186,255,249,46,5,255,11,187,255,14,35,255,254,255,252
	db	255,21,185,245,185,165,245,189,142,255,253,255,239,60,58,255
	db	65,69,240,255,65,69,225,255,154,19,155,72,65,13,192,66
	db	66,192,255,66,221,192,66,198,193,255,154,178,155,231,255,165
	db	213,255,170,165,255,65,69,224,255,250,65,223,226,255,244,65
	db	244,208,255,244,65,244,192,255,244,65,167,192,255,244,65,167
	db	208,255,244,65,167,200,255,244,65,167,208,255,244,65,167,192
	db	255,244,65,244,192,255,244,65,244,208,255,244,65,244,200,255
	db	244,65,244,216,255,244,65,244,200,255,244,65,167,216,255,244
	db	65,167,200,255,158,227,160,24,65,20,208,64,248,209,255,244
	db	65,251,240,244,65,223,241,255,244,67,47,240,244,67,19,241
	db	255,161,75,162,128,65,20,216,64,248,217,255,66,198,217,255
	db	241,65,69,255,255,65,69,246,255,250,65,223,225,255,168,131
	db	169,184,65,13,240,66,66,248,255,66,221,248,66,198,249,255
	db	169,34,170,87,255,170,235,172,32,65,13,248,66,66,240,255
	db	66,221,240,66,198,241,255,171,138,172,191,255,250,65,223,224
	db	255,66,148,192,255,159,130,160,183,255,161,234,163,31,255,154
	db	255,156,52,168,50,255,65,69,247,255,250,65,223,227,255,159
	db	207,161,4,255,162,55,163,108,173,2,255,154,96,155,149,167
	db	9,65,96,192,255,65,69,232,255,65,69,233,255,65,69,234
	db	255,65,69,235,255,65,69,236,255,65,69,237,255,65,69,238
	db	255,250,166,110,255,164,10,255,156,123,157,176,65,13,200,66
	db	66,200,255,66,221,200,66,198,201,255,157,26,158,79,255,65
	db	69,208,255,65,69,243,255,65,69,248,255,241,65,69,245,255
	db	65,69,242,255,65,69,252,255,165,62,255,250,170,14,255,65
	db	69,253,255,250,240,65,223,228,255,241,65,69,254,255,241,65
	db	69,251,255,65,69,250,255,159,48,160,101,66,148,208,255,161
	db	152,162,205,171,217,66,148,216,255,250,171,62,255,250,168,218
	db	255,250,67,49,224,172,114,255,163,179,164,232,65,13,224,66
	db	66,232,255,66,221,232,66,198,233,255,164,82,165,135,255,166
	db	27,167,80,65,13,232,66,66,224,255,66,221,224,66,198,225
	db	255,166,186,167,239,255,65,69,228,255,241,66,149,224,241,66
	db	121,225,255,244,65,251,232,244,65,223,233,255,244,67,47,232
	db	244,67,19,233,255,241,66,149,232,241,66,121,233,255,241,65
	db	146,233,255,46,159,255,65,69,229,255,65,97,200,65,69,201
	db	255,65,69,244,255,65,69,241,255,65,69,249,255,73,100,255
	db	189,219,255,189,65,241,129,171,239,32,78,239,32,79,239,31
	db	182,239,31,183,255,68,183,71,32,255,19,81,245,185,88,245
	db	239,32,124,255,249,239,32,201,255,61,129,61,207,255,61,246
	db	255,242,79,104,255,242,192,80,255,249,62,67,255,35,242,241
	db	117,167,255,34,190,241,116,115,255,34,113,241,116,38,255,35
	db	165,241,117,90,255,34,113,241,116,38,255,249,68,110,255,35
	db	11,241,116,192,255,38,90,241,120,15,255,37,192,241,119,117
	db	255,37,115,241,119,40,255,38,13,241,119,194,255,35,165,241
	db	117,90,255,34,113,241,116,38,255,34,190,241,116,115,255,35
	db	242,241,117,167,255,34,190,241,116,115,255,35,88,241,117,13
	db	255,38,13,241,119,194,255,37,115,241,119,40,255,37,192,241
	db	119,117,255,38,90,241,120,15,255,34,36,241,115,217,255,37
	db	38,241,118,219,255,36,140,241,118,65,255,35,88,241,117,13
	db	255,33,215,241,115,140,255,36,217,241,118,142,255,36,217,241
	db	118,142,255,37,38,241,118,219,255,36,63,241,117,244,255,35
	db	11,241,116,192,255,70,214,70,33,181,213,182,7,70,111,255
	db	47,211,255,240,77,162,255,59,72,255,241,130,145,255,58,251
	db	255,241,131,43,255,241,131,120,255,42,112,255,239,60,117,255
	db	240,190,207,255,240,191,28,255,240,193,68,255,240,192,16,255
	db	246,240,51,188,255,249,52,9,255,249,68,34,68,33,255,249
	db	67,213,67,212,255,249,67,213,67,212,255,249,67,136,67,135
	db	255,249,67,136,67,135,255,240,77,239,255,240,193,145,255,48
	db	77,48,232,40,236,41,135,42,71,42,226,53,31,55,136,194
	db	234,241,86,231,241,87,130,241,87,54,241,87,209,241,88,31
	db	241,88,186,255,49,84,255,249,49,161,255,241,134,87,241,134
	db	165,255,241,131,239,241,132,61,255,188,244,255,245,188,167,255
	db	43,80,255,245,188,90,255,3,157,245,173,144,245,175,247,245
	db	2,108,3,7,255,251,255,69,97,71,202,255,239,33,22,255
	db	249,239,33,99,255,197,133,26,137,9,140,2,81,7,35,241
	db	125,167,241,128,16,255,249,239,29,45,255,249,47,57,255,24
	db	33,182,111,239,32,31,239,31,132,4,109,6,214,9,63,2
	db	4,241,125,90,241,127,195,255,249,239,28,224,255,249,46,236
	db	255,200,144,202,249,239,205,98,255,200,221,203,70,239,205,175
	db	255,199,246,202,95,239,204,200,255,200,67,202,172,239,205,21
	db	255,243,92,10,255,246,243,246,243,246,242,58,167,58,155,255
	db	249,61,15,61,3,255,243,128,34,255,47,134,255,201,42,203
	db	147,239,205,252,255,202,17,204,122,239,206,227,255,11,164,14
	db	13,16,118,18,223,30,78,30,156,255,247,38,247,46,247,54
	db	247,62,247,100,247,101,201,42,203,147,239,205,252,255,201,119
	db	203,224,239,206,73,255,8,109,245,174,42,245,176,145,245,7
	db	60,7,215,255,52,86,255,249,52,163,255,241,122,173,255,241
	db	121,121,255,241,121,44,255,241,122,96,255,241,121,44,255,241
	db	121,198,255,241,125,21,255,241,124,123,255,241,124,46,255,241
	db	124,200,255,241,122,96,255,241,121,44,255,241,121,121,255,241
	db	122,173,255,241,121,121,255,241,122,19,255,241,124,200,255,241
	db	124,46,255,241,124,123,255,241,125,21,255,241,120,223,255,241
	db	123,225,255,241,123,71,255,241,122,19,255,241,120,146,255,241
	db	123,148,255,241,123,148,255,241,123,225,255,241,122,250,255,241
	db	121,198,255,240,190,53,255,240,190,130,255,241,126,151,241,126
	db	229,255,241,128,255,241,129,77,255,240,192,169,255,240,191,118
	db	255,74,229,255,76,25,255,75,127,255,51,34,255,249,51,111
	db	255,240,192,247,255,13,61,245,174,196,245,177,43,245,12,12
	db	12,167,255,50,137,187,178,39,184,39,185,255,240,193,222,255
	db	240,194,43,255,46,159,255,242,79,181,255,243,91,112,255,245
	db	242,134,196,255,43,149,43,150,245,40,82,245,40,83,255,64
	db	171,255,64,171,255,15,165,245,175,17,245,177,120,245,14,116
	db	15,15,255

;	Data on groups (for the assembler).

agroups	dw	131,128,442,255,455,254,246,257,256,198,143,208,210,192

;	This is the list of assembler mnemonics.

mnlist	db	1,1,"AAA",0,1,4,"AAD",0,1,8,"AAM",0,1,12,"AAS",0
	db	1,15,"ADC",0,1,29,"ADD",0,1,43,"AND",0,1,57,"ARPL",0
	db	1,61,"BOUND",0,1,65,"BSF",0,1,69,"BSR",0
	db	1,73,"BSWAP",0,1,78,"BT",0,1,85,"BTC",0,1,94,"BTR",0
	db	1,103,"BTS",0,1,112,"CALL",0,1,122,"CBW",0,2,37,"CDQ",0
	db	1,125,"CLC",0,1,128,"CLD",0,1,131,"CLI",0,1,134,"CLTS",0
	db	1,138,"CMC",0,1,141,"CMOVA",0,1,145,"CMOVAE",0
	db	1,149,"CMOVB",0,1,153,"CMOVBE",0,1,157,"CMOVC",0
	db	1,161,"CMOVE",0,1,165,"CMOVG",0,1,169,"CMOVGE",0
	db	1,173,"CMOVL",0,1,177,"CMOVLE",0,1,181,"CMOVNA",0
	db	1,185,"CMOVNAE",0,1,189,"CMOVNB",0,1,193,"CMOVNBE",0
	db	1,197,"CMOVNC",0,1,201,"CMOVNE",0,1,205,"CMOVNG",0
	db	1,209,"CMOVNGE",0,1,213,"CMOVNL",0,1,217,"CMOVNLE",0
	db	1,221,"CMOVNO",0,1,225,"CMOVNP",0,1,229,"CMOVNS",0
	db	1,233,"CMOVNZ",0,1,237,"CMOVO",0,1,241,"CMOVP",0
	db	1,245,"CMOVPE",0,1,249,"CMOVPO",0,1,253,"CMOVS",0
	db	2,2,"CMOVZ",0,2,6,"CMP",0,2,17,"CMPSB",0
	db	2,20,"CMPSD",0,2,21,"CMPSW",0,2,24,"CMPXCHG",0
	db	2,29,"CMPXCHG8B",0,2,33,"CPUID",0,6,194,"CS",0
	db	2,38,"CWD",0,1,121,"CWDE",0,2,41,"DAA",0,2,44,"DAS",0
	db	2,47,"DB",0,2,49,"DD",0,2,51,"DEC",0,2,57,"DIV",0
	db	6,198,"DS",0,2,60,"DW",0,2,62,"ENTER",0,6,192,"ES",0
	db	2,66,"F2XM1",0,2,70,"FABS",0,2,74,"FADD",0
	db	2,85,"FADDP",0,2,97,"FBLD",0,2,100,"FBSTP",0
	db	2,103,"FCHS",0,2,107,"FCLEX",0,2,112,"FCMOVA",0
	db	2,117,"FCMOVAE",0,2,122,"FCMOVB",0,2,127,"FCMOVBE",0
	db	2,132,"FCMOVE",0,2,137,"FCMOVNA",0,2,142,"FCMOVNAE",0
	db	2,147,"FCMOVNB",0,2,152,"FCMOVNBE",0,2,157,"FCMOVNE",0
	db	2,162,"FCMOVNU",0,2,167,"FCMOVNZ",0,2,172,"FCMOVU",0
	db	2,177,"FCMOVZ",0,2,182,"FCOM",0,2,193,"FCOMI",0
	db	2,202,"FCOMIP",0,2,211,"FCOMP",0,2,222,"FCOMPP",0
	db	2,226,"FCOS",0,2,231,"FDECSTP",0,2,235,"FDISI",0
	db	2,240,"FDIV",0,2,251,"FDIVP",0,3,8,"FDIVR",0
	db	3,19,"FDIVRP",0,3,31,"FENI",0,3,36,"FFREE",0
	db	2,92,"FIADD",0,3,40,"FICOM",0,3,45,"FICOMP",0
	db	3,3,"FIDIV",0,3,26,"FIDIVR",0,3,50,"FILD",0
	db	3,141,"FIMUL",0,3,57,"FINCSTP",0,3,61,"FINIT",0
	db	3,66,"FIST",0,3,71,"FISTP",0,3,253,"FISUB",0
	db	4,21,"FISUBR",0,3,78,"FLD",0,3,88,"FLD1",0
	db	3,116,"FLDCW",0,3,120,"FLDENV",0,3,96,"FLDL2E",0
	db	3,92,"FLDL2T",0,3,104,"FLDLG2",0,3,108,"FLDLN2",0
	db	3,100,"FLDPI",0,3,112,"FLDZ",0,3,123,"FMUL",0
	db	3,134,"FMULP",0,2,108,"FNCLEX",0,2,236,"FNDISI",0
	db	3,32,"FNENI",0,3,62,"FNINIT",0,3,117,"FNLDCW",0
	db	3,146,"FNOP",0,3,175,"FNSAVE",0,3,183,"FNSETPM",0
	db	3,221,"FNSTCW",0,3,225,"FNSTENV",0,3,229,"FNSTSW",0
	db	3,150,"FPATAN",0,3,154,"FPREM",0,3,158,"FPREM1",0
	db	3,163,"FPTAN",0,3,167,"FRNDINT",0,3,171,"FRSTOR",0
	db	6,200,"FS",0,3,174,"FSAVE",0,3,178,"FSCALE",0
	db	3,182,"FSETPM",0,3,188,"FSIN",0,3,193,"FSINCOS",0
	db	3,198,"FSQRT",0,3,202,"FST",0,3,220,"FSTCW",0
	db	3,224,"FSTENV",0,3,210,"FSTP",0,3,228,"FSTSW",0
	db	3,235,"FSUB",0,3,246,"FSUBP",0,4,3,"FSUBR",0
	db	4,14,"FSUBRP",0,4,26,"FTST",0,4,30,"FUCOM",0
	db	4,39,"FUCOMI",0,4,48,"FUCOMIP",0,4,57,"FUCOMP",0
	db	4,66,"FUCOMPP",0,4,71,"FWAIT",0,4,74,"FXAM",0
	db	4,78,"FXCH",0,4,85,"FXTRACT",0,4,89,"FYL2X",0
	db	4,93,"FYL2XP1",0,6,202,"GS",0,4,97,"HLT",0
	db	4,100,"IDIV",0,4,103,"IMUL",0,4,121,"IN",0,4,126,"INC",0
	db	4,132,"INSB",0,4,136,"INSD",0,4,137,"INSW",0
	db	4,141,"INT",0,4,146,"INTO",0,4,149,"INVD",0
	db	4,153,"INVLPG",0,4,158,"IRET",0,4,157,"IRETD",0
	db	4,161,"JA",0,4,167,"JAE",0,4,173,"JB",0,4,179,"JBE",0
	db	4,185,"JC",0,4,192,"JCXZ",0,4,195,"JE",0,4,191,"JECXZ",0
	db	4,201,"JG",0,4,207,"JGE",0,4,213,"JL",0,4,219,"JLE",0
	db	5,90,"JMP",0,4,225,"JNA",0,4,231,"JNAE",0,4,237,"JNB",0
	db	4,243,"JNBE",0,4,249,"JNC",0,4,255,"JNE",0,5,6,"JNG",0
	db	5,12,"JNGE",0,5,18,"JNL",0,5,24,"JNLE",0
	db	5,30,"JNO",0,5,36,"JNP",0,5,42,"JNS",0,5,48,"JNZ",0
	db	5,54,"JO",0,5,60,"JP",0,5,66,"JPE",0,5,72,"JPO",0
	db	5,78,"JS",0,5,84,"JZ",0,5,101,"LAHF",0,5,104,"LAR",0
	db	5,108,"LDS",0,5,126,"LEA",0,5,129,"LEAVE",0
	db	5,115,"LES",0,5,118,"LFS",0,5,133,"LGDT",0,5,122,"LGS",0
	db	5,137,"LIDT",0,5,141,"LLDT",0,5,145,"LMSW",0
	db	5,149,"LOCK",0,5,151,"LODSB",0,5,154,"LODSD",0
	db	5,155,"LODSW",0,5,159,"LOOP",0,5,158,"LOOPD",0
	db	5,165,"LOOPE",0,5,164,"LOOPED",0,5,177,"LOOPNE",0
	db	5,176,"LOOPNED",0,5,183,"LOOPNZ",0,5,182,"LOOPNZD",0
	db	5,171,"LOOPZ",0,5,170,"LOOPZD",0,5,188,"LSL",0
	db	5,111,"LSS",0,5,192,"LTR",0,5,196,"MOV",0
	db	5,233,"MOVSB",0,5,236,"MOVSD",0,5,237,"MOVSW",0
	db	5,240,"MOVSX",0,5,247,"MOVZX",0,5,254,"MUL",0
	db	6,2,"NEG",0,6,6,"NOP",0,6,9,"NOT",0,6,13,"OR",0
	db	6,27,"ORG",0,6,29,"OUT",0,6,34,"OUTSB",0
	db	6,38,"OUTSD",0,6,39,"OUTSW",0,6,43,"POP",0
	db	6,61,"POPA",0,6,60,"POPAD",0,6,66,"POPF",0
	db	6,65,"POPFD",0,6,69,"PUSH",0,6,95,"PUSHA",0
	db	6,94,"PUSHAD",0,6,100,"PUSHF",0,6,99,"PUSHFD",0
	db	6,103,"RCL",0,6,111,"RCR",0,6,135,"RDMSR",0
	db	6,139,"REP",0,6,141,"REPE",0,6,143,"REPNE",0
	db	6,145,"RET",0,6,151,"RETF",0,6,150,"RETFD",0
	db	6,119,"ROL",0,6,127,"ROR",0,6,156,"RSM",0,6,160,"SAHF",0
	db	6,163,"SAL",0,6,171,"SAR",0,6,220,"SBB",0
	db	6,234,"SCASB",0,6,237,"SCASD",0,6,238,"SCASW",0
	db	6,179,"SEG",0,6,241,"SETA",0,6,245,"SETAE",0
	db	6,249,"SETB",0,6,253,"SETBE",0,7,2,"SETC",0
	db	7,6,"SETE",0,7,10,"SETG",0,7,14,"SETGE",0
	db	7,18,"SETL",0,7,22,"SETLE",0,7,26,"SETNA",0
	db	7,30,"SETNAE",0,7,34,"SETNB",0,7,38,"SETNBE",0
	db	7,42,"SETNC",0,7,46,"SETNE",0,7,50,"SETNG",0
	db	7,54,"SETNGE",0,7,58,"SETNL",0,7,62,"SETNLE",0
	db	7,66,"SETNO",0,7,70,"SETNP",0,7,74,"SETNS",0
	db	7,78,"SETNZ",0,7,82,"SETO",0,7,86,"SETP",0
	db	7,90,"SETPE",0,7,94,"SETPO",0,7,98,"SETS",0
	db	7,102,"SETZ",0,7,106,"SGDT",0,6,204,"SHL",0
	db	7,114,"SHLD",0,6,212,"SHR",0,7,121,"SHRD",0
	db	7,110,"SIDT",0,7,128,"SLDT",0,7,132,"SMSW",0
	db	6,196,"SS",0,7,136,"STC",0,7,139,"STD",0,7,142,"STI",0
	db	7,145,"STOSB",0,7,148,"STOSD",0,7,149,"STOSW",0
	db	7,152,"STR",0,7,156,"SUB",0,7,170,"TEST",0
	db	7,179,"VERR",0,7,183,"VERW",0,7,187,"WAIT",0
	db	7,190,"WBINVD",0,7,194,"WRMSR",0,7,198,"XADD",0
	db	7,203,"XCHG",0,7,214,"XLAT",0,7,217,"XLATB",0
	db	7,220,"XOR",0
end_mnlist:

;	These are equates to refer to the above mnemonics.

MNEM_BSWAP	EQU	71
MNEM_DB	EQU	506
MNEM_LOCK	EQU	1819
MNEM_REP	EQU	2163
MNEM_REPE	EQU	2169
MNEM_REPNE	EQU	2176
MNEM_SEG	EQU	2272
MNEM_WAIT	EQU	2646

;	Number of entries in the following array.

ASMMOD	EQU	77

;	This is an array of indices into the oplists array (below).
;	It is used by the assembler to save space.

opindex	db	0,1,4,7,10,13,16,19,22,25,27,30,33,35,37,39,41
	db	43,45,48,50,52,55,58,62,64,66,68,70,73,75,77,81
	db	85,89,93,96,99,101,103,105,108,110,112,115,118,121,124,127
	db	130,134,138,141,144,146,148,150,152,154,156,158,161,164,167,170
	db	173,175,177,181,185,188,191,194,197,200,203,206

;	These are the lists of operands for the various instruction types.

oplists	db	0	;simple instruction
	db	OP_ALL+OP_AX, OP_ALL+OP_IMM, 0
	db	OP_ALL+OP_RM, OP_ALL+OP_IMM, 0
	db	OP_1632+OP_RM, OP_IMMS8, 0
	db	OP_ALL+OP_RM, OP_ALL+OP_R, 0
	db	OP_ALL+OP_R, OP_ALL+OP_RM, 0
	db	OP_16+OP_RM, OP_16+OP_R, 0
	db	OP_1632+OP_R, OP_1632+OP_M, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, 0
	db	OP_32+OP_R_ADD, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, 0
	db	OP_1632+OP_RM, OP_IMM8, 0
	db	OP_REL1632, 0
	db	OP_FARP, 0
	db	OP_FARMEM, 0
	db	OP_M64, 0
	db	OP_ALL+OP_RM, 0
	db	OP_1632+OP_R_ADD, 0
	db	OP_16+OP_IMM, OP_IMM8, 0
	db	OP_MFLOAT, 0
	db	OP_MDOUBLE, 0
	db	OP_ST, OP_STI, 0
	db	OP_STI, OP_ST, 0
	db	OP_1CHK, OP_STI, OP_ST, 0
	db	OP_32+OP_M, 0
	db	OP_16+OP_M, 0
	db	OP_M80, 0
	db	OP_STI, 0
	db	OP_1CHK, OP_STI, 0
	db	OP_MXX, 0
	db	OP_16+OP_AX, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, OP_IMMS8, 0
	db	OP_1632+OP_R_MOD, OP_1632+OP_R, OP_IMMS8, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, OP_1632+OP_IMM, 0
	db	OP_1632+OP_R_MOD, OP_1632+OP_R, OP_1632+OP_IMM, 0
	db	OP_ALL+OP_AX, OP_IMM8, 0
	db	OP_ALL+OP_AX, OP_DX, 0
	db	OP_3, 0
	db	OP_IMM8, 0
	db	OP_REL8, 0
	db	OP_ECX, OP_REL8, 0
	db	OP_1632+OP_RM, 0
	db	OP_16+OP_RM, 0
	db	OP_16+OP_RM, OP_SEGREG, 0
	db	OP_SEGREG, OP_16+OP_RM, 0
	db	OP_ALL+OP_AX, OP_ALL+OP_MOFFS, 0
	db	OP_ALL+OP_MOFFS, OP_ALL+OP_AX, 0
	db	OP_8+OP_R_ADD, OP_8+OP_IMM, 0
	db	OP_1632+OP_R_ADD, OP_1632+OP_IMM, 0
	db	OP_1632+OP_R, OP_SHOSIZ, OP_8+OP_RM, 0
	db	OP_1632+OP_R, OP_SHOSIZ, OP_16+OP_RM, 0
	db	OP_IMM8, OP_ALL+OP_AX, 0
	db	OP_DX, OP_ALL+OP_AX, 0
	db	OP_1632+OP_M, 0
	db	OP_ES, 0
	db	OP_CS, 0
	db	OP_SS, 0
	db	OP_DS, 0
	db	OP_FS, 0
	db	OP_GS, 0
	db	OP_SHOSIZ, OP_1632+OP_IMM, 0
	db	OP_SHOSIZ, OP_IMM8, 0
	db	OP_ALL+OP_RM, OP_1, 0
	db	OP_ALL+OP_RM, OP_CL, 0
	db	OP_ALL+OP_RM, OP_IMM8, 0
	db	OP_16+OP_IMM, 0
	db	OP_8+OP_RM, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, OP_IMM8, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, OP_CL, 0
	db	OP_1632+OP_AX, OP_1632+OP_R_ADD, 0
	db	OP_1632+OP_R_ADD, OP_1632+OP_AX, 0
	db	OP_32+OP_R_MOD, OP_CR, 0
	db	OP_CR, OP_32+OP_R_MOD, 0
	db	OP_32+OP_R_MOD, OP_DR, 0
	db	OP_DR, OP_32+OP_R_MOD, 0
	db	OP_32+OP_R_MOD, OP_TR, 0
	db	OP_TR, OP_32+OP_R_MOD, 0

OPTYPES_BASE	EQU	12

OPLIST_Z	EQU	113
OPLIST_ES	EQU	158

;	Here is the compressed table of the opcode types.

optypes	db	 22, 22, 25, 25, 13, 13,158,158	; 00 - 07 (main opcode part)
	db	 22, 22, 25, 25, 13, 13,160,  2	; 08 - 0f
	db	 22, 22, 25, 25, 13, 13,162,162	; 10 - 17
	db	 22, 22, 25, 25, 13, 13,164,164	; 18 - 1f
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 20 - 27
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 28 - 2f
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 30 - 37
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 38 - 3f
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 40 - 47
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 48 - 4f
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 50 - 57
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 58 - 5f
	db	 12, 12, 31, 28, 10, 10, 10, 10	; 60 - 67
	db	170, 97,173, 89, 12, 12, 12, 12	; 68 - 6f
	db	115,115,115,115,115,115,115,115	; 70 - 77
	db	115,115,115,115,115,115,115,115	; 78 - 7f
	db	  4,  4,  0,  4, 22, 22, 25, 25	; 80 - 87
	db	 22, 22, 25, 25,124, 31,127,  4	; 88 - 8f
	db	 12,197,197,197,197,197,197,197	; 90 - 97
	db	 12, 12, 47, 12, 12, 12, 12, 12	; 98 - 9f
	db	130,130,133,133, 12, 12, 12, 12	; a0 - a7
	db	 13, 13, 12, 12, 12, 12, 12, 12	; a8 - af
	db	136,136,136,136,136,136,136,136	; b0 - b7
	db	139,139,139,139,139,139,139,139	; b8 - bf
	db	  4,  4,185, 12, 31, 31,  4,  4	; c0 - c7
	db	 57, 12,185, 12,111,113, 12, 12	; c8 - cf
	db	  4,  4,  4,  4,113,113,  0, 12	; d0 - d7
	db	  6,  6,  6,  6,  6,  6,  6,  6	; d8 - df
	db	117,117,117,115,105,105,150,150	; e0 - e7
	db	 45, 45, 47,115,108,108,153,153	; e8 - ef
	db	 10,  0, 10, 10, 12, 12,  4,  4	; f0 - f7
	db	 12, 12, 12, 12, 12, 12,  4,  4	; f8 - ff
	db	 16, 16, 16, 16, 16, 16, 16, 16	; 100 - 107 (Intel group 1)
	db	 19, 19, 19, 19, 19, 19, 19, 19	; 108 - 10f
	db	176,176,176,176,176,176,  0,176	; 110 - 117 (Intel group 2)
	db	179,179,179,179,179,179,  0,179	; 118 - 11f
	db	182,182,182,182,182,182,  0,182	; 120 - 127 (Intel group 2a)
	db	 16,  0, 53, 53, 53, 53, 53, 53	; 128 - 12f (Intel group 3)
	db	 53, 53,120, 49,120, 49,120,  0	; 130 - 137 (Intel group 5)
	db	120,122,122,122,122,122,  0,  0	; 138 - 13f (Intel group 6)
	db	 85, 85, 85, 85,122,  0,122, 85	; 140 - 147 (Intel group 7)
	db	 60, 60, 60, 60, 60, 60, 60, 60	; 148 - 14f (Coprocessor d8)
	db	 64, 64, 82, 82, 64, 64, 64, 64	; 150 - 157
	db	 60,  0, 60, 60, 85, 76, 85, 76	; 158 - 15f (Coprocessor d9)
	db	 80, 82,  8,  0,  8,  8,  8,  8	; 160 - 167
	db	 74, 74, 74, 74, 74, 74, 74, 74	; 168 - 16f (Coprocessor da)
	db	 64, 64, 64, 64,  0,  8,  0,  0	; 170 - 177
	db	 74,  0, 74, 74,  0, 78,  0, 78	; 178 - 17f (Coprocessor db)
	db	 64, 64, 64, 64,  8, 82, 82,  0	; 180 - 187
	db	 62, 62, 62, 62, 62, 62, 62, 62	; 188 - 18f (Coprocessor dc)
	db	 67, 67,  0,  0, 67, 67, 67, 67	; 190 - 197
	db	 62,  0, 62, 62, 85,  0, 85, 76	; 198 - 19f (Coprocessor dd)
	db	 80,  0, 80, 80, 82, 82,  0,  0	; 1a0 - 1a7
	db	 76, 76, 76, 76, 76, 76, 76, 76	; 1a8 - 1af (Coprocessor de)
	db	 70, 70,  0,  8, 70, 70, 70, 70	; 1b0 - 1b7
	db	 76,  0, 76, 76, 78, 51, 78, 51	; 1b8 - 1bf (Coprocessor df)
	db	  0,  0,  0,  0,  8, 82, 82,  0	; 1c0 - 1c7
	db	 12, 12, 12, 12, 12, 12, 12,  0	; 1c8 - 1cf (Coprocessor groups)
	db	 12, 12, 12, 12, 12, 12, 12, 12	; 1d0 - 1d7
	db	 12, 12, 12, 12, 12, 12, 12, 12	; 1d8 - 1df
;	The rest of these are squeezed.
	db	 0,  4,  4, 34, 34, 12, 12, 12
	db	203,209,206,212,215,218, 12, 12
	db	 34, 34, 34, 34, 34, 34, 34, 34
	db	 34, 34, 34, 34, 34, 34, 34, 34
	db	 45, 45, 45, 45, 45, 45, 45, 45
	db	 45, 45, 45, 45, 45, 45, 45, 45
	db	187,187,187,187,187,187,187,187
	db	187,187,187,187,187,187,187,187
	db	166,166, 12, 39,189,193,168,168
	db	 12, 39,189,193, 34, 22, 22, 31
	db	 39, 31, 31,142,146,  4, 39, 34
	db	 34,142,146, 22, 22,  4, 37, 37
	db	 37, 37, 37, 37, 37, 37, 53, 53
	db	 42, 42, 42, 42, 51,156, 16, 12
	db	 12, 12, 12, 12, 12, 12, 12, 12
	db	 12, 12, 12, 87

;	And here is the compressed table of additional information.

opinfo	dw	00020h,00020h,00020h,00020h,00020h,00020h,00836h,00812h	; 00
	dw	007e9h,007e9h,007e9h,007e9h,007e9h,007e9h,00836h,001e0h	; 08
	dw	0001ah,0001ah,0001ah,0001ah,0001ah,0001ah,00836h,00812h	; 10
	dw	008c2h,008c2h,008c2h,008c2h,008c2h,008c2h,00836h,00812h	; 18
	dw	00026h,00026h,00026h,00026h,00026h,00026h,00001h,001eeh	; 20
	dw	00a3bh,00a3bh,00a3bh,00a3bh,00a3bh,00a3bh,00101h,001f4h	; 28
	dw	00a8bh,00a8bh,00a8bh,00a8bh,00a8bh,00a8bh,00201h,00002h	; 30
	dw	001a0h,001a0h,001a0h,001a0h,001a0h,001a0h,00301h,00014h	; 38
	dw	005c2h,005c2h,005c2h,005c2h,005c2h,005c2h,005c2h,005c2h	; 40
	dw	00204h,00204h,00204h,00204h,00204h,00204h,00204h,00204h	; 48
	dw	00836h,00836h,00836h,00836h,00836h,00836h,00836h,00836h	; 50
	dw	00812h,00812h,00812h,00812h,00812h,00812h,00812h,00812h	; 58
	dw	0183dh,01818h,01033h,0202ch,03401h,03501h,03010h,03020h	; 60
	dw	01836h,015b6h,01836h,015b6h,015c8h,015d6h,017fah,0180ah	; 68
	dw	006ach,00694h,00614h,0060eh,006c7h,006a6h,00619h,00609h	; 70
	dw	006c2h,006a0h,006b6h,006bch,00643h,0063dh,00648h,00638h	; 78
	dw	00100h,00100h,00000h,00108h,00a41h,00a41h,00a75h,00a75h	; 80
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,006dfh,007a3h,002f8h	; 88
	dw	007ddh,00a75h,00a75h,00a75h,00a75h,00a75h,00a75h,00a75h	; 90
	dw	0006dh,001e1h,00066h,00a56h,0084eh,00827h,008afh,006cch	; 98
	dw	007a3h,007a3h,007a3h,007a3h,007a9h,007b9h,001a6h,001b6h	; a0
	dw	00a41h,00a41h,00a1dh,00a2dh,00722h,00732h,008c8h,008d8h	; a8
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h	; b0
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h	; b8
	dw	00120h,00120h,00888h,00888h,006edh,006d9h,00300h,00300h	; c0
	dw	0121ah,016e5h,0088eh,0088eh,005ddh,005ddh,005e3h,005fah	; c8
	dw	00110h,00110h,00118h,00118h,0000eh,00008h,00000h,00a83h	; d0
	dw	00148h,00158h,00168h,00178h,00188h,00198h,001a8h,001b8h	; d8
	dw	0076dh,00780h,0073ah,00624h,005bdh,005bdh,007f4h,007f4h	; e0
	dw	00066h,0064eh,0064eh,0064eh,005bdh,005bdh,007f4h,007f4h	; e8
	dw	00008h,00000h,00002h,00006h,005a9h,00092h,00128h,00128h	; f0
	dw	00079h,00a0bh,00085h,00a17h,0007fh,00a11h,002e0h,00130h	; f8
	dw	00020h,007e9h,0001ah,008c2h,00026h,00a3bh,00a8bh,001a0h	; 100
	dw	00020h,007e9h,0001ah,008c2h,00026h,00a3bh,00a8bh,001a0h	; 108
	dw	0089dh,008a3h,0085fh,00865h,009d7h,009e4h,00000h,008bch	; 110
	dw	0089dh,008a3h,0085fh,00865h,009d7h,009e4h,00000h,008bch	; 118
	dw	0189dh,018a3h,0185fh,01865h,019d7h,019e4h,00000h,018bch	; 120
	dw	00a41h,00000h,007e3h,007d7h,007d1h,005b6h,0020ah,005afh	; 128
	dw	005c2h,00204h,00066h,00066h,0064eh,0064eh,00836h,00000h	; 130
	dw	029f8h,02a35h,0270dh,0279dh,02a48h,02a4fh,00000h,00000h	; 138
	dw	029d0h,029f1h,026f9h,02706h,029ffh,00000h,02714h,045f1h	; 140
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 148
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 150
	dw	003c8h,00000h,004f7h,0050eh,003ddh,0044bh,00477h,0046eh	; 158
	dw	003c8h,00581h,00308h,00000h,00310h,001c8h,001d0h,001d8h	; 160
	dw	0035dh,0038eh,00365h,0036dh,003b7h,003bfh,00376h,0037eh	; 168
	dw	06276h,06289h,0627fh,062dah,00000h,00318h,00000h,00000h	; 170
	dw	00387h,00000h,003a8h,003afh,00000h,003c8h,00000h,0050eh	; 178
	dw	062a7h,062bch,062b1h,062c6h,00320h,0654ch,062f3h,00000h	; 180
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 188
	dw	00236h,00419h,00000h,00000h,0052ch,0051dh,0033dh,0032eh	; 190
	dw	003c8h,00000h,004f7h,0050eh,004b6h,00000h,0045bh,00481h	; 198
	dw	00355h,00000h,004f7h,0050eh,03544h,0355fh,00000h,00000h	; 1a0
	dw	0035dh,0038eh,00365h,0036dh,003b7h,003bfh,00376h,0037eh	; 1a8
	dw	0023dh,00420h,00000h,00328h,00534h,00524h,00345h,00335h	; 1b0
	dw	00387h,00000h,003a8h,003afh,00245h,00387h,0024ch,003afh	; 1b8
	dw	00000h,00000h,00000h,00000h,00330h,06555h,062fbh,00000h	; 1c0
	dw	003ceh,003efh,003e6h,0040ah,003f8h,00401h,00412h,00000h	; 1c8
	dw	00227h,00592h,004a4h,0048ah,00588h,0349bh,0031ch,00396h	; 1d0
	dw	00493h,0059ah,004efh,034e5h,004ach,004cch,034deh,03315h	; 1d8
;	The rest of these are squeezed.
	dw	     0,00138h,00140h,026d3h,02791h,0208bh,045eah,04a5dh
	dw	037a3h,037a3h,037a3h,037a3h,037a3h,037a3h,05a66h,0586bh
	dw	0616eh,0614ah,060a9h,060a0h,06198h,06165h,060b1h,06098h
	dw	06190h,0615ch,0617eh,06187h,060dbh,060d2h,060e3h,060cah
	dw	036ach,03694h,03614h,0360eh,036c7h,036a6h,03619h,03609h
	dw	036c2h,036a0h,036b6h,036bch,03643h,0363dh,03648h,03638h
	dw	039a4h,03984h,038f5h,038edh,039c9h,0399ch,038fch,038e6h
	dw	039c2h,03994h,039b2h,039bah,03921h,03919h,03928h,03912h
	dw	03836h,03812h,051d4h,0304fh,039ddh,039ddh,03836h,03812h
	dw	058a9h,03060h,039eah,039eah,035b6h,041beh,041beh,03797h
	dw	0305ah,036f3h,03700h,037c9h,037c9h,002e8h,03054h,0303bh
	dw	03041h,037c1h,037c1h,04a6eh,04a6eh,002f0h,04047h,04047h
	dw	04047h,04047h,04047h,04047h,04047h,04047h,005c2h,00204h
	dw	0304fh,03060h,0305ah,03054h,051c8h,00812h,007a3h,00454h
	dw	00254h,0022fh,0053dh,0057ah,03568h,0043ah,00431h,00428h
	dw	00442h,02464h,0030ch,00481h

;	This table converts unsqueezed numbers to squeezed.

sqztab	db	  1,  2,  3,  4,  0,  0,  5,  0
	db	  6,  7,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  8,  9, 10, 11, 12,  0, 13,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 14,  0, 15,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 16, 17, 18, 19, 20, 21, 22, 23
	db	 24, 25, 26, 27, 28, 29, 30, 31
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 32, 33, 34, 35, 36, 37, 38, 39
	db	 40, 41, 42, 43, 44, 45, 46, 47
	db	 48, 49, 50, 51, 52, 53, 54, 55
	db	 56, 57, 58, 59, 60, 61, 62, 63
	db	 64, 65, 66, 67, 68, 69,  0,  0
	db	 70, 71, 72, 73, 74, 75,  0, 76
	db	 77, 78, 79, 80, 81, 82, 83, 84
	db	  0,  0, 85, 86, 87, 88, 89, 90
	db	 91, 92,  0,  0,  0,  0,  0, 93
	db	 94, 95, 96, 97, 98, 99,100,101
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	102,103,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,104,105,106,107
	db	  0,108,  0,  0,  0,  0,  0,  0
	db	109,  0,  0,  0,  0,  0,  0,  0
	db	110,  0,  0,  0,  0,  0,  0,  0
	db	111,  0,  0,  0,  0,  0,  0,  0
	db	112,113,  0,  0,114,115,  0,  0
	db	  0,116,  0,  0,  0,  0,  0,  0
	db	117,118,119,120,121,  0,  0,  0
	db	  0,122,  0,  0,  0,  0,  0,  0
	db	123,  0,  0,  0,  0,  0,  0,  0

;	This is the table of mnemonics that change in the presence of a WAIT
;	instruction.

wtab1	dw	0322h,0321h,0320h,0323h,015dh,019eh,0324h,015fh
	dw	015eh,0330h,019fh
wtab2	dw	025bh,0326h,034eh,03a0h,03d5h,04c4h,04d5h,04fdh
	dw	0505h,0515h,0515h
N_WTAB	equ	11

;	This is the table for operands which have a different mnemonic for
;	their 32 bit versions (66h prefix).

ltab1	dw	098h,0a7h,099h,06dh,0cfh,0adh,0a5h,06fh
	dw	061h,09dh,060h,09ch,0cbh,0cah,0afh,0abh
ltab2	dw	01e7h,01aeh,073h,05cfh,0601h,072ah,07b1h,0802h
	dw	081fh,082eh,0845h,0856h,0895h,0895h,08d0h,0a25h
N_LTAB	equ	16

;	This is the table for operands which have a different mnemonic for
;	their 32 bit versions (67h prefix).

ltab1X	dw	0e3h,0e2h,0e2h,0e1h,0e1h,0e1h,0e1h,0e0h
	dw	0e0h,0e0h,0e0h
ltab2X	dw	0630h,0741h,0741h,0751h,0751h,0788h,0788h,0763h
	dw	0763h,0776h,0776h
N_LTABX	equ	11

;	This is the table of lockable instructions

locktab	dw	010ah,0102h,010h,011h,0108h,0100h,00h,01h
	dw	010ch,0104h,020h,021h,029bh,02efh,0293h,02eeh
	dw	028bh,02edh,0290h,0291h,02e1h,0131h,02e0h,0130h
	dw	012bh,012ah,0109h,0101h,08h,09h,010bh,0103h
	dw	018h,019h,010dh,0105h,028h,029h,02a0h,02a1h
	dw	086h,087h,010eh,0106h,030h,031h
N_LOCK	equ	46

;	Equates used in the assembly-language code.

SPARSE_BASE	equ	480

SFPGROUP3	equ	800

