/*
 * SET.C
 *
 *  06/14/97 (Tim Norman)
 *     changed static var in set() to a malloc'd space to pass to putenv.
 *     need to find a better way to do this, since it seems it is wasting
 *     memory when variables are redefined.
 *
 *  07/08/1998 (John P. Price)
 *  - removed call to show_environment in set command.
 *  - moved test for syntax before allocating memory in set command.
 *  - misc clean up and optimization.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added set_env function to set env. variable without needing set command
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_SET

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "command.h"


int set_env(char *s)
{
  char *env_temp;               /* temporary copy for putenv */
  unsigned char count;          /* counter */

  if ((env_temp = strdup(s)) == NULL)
  {
    error_out_of_memory();
    return 1;
  }

  /* capitalize name of env. var. */
  for (count = 0; env_temp[count] && env_temp[count] != '='; count++)
  {
    env_temp[count] = toupper(env_temp[count]);
  }

  dprintf(("[SET:putenv: %s]\n", env_temp));

  return putenv(env_temp);
}


/*
 * set environment variables
 *
 *
 */
#pragma argsused
int cmd_set(char *first, char *rest)
{
  unsigned char count;          /* counter */

  /* if no parameters, show the environment */
  if (rest[0] == 0)
  {
    /* JPP 07/08/1998 removed call to show_environment */
    for (count = 0; environ[count]; count++)
    {
      puts(environ[count]);
    }
    return 0;
  }

  /* make sure there is an = in the command */
  /* JPP 07/08/1998 moved test for syntax before allocating memory */
  if (strchr(rest, '=') == NULL)
  {
    error_syntax(NULL);
    return 1;
  }

  if (set_env(rest) < 0)
  {
    puts("SET: Environment error");
  }

  return 0;
}

#endif
