/*
 * REDIR.C
 *
 * Comments:
 *
 * 12/15/95 (Tim Norman)
 * started.
 *
 * 12 Jul 98 (Hans B Pufal)
 * - Rewrote to make more efficient and to conform to new command.c and
 *   batch.c processing.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>

static int is_redir(char c)
 {
  return (c == '<') || (c == '>') || (c == '|');
}

int get_redirection(char *s, char *ifn, char *ofn, int *ofatt)
 {
  /*
   * Gets the redirection infor from the command line and copies the
   * file names into ifn and ofn removing them form the command line.
   *
   * Converts remainin command line into a series of null terminated
   * strings defined by the pipe char '|'. Each string corresponds
   * to a single executable command. A double null terminates the
   * command strings.
   *
   * Check for, but do not implement, output append redirect.
   *
   * Return number of command strings found.
   *
   */

  int
    num = 1;

  char
   *dp = s,
   *sp = s;

  /* find and remove all the redirections first */

  while (*sp)
  {
    if ((*sp == '"') || (*sp == '\''))  /* No redirects inside quotes */
    {
      char
        qc = *sp;

      do
        *dp++ = *sp++;
      while (*sp != qc);

      *dp++ = *sp++;
    }

    else if ((*sp == '<') || (*sp == '>'))
    {
      /* MS-DOS ignores multiple redirection symbols and uses the last */
      /* redirection, so we'll emulate that and not check */

      char
       *op = (*sp == '<') ? ifn : ofn;

      if ((*sp++ == '>') && (*sp == '>')) /* Append request ? */
      {
        *ofatt = O_CREAT | O_APPEND | O_TEXT | O_WRONLY;
        sp++;
      }

      while (isspace(*sp))
        sp++;

      while (*sp && !is_redir(*sp) && !isspace(*sp))
        *op++ = *sp++;

      *op = '\0';
    }

    else
      *dp++ = *sp++;
  }

  *dp++ = '\0';
  *dp = '\0';

  /* now go after the pipes */

  sp = s;

  while (*sp)
  {
    if ((*sp == '"') || (*sp == '\''))
    {
      char
        qc = *sp;

      do
        sp++;
      while (*sp != qc);

      sp++;
    }

    else if (*sp == '|')
    {
      *sp++ = '\0';
      num++;
    }

    else
      sp++;
  }

  return num;
}
