/*
 *  ECHO.C - echo command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "command.h"
#include "batch.h"

int cmd_echo(char *cmd, char *param)
{
  /*
   * Perform ECHO command.
   *
   */

  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    printf("%s :\n", cmd);
    return 0;
  }

  if (stricmp(param, D_OFF) == 0)
    echo = 0;
  else if (stricmp(param, D_ON) == 0)
    echo = 1;
  else if (*param)
    puts(param);
  else
    printf("ECHO is %s\n", echo ? D_ON : D_OFF);

  return 0;
}
