/* COMMAND.H
 * header file for the modules in COMMAND.COM
 * Tim Norman
 * 7-15-95
 *
 * 06/29/98 (Rob Lake)
 *  - Moved error messages in here
 *
 * 07/12/98 (Rob Lake)
 *  - Moved more error messages here
 *
 * 30-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - Added compile date to version
 *
 */

#define SHELLVER     "version 0.75 [" __DATE__"]"

#define EnvSeg (*(unsigned far*)MK_FP(_psp, 0x2c))
#define OwnerPSP (*(unsigned far *)MK_FP(_psp, 0x16))

#define BREAK_BATCHFILE 1
#define BREAK_OUTOFBATCH 2
#define BREAK_INPUT 3
#define BREAK_IGNORE 4

/* define some error messages */
#define NOENVERR        "ERROR: no environment"
#define INVALIDDRIVE    "ERROR: invalid drive"
#define INVALIDFUNCTION "ERROR: invalid function"
#define ACCESSDENIED    "ERROR: access denied"
#define BADENVIROMENT   "ERROR: bad enviroment"
#define BADFORMAT       "ERROR: bad format"
#define ERROR_E2BIG     "ERROR: Argument list too long"
#define ERROR_EINVAL    "ERROR: Invalid argument"

#define SHELLINFO    "FreeDOS Command Line Interface"
#define USAGE        "usage"
#define CD_HELP      "change to directory   CD [d:][path]"
#define MD_HELP      "make directory   MD [d:]path"
#define RD_HELP      "remove directory   RD [d:]path"
#define SET_HELP     "SET"

enum
{
  FALSE, TRUE
};

/* prototypes for COMMAND.C */
extern int ctrlBreak;
extern int exitflag;
extern int errorlevel;
extern unsigned far *maxx;
extern unsigned char far *maxy;

void fatal_error(char *);
char is_delim(char);
void execute(char *, char *);
void command(char *);
void parsecommandline(char *);
int c_brk(void);
void initialize(int, char *[]);
void short_version(void);

/* prototypes for INTERNAL.C */
int cmd_dir(char *, char *);
int cmd_chdir(char *, char *);
int cmd_mkdir(char *, char *);
int cmd_rmdir(char *, char *);
int cmd_set(char *, char *);
int cmd_ver(char *, char *);
int cmd_del(char *, char *);
int cmd_rename(char *, char *);
int internal_exit(char *, char *);
int cmd_rem(char *, char *);
int cmd_doskey(char *, char *);
int cmd_prompt(char *, char *);
int cmd_path(char *, char *);
int cmd_date(char *, char *);   /*JPP 07/08/1998 */
int cmd_time(char *, char *);   /*JPP 07/08/1998 */
int cmd_type(char *, char *);   /*JPP 07/08/1998 */
int cmd_truename(char *first, char *rest);  /*RL 07/14/1998 */
int cmd_cls(char *, char *);   /*JPP 07/27/1998 */
int set_env(char *s);
int cmd_verify(char *cmd, char *param);/*JPP 31-Jul-1998 */

/* prototypes for ENVIRON.C */

/* prototypes from PROMPT.C */
void printprompt(void);

/* prototypes for CMDINPUT.C */
void readcommand(char *, int);

/* prototypes for BATCH.C */
/* int batch(char *, char *); - HBP */
int _getch(void);

/* prototypes for WHERE.C */
char *find_which(const char *);

/* prototypes for EXEC.C */
int exec(const char *, char *, const unsigned);

/* prototypes for REDIR.C */

/* prototypes for LOADHIGH.C */
int cmd_loadhigh(char *, char *);
int cmd_loadfix(char *, char *);

/* prototypes for ALIAS.C */
void aliasexpand(char *, int);
int aliasswapout(void);
int aliasswapin(void);
int cmd_alias(char *, char *);

/* Prototypes for ERR_HAND.C */
void init_error_handler(void);
void printstring(char *);
char *get_err(unsigned);
void interrupt far dos_critical_error(unsigned, unsigned, unsigned, unsigned,
                          unsigned, unsigned, unsigned, unsigned, unsigned);

/* Prototypes for MISC.C */
int exist(const char *);
int chkCBreak(int);
int cgetchar(void);
int split(char *, char **);
char *parse_firstarg(char *);

/* Prototypes for ERROR.C */
void error_no_pipe(void);
void error_bad_command(void);
void error_invalid_drive(void);
void error_req_param_missing(void);
void error_sfile_not_found(char *);
void error_file_not_found(void);
void error_path_not_found(void);
void error_too_many_parameters(char *);
void error_invalid_switch(char);
void error_out_of_memory(void);
void error_syntax(char *);

void msg_pause(void);

/* [ HBP 16 Jul 1998   */

/* use the first line for debugging messages.  2nd for none. */
#ifdef DEBUG
#define dprintf(p)  printf p
#else
#define dprintf(p)
#endif

#define D_ON         "on"
#define D_OFF        "off"

/* Flags used in CMDTABLE */

#define CMD_SPECIAL     1
#define CMD_BATCHONLY   2

struct CMD
{
  char *name;
  int flags;
  int (*func) (char *, char *);
};

/* New procs in BATCH.C */

char *readbatchline(int *);
char *find_arg(int);

/* The MSDOS Batch Commands [MS-DOS 5.0 User's Guide and Reference p359] */
int cmd_call(char *, char *);
int cmd_echo(char *, char *);
int cmd_for(char *, char *);
int cmd_goto(char *, char *);
int cmd_if(char *, char *);
int cmd_pause(char *, char *);
int cmd_shift(char *, char *);

int cmd_beep(char *, char *);

/* The following are changes to old lines, originals commented out with
 * -HBP tag */

int get_redirection(char *, char *, char *, int *);

int batch(char *, char *, char *);

/*   HBP 16 Jul 1998 ] */
