/*
 * SET.C
 *
 *  06/14/97 (Tim Norman)
 *     changed static var in set() to a malloc'd space to pass to putenv.
 *     need to find a better way to do this, since it seems it is wasting
 *     memory when variables are redefined.
 *
 *  07/08/1998 (John P. Price)
 *  - removed call to show_environment in set command.
 *  - moved test for syntax before allocating memory in set command.
 *  - misc clean up and optimization.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added set_env function to set env. variable without needing set command
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_SET

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <environ.h>

#include "command.h"

/*
 *                                                                            Helper function for displaying all environment variables
 */
#pragma argsused
static int set_view(void *arg, word segm, word ofs)
{
  printf("%Fs\n", MK_FP(segm, ofs));
  return 0;                     /* don't stop */
}

/*
 * set environment variables
 *
 *
 */
#pragma argsused
int cmd_set(char *rest)
{

  char *p;
  int saveCase,
    rv;

  saveCase = 0;
  if (*rest == '/')
  {
    while (!isspace(rv = toupper(*++rest)) && rv)
      switch (rv)
      {
        case 'C':
          saveCase = 1;
        case '/':
          break;
      }
    if (*rest)
      while (isspace(*++rest)) ;
  }

  /* if no parameters, show the environment */
  if (rest[0] == 0)
  {
    env_forAll(0, set_view, 0);
    return 0;
  }

  /* make sure there is an = in the command */
  if ((p = strchr(rest, '=')) == NULL)
  {
    if ((p = getEnv(rest)) == NULL)
    {
      error_env_var_not_found(rest);
      return 1;
    }
    puts(p);
    return 0;
  }

  if (saveCase)
  {
    *p = '\0';
    rv = chgEnv1(rest, p + 1);
  }
  else
    rv = putEnv(rest);

  if (rv < 0)
  {
    error_env();
    return 1;
  }

  return 0;
}
#endif
