/*
 *  GOTO.C - goto command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28 Jul 1998 (Hans B Pufal) [HBP_003]
 *   Terminate label on first space character, use only first 8 chars of
 *   label string
 *
 * 10-Aug-1998 ska
 * - moved code into readbatchline() that automatically supports
 *   modifyable scripts & ^Break checks
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "command.h"
#include "batch.h"
#include "strings.h"

#pragma argsused
int cmd_goto(char *param)
{
/*
 * Perform GOTO command.
 *
 * Only valid if batch file current.
 *
 */

  char *tmp;

	if (bc == NULL)
  {
    /*!! not in batch error */

    return 1;
  }

	if (*param == '\0')
	{
		display_string(TEXT_ERROR_NO_GOTO_LABEL);
		exit_batch();
    return 1;
  }

  tmp = param;
  while (*tmp && !isspace(*tmp))
    tmp++;
  *tmp = '\0';

  tmp = strdup(param);
  if (!tmp)
  {
    error_out_of_memory();
    return 1;
  }

  bc->brewind = 1;
  bc->blabel = tmp;

  return 0;
}
