
;   DISPLAY.COM v0.6
;
;   ===================================================================
;
;   FreeDOS driver for loading EGA/VGA/SVGA character generator
;   to bring national language support to different screen modes
;
;   Copyright (C) 9 Aug 2000 Ilya V. Vasilyev aka AtH//UgF@hMoscow
;   e-mail: hscool@netclub.ru
;
;   Copyright (C) 27 Aug 2002 Aitor Santamara_Merino
;   email:  aitor.sm@wanadoo.es
;
;   WWW:    http://www.freedos.org/
;
;   ===================================================================
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;   ===================================================================
;
;   Limitations:
;   - EGA and VGA monitors  (VESA working (?))
;   - commandline tool (no device driver, no IOCTL yet)
;   - support for only one extra codepage (hardware codepage assumed 437)
;   - to be used with supplied MODECONC.EXE only
;   - parses RAW files only (no CPI files)
;   - does not query KEYB before selecting a new codepage
;   - does not admit parameters
;   - does not admit "force hardware type" by commandline
;   - does not support subfonts
;
;
;               .       .       .       .       .       line that rules

                %include "display.inc"

                ORG     100H

                jmp     NEAR Install     ; for the moment, simply go to Install
;                DB      -1
;                DW      8000H           ; Attributes
;                DW      Strategy-100H
;                DW      Init-100H
;                DB      "DISPLAY "      ; Device name
;dRequest:       DD      ?


;===================================================================
; INTERRUPT ROUTINE FOR 10h (video adapter interrup)
;
; ah=00h   (set video mode) 
;          reload the font after changing the video mode
; ax=4f02h (set superVGA mode)
;          reload the font after changing the video mode
; ah=11h   (character generation functions)
;          al= 30h: get info about tables
;          al= 1h, 2h, 4h, 11h, 12h, 14h: load fonts in text mode
;          al= 22h, 23h, 24h: load fonts in graphics mode
;
; NOTES:
; flgOur: clear if we should process function ah=00h
;
;               .       .       .       .       .       line that rules

                ;************** check if active

New10:          test     BYTE [cs:flgActive],0FFH
                jz       jOld10         ; if we are not active, then go to old

                ;************** check if ah=00h and flgOur is clear

                or      ah,ah
                jnz     i10n0
                cmp     ah,[cs:flgOur]  ; VESA switching can call i10Fn0
                jnz     jnzOld10        ; ah=00h BUT flgOur set, so chain to next int10h

                ;************** AH=00h and flgOur clear: call old, then load fonts
                ; Here we fix Classic Video BIOS Fn 00: Set Screen Modee

                push    ax
                pushf
                call    FAR [cs:dOld10]
                pop     ax              ; Do not assume i10Fn0 saved AL

                push    ax
                and     al,7fH          ; High bit means save video memory
iSFpr:          call    SetFont
                pop     ax
                iret

                ;************** AH <> 00h
                ;************** check if ah=4f02h (set VESA SuperVGA mode)
i10n0:
                cmp     ax,4f02H        ; VESA SET MODE
                jnz     i10nVESA

                inc     BYTE [cs:flgOur]; prevent our processing the call
                pushf
                call    FAR  [cs:dOld10]
                dec     BYTE [cs:flgOur]
                push    ax
                mov     al,-1           ; Call SetFont with Unknown video mode
                jmp     SHORT iSFpr     ; (mode determined dinamically)

                ;************** AH <> 00h, 4f02h
                ;************** All other business is with character generator functions (ah=11h)
i10nVESA:
                cmp     ah,11H          ; ah=11h?
jnzOld10:       jnz     jOld10          ; no, then jump to next

                cmp     al,30H          ; Get Font Information?
                jnz     i10f11n30

                ;************** AL = 30h (Get Font Information), BH: font info to be supplied

                ;************** unsupported cases: bh=5, bh>6, bh=6 on NON-VGA

                cmp     bh,5            ; Font 9x14 not supported (now?)
                jz      jOld10
                cmp     bh,6
                ja      jOld10          ; Font 9x16 not supported (now?)
                jb      i10f1130n6
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA

                ;************** supported cases: bh<5, VGA-bh=6
i10f1130n6:
                sub     cx,cx           ; CH register must be zero on exit
                mov     es,cx
                mov     dl,[es:484H]    ; Number of lines - 1
                mov     cl,[es:485H]    ; Bytes per char
                cmp     bh,1
                ja      i10f1130a1
                jz      i10f1130s1
                les     bp,[es:7cH]     ; SubFn 00: Return vector 1FH
                iret
i10f1130s1:
                les     bp,[es:43H*4]   ; SubFn 01: Return vector 43H
                iret
i10f1130a1:
                push    cs              ; All other functions return fonts
                pop     es              ;   from DISPLAY.SYS segment
                cmp     bh,3
                ja      i10f1130a3
                jz      i10f1130f3
                mov     bp,bFont8x14    ; SubFn 02: Return ROM font 8x14
                iret
i10f1130f3:
                mov     bp,bFont8x8     ; SubFn 03: Return ROM font 8x8 (00..7f)
                iret
i10f1130a3:
                cmp     bh,6
                jz      i10f1130s6
                mov     bp,bFont8x8+1024; SubFn 04: Return ROM font 8x8 (80..ff)
                iret
i10f1130s6:
                mov     bp,bFont8x16    ; SubFn 06: Return ROM font 8x16
                iret

                ;************** subfunctions AL= 01/11, 02/12 and (VGA+) 04/14

i10f11n30:
                cmp     al,01           ; SubFn 01: Set ROM font 8x14
                jz      i10f1101
                cmp     al,11H          ; SubFn 11: Set ROM font 8x14
                jnz     i10f11n11
i10f1101:
                push    bp
                push    bx
                mov     bp,bFont8x14
                mov     bh,14
i10set:         push    es              ; set a font, by calling ax=1110h, bh=bytes/char
                push    ax
                push    cx
                push    dx
                push    cs
                pop     es
                mov     cx,256          ; load 256 characters
                cwd                     ; DX=0
                and     al,10H
                pushf
                call    FAR [cs:dOld10]
                pop     dx
                pop     cx
                pop     ax
                pop     es
                pop     bx
                pop     bp
                iret
jOld10:         DB      0eaH
dOld10:         DD      -16
i10f11n11:
                cmp     al,02           ; SubFn 02: Set ROM font 8x8
                jz      i10f1102
                cmp     al,12H          ; SubFn 12: Set ROM font 8x8
                jnz     i10f11n12
i10f1102:
                push    bp
                push    bx
                mov     bp,bFont8x8
                mov     bh,8
                jmp     i10set
i10f11n12:
                cmp     al,04           ; SubFn 04: Set ROM font 8x16
                jz      i10f1104
                cmp     al,14H          ; SubFn 14: Set ROM font 8x16
                jnz     i10f11n14
i10f1104:
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    bx
                mov     bp,bFont8x16
                mov     bh,16
                jmp     i10set

                ;************** subfunctions AL= 22, 23 and (VGA+) 24

i10f11n14:
                cmp     al,22H          ; SubFn 22: Set ROM font 8x14 (INT 43)
                jnz     i10f11n22
                push    bp
                push    cx
                mov     bp,bFont8x14
                mov     cx,14
i10setg:        push    es
                push    ax
                push    cs
                pop     es
                mov     ax,1121H
                pushf
                call    FAR [cs:dOld10]
                pop     ax
                pop     es
                pop     cx
                pop     bp
                iret

i10f11n22:
                cmp     al,23H          ; SubFn 23: Set ROM font 8x8 (INT 43)
                jnz     i10f11n23
                push    bp
                push    cx
                mov     bp,bFont8x8
                mov     cx,8
                jmp     i10setg
i10f11n23:
                cmp     al,24H          ; SubFn 24: Set ROM font 8x16 (INT 43)
                jnz     jOld10
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    cx
                mov     bp,bFont8x16
                mov     cx,16
                jmp     i10setg

;===================================================================
; INTERRUPT ROUTINE FOR 2Fh (DOS Multiplexer)
;
; MuX CODE:  adh
;
; 00: Installation check (return al non-zero)
; 01: Set Active Codepage (IN: bx=requested codepage)
; 02: Get Active Codepage (OUT: bx=active codepage)
; 0E: Set Codepage information 
; 0F: Get codepage information (IN: ES:DI->buffer, CX:size)
;
;        .      .       .       .       .       .       line that rules

                ;************** check first MUX code for DISPLAY: ADh

New2f:          pushf                   ; we must preserve flags!
                cmp     ah,0adH         ; ADh is MUX code for DISPLAY and KEYB
                jnz     jOld2f

                ;************** function 00h: Installation check

                test    al,0ffH
                jnz     mDno0
                mov     ah,0ffH         ; required for MS-DISPLAY compatibility
                mov     bx, 0006H       ; return version in BX (major.minor)
                                        ; bh=0 will stand for the beta versions of
                                        ; FreeDOS DISPLAY
                popf
                clc                     ; clear carry
                retf    2

                ;************** function 01h: Set active codepage

mDno0:          cmp     al,01
                jnz     mDno1
                cmp     bx,[cs:bCPsoft] ; is it software codepage?
                jne     NoSoftCP
                mov     BYTE [cs:flgActive],1
                mov     al, -1          ; YES: activate DISPLAY and
                call    SetFont         ; call SetFont with unknown mode
retClearAX:     mov     ax, 0001h       ; set ax=1,
retClear:       popf                    ; restore flags,
                clc                     ; clear carry (success)
                retf    2               ; and return, discarding flags
NoSoftCP:       cmp     [cs:bCPhard],bx ; is it hardware codepage?
                jne     f01err
                mov     BYTE [cs:flgActive],0
                mov     ax, 1101h       ; NO: disable display and load from old driver
                xor     bx,bx
                pushf
                call    FAR [cs:dOld10]
                mov     ax, 1102h
                xor     bx,bx
                pushf
                call    FAR [cs:dOld10]
                mov     ax, 1104h
                xor     bx,bx
                pushf
                call    FAR [cs:dOld10]
;                mov     ax, 1122h       ; now for the graphics mode
;                xor     bx,bx           ; DOES NOT WORK, WHY?
;                pushf
;                call    FAR [cs:dOld10]
;                mov     ax, 1123h
;                xor     bx,bx
;                pushf
;                call    FAR [cs:dOld10]
;                mov     ax, 1124h
;                xor     bx,bx
;                pushf
;                call    FAR [cs:dOld10]
                jmp     retClearAX      ; we set AX=1 and we are finished!  ;-)
f01err:         xor ax, ax              ; ax=0
retSet:         popf
                stc                     ; set carry: error
                retf    2

                ;************** function 02h: Get active codepage

mDno1:          cmp     al,02
                jnz     mDno2
                test    BYTE [cs:bCPsoft],0ffh
                jnz     CodepageWasSet  ; has codepage ever been set? (always: YES, due to 858 being hardcoded)
                mov     ax, 0001h
                mov     bx, 0ffffh
                jmp     retSet
CodepageWasSet: test    BYTE [cs:flgActive],0ffh
                jnz     CurrentIsSoft   ; is DISPLAY active?
                mov     bx, [cs:bCPhard]; no, then it is the hardware one
                jmp     retClear
CurrentIsSoft:  mov     bx, [cs:bCPsoft]
                jmp     retClear


                ;************** function 0Eh: Set codepage table (from DS:SI)

mDno2:          cmp     al,0eh
                jnz     mDnoE

                test    BYTE [cs:flgActive],0ffh
                jnz     retSet          ; it should be inactive to prepare (we have only one pool!)

                mov     [cs:bCPsoft],bx ; we save the new software codepage number

                push    cx
                push    es
                push    di

                push    cs              ; ES <- CS
                pop     es
                mov     di,bFont8x8

                mov     cx,4864         ; move 4864 = 128*(8+14+16) words to the fonts
           rep  movsw

                pop     di
                pop     es
                pop     cx

                jmp     retClear        ; restore Registers and return clear

                ;************** function 0Fh: Get codepage table (to ES:DI)

mDnoE:          cmp     al,03
                jnz     jOld2f

                push    cx
                push    ds
                push    si

                push    cs
                pop     ds              ; DS <- CS
                mov     si,bFont8x8

                mov     cx,4864         ; move 4864 = 128*(8+14+16) words from the fonts
loop2:     rep  movsw

                pop     si
                pop     ds
                pop     cx

                mov     bx,[cs:bCPsoft] ; return software codepage number

                jmp     retClear        ; restore Registers and return clear

jOld2f:         popf
                DB      0eaH
dOld2f:         DD      -16


;-------------------------------------------------------
; DRIVER INTERFACE
;
;               .       .       .       .       .       line that rules
;Strategy:
;                mov     [cs:dRequest-100H],bx
;                mov     [cs:dRequest+2-100H],es
;                ret
;
;Init:           push    ds
;                push    bx
;                lds     bx,[cs:dRequest-100H]
;                test    BYTE [cs:flgInstalled-100H],-1
;                jz      iExit
;                cmp     BYTE [bx+2],0
;                jz      InitFn0
;iExit:
;                mov     WORD [bx+3],8003H
;                pop     bx
;                pop     ds
;                retf
;
; .SYS initilization code goes here
;
;InitFn0:
;                push    ds                      ; Save Request
;                push    bx
;
;                mov     ax,cs
;                push    ax
;                call    _Install
;
;                pop     bx
;                pop     ds                      ; Restore Request
;                mov     ax,[cs:pMemTop-100H]
;                mov     WORD [bx+14],ax
;                mov     WORD [bx+16],cs
;                mov     WORD [bx+3],0100H       ; Status "Operation Complete"
;                pop     bx
;                pop     ds
;                retf
;_Install
;                sub     ax,10H
;                push    ax
;                mov     ax,DoInstall
;                push    ax
;                retf


;-------------------------------------------------------
; RESIDENT SUBROUTINES
;
;       .       .       .       .       .       .       line that rules

; Fn:   SetFont
; Does: Set a proper localized font for a given video mode
; In:   AL Screen mode (-1 if unknown)
; Mod:  (none)
;
; Summary: self-determine rows per character, then call the load-character-table function, which is
;          int10h: AX=1100h (for text mode), AX=1121h (for graphics mode)
SetFont:
                push    ds
                push    es
                push    ax
                push    cx
                push    dx
                push    bx
                push    si
                push    di
                push    bp


                ;************ initialise DX to number of lines (rows) in the screen

                sub     bx,bx                   ; BL: Zero!
                mov     ds,bx
                mov     dx,[484H]
                mov     bh,dh                   ; BH: bytes per character
                inc     dx                      ; DL: number of lines

                ;************ restore int1Fh vector with pointer to 8x8 table

                mov     WORD [7cH],bFont8x8+1024; Kinda tradition to restore
                mov     [7eH],cs                ; vector 1f every time

                ;************ ES <- CS

                push    cs
                pop     es

                ;************ determine the table to be installed (the number of rows)

                cmp     BYTE [cs:bAdapter],VGA  ; if VGA (or better) or BH>=16, then 8x16
                jb      sfNo8x16
                cmp     bh,16
                jb      sfNo8x16
                mov     bh,16                   ; force bh=16 (in case it's >16)
                mov     bp,bFont8x16
                jmp     SHORT sfSetIt
sfNo8x16:
                cmp     bh,14                   ; check bh>=14
                jb      sfNo8x14
                mov     bh,14                   ; force bh=14 (in case it's >14)
                mov     bp,bFont8x14
                jmp     SHORT sfSetIt
sfNo8x14:
                cmp     bh,8                    ; check bh>=8
                jb      sfpr                    ; if below 8, then unsupported ->RETURN
                mov     bh,8                    ; force bh=8 (in case it's >8)
                mov     bp,bFont8x8

                ;************ We have checked the number of rows, then set it
sfSetIt:
                cmp     al,13H
                ja      sfTest          ; Screen modes above 13H are unknown
                cmp     al,0dH
                jae     sfGraph         ; Screen modes 0d..13H   are graphics
                cmp     al,4
                jb      sfText          ; Screen modes  0..3     are text
                cmp     al,7
                jz      sfText          ; Screen mode    7       is  text
                jb      sfGraph         ; Screen modes  4..6     are graphics

                ;************ unknown, test if text/graphics mode (EGA/VGA only!)
sfTest:         mov     al,6
                push    dx
                mov     dx,3ceH
                out     dx,al
                call    sfr             ; Small delay
                inc     dx
                in      al,dx           ; Graph Controller Misc Register
                pop     dx
                shr     al,1
                jc      sfGraph

                ;************ set the font for text mode: use int10h / ax=1100h
sfText:
                mov     cx,256          ; Load 256 characters
                mov     ax,1100H        ; Load user font and reprogram controller
                cwd                     ; DX=0, BL is already zero, BH=bpc
                jmp     SHORT sfi10

                ;************ set the font for graphics mode: use int10h / ax=1121h
sfGraph:
                mov     cl,bh           ; bytes per character
                sub     ch,ch           ; BL is already zero, DL=# of lines
                mov     ax,1121H        ; Set vector 43H for user font

                ;************ call the appropriate interrupt function
sfi10:          pushf
                call    FAR [cs:dOld10]

                ;************ end of interrupt
sfpr:
                pop     bp
                pop     di
                pop     si
                pop     bx
                pop     dx
                pop     cx
                pop     ax
                pop     es
                pop     ds
sfr:            ret

;               .       .       .       .       .       line that rules
;
; The following is vital for interface with FreeDOS MODE.COM
;
flgOur          DB      0               ; Our INT 10 Fn 00?
;flgInstalled    DB      0               ; Already called drive Req 00 Init?
flgActive       DB      0               ; Are we active? NO, we start inactive
bAdapter        DB      0
bCPhard         DW      437             ; For the moment, we assume 437
bCPsoft         DW      858             ; 850 is hardcoded in the single pool
;bCharGenTable   DW      0,0             ; address of BIOS character generator
bFont8x8:       incbin  "cp858.f08"
bFont8x14:      incbin  "cp858.f14"
bFont8x16:      incbin  "cp858.f16"

bLastByte:
;-----------------------------
; End of Resident part
;

pMemTop:        DW      bLastByte


;===================================================================
; MAIN FOR THE .COM VERSION
;
;               .       .       .       .       .       line that rules


                ;****** MAIN ***********
Install:
                push    cs
                call    DoInstall       ; call DoInstall
                jc      Done            ; Carry? then we should exit
                mov     dx,[pMemTop]
                int     27H             ; TSR  for .COM files
Done:           int     20H             ; Exit for .COM files


                ;****** ERROR: driver is already in memory
Already:
                mov     dx,errAlready
rQc:            mov     ah,9
                int     21H
                stc
                retf

                ;****** ERROR: driver requires EGA or better
Acient:
                mov     dx,errAcient
                jmp     rQc


                ;****** DoInstall (Install if possible)
                ;****** CF: set on error

DoInstall:

                ;****** show copyright and version

                mov     dx,copyVer
                mov     ah,9
                int     21H

                ;****** check if already loaded

                mov     ax,0ad00H
                int     2fH
                cmp     ah,-1
                jz      Already

                ;****** check if EGA or better

                call    TestAdapter
                cmp     al,CGA
                jbe     Acient
                push    ax              ; save AdapterID for later

                ;****** set our interrupt vectors

                mov     ax,352fH        ; Get vector 2f
                int     21H
                mov     [dOld2f],bx
                mov     [dOld2f+2],es

                mov     dx,New2f
                mov     ax,252fH        ; Set vector 2f
                int     21H

                mov     ax,3510H        ; Get vector 10
                int     21H
                mov     [dOld10],bx
                mov     [dOld10+2],es

                mov     dx,New10
                mov     ax,2510H        ; Set vector 10
                int     21H

                ;****** get the BIOS character generator address
                ;        (seems no longer needed ?)

;                push    bp
;                mov     ax,1130H
;                mov     bh,3
;                int     10H             ; Get BIOS ROM character generator to ES:BP
;                mov     [bCharGenTable]  , bp
;                mov     [bCharGenTable+2], es
;                pop     bp

                ;****** Prepare to install de font and exit

                pop     ax              ; recover the AdapterID
                cmp     al,VGA
                jae     InstallAllFonts ; Save 4K on EGA
                mov     WORD [pMemTop],bFont8x16

InstallAllFonts:

                ;************ loads fonts on the BIOS ROM character generator
                ;        (seems no longer needed ?)

;                lds     si, [bCharGenTable]
;                push    cs
;                pop     es
;                mov     di,bFont8x8
;                mov     cx,256*4
;        rep     movsw

                clc
                retf


; Fn:   TestAdapter
; In:   (none)
; Out:  AL Video adapter type
; Note: No VESA check yet.
;       .       .       .       .       .       .       line that rules
TestAdapter:
                 mov    ax,1a00H        ; Call DCC
                 int    10H
                 cmp    al,1aH
                 jnz    taNoDCC

; Now we know, that have PS/2 Video BIOS.
; Active adapter code is now in BL register

                 cmp    bl,0cH
                 ja     taNoDCC
                 sub    bh,bh
                 mov    al,[tblDCC+bx]
                 cmp    al,bh
                 jnz    taKnowAdapter
taNoDCC:
                 mov    bl,10H          ; Get Configuration Information
                 mov    ah,12H          ; Alternate Select
                 int    10H
                 mov    al,EGA
                 cmp    bl,10H
                 jnz    taKnowAdapter   ; if bh<>0, EGA_MONO

                 int    11H             ; EquipList
                 and    al,30H
                 cmp    al,30H
                 mov    al,MDA
                 jz     taKnowAdapter
                 mov    al,CGA
taKnowAdapter:
                 mov    [bAdapter],al
                 ret

tblDCC           DB     NO,MDA,CGA,NO,EGA,EGA,NO,VGA,VGA,NO,MCGA,MCGA,MCGA
errAlready       DB     "DIPSLAY is already loaded", 0dH, 0aH, "$"
errAcient        DB     "DISPLAY needs at least EGA adapter", 0dH, 0aH, "$"
copyVer          DB     "FreeDOS DISPLAY ver. 0.06", 0dH, 0aH, "$"

                 END
