\XPLX.XPL	4-Jun-2012
\OPTIMIZED XPL0 COMPILER
\COPYRIGHT 1984-2012 P.J.R. BOYLE
\FLOATING POINT VERSION BY LOREN BLANEY
\IBM NATIVE LANGUAGE VERSION BY LARRY FISH
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.TXT); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach the authors at: loren.blaney@gmail.com
\
\REVISIONS:
\V2.0 AUG-21-93
\V2.1 NOV-22-93, FIXED BUG IN INTEGER SEGMENT ARRAY WITH CONSTANT SUBSCRIPTS
\V2.1 FEB-16-94, FIXED MULTIPLE "PROGRM" LABEL ERROR WHEN LINKING EXTERNAL
\ PROCEDURES. INDENT INCLUDED FILES ACCORDING TO NESTING LEVEL. FIX PROBLEM
\ WHEN LINKING MORE THAN 64K OF EPROCS.
\V2.2 FEB-28-95, OPTIMIZATIONS, ADDRESS OF ARRAY ELEMENT, 16-CHAR NAMES, ETC.
\V2.2.1 APR-19-95, FIX FOR LOOP BUG WHEN CONTROL VAR IS GLOBAL
\V2.2.2 MAY-27-95, ARRAY DECLARATIONS AND MULTIDIMENSIONAL CHARACTER ARRAYS, ETC.
\V2.3 JUL-01-95, DISTRIBUTION.
\V2.3.1 JUL-13-95, Fix /S for eprocs. Remove underlines for assembly externals.
\V2.3.2 JUL-23-95, 1600 symbol names, 160 quits and real constants. Public
\ forward procedures.
\V2.3.4 MAY-04-99, Distribute under GNU General Public License.
\V2.4 24-FEB-2001, DI register is devoted to HP; SI is devoted to local
\ variables. Short-circuit booleans (/B). Numerous miscellaneous optimizations.
\ Clean up DOSOPEN. Fixed "~" in constant calculations. GENSTXADD for fast
\ Sieve. Clean up GENAX and add MOV AH,imm. Don't generate MOV SP,STKPTR when
\ returning from level 0. /2 & /3 aligns procedures. Remove NOLOC remnant.
\ Optimize code for accessing global variables (except in optimized
\ procedures); optimize case statements, 0 and -1 arguments, GENINP, GENFIMM,
\ GENFNEG, GENARG0 for reals. Inline abs, rem, swap, and ext functions.
\ Optimize declared arrays (MKARRAY). "port" command.
\V2.4.1 29-JUN-2001, Allow pathnames in input files.
\V2.4.2 11-MAR-2002, Fix bug caused by aligning arrays on word boundaries.
\V2.4.3 25-APR-2002, Fix bug caused by declaring arrays totalling more than 32K.
\ Fix abs($8000) infinite loop.
\V2.4.4 27-JUL-2002, Compensate for deficiency in MASM 6.11 that does not allow
\ 52/2 CR,LF pairs on a single line. Reduced the maximum number to 40.
\V2.4.5 15-SEP-2003, Modify Equip intrinsic (compilers not modified).
\V2.4.6 26-JUL-2004, Fix rare bug involving 'for' loop control variable
\ defined at intermediate level and used in a loop. Generate abs as DB 7C FC
\ rather than JL $-2 (because MASM 6.11 is stupid). Remove unused argument in
\ FPRDEC.
\V2.4.7 1-NOV-2004, Fix bug, e.g: char A; A(0):= $1FF;
\V2.4.8 29-MAR-2005, Fix tiny bug where DO_IMM_STK called OPSTRING without all
\ the proper arguments, but it couldn't cause a compile error.
\V2.5 31-DEC-2005, Inline assembly code ('asm')
\V2.5.1 23-APR-2007, Added 'string' directive to enable null-terminated strings.
\ Accept "^Z" in strings (but not an actual ^Z). Flag integer-expected error for
\ Real ANDed with Int. Fix bug when dividing by a 'for' loop control variable.
\ Don't flag EOF error for null strings ("") when conditional compile is false.
\V2.6 17-Mar-2008, Added binary notation (e.g: $1e = %11110); underlines are
\ allowed in numbers (123_456.78); variables can be declared after procedures.
\V2.7 13-Jan-2010, Allow 'to' to replace ',' in 'for' loops; implement 'downto'.
\ Added arithmetic shift right operator "->>". Optimize some zero results, etc.
\V2.8 20-Feb-2010, Fix bug caused by optimizing zero results. Abort on internal
\ errors. Add command words 'and', 'or', 'xor'.
\V2.9 31-Oct-2011, Display command line switches.
\V3.0 04-Jun-2012, Eliminate INTERNAL ERROR caused by MIXED MODE assignment.
\ Detect more /0 errors. Double backslash comments out rest of line. At-sign
\ (@) for 'addr'. Settable counter for enumerated defines.

code	ABS=0,		REM=2,		RESERVE=3,	SWAP=4,
	EXTEND=5,	CHIN=7,		CHOUT=8,	CRLF=9,
	INTIN=10,	INTOUT=11,	TEXT=12,	OPENI=13,
	OPENO=14,	CLOSE=15,	TRAP=17,	GETERR=22,
	HEXOUT=27,	FSET=24,	FOPEN=29,	FCLOSE=32,
	GETREG=35,	BLIT=36,	PEEK=37;
code real		FLOAT=49,	RLRES=46;

def	SYMAX=1600,	\MAXIMUM NUMBER OF SYMBOLS IN SYMBOL TABLE
	SIGCHAR=16,	\NO. OF SIGNIFICANT CHARS IN AN IDENTIFER
	HASHMSK=$FF,	\MASK FOR HASHES
	EMTPNT=-1,	\EMPTY SYMBOL POINTER
	BOXNUM=256,	\NUMBER OF BOXES
	RLMAX=160,	\SIZE OF REAL-CONSTANT SYMBOL TABLE
	RLSIZE=8,	\NO. OF BYTES IN A REAL NUMBER
	QUITMAX=160,	\MAXIMUM NO. OF 'QUIT'S IN A 'LOOP'
	HANMAX=8,	\MAXIMUM NESTING DEPTH OF INCLUDES (FILE HANDLES)
	STKMAX=100,	\MAXIMUM ITEMS ON PSEUDO STACK
	LEVELMAX=8;	\MAXIMUM NUMBER OF STATIC LEVELS (0 THRU LEVELMAX-1)

def	TV=0, KB=0, NULDEV=7;			\I/O DEVICES
def	BEL=$07, EOL=$0A, EOF=$1A;		\CONTROL CHARACTERS

int	OPTIMIZE;	\TYPE OF OPTIMIZATION
def	\OPTIMIZE\	OPT88,		\OPTIMIZE FOR 8088
			OPT286,		\OPTIMIZE FOR 286 (16-BIT BUS)
			OPT386;		\OPTIMIZE FOR 386 (32-BIT BUS)

int	AXIMM,		\FLAG: AX REGISTER CONTAINS IMMEDIATE VALUE IN AXVAL
	AXVAL,		\IMMEDIATE VALUE CURRENTLY IN AX (IF AXIMM IS TRUE)
	AHZERO,		\FLAG: AH REGISTER CONTAINS A ZERO
	AXLEV,		\THE AX REGISTER CONTAINS THE VALUE OF A VARIABLE
	AXOFF,		\ AT THIS LEVEL & OFFSET
	SAXIMM,		\SAVED AXIMM & AXLEV; USED TO RESTORE AXIMM & AXLEV
	SAXLEV,		\ AFTER AN OPTIMIZED COMPARE
	SAHZERO,
	DXLEV,		\DX REGISTER SHADOWS THE VARIABLE AT THIS LEVEL
	DXOFF,		\ AND OFFSET (ONLY USED BY 'FOR' LOOP CONTROL VARIABLE)
	DXPEND,		\DXLEV PENDING LOOP; EVEN READING VAR IN A LOOP BOMBS DX
	HAVENEST,	\FLAG: THE CURRENT PROCEDURE HAS A PROC NESTED IN IT
	HAVESTAT,	\FLAG: PROCESSOR STATUS FLAGS ARE VALID FOR TOS
	STXFLAG,	\FLAG TO OPTIMIZE GENSTX
	POSTGENTYPE,	\WHICH MOV [BX],POSTGENVAL NEEDS TO BE GENERATED (0=NONE)
	POSTGENVAL,	\MOV BYTE PTR [BX]+POSTGENOFF,POSTGENVAL
	POSTGENOFF;

int	PSTKPTR,	\STACK POINTER FOR THE FOLLOWING STACKS (PUSH=STO,INC)
	PSTKTYP,	\PSEUDO STACK: HOLDS STACK ARGUMENT TYPE
	PSTKLEV,	\PSEUDO STACK: HOLDS LEVEL OF ADDR ARGUMENT OR IMM VALUE
	PSTKOFF;	\PSEUDO STACK: HOLDS OFFSET OF ADDR ARGUMENT OR ^C OR ^L
def	\TYPES OF PSEUDO-STACK ARGUMENTS:
	REGTYP,		\TOS IN REGISTER AX
	STKTYP,		\TOS IS ON H/W STACK
	ADDTYP,		\TOS IS IN ADDRESS (LEVEL, OFFSET)
	IMMTYP,		\TOS IS IMMEDIATE VALUE (^C=NORMAL CONSTANT; ^L=LABEL)
	REALTYP;	\TOS IS A REAL ON THE H/W STACK

int	COMFLG,		\SWITCH (/C): PUT COMMENTS IN CODE
	DEBUG,		\SWITCH (/D): DEBUG MODE
	OPTJPC,		\SWITCH (/J): OPTIMIZE CONDITIONAL JUMPS (MASM 6 ON 386)
	OPTCALL,	\SWITCH (/S): USE NEAR CALLS FOR PROCEDURES (PROG < 64K)
	SHORTBOOL,	\SWITCH (/B): USE SHORT-CIRCUIT BOOLEAN EVALUATION

	CODCTR,		\USED TO SEE IF THERE ANY CODE IN THE MAIN PROC
	OLDCODCTR,	\USED TO CONTROL CRLF FOR DEBUG LISTING
	HASMAIN,	\FLAG: THERE IS A STATEMENT IN THE MAIN PROCEDURE
	CONDITIONAL,	\FLAG: CONDITIONAL COMPILE
	STRTERM,	\flag: string termination (0=null, nonzero=MSB)
	LOCAL,		\COUNTS AND CREATES UNIQUE LOCAL LABELS (FOR JUMPS)
	OLDLEV,		\OLD STATIC LEVEL (FOR DETERMINING WHEN TO LOAD BP REG)
	SEGCNT,		\COUNTS AND CREATES UNIQUE SEGMENT NUMBER
	DEEPER,		\FLAG: NESTING SEGMENTS DEEPER
	INHAND,		\INPUT FILE HANDLE
	OUTHAND;	\OUTPUT FILE HANDLE
char	FNAME;		\NAME PART OF INPUT FILE (EXCLUDING DRIVE AND PATHNAME)
			\(ASSIGNS UNIQUE NAMES TO PROCEDURE CODE SEGMENTS)

int	ERRCNT,		\COMPILE ERROR COUNTER
	LSTDEV,		\LISTING OUTPUT DEVICE NUMBER
	SRCDEV,		\SOURCE INPUT DEVICE NUMBER
	BINDEV,		\BINARY OUTPUT DEVICE NUMBER
	CHAR,		\CURRENT CHARACTER.  MOST OF THE TIME THIS CONTAINS
			\ THE TERMINATOR OF THE CURRENT ATOM
	ATOM,		\PRESENT ATOM DESCRIPTOR
			\CONTAINS RESERVED WORD HASH OR THE ASCII FOR A SPECIAL
			\ CHARACTER; 0 IF THE ATOM IS A CONSTANT OR IDENTIFIER
	ATYPE;		\PRESENT ATOM TYPE DESCRIPTOR
def	\ATYPE\ SPECIAL, IDENTIFIER, INTCON, REALCON;
char	IDENT;		\ARRAY--CURRENT IDENTIFIER NAME
int	HASH,		\CURRENT IDENTIFIER HASH CODE
	LABCNT,		\LABEL COUNTER (LXX:)
	IATOM;		\VALUE OF CURRENT INTEGER CONSTANT
real	RLATOM;		\REAL CONSTANT FROM PROC "RATOM"

int	IDTYPE;		\PRESENT IDENTIFIER TYPE DESCRIPTOR
def	UNDEF=0,	\UNDEFINED ID (NO. ORDER IS CRITICAL)
	ADDRVAR=1,	\ADDRESS VARIABLE ID (TYPE = INTEGER)
	INVAR=3,	\INTEGER VARIABLE ID (ODD NOS.=INTEGER)
	RLVAR=4,	\REAL VARIABLE ID
	INCON=5,	\INTEGER CONSTANT ID
	RLCON=6,	\REAL CONSTANT ID
	INPROC=7,	\INTEGER PROCEDURE ID
	RLPROC=8,	\REAL PROCEDURE ID
	INFPROC=9,	\INTEGER FORWARD PROCEDURE ID
	RLFPROC=10,	\REAL FORWARD PROCEDURE ID
	INOPT=11,	\INTEGER OPTIMIZED PROCEDURE ID
	RLOPT=12,	\REAL OPTIMIZED PROCEDURE ID
	INEPRO=13,	\INTEGER XPL EXTERNAL PROCEDURE
	RLEPRO=14,	\REAL XPL EXTERNAL PROCEDURE
	ININT=15,	\INTEGER INTRINSIC ID
	RLINT=16,	\REAL INTRINSIC ID
	INEXT=17,	\INTEGER EXTERNAL PROCEDURE ID
	RLEXT=18,	\REAL EXTERNAL PROCEDURE ID
	INSEG=19,	\INTEGER SEGMENT VARIABLE ID
	RLSEG=20,	\REAL SEGMENT VARIABLE ID
	ADSEG=21,	\ADDRESS VARIABLE ID
	SHSEG=22;	\SHORT SEGMENT VARIABLE ID

int	LEV,		\STATIC LEVEL OF CURRENT IDENTIFIER
	VAL,		\VALUE OR ADDRESS OF CURRENT IDENTIFIER
	SYMNUM,		\POSITION IN "SYMTBL" OF CURRENT IDENTIFER
	FACTYP;		\FACTOR (OR OPERAND) TYPE (REAL OR INTEGER)
def	\FACTYP\ REAL, INTEGER;
int	PROCRETS,	\ARRAY--CODE LABELS FOR PROCEDURE RETURNS FOR EACH LEVEL
	FIXES,		\ARRAY--'QUIT' FIXES STILL OUTSTANDING
	LEVEL,		\STATIC LEVEL OF CURRENT PROCEDURE
	NOSYM,		\CURRENT NUMBER OF SYMBOLS IN SYMBOL TABLE
	FIXCNT,		\COUNT OF THE NUMBER OF OUTSTANDING 'QUIT'S
	STKLOD,		\NO. OF INTEGERS LEFT ON STACK BY 'FOR' OR 'CASE'
	OPTPROC,	\BOOLEAN--GENERATE AN OPTIMIZED PROCEDURE CALL
	NORLSY,		\CURRENT NUMBER OF REAL CONSTANTS IN TABLE
	LASTOP,		\PREVIOUS OPCODE
	II;		\SCRATCH FOR MAIN
char	HEXDIGIT;	\ARRAY OF HEX DIGITS (0 - F)

\SYMBOL TABLE ARRAYS:
char	SYMBOL,		\IDENTIFIER NAME (IDENT)
	SYMTYP,		\TYPE DESCRIPTORS (IDTYPE)
	SYMLEV;		\LEVEL (LEV)
int	SYMVAL,		\VALUE OR ADDRESS (VAL)
	SYMPNT,		\LIST LINKAGE POINTERS
	BOX;		\HASH BOXES (SYMBOL LIST HEADERS)
real	RLTBL;		\REAL CONSTANT TABLE

int	HANPTR,		\POINTER TO OLD INCLUDE HANDLES
	OLDHAN;		\ARRAY OF OLD INCLUDE HANDLES

\RESERVED WORD HASHES:
def	ADRSYM=$88E4,	BEGSYM=$84C7,	CASEYM=$8053,	CODSYM=$8184,
	DEFSYM=$9CC6,	DOSYM=$0CEF,	ELSEYM=$99F3,	ENDSYM=$99A4,
	EXITYM=$9B69,	EXTNYM=$9B74,	FALSYM=$944C,	FFUNYM=$94B5,
	FORSYM=$9592,	FPRSYM=$9672,	FUNSYM=$96CE,	GESYM=$0C85,
	GETSYM=$90D4,	IFSYM=$0D46,	INTSYM=$A9B4,	LESYM=$0DE5,
	LOOPYM=$BD8F,	NOTSYM=$B594,	OFSYM=$0D86,	PROCYM=$CE2F,
	QUITYM=$CAC9,	REALYM=$C4C1,	REPSYM=$C4D0,	RETSYM=$C4D4,
	THENYM=$DD65,	TRUSYM=$DE35,	UNTSYM=$D9B4,	WHILYM=$D169,
	CHARYM=$8161,	EPRSYM=$9A72,	EFUNYM=$98B5,	PUBSYM=$CEC2,
	OTHSYM=$B2E8,	INCSYM=$A9A3,	LSLSYM=$BE0C,	LSRSYM=$BE92,
	SEGSYM=$C0C7,	SHTSYM=$C16F,	CONSYM=$818E,	ABSSYM=$8833,
	REMSYM=$C4CD,	SWAPYM=$C281,	EXTSYM=$9B74,	PORTYM=$CD92,
	STRSYM=$C2F2,	ASMSYM=$8A0D,	TOSYM=$0EEF,	DOWNYM=$9D97,
	ASRSYM=$8A12,	ANDSYM=$89A4,	ORSYM=$0D92,	XORSYM=$ED92;


func	GETBC;		\READ A CHAR FROM DEVICE 8. RETURN EOF IF END OF BUFFER
int	C, D;
begin
for D:= 1, HANMAX do
	[C:= CHIN(8); if C#EOF then return C];
return C;
end;	\GETBC



proc	ERROR(N);	\DISPLAY ERROR MESSAGE
int	N;
int	ERR, CH, I;
char	STRING;
def	MAXERR=75;	\MAXIMUM ERROR NUMBER
begin
I:= " ";	\fixes MASM 6.11 bug: line too long
ERR:= RESERVE((MAXERR+1)*2);
for I:= 0, MAXERR do ERR(I):= "? ";	\UNUSED ERROR NOS. ="?"

ERR(0):= "INTERNAL ERROR ";
ERR(1):= "TOO MANY VARIABLES ";
ERR(2):= "TOO MANY REAL CONSTANT NAMES ";
ERR(3):= "TOO MANY NAMES ";
ERR(4):= "TOO MANY 'QUITS' ";
ERR(5):= "TOO MANY STATIC LEVELS ";
ERR(6):= "NUMBER OUT OF RANGE ";
ERR(7):= ERR(6);			\FOR INTRINSIC DECLARATIONS
ERR(10):= "UNDECLARED NAME ";
ERR(11):= "NAME ALREADY DECLARED ";
ERR(20):= "ILLEGAL START OF A STATEMENT ";	\IN "ASSIGN"
ERR(21):= "^":=^"* ";
ERR(22):= "'THEN'* ";
ERR(23):= "'DO'* ";
ERR(24):="'TO' OR 'DOWNTO'* ";
ERR(26):= "ILLEGAL FACTOR ";		\UNRECOGNIZABLE SPECIAL FACTOR
ERR(27):= "STATEMENT STARTING WITH A CONSTANT "; \IN "ASSIGN"
ERR(28):= "'UNTIL'* ";
ERR(29):= "'OTHER'* ";
ERR(30):= "'ELSE'* ";
ERR(31):= "DIGIT* ";
ERR(33):= "INTEGER VARIABLE* ";		\IN A 'FOR' STATEMENT
ERR(38):= "^">^"* ";		\ASR ->>
ERR(39):= "^"(^"* ";
ERR(40):= "^"=^"* ";
ERR(41):= "^";^"* ";
ERR(42):= "CONSTANT* ";			\IN "GETCON"
ERR(43):= "VARIABLE* ";			\FOR AN 'ADDR' OPERATOR
ERR(44):= "^")^"* ";
ERR(45):= "NAME* ";
ERR(46):= "MIXED MODE ";
ERR(47):= "INTEGER* ";
ERR(48):= "'OF'* ";
ERR(49):= "^":^"* ";
ERR(50):= "^"]^"* ";
ERR(51):= "NO ARGUMENTS DECLARED ";
ERR(52):= "STATEMENT STARTING WITH 'ELSE' ";
ERR(53):= "STATEMENT STARTING WITH 'OTHER' ";
ERR(60):= "'QUIT' NOT IN A 'LOOP' ";
ERR(61):= "EOF* ";
ERR(62):= "EOF INSIDE A BLOCK ";
ERR(63):= "EOF INSIDE A STRING ";
ERR(65):= "'FPROC' & ITS 'PROC' NOT AT SAME LEVEL ";
ERR(66):= "'FPROC' REFERENCE NOT FOUND ";
ERR(67):= "'PROC' OR 'FUNC'* ";
ERR(68):= "'EPROC'S AND 'PUBLIC'S MUST BE GLOBAL ";
ERR(69):= "'INCLUDE'S NESTED TOO DEEP ";
ERR(70):= "BAD FILE SPEC ";
ERR(71):= "FILE NOT FOUND ";
ERR(72):= "'INT', 'REAL', 'CHAR' or 'ADDR'* ";
ERR(73):= "DIVIDE BY ZERO ";
ERR(74):= "MATH ERROR IN A CONSTANT EXPRESSION ";
ERR(75):= "EXPRESSION MUST BE ENCLOSED IN PARENTHESES ";

if LSTDEV = 8 then
	begin
	OPENI(8);
	loop	begin
		CH:= GETBC;
		if CH=EOF then quit;
		CHOUT(TV, CH);
		end;
	CRLF(TV);
	end;

CHOUT(TV, BEL); CHOUT(TV, $0A);		\(DAMN LINEFEEDS!)
CRLF(TV);
TEXT(TV, "***** ERROR NO. "); INTOUT(TV, N); TEXT(TV, " *****");
CRLF(TV);
STRING:= ERR(N);
I:= 0;
loop	[CH:= STRING(I);		\OUTPUT MESSAGE
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV, " EXPECTED BUT NOT FOUND")
	else CHOUT(TV, CH);
	I:= I+1];
CRLF(TV);
TEXT(TV, "ATTEMPT TO CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N, ^n: [CLOSE(LSTDEV); exit 1] other;
BINDEV:= NULDEV;			\THERE SHALL BE NO OUTPUT FILE
ERRCNT:= ERRCNT+1;
end;	\ERROR



proc	DEBDUMP;	\DUMP XPL SOURCE TO ASSEMBLY FILE FOR DEBUGGING (/D)
int	CH;


	func	DUMPLINE;	\DUMP A LINE OF SOURCE CODE
	begin
	CH:= GETBC;
	if CH=EOF then return false;
	TEXT(BINDEV, "; ");
	loop	begin
		if CH=EOF then return false;
		CHOUT(BINDEV, CH);
		if CH=EOL then return true;
		CH:= GETBC;
		end;
	end;	\DUMPLINE


begin	\DEBDUMP
if LSTDEV=8 then
	begin
	OPENI(8);
	while DUMPLINE do;
	OPENO(8);
	end;
if OLDCODCTR # CODCTR then CRLF(BINDEV);
OLDCODCTR:= CODCTR;
end;	\DEBDUMP



proc	GETCH;		\GET A CHARACTER FROM THE SOURCE DEVICE
\ FILTERS OUT COMMENTS
begin
CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
if DEBUG then
	if CHAR=EOL then DEBDUMP;
if CHAR=^\ then				\FILTER OUT COMMENTS
	begin
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
	if CHAR=^\ then			\FILTER OUT REST OF LINE
		loop   [CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
			if CHAR=$0D\CR\ then return;
			if CHAR=EOF then return]
	else	loop   [if CHAR=$0D\CR\ then return;
			if CHAR=EOF then return;
			CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
			if CHAR=^\ then [CHAR:= ^ ; return]];
	end;
end;	\GETCH



proc	GETCH_;		\GET A NON-UNDERLINE CHAR FROM THE SOURCE DEVICE
repeat GETCH until CHAR#^_;

\------------------------- ROUTINES TO HANDLE INCLUDES -------------------------

proc	FALLBACK;	\TERMINATE AN INCLUDE AND FALL BACK TO PREVIOUS HANDLE
begin
HANPTR:= HANPTR-1;
FCLOSE(INHAND);
INHAND:= OLDHAN(HANPTR);
FSET(INHAND, if HANPTR=0 then ^I else ^i); \ONLY THE MAIN FILE GETS THE BIG BUFFER
end;	\FALLBACK



proc	INCLUDE;	\SET UP AN INCLUDE FILE
char	NAME;
def	NAMMAX=80;
int	NEWHAND, I;


	proc	GETC;	\GET CHARACTER WITH NO FILTERING
	begin
	CHAR:= CHIN(SRCDEV);
	CHOUT(LSTDEV, CHAR);
	end;	\GETC


	func	GETNAME;	\READ FILE SPECIFICATION
	int	EXTFLG, I, K;
	char	DEFEXT;
	begin
	DEFEXT:= ".XPL";
	EXTFLG:= false;

	while CHAR<=$20 do		\EAT LEADING SPACES AND CONTROL CHARS
		[if CHAR=EOF then ERROR(61); GETC];

	K:= 0;				\COPY FILE NAME INTO 'NAME'
	loop	begin
		case CHAR of
		  ^.:	EXTFLG:= true;
		  EOL:	return false;
		  ^;:	quit
		other;

		NAME(K):= CHAR;
		K:= K+1;
		if K>=NAMMAX  then return false;
		GETC;
		end;

	if K=0 then return false;	\DEAL WITH EMPTY FILENAME

	if EXTFLG then			\DEAL WITH DEFAULT EXTENSIONS
		NAME(K-1):= NAME(K-1) ! $80
	else	begin
		if (K+4) >= NAMMAX then return false;
		for I:= 0, 3 do NAME(K+I):= DEFEXT(I);
		end;
	return true;
	end;	\GETNAME


begin	\INCLUDE
NAME:= RESERVE(NAMMAX);
if HANPTR >= HANMAX then
	[ERROR(69); while CHAR#^; & CHAR#EOF do GETC; return];
if not GETNAME then
	[ERROR(70); while CHAR#^; & CHAR#EOF do GETC; return];

TRAP($FFFB);				\OPEN FILE
NEWHAND:= FOPEN(NAME, 0);
TRAP($FFFF);
if GETERR = 3 then [ERROR(71); return];

OLDHAN(HANPTR):= INHAND;		\SAVE OLD FILE HANDLE ON STACK
HANPTR:= HANPTR+1;
INHAND:= NEWHAND;

FSET(INHAND, ^i);			\INCLUDE FILES ALWAYS USE SMALL BUFFERS

TEXT(TV, "INCLUDING: ");
for I:= 2, HANPTR do TEXT(TV, "   ");
TEXT(TV, NAME); CRLF(TV);
end;	\INCLUDE

\-------------------------------------------------------------------------------

fproc	CONEXPRESS;
fproc	LOOKUP, TTXT, POSTGEN;	\FOR 'ASM'


proc	RATOM;		\READ AN ATOM
\OUTPUTS:  ATOM, ATYPE, IDENT, HASH, IATOM, CHAR, RLATOM.
int	LEN, NEG, EXP, I, INTOVF;
real	FRACT, DENOM;


	proc	RFRACT;	\READ THE FRACTIONAL PART OF A REAL NO.
	begin
	ATYPE:= REALCON; ATOM:= 0;
	GETCH_;
	FRACT:= FLOAT(0); DENOM:= FLOAT(10);	\(10.0 IS NOT SO PORTABLE)
	while CHAR>=^0 & CHAR<=^9 do
		[FRACT:= FRACT +FLOAT(CHAR-^0) /DENOM;
		DENOM:= DENOM*FLOAT(10);
		GETCH_];
	RLATOM:= RLATOM +FRACT;
	end;	\RFRACT


	proc	REXP;	\READ AN EXPONENT IF ANY
	if CHAR=^E ! CHAR=^e then
		begin
		ATYPE:= REALCON;
		GETCH_;
		if CHAR=^- then [NEG:= true; GETCH_]
		else NEG:= false;
		if CHAR=^+ then GETCH_;
		EXP:= 0;
		if CHAR<^0 ! CHAR>^9 then ERROR(31);
		while CHAR>=^0 & CHAR<=^9 do
			[EXP:= EXP *10 +CHAR-^0; GETCH_];
		if NEG then EXP:= -EXP;
		while EXP>0 do
			[RLATOM:= RLATOM *FLOAT(10); EXP:= EXP-1];
		while EXP<0 do
			[RLATOM:= RLATOM /FLOAT(10); EXP:= EXP+1];
		end;	\REXP


	proc	DoAsmLine;	\Output a line of assembly code
	int	HaveComment;
	begin
	HaveComment:= false;
	while CHAR#$0D\CR\ & CHAR#^} do
		begin
		if CHAR=^; then HaveComment:= true;
		if not HaveComment then CHOUT(BINDEV,CHAR);
		GETCH;
		if CHAR>=^A & CHAR<=^Z & not HaveComment then
			begin
			RATOM;			\(ATYPE=IDENTIFIER)
			LOOKUP;
			case IDTYPE of
			  ADDRVAR, INVAR, RLVAR:
				[if IDTYPE=RLVAR then TTXT("qword ptr ");
				if LEV=0 then TTXT("heaplo+")
				else if LEV=LEVEL then TTXT("[si]+")
				else TTXT("[bp]+");
				INTOUT(BINDEV,VAL)];
			  INCON:
				INTOUT(BINDEV,VAL);
			  UNDEF:
				ERROR(10)
			other	ERROR(26);
			end;
		if CHAR=EOF then [ERROR(62); exit 1];
		end;
	if CHAR=$0D\CR\ then [CRLF(BINDEV); GETCH];
	if CHAR=$0A\LF\ then GETCH;
	end;	\DoAsmLine


begin	\RATOM
while CHAR<=$20 do	\SKIP SPACES, TABS, CR'S, LF'S, & FF'S, ETC.
	begin		\ BUT DON'T GO PAST EOF
			\IF HANPTR=0 THEN IT'S A HARD EOF
	if CHAR=EOF then if HANPTR>0 then FALLBACK
		    else [ATYPE:= SPECIAL; ATOM:= EOF; return];
	GETCH;
	end;
if CHAR>=^a then if CHAR<=^z then			\RESERVED WORD
	[ATYPE:= SPECIAL;
	ATOM:= CHAR; GETCH;
	ATOM:= ATOM<<5|CHAR; GETCH;
	if CHAR>=^a & CHAR<=^z then [ATOM:= ATOM<<5|CHAR; GETCH];
	while CHAR>=^a & CHAR<=^z do GETCH;
	case ATOM of
	  TRUSYM: [ATYPE:= INTCON; ATOM:= 0; IATOM:= true];
	  FALSYM: [ATYPE:= INTCON; ATOM:= 0; IATOM:= false];
	  CONSYM: begin
		  RATOM;
		  CONEXPRESS;
		  if FACTYP=INTEGER then CONDITIONAL:= IATOM else ERROR(47);
		  while ATOM=^; do RATOM;		\EAT SEMI, IF ANY
		  loop	begin				\EAT ATOMS TIL COND=TRUE
			if CONDITIONAL \#0\ then quit;
			if ATYPE=SPECIAL then
			  if ATOM=EOF then quit
			  else if ATOM=^" then		\ignore 'con' in strings
			    begin
			    if CHAR#^" then		\null string ("")
			      loop begin
				 CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
				 if CHAR=EOF then [ERROR(63); exit 1];
				 if CHAR=^^ then
					[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)]
				 else	if CHAR=^" then quit;
				 end;
			    GETCH;
			    end;
			RATOM;
			end;
		  end;
	  STRSYM:
		begin
		RATOM;
		CONEXPRESS;
		if FACTYP=INTEGER then STRTERM:= IATOM else ERROR(47);
		while ATOM=^; do RATOM;		\eat semicolon, if any
		end;
	  ASMSYM:
	    if CONDITIONAL then
	  	begin				\INSERT IN-LINE ASSEMBLY CODE
	  	LASTOP:= -1;			\instead of call to COMMENT
	  	CODCTR:= CODCTR +1;		\Main proc might be pure asm
	  	if POSTGENTYPE\#0\ then POSTGEN;\deal with pending BX, if any
		while CHAR=$20\SPACE\ ! CHAR=$09\TAB\ do
			[CHOUT(BINDEV,CHAR); GETCH]; \don't skip EOL
		if CHAR=^{ then
			begin
			GETCH;		\eat {
			repeat DoAsmLine until CHAR=^};
			GETCH;		\eat }
			CRLF(BINDEV);
			end
		else	DoAsmLine;
		OLDLEV:= -1;	\assume AX, DX, and BP registers are destroyed
		DXLEV:= -1;
		AXLEV:= -1;
		AXIMM:= false;
		AHZERO:= false;
		RATOM;		\return atom following 'asm' line(s)
		end;
	  INCSYM: [INCLUDE; GETCH; RATOM]
	other;
	return];
if CHAR>=^A then if CHAR<=^Z ! CHAR=^_ then		\IDENTIFIER
	begin
	ATYPE:= IDENTIFIER; ATOM:= 0;
	IDENT(0):= CHAR; HASH:= CHAR; GETCH;
	LEN:= 1;
	loop	begin
		if CHAR>=^a & CHAR<=^z then CHAR:= CHAR & $DF;	\UPPERCASE
		case of
		  CHAR>=^A & CHAR<=^Z,  CHAR>=^0 & CHAR<=^9,  CHAR=^_ :
			begin
			if LEN <SIGCHAR then
				[IDENT(LEN):= CHAR;
				HASH:= HASH+CHAR;
				LEN:= LEN+1];
			GETCH;
			end
		other	quit;
		end;
	for LEN:= LEN, SIGCHAR-1 do
		[IDENT(LEN):= ^ ; HASH:= HASH+^ ];
	HASH:= HASH & HASHMSK;
	return;
	end;
if CHAR>=^0 then if CHAR<=^9 then			\UNSIGNED INTEGER
	begin
	ATYPE:= INTCON;		\ASSUME INTEGER UNTIL SHOWN OTHERWISE
	ATOM:= 0;
	INTOVF:= false;
	IATOM:= CHAR-^0; GETCH_;
	loop	begin
		I:= IATOM;
		if CHAR<^0 ! CHAR>^9 then quit;
		I:= IATOM*10+CHAR-^0;
		if IATOM>3276 ! IATOM=3276 & CHAR>^7 then	\"I" OVERFLOWED
			[INTOVF:=true; quit];			\OK IF IT'S REAL
		IATOM:= I;
		GETCH_;
		end;
	RLATOM:= FLOAT(IATOM);
	IATOM:= I;			\(CAN'T FLOAT(32768))
	while CHAR>=^0 & CHAR<=^9 do	\MORE DIGITS MUST BE REAL
		[RLATOM:= RLATOM*FLOAT(10) + FLOAT(CHAR-^0);
		GETCH_];
	if CHAR=^. then RFRACT;				\UNSIGNED REAL
	REXP;
	if ATYPE=INTCON & INTOVF & IATOM#$8000 then
		if CONDITIONAL then ERROR(6);
	return;
	end;
case CHAR of
  ^.:	[RLATOM:= FLOAT(0);				\UNSIGNED REAL
	RFRACT;
	REXP;
	return];
  ^$:	begin						\UNSIGNED HEX INTEGER
	ATYPE:= INTCON; ATOM:= 0;
	GETCH_;
	case of
	  CHAR>=^0 & CHAR<=^9:	IATOM:= CHAR-^0;
	  CHAR>=^A & CHAR<=^F:	IATOM:= CHAR-$37;
	  CHAR>=^a & CHAR<=^f:	IATOM:=CHAR-$57
	other	[\DIGIT EXPECTED\ ERROR(31); return];
	loop	begin
		GETCH_;
		case of
		  CHAR>=^0 & CHAR<=^9:	I:= CHAR-^0;
		  CHAR>=^A & CHAR<=^F:	I:= CHAR-$37;
		  CHAR>=^a & CHAR<=^f:	I:=CHAR-$57
		other return;
		if IATOM>$FFF then
			if CONDITIONAL then ERROR(6);
		IATOM:= IATOM*16+I;
		end;
	end;
  ^%:	begin						\UNSIGNED BINARY INTEGER
	ATYPE:= INTCON; ATOM:= 0;
	GETCH_;
	if CHAR>=^0 & CHAR<=^1 then IATOM:= CHAR-^0
	else [\DIGIT EXPECTED\ ERROR(31); return];
	loop	[GETCH_;
		if CHAR>=^0 & CHAR<=^1 then I:= CHAR-^0
		else return;
		if IATOM<0 then		\(if IATOM > $7FFF ... unsigned)
			if CONDITIONAL then ERROR(6);
		IATOM:= IATOM*2+I];
	end;
  ^^:	[ATYPE:= INTCON;				\META CHARACTER
	ATOM:= 0;					\ = INTEGER CONSTANT
	CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
	IATOM:= CHAR;
	GETCH;
	return];
  ^":	[ATYPE:= SPECIAL;				\SPECIAL CHARACTER
	ATOM:= CHAR;		\' AND BACKSLASH HAVE NO EFFECT IN STRINGS
	CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
	return]
other;
ATYPE:= SPECIAL;					\SPECIAL CHARACTER
ATOM:= CHAR;
GETCH;
case CHAR of
  ^=:	case ATOM of
	^::	[GETCH; ATOM:= GETSYM];
	^>:	[GETCH; ATOM:= GESYM];
	^<:	[GETCH; ATOM:= LESYM]
	other;
  ^<:	[if ATOM = ^< then [GETCH; ATOM:= LSLSYM]];
  ^>:	begin
	if ATOM = ^> then [GETCH; ATOM:= LSRSYM]
	else if ATOM = ^- then
		[GETCH;
		if CHAR#^> then ERROR(38);
		GETCH;
		ATOM:= ASRSYM];
	end
other	[];
end;	\RATOM

\-------------------------------------------------------------------------------

proc	SKIPIT;		\SKIP THE REST OF A STATEMENT (FOR ERROR RECOVERY)
begin
while ATOM#EOF & ATOM#^; & ATOM#ENDSYM & ATOM#^] & ATOM#BEGSYM & ATOM#^[ do
	RATOM;
end;	\SKIPIT



proc	HEXB(I);	\OUTPUT HEX BYTE
int	I;
begin
CHOUT(BINDEV, HEXDIGIT( (I&$FF)/16 ));
CHOUT(BINDEV, HEXDIGIT(REM(0)));
end;	\HEXB



proc	SYMOUT(SYM);	\OUTPUT SYMBOL NAME AT 'SYM'
int	SYM;
int	I, C;
begin
for I:= 0, SIGCHAR-1 do
	begin
	C:= SYMBOL(SYM);
	if C=$20 then return;
	CHOUT(BINDEV, C);
	SYM:= SYM +SYMAX;
	end;
end;	\SYMOUT

\=========================== CODE GENERATOR ===========================

proc	TTXT(STR);	\OUTPUT OPCODE STRING
char	STR;
int	I, CH;
begin
for I:= 0, 32000 do
	begin
	CH:= STR(I);
	if CH >= $80 then 
		[CH:= CH & $7F;   I:= 32000];
	if CH=^| then CRLF(BINDEV) else CHOUT(BINDEV, CH);
	end
end;	\TTXT



proc	DOALIGN;	\DO ALIGNMENT STATEMENT
begin
case OPTIMIZE of
  OPT286: TTXT("	EVEN|");
  OPT386: TTXT("	ALIGN 4|")
other;
end;	\DOALIGN



proc	LOCOUT(DEFINE);	\OUTPUT CURRENT LOCAL LABEL
\ONLY USED FOR A Jcc OVER JMP TO MAKE A LONG CONDITIONAL JUMP. THEREFORE THIS
\ LABEL DOES NOT BOMB THE AX REGISTER INFO (AXIMM, AXLEV, AHZERO).
int	DEFINE;		\FLAG: IS LABEL DEFINITION
begin
TTXT("LL");
INTOUT(BINDEV, LOCAL);
if DEFINE then
	[TTXT(":");   LOCAL:= LOCAL +1];
if DEBUG then CRLF(BINDEV);
end;	\LOCOUT



proc	OPTNEWLEVEL(L);	\SET SI FOR CURRENT LEVEL FOR AN OPTIMIZED PROCEDURE
\Note that an optimized procedure can be called from a procedure at a deeper
\ level, thus SI must be set to make sure it is at the current level.
int	L;
begin
if L > 0 then
	begin
	TTXT("	PUSH	SI|	MOV	SI,BASE");
	INTOUT(BINDEV, L/2); CRLF(BINDEV);
	end;
OLDLEV:= -1;		\BP IS UNDEFINED
end;	\OPTNEWLEVEL



proc	NEWLEVEL(L);	\LOAD A NEW LEVEL IF NEEDED
int	L;
begin
if L#0 & L#OLDLEV & L#LEVEL then
	begin
	TTXT("	MOV	BP,BASE");
	INTOUT(BINDEV, L/2); CRLF(BINDEV);
	OLDLEV:= L;
	end;
end;	\NEWLEVEL



proc	SHOWSTK;	\DEBUGGING ROUTINE TO SHOW THE PSEUDO STACK
int	P;
begin
if not COMFLG then return;
TEXT(BINDEV, "
; ==============================
");

for P:= 0, PSTKPTR-1 do
	begin
	TEXT(BINDEV, "; ");
	case P of
	  PSTKPTR-1:	TEXT(BINDEV, "TOS> ");
	  PSTKPTR-2:	TEXT(BINDEV, "NOS> ")
	other TEXT(BINDEV, "     ");

	case PSTKTYP(P) of
	  REGTYP:	TEXT(BINDEV, "REG");
	  STKTYP:	TEXT(BINDEV, "STK");
	  ADDTYP:	TEXT(BINDEV, "ADD");
	  IMMTYP:	TEXT(BINDEV, "IMM");
	  REALTYP:	TEXT(BINDEV, "FLT")
	other;

	TEXT(BINDEV, " - ");
	INTOUT(BINDEV, PSTKLEV(P)); TEXT(BINDEV, " - ");
	INTOUT(BINDEV, PSTKOFF(P));
	CRLF(BINDEV);
	end;
TEXT(BINDEV, "; ==============================
");
end;	\SHOWSTK

\------------ ROUTINES TO HANDLE INTERNAL OPTIMIZING (PSEUDO) STACK ------------

proc	BUGMSG(S);	\DISPLAY MESSAGE FOR INTERNAL COMPILER ERROR (I.E: BUG)
int	S;
begin
TEXT(TV, "INTERNAL ERROR - "); TEXT(TV, S); CRLF(TV);
TTXT(";INTERNAL ERROR - "); TTXT(S); CRLF(BINDEV);
ERROR(0);
end;	\BUGMSG


	
proc	PPUSH(TYP, LEV, OFF);	\PUSH AN ITEM ONTO PSEUDO STACK
int	TYP, LEV, OFF;
begin
PSTKTYP(PSTKPTR):= TYP;
PSTKLEV(PSTKPTR):= LEV;
PSTKOFF(PSTKPTR):= OFF;
PSTKPTR:= PSTKPTR+1;
end;	\PPUSH



proc	PDROP(N);	\DROP (POP) "N" ITEMS FROM PSEUDO STACK
int	N;
begin
PSTKPTR:= PSTKPTR-N;
if PSTKPTR < 0 then [PSTKPTR:= 0; BUGMSG("PDROP PSTKPTR<0")];
end;	\PDROP



proc	PSWAP;		\SWAP TOP TWO ITEMS ON THE PSEUDO STACK
int	T;
begin
T:= PSTKTYP(PSTKPTR-2);
PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
PSTKTYP(PSTKPTR-1):= T;

T:= PSTKLEV(PSTKPTR-2);
PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
PSTKLEV(PSTKPTR-1):= T;

T:= PSTKOFF(PSTKPTR-2);
PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
PSTKOFF(PSTKPTR-1):= T;
end;	\PSWAP



proc	GENAX(L, O);	\GENERATE CODE TO PUT AN IMMEDIATE VALUE INTO AX
int	L,	\THE VALUE TO GENERATE
	O;	\^L OR ^C (LABEL OR CONSTANT)
begin
CHOUT(BINDEV,^	);
case of
  O = ^L:		[TTXT("MOV	AX,OFFSET L"); INTOUT(BINDEV, L)];

\0-BYTE SOLUTIONS:
  L=AXVAL & AXIMM:	[];			\ALREADY IN AX

\1-BYTE SOLUTIONS:
  L=AXVAL+1 & AXIMM:	TTXT("INC	AX");
  L=AXVAL-1 & AXIMM:	TTXT("DEC	AX");

\2-BYTE SOLUTIONS:
  L=0:			TTXT("XOR	AX,AX");
  L=(L&$00FF ! AXVAL&$FF00) & AXIMM:
			[TTXT("MOV	AL,"); INTOUT(BINDEV, L&$00FF)];
  L>>8=0 & AHZERO:	[TTXT("MOV	AL,"); INTOUT(BINDEV, L)];
  L=(L&$FF00 ! AXVAL&$00FF) & AXIMM:
			[TTXT("MOV	AH,"); INTOUT(BINDEV, L>>8)];
  L=-AXVAL & AXIMM:	TTXT("NEG	AX");		\(BEWARE OF $8000)
  L=(~AXVAL) & AXIMM:	TTXT("NOT	AX");
  L=AXVAL+AXVAL & AXIMM:TTXT("ADD	AX,AX")
\3-BYTE SOLUTION:
other			[TTXT("MOV	AX,"); INTOUT(BINDEV, L)];
CRLF(BINDEV);

AXIMM:= O # ^L;		\Don't use label for immediate value
if AXIMM then AXVAL:= L;
AHZERO:= if AXIMM then AXVAL>>8=0 else false;
AXLEV:= -1;
end;	\GENAX



func	ISZERO(COMM);	\Eliminate operations that result in zero
			\Returns 'true' if operation equals 0
int	COMM;		\operation is commutative
begin
if PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKLEV(PSTKPTR-2)=0 & PSTKOFF(PSTKPTR-2)=^C then
	[PDROP(1); return true];	\e.g: 0/A
if COMM then				\e.g: 0*A = A*0
	begin
	if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKLEV(PSTKPTR-1)=0 &
	   PSTKOFF(PSTKPTR-1)=^C then
		begin			\e.g: A*0
		PSTKTYP(PSTKPTR-2):= IMMTYP;
		PSTKLEV(PSTKPTR-2):= 0;
		PSTKOFF(PSTKPTR-2):= ^C;
		PDROP(1);
		return true;
		end;
	end;
return false;
end;	\ISZERO



func	IDENTITY(N,COMM);\Eliminate identity operations such as A+0 and A*1
int	N,		\returns 'true' if it was an identity operation
	COMM;		\OPERATION IS COMMUTATIVE
begin
if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKLEV(PSTKPTR-1)=N & PSTKOFF(PSTKPTR-1)=^C then
	[PDROP(1); return true];

if COMM then
	begin
	if PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKLEV(PSTKPTR-2)=N &
	    PSTKOFF(PSTKPTR-2)=^C then
		begin	\eliminate identity operator
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		return true;
		end
	end;
return false;
end;	\IDENTITY



proc	OPSTRING(STR, TYP, LEV, OFF, REG);
\OUTPUT OPCODE STRING WITH EMBEDDED OPERANDS OR REGISTERS
\ SPECIAL STRING SYMBOLS: |=CRLF, &=OPERAND, #=REGISTER
\*** WARNING***: BE SURE TO BOMB DX (DXLEV:= -1) AND AX BEFORE USING THIS
\ PROCEDURE TO STORE INTO ANY MEMORY VARIABLE.
char	STR;	\STRING
int	TYP,	\TYPE OF OPERAND (&: ^R, ^A or ^I)
	LEV,	\LEVEL FOR ADDRESS (A), VALUE FOR IMMEDIATE (I), OR STRING FOR REG (R)
	OFF,	\OFFSET FOR ADDRESS, OR ^L FOR LABELS
	REG;	\REGISTER (#: ^A, ^B, ^C, ^D, ^S, ^I, or ^P)
int	I, CH;
begin
if TYP=^A then 
	begin	\IF ADDRESS OPERAND, MAKE SURE BP IS PROPERLY SET IF NECESSARY
	case of
	  LEV=DXLEV & OFF=DXOFF:	\EVEN READING DX IN WHILE LOOP BOMBS IT
		if DXPEND then [DXLEV:= -1; DXPEND:=false; NEWLEVEL(LEV)];
	  LEV=AXLEV & OFF=AXOFF:
		[]
	other NEWLEVEL(LEV);
	end;
for I:= 0, 32000 do
	begin
	CH:= STR(I) & $7F;
	case CH of
	  ^&:	case TYP of
		  ^R:	TEXT(BINDEV, LEV);			\REGISTER (AX)
		  ^A:	begin					\ADDRESS
			if LEV=DXLEV & OFF=DXOFF then		\REGISTER VAR
				TTXT("DX")
			else if LEV=AXLEV & OFF=AXOFF then	\REGISTER VAR
				TTXT("AX")
			else	begin
				TTXT("WP ");			\WORD PTR
				case LEV of
				  0:	TTXT(if LEVEL#0 ! OPTPROC ! ABS(OFF)>127
				  		then "HEAPLO+" else "[SI]+");
				  LEVEL:TTXT("[SI]+")
				other	TTXT("[BP]+");
				INTOUT(BINDEV, OFF);
				end;
			end;
		  ^I:	begin
			if OFF=^L then
				[TTXT("OFFSET L");		\IMMEDIATE
				INTOUT(BINDEV, LEV)]
			else if AXIMM & AXVAL=LEV then TTXT("AX")
			else INTOUT(BINDEV, LEV);
			end
		other;
	  ^#:	case REG of
		  ^A:	[TEXT(BINDEV, "AX");
			AXLEV:= -1;   AXIMM:= false;   AHZERO:= false];
		  ^B:	TEXT(BINDEV, "BX");
		  ^C:	TEXT(BINDEV, "CX");
		  ^D:	[TEXT(BINDEV, "DX");  DXLEV:= -1];
		  ^S:	TEXT(BINDEV, "SI");
		  ^I:	TEXT(BINDEV, "DI");	\WARNING: RESERVED FOR HP
		  ^P:	TEXT(BINDEV, "BP")
		other	BUGMSG("OPSTRING");
	  ^|:	CRLF(BINDEV)
	other	CHOUT(BINDEV, CH);
	if STR(I) >= $80 then return;
	end
end;	\OPSTRING



proc	TOS2REG(R);	\COPY TOS INTO REGISTER SPECIFIED BY 'R'
int	R, TOS;		\ (UNLESS IT'S A REAL)
begin
case PSTKTYP(PSTKPTR-1) of
  REGTYP: if R#^A then OPSTRING("	MOV	#,AX|", 0, 0, 0, R);
  STKTYP: begin
	  OPSTRING("	POP	#|", 0, 0, 0, R);
	  if R = ^A then [AXLEV:= -1; AXIMM:= false; AHZERO:= false];
	  end;
  ADDTYP: begin
	  OPSTRING("	MOV	#,&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), R);
	  if R = ^A then
		[AXLEV:= PSTKLEV(PSTKPTR-1); AXOFF:= PSTKOFF(PSTKPTR-1);
		AXIMM:= false; AHZERO:= false];
	  end;
  IMMTYP: if R=^A then GENAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1))
	  else	if PSTKLEV(PSTKPTR-1)=0 \& #^L\ then
			OPSTRING("	XOR	#,#|", 0, 0, 0, R)
	  	else	OPSTRING("	MOV	#,&|", ^I, PSTKLEV(PSTKPTR-1),
				PSTKOFF(PSTKPTR-1), R)\;
\ REALTYP: []
other	BUGMSG("TOS2REG");
end;	\TOS2REG



proc	ADDTOS2BX;	\ADD TOS TO BX (FOR INDEXING OPERATION)
int	TOS;
begin
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	ADD	BX,AX|");
  STKTYP: TTXT("	POP	CX|	ADD	BX,CX|");
  ADDTYP: OPSTRING("	ADD	BX,&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
  IMMTYP: if PSTKLEV(PSTKPTR-1)#0 \& #^L\ then	\(THIS IS USUALLY OPTIMIZED ELSEWHERE)
		OPSTRING("	ADD	BX,&|", ^I, PSTKLEV(PSTKPTR-1),
				PSTKOFF(PSTKPTR-1), 0)\;
\  REALTYP: []
other	BUGMSG("ADDTOS2BX");
end;	\ADDTOS2BX



proc	TOS2ES;		\COPY TOS INTO EXTRA SEGMENT (ES) REGISTER (USES BP)
begin
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	MOV	ES,AX|");
  STKTYP: TTXT("	POP	ES|");
  ADDTYP: OPSTRING("	MOV	ES,&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
  IMMTYP: [OPSTRING("	MOV	BP,&|", ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	  TTXT("	MOV	ES,BP|");
	  OLDLEV:= -1]\;
\  REALTYP: []
other	BUGMSG("TOS2ES");
end;	\TOS2ES



proc	CLEANREG(LEV);	\PUSH ANY AX BELOW 'LEV' ON PSEUDO STACK ONTO H/W STACK
int	LEV;	\i.e: clean AX off pseudo stack because we are about to use it
int	I;
begin
for I:= 0, PSTKPTR-(LEV+1) do	\from the bottom of the stack toward the top...
	if PSTKTYP(I) = REGTYP then
		[TTXT("	PUSH	AX|");
		PSTKTYP(I):= STKTYP];
end;	\CLEANREG



proc	TOS2HARD;   \MAKE SURE TOS IS A HARD VALUE, EITHER IN AX OR ON H/W STACK
begin
if PSTKPTR < 1 then [BUGMSG("TOS2HARD"); return];
case PSTKTYP(PSTKPTR-1) of
  REGTYP, STKTYP, REALTYP: return;
  ADDTYP:
	begin
	CLEANREG(1);	\AX on TOS is ok, but stack it if it's below TOS.
	OPSTRING("	MOV	AX,&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	AXLEV:= PSTKLEV(PSTKPTR-1); AXOFF:= PSTKOFF(PSTKPTR-1);
	AXIMM:= false; AHZERO:= false;
	end;
  IMMTYP:
	begin
	CLEANREG(1);
	GENAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
	end
other	BUGMSG("TOS2HARD");
PSTKTYP(PSTKPTR-1):= REGTYP;
end;	\TOS2HARD



proc	TOS2STACK;	\MAKE SURE TOS IS IN THE TOP OF THE HARDWARE STACK
begin
if PSTKPTR < 1 then [BUGMSG("TOS2STACK"); return];
CLEANREG(1);
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	PUSH	AX|");
  STKTYP: return;
  ADDTYP: OPSTRING("	PUSH	&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
  IMMTYP: begin
	  GENAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
	  TTXT("	PUSH	AX|");
	  end;
  REALTYP: []		\IT IS ALREADY ON HARDWARE STACK
other	BUGMSG("TOS2STACK");
PSTKTYP(PSTKPTR-1):= STKTYP;
end;	\TOS2STACK



proc	TOS2AX;		\MAKE SURE TOS IS IN AX
begin
CLEANREG(1);
TOS2REG(^A);
PSTKTYP(PSTKPTR-1):= REGTYP;
end;	\TOS2AX



proc	GENOP2(OPSTR, REV, NOIMM, OP);	\OUTPUT AN OPCODE FOR TWO-ARGUMENT OPS
char	OPSTR;	\OPCODE STRING
int	REV,	\FLAGS REVERSE ORDER OPCODES (OPERATION IS NOT COMMUTATIVE)
	NOIMM;	\FLAGS OPS THAT CAN'T DO IMMEDIATE
char	OP;	\STRING CONTAINING OPERATOR, I.E: ">="
int	TOS, NOS;


	\PROCEDURE NAME ORDER: DO_NOS_TOS
	proc	DO_REG_REG;				\0
	begin				\(THIS IS POSSIBLE BECAUSE OF OPTIMIZING)
	OPSTRING(OPSTR, ^R, "AX", 0, 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_REG_REG


	proc	DO_STK_REG;				\1
	begin
	TTXT("	POP	CX|");
	if REV then
		[TTXT("	XCHG	AX,CX|"); AXLEV:= -1; AXIMM:= false; AHZERO:= false];
	OPSTRING(OPSTR, ^R, "CX", 0, 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_STK_REG


	proc	DO_ADD_REG;				\2
	begin
	if REV then
		begin
		OPSTRING("	MOV	CX,AX|	MOV	AX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
		AXIMM:= false; AHZERO:= false;
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_ADD_REG


	proc	DO_IMM_REG;				\3
	begin
	if REV then
		begin
		TTXT("	MOV	CX,AX|");
		GENAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	begin
		if NOIMM then
			begin
			OPSTRING("	MOV	CX,&|",
				^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
			OPSTRING(OPSTR, ^R, "CX", 0, 0);
			end
		else OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		end;
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_IMM_REG


	proc	DO_STK_STK;				\4
	begin
	TTXT("	POP	CX|	POP	AX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	OPSTRING(OPSTR, ^R, "CX", 0, 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_STK_STK


	proc	DO_ADD_STK;				\5
	begin
	if REV then
		begin
		OPSTRING("	POP	CX|	MOV	AX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
		AXIMM:= false; AHZERO:= false;
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	begin
		TTXT("	POP	AX|");
		AXLEV:= -1; AXIMM:= false; AHZERO:= false;
		OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		end;
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_ADD_STK


	proc	DO_IMM_STK;				\6
	begin
	if REV then
		begin
		OPSTRING("	POP	CX|", 0, 0, 0, 0);
		GENAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	begin
		TTXT("	POP	AX|");
		AXLEV:= -1; AXIMM:= false; AHZERO:= false;
		if NOIMM then
			begin
			OPSTRING("	MOV	CX,&|",
				^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
			OPSTRING(OPSTR, ^R, "CX", 0, 0);
			end
		else OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		end;
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_IMM_STK


	proc	DO_REG_ADD;				\7
	begin
	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_REG_ADD


	proc	DO_STK_ADD;				\8
	begin
	TTXT("	POP	AX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_STK_ADD


	proc	DO_ADD_ADD;				\9
	begin
	\IF NOS IS IN DX THEN IT'S BETTER TO REVERSE THE OPERATION
	if ~REV & PSTKLEV(PSTKPTR-2)=DXLEV & PSTKOFF(PSTKPTR-2)=DXOFF then PSWAP;
	OPSTRING("	MOV	AX,&|",
			^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
	AXIMM:= false; AHZERO:= false;

	if PSTKLEV(PSTKPTR-1) = PSTKLEV(PSTKPTR-2) &
	   PSTKOFF(PSTKPTR-1) = PSTKOFF(PSTKPTR-2) then
		OPSTRING(OPSTR, ^R, "AX", 0, 0)  \Don't fetch same value twice
	else	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_ADD_ADD


	proc	DO_IMM_ADD;				\10
	begin
	if REV ! NOIMM then
		begin
		GENAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
		OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		end
	else	begin
		OPSTRING("	MOV	AX,&|",
				^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		AXLEV:= PSTKLEV(PSTKPTR-1); AXOFF:= PSTKOFF(PSTKPTR-1);
		AXIMM:= false; AHZERO:= false;
		OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		end;
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_IMM_ADD


	proc	DO_REG_IMM;				\11
	begin
	if NOIMM then
		begin
		TTXT("	MOV	CX,");
		INTOUT(BINDEV, PSTKLEV(PSTKPTR-1)); CRLF(BINDEV);
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_REG_IMM


	proc	DO_STK_IMM;				\12
	begin
	TTXT("	POP	AX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	if NOIMM then
		begin
		TTXT("	MOV	CX,");
		INTOUT(BINDEV, PSTKLEV(PSTKPTR-1)); CRLF(BINDEV);
		OPSTRING(OPSTR, ^R, "CX", 0, 0);
		end
	else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_STK_IMM


	proc	DO_ADD_IMM;				\13
	begin
	if REV then
		begin
		OPSTRING("	MOV	AX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
		AXIMM:= false; AHZERO:= false;
		if NOIMM then
			begin
			OPSTRING("	MOV	CX,&|",
				^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
			OPSTRING(OPSTR, ^R, "CX", 0, 0);
			end
		else OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		end
	else	begin
		if NOIMM then
			begin
			GENAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
			OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
			end
		else	begin
			OPSTRING("	MOV	AX,&|",
					^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
			AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
			AXIMM:= false; AHZERO:= false;
			OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
			end;
		end;
	PDROP(2);
	PPUSH(REGTYP, 0, 0);
	end;	\DO_ADD_IMM


	proc	DO_IMM_IMM;				\14
	\WARNING: THIS MUST NOT AFFECT AX (NOT CLEAN)
	int	TOSVAL, NOSVAL, C1, C2, REMAIN;
	begin
	if PSTKOFF(PSTKPTR-1)#^C ! PSTKOFF(PSTKPTR-2)#^C then
		BUGMSG("DO_IMM_IMM LABELS");

	TOSVAL:= PSTKLEV(PSTKPTR-1);
	NOSVAL:= PSTKLEV(PSTKPTR-2);
	C1:= OP(0); C2:= OP(1);		\GET OPERATOR SYMBOL FROM STRING
	C2:= if C1>=$80 then 0 else C2 & $7F;
	C1:= C1 & $7F;
	case C1 of
	  ^=:	TOSVAL:= NOSVAL=TOSVAL;
	  ^#:	TOSVAL:= NOSVAL#TOSVAL;
	  ^>:	TOSVAL:= if C2=^= then NOSVAL>=TOSVAL else NOSVAL>TOSVAL;
	  ^<:	TOSVAL:= if C2=^= then NOSVAL<=TOSVAL else NOSVAL<TOSVAL;
	  ^!:	TOSVAL:= NOSVAL!TOSVAL;
	  ^&:	TOSVAL:= NOSVAL&TOSVAL;
	  ^|:	TOSVAL:= NOSVAL|TOSVAL;
	  ^+:	TOSVAL:= NOSVAL+TOSVAL;
	  ^-:	TOSVAL:= NOSVAL-TOSVAL;
	  ^*:	TOSVAL:= NOSVAL*TOSVAL;
	  ^/:	begin
		if TOSVAL=0 then [ERROR(73); TOSVAL:= $7FFF; REMAIN:= 0]
		else [TOSVAL:= NOSVAL/TOSVAL; REMAIN:= REM(0)];
		OPSTRING("	MOV	REMAIN,&|", ^I, REMAIN, ^C, 0);
		end
	other	BUGMSG("DO_IMM_IMM");
	PDROP(2);
	PPUSH(IMMTYP, TOSVAL, ^C);
	HAVESTAT:= false;
	end;	\DO_IMM_IMM


begin	\GENOP2
if PSTKPTR < 2 then BUGMSG("GENOP2");

if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKOFF(PSTKPTR-1)#^C !	\HANDLE "NAME"+2, ETC.
   PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKOFF(PSTKPTR-2)#^C then
	[TOS2HARD; AXLEV:= -1; AXIMM:= false; AHZERO:= false];

TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
if TOS#IMMTYP ! NOS#IMMTYP then CLEANREG(2);	\IF THEY'RE NOT BOTH IMMEDIATES
HAVESTAT:= true;	\"OPSTR" SETS STATUS FLAGS EXCEPT FOR DO_IMM_IMM

\GENERATE OPCODE BASED ON NOS AND TOS
case of
  NOS=REGTYP & TOS=REGTYP: DO_REG_REG;			\0
  NOS=STKTYP & TOS=REGTYP: DO_STK_REG;			\1
  NOS=ADDTYP & TOS=REGTYP: DO_ADD_REG;			\2
  NOS=IMMTYP & TOS=REGTYP: DO_IMM_REG;			\3

  NOS=STKTYP & TOS=STKTYP: DO_STK_STK;			\4
  NOS=ADDTYP & TOS=STKTYP: DO_ADD_STK;			\5
  NOS=IMMTYP & TOS=STKTYP: DO_IMM_STK;			\6

  NOS=REGTYP & TOS=ADDTYP: DO_REG_ADD;			\7
  NOS=STKTYP & TOS=ADDTYP: DO_STK_ADD;			\8
  NOS=ADDTYP & TOS=ADDTYP: DO_ADD_ADD;			\9
  NOS=IMMTYP & TOS=ADDTYP: DO_IMM_ADD;			\10

  NOS=REGTYP & TOS=IMMTYP: DO_REG_IMM;			\11
  NOS=STKTYP & TOS=IMMTYP: DO_STK_IMM;			\12
  NOS=ADDTYP & TOS=IMMTYP: DO_ADD_IMM;			\13
  NOS=IMMTYP & TOS=IMMTYP: DO_IMM_IMM			\14
other	BUGMSG("GENOP2");
end;	\GENOP2

\------------------------- ROUTINES TO GENERATE OPCODES ------------------------

proc	POSTGEN;
\Postponing the use of an index register after it is loaded can save 2
\ cycles on a 486 and even more on a Pentium. These hidden cycles are
\ caused by Address Generation Interlock (AGI).
begin
\Note that the MOV instruction does not affect status. GENFOR takes advantage of this.
\(Don't use OPSTRING because AX can't be used for an immediate value with a BYTE PTR)
case POSTGENTYPE of
  1:	[TTXT("	MOV	BYTE PTR [BX]+"); INTOUT(BINDEV,POSTGENOFF);
	CHOUT(BINDEV, ^,); INTOUT(BINDEV,POSTGENVAL&$FF); CRLF(BINDEV)];
  2:	OPSTRING("	MOV	WP [BX],&|", ^I, POSTGENVAL, ^C, 0)
other	BUGMSG("POSTGEN");
POSTGENTYPE:= 0;
end;	\POSTGEN



proc	GENSTART;
begin
TTXT("	INCLUDE	RUNTIME.ASM|CSEG	SEGMENT DWORD PUBLIC 'CODE'|");
TTXT("	ASSUME CS:CSEG|PROGRM:|");
end;	\GENSTART



proc	DSTART;		\START A DATA SEGMENT
begin
if POSTGENTYPE\#0\ then POSTGEN;	\(FOR NEATNESS)
TTXT("|DSEG	SEGMENT WORD PUBLIC 'DATA'|");
end;	\DSTART



proc	DEND;
begin
TTXT("DSEG	ENDS||");
end;	\DEND



proc	STARTSEG(LEV, SEG);	\START A NEW CODE SEGMENT
int	LEV, SEG;

	proc	PUTSYMBOL;	\OUTPUT SYMBOLS
	begin
	TTXT("CSEG");
	if ~OPTCALL & LEV#0 then
		begin
		CHOUT(BINDEV, ^_);
		TEXT(BINDEV, FNAME);
		CHOUT(BINDEV, ^_);
		INTOUT(BINDEV, SEG);
		end;
	end;	\PUTSYMBOL

begin	\STARTSEG
if OPTCALL then return;		\EVERYTHING'S IN THE 'CSEG' SEGMENT
TTXT("@curseg	ENDS||");
PUTSYMBOL;
TTXT("	SEGMENT DWORD PUBLIC 'CODE'|	ASSUME	CS:");
PUTSYMBOL;
CRLF(BINDEV);
end;	\STARTSEG



proc	DLABEL(N);	\MAKE DATA LABEL
int	N;
begin
TTXT("|L");	\"|" IS NECESSARY BECAUSE THERE MIGHT ALREADY BE A LABEL HERE
INTOUT(BINDEV, N);
end;	\DLABEL



proc	FLABEL(N);	\MAKE A FAR (OR NEAR) CODE LABEL
int	N;
begin
DLABEL(N);
TTXT("	LABEL	");
TTXT(if OPTCALL then "NEAR|" else "FAR|");
LASTOP:= -1;		\WE MIGHT NOT BE COMING FROM THE PREVIOUS OPCODE
OLDLEV:= -1;		\WE DON'T KNOW WHAT'S IN THESE REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\FLABEL



proc	CLABEL(N);	\MAKE A CODE LABEL
int	N;
begin
if POSTGENTYPE\#0\ then POSTGEN;
DLABEL(N); CHOUT(BINDEV, ^:);
if DEBUG then CRLF(BINDEV);
LASTOP:= -1;		\WE MIGHT NOT BE COMING FROM THE PREVIOUS OPCODE
OLDLEV:= -1;		\(DO NOT BOMB THE DX REGISTER)
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\CLABEL



func	NEWLAB;		\GENERATE A NEW LABEL NUMBER
begin
LABCNT:= LABCNT+1;
return LABCNT;
end;	\NEWLAB



proc	COMMENT(OPC);		\EVERY OPCODE ROUTINE MUST CALL THIS
int	OPC;
int	COMTB1, COMTB2, C;
begin
LASTOP:= OPC;
CODCTR:= CODCTR +1;

\IF NOT CERTAIN OPCODES (WHICH DON'T USE BX, OR IF A LABEL) THEN POSTGEN
\OPCODES ALREADY OPTIMIZED BY A FOLLOWING OPCODE (USES LASTOP) ARE NOT INCLUDED
if POSTGENTYPE\#0\ then
	begin
	case OPC of
	  $01\LOD\, $03\STO\, $0A\ARG\, $0B\IMM\, $0D\ADD\, $0E\SUB\, $0F\MUL\,
	  $10\DIV\, $11\NEG\, $18\FOR\, $19\INP\, $1A\OR\, $1B\AND\, $1D\EOR\,
	  $21\ADR\, $28\DRP\, $3C\MARK\, $3D\ASR\, $3E\LSL\, $3F\LSR\: []
	other POSTGEN;
	end;

if not COMFLG then return;

COMTB1:=
 ["EXIT","LOD","LDX","STO","STX","CAL","RET","JMP","JPC","HPI","ARG","IMM",
 "CML","ADD","SUB","MUL","DIV","NEG","EQ","NE","GE","GT","LE","LT","FOR",
 "INP","OR","AND","NOT","EOR","DBA","STD","DBX","ADR","LDI","LDA","IMS",
 "CJP","JSR","RTS","DRP","CEXT","FLOD","FSTO","FIMM","FADD","FSUB","FMUL",
 "FDIV","FNEG","FEQ","FNE","FGE","FGT","FLE","FLT","TRA","TRX","TRI","STT",
 "MARK","ASR","LSL","LSR","LDSI","LDSB","LDSR","STSI","STSB","STSR","LSHORT",
 "SSHORT","MKARRAY","ABS","FABS","REM","SWAP","EXT","PIN","POUT" ];

COMTB2:= ["TXT","FLT","INT","END","NUL"];

SHOWSTK;
CRLF(BINDEV);
TEXT(BINDEV, "; $"); HEXB(OPC); TEXT(BINDEV, " - ");
TEXT(BINDEV, if OPC >= $FB then COMTB2(OPC-$FB) else COMTB1(OPC));
CRLF(BINDEV);
end;	\COMMENT



proc	GENEXIT;	\$00
begin
COMMENT($00);
TTXT("	MOV	SP,STKPTR|	RETF|");
DOALIGN;
end;	\GENEXIT



proc	GENLOD(L, O);	\$01 TOS <- @(Level + Offset)
int	L, O;
begin
COMMENT($01);
if L=AXLEV & O=AXOFF then	\IT'S ALREADY IN AX
	PPUSH(REGTYP, 0, 0)
else	PPUSH(ADDTYP, L, O);
end;	\GENLOD



proc	GENLDX;		\$02 TOS <- @((TOS) + NOS)
int	C;
begin
COMMENT($02);
CLEANREG(2);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin
	C:= PSTKLEV(PSTKPTR-1);
	PDROP(1);
	TOS2REG(^B);
	TTXT("	MOV	AL,[BX]+"); INTOUT(BINDEV,C);
	end
else	begin
	\IF TOS IS IN A REGISTER THEN IT'S BETTER TO REVERSE THE OPERATION
	if PSTKLEV(PSTKPTR-1)=DXLEV & PSTKOFF(PSTKPTR-1)=DXOFF !
	   PSTKTYP(PSTKPTR-1)=REGTYP then PSWAP;
	TOS2REG(^B); PDROP(1);
	ADDTOS2BX;
	TTXT("	MOV	AL,[BX]");
	end;
PDROP(1);
TTXT("|");

if AHZERO then LASTOP:= -1
else TTXT("	XOR	AH,AH|");
\Optimized GENSTX, GENJPC, SHIFT and GENPOUT depends on this XOR instruction

PPUSH(REGTYP, 0, 0);
AXLEV:= -1; AXIMM:= false; AHZERO:= true;
end;	\GENLDX



proc	GENSTO(L, O);	\$03 @(Level + Offset) <- TOS
int	L, O;
begin
COMMENT($03);
if L=AXLEV & O=AXOFF then AXLEV:= -1;	\MUST BOMB REGISTER VARIABLE BEFORE USING
if L=DXLEV & O=DXOFF then DXLEV:= -1;	\ OPSTRING TO STORE INTO ANY VARIABLE
case PSTKTYP(PSTKPTR-1) of
  REGTYP: [OPSTRING("	MOV	&,AX|",	^A, L, O, 0);
	   AXLEV:= L; AXOFF:= O];
  STKTYP: OPSTRING("	POP	&|",	^A, L, O, 0);
  ADDTYP: if L#PSTKLEV(PSTKPTR-1) ! O#PSTKOFF(PSTKPTR-1) then	\don't do A:= A
	    [OPSTRING("	MOV	AX,&|",	^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	     OPSTRING("	MOV	&,AX|",	^A, L, O, 0);
	     AXLEV:= L; AXOFF:= O; AXIMM:= false; AHZERO:= false];
  IMMTYP:
	begin	\IF IMMEDIATE VALUE IS 0, IT'S BETTER TO USE 2 INSTRUCTIONS
	if PSTKLEV(PSTKPTR-1) = 0 then
		[GENAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
		OPSTRING("	MOV	&,AX|",	^A, L, O, 0);
		AXLEV:= L; AXOFF:= O]
	else	[OPSTRING("	MOV	&,",	^A, L, O, 0);
		OPSTRING("&|",		^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0)];
	end
other	BUGMSG("GENSTO");
PDROP(1);
end;	\GENSTO



proc	GENSTX;		\$04 @(NOS) <- TOS
int	LEV, OFF, TOS, NOS, LOP;
begin
LOP:= LASTOP;
COMMENT($04);
if LOP=\LDX\$02 ! LOP=\LDSB\$41 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-2|"); AHZERO:= false];	\REPLACE XOR AH,AH

TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);

if TOS=IMMTYP then
	begin
	LEV:= PSTKLEV(PSTKPTR-1);
	OFF:= PSTKOFF(PSTKPTR-1);
	PDROP(1);
	TOS2REG(^B);
	OPSTRING("	MOV	BYTE PTR [BX],&|", ^I, LEV&$FF, OFF, 0);
	PDROP(1);
	end
else	begin
	if NOS=REGTYP then
		begin
		TTXT("	MOV	BX,AX|");
		TOS2REG(^A); PDROP(2);
		end
	else	begin
		TOS2REG(^A); PDROP(1);
		TOS2REG(^B); PDROP(1);
		end;
	TTXT("	MOV	[BX],AL|");
	end;
end;	\GENSTX



proc	GENSTX2;	\$04 @(NOS2+NOS) <- TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($04);
if LOP=\LDX\$02 ! LOP=\LDSB\$41 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-2|"); AHZERO:= false];	\REPLACE XOR AH,AH

OPSTRING("	MOV	BX,&|", ^A, PSTKLEV(PSTKPTR-3), PSTKOFF(PSTKPTR-3), 0);

POSTGENOFF:= 0;
case PSTKTYP(PSTKPTR-2) of
  REGTYP: OPSTRING("	ADD	BX,&|", ^R, "AX", 0, 0);
  STKTYP: OPSTRING("	POP	CX|	ADD	BX,&|", ^R, "CX", 0, 0);
  ADDTYP: OPSTRING("	ADD	BX,&|", ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
  IMMTYP: POSTGENOFF:= PSTKLEV(PSTKPTR-2)
other BUGMSG("GENSTX2");

if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKOFF(PSTKPTR-1)=^C then
	[POSTGENVAL:= PSTKLEV(PSTKPTR-1); POSTGENTYPE:= 1]
else	begin
	TOS2REG(^A);
	TTXT("	MOV	[BX]+"); INTOUT(BINDEV,POSTGENOFF); TTXT(",AL|");
	end;
PDROP(3);
end;	\GENSTX2



proc	GENCAL(LABEL, EXT);	\$05 PROCEDURE CALL
int	LABEL,
	EXT;	\FLAG: EXTERNAL
begin
COMMENT($05);
TTXT("	CALL	");
if EXT then [CHOUT(BINDEV, ^_); SYMOUT(LABEL)]
else [TTXT("L"); INTOUT(BINDEV, LABEL)];
CRLF(BINDEV);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENCAL



proc	DOJUMP(L);
int	L;
begin
TTXT("	JMP	L"); INTOUT(BINDEV, L);
CRLF(BINDEV);
DOALIGN;
end;	\DOJUMP



proc	GENRET(L);	\$06
int	L;
int	P;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$06\RET\ ! LASTOP=$07\JMP\ then return;
COMMENT($06);
if L = 0 then TTXT("	RETF|")
else	begin	     \(DON'T MESS UP AX BECAUSE A VALUE MIGHT BE RETURNED IN IT)
	L:= L >> 1;
	if PROCRETS(L)\#0\ & OPTCALL & HAVENEST then
		DOJUMP(PROCRETS(L))	\JUMP TO EXISTING PROCEDURE RETURN
	else	begin
		if OPTCALL & HAVENEST then
			begin		\MAKE LABEL FOR THIS PROC RETURN
			P:= NEWLAB;
			PROCRETS(L):= P;
			CLABEL(P);
			end;

		\ 1	POP	DI	 ;get value originally in BASEn
		\ 4	XCHG	DI,BASEn ;restore BASEn and DI
		\ 1	POP	SI	 ;restore SI
		\ 1	RETF

		TTXT("	POP	DI|");
		if HAVENEST then
			[TTXT("	XCHG	DI,BASE"); INTOUT(BINDEV, L); TTXT("|")];
		TTXT("	POP	SI|	RET");
		if ~OPTCALL then CHOUT(BINDEV,^F);
		CRLF(BINDEV);
		DOALIGN;
		end;
	end;
end;	\GENRET



proc	GENJSR(L);	\$26 OPTIMIZE PROCEDURE CALL
int	L;
begin
COMMENT($26);
TTXT("	CALL	L"); INTOUT(BINDEV, L); CRLF(BINDEV);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENJSR



proc	GENRTS(L);		\$27
int	L;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$07\JMP\ ! LASTOP=$27\RTS\ then return;
COMMENT($27);
\DON'T MESS UP AX BECAUSE A VALUE MIGHT BE RETURNED IN IT
if L > 0 then TTXT("	POP	SI|");
TTXT("	RET");
if ~OPTCALL then CHOUT(BINDEV,^F);
CRLF(BINDEV);
DOALIGN;
end;	\GENRTS



proc	GENCML(LABEL, LAST, TYPE, FUNC, ARGS);	\$0C INTRINSIC CALL
int	LABEL, LAST, TYPE, FUNC, ARGS;
begin
COMMENT($0C);
if ARGS > 0 then
	begin				\HANDLE ALL COMBINATIONS OF ARGUMENTS
	if TYPE=ININT then
		[if LAST=INTEGER then TOS2AX else TTXT("	POP	AX|")]
	else	TOS2STACK;
	end;

if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR INTR")
else	TTXT("	CALL	INTR");
INTOUT(BINDEV, LABEL);
if LABEL=12 & STRTERM=0 then CHOUT(BINDEV, ^A);	\use alternate Text intrinsic
CRLF(BINDEV);

PDROP(ARGS);
OLDLEV:= -1;		\INTRINSIC CALL MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
if FUNC then
	case TYPE of
	  ININT: PPUSH(REGTYP, 0, 0);
	  RLINT: PPUSH(REALTYP, 0, 0)
	other;
end;	\GENCML



proc	GENCEXT(LABEL, LAST, TYPE, FUNC, ARGS);	\$29 EXTERNAL ASSEMBLY PROCEDURE
int	LABEL, LAST, TYPE, FUNC, ARGS;
begin
COMMENT($29);
if ARGS>0 & LAST=INTEGER then TOS2STACK;

TTXT("	MOV	[DI]+0,SI|	MOV	ES,DI|");
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
SYMOUT(LABEL);
TTXT("|	MOV	DI,ES|	MOV	SI,[DI]+0|");

\Since arguments are copied immediately before calling a procdure, it's safe to
\ use [DI]+0 as a temporary location (which only requires two bytes to access).

PDROP(ARGS);
OLDLEV:= -1;		\SUBROUTINE CALL MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
if FUNC then
	case TYPE of
	  INEXT: PPUSH(STKTYP, 0, 0);
	  RLEXT: PPUSH(REALTYP, 0, 0)
	other;
end;	\GENCEXT



proc	GENJMP(L);	\$07
int	L;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$06\RET\ ! LASTOP=$07\JMP\ !
	LASTOP=$27\RTS\ then return;
COMMENT($07);
DOJUMP(L);
end;	\GENJMP



proc	GENFJMP(L);	\GENERATE FAR (OR NEAR) JUMP FOR FPROCS
int	L;
begin
COMMENT($07);
TTXT("	JMP	");
if ~OPTCALL then TTXT("FAR PTR ");
CHOUT(BINDEV,^L); INTOUT(BINDEV, L); CRLF(BINDEV);
end;	\GENFJMP



proc	GENJPC(L, SENSE);	\$08 JUMP IF TOS=FALSE (OR TRUE)
int	L, SENSE;	\NORMALLY SENSE = FALSE, FOR JUMP ON FALSE
int	LOP;

	proc	GENJ(S);
	char	S;
	begin
	TTXT("	J");
	S:= S +1;			\Skip the "J"
	if SENSE = OPTJPC then		\Reverse meaning
		[if S(0) = ^N then S:= S +1
		else TTXT("N")];
	TTXT(S);
	TTXT("	");
	if OPTJPC then
		[TTXT("L");
		INTOUT(BINDEV, L); CRLF(BINDEV)]
	else	[LOCOUT(false); CRLF(BINDEV);
		DOJUMP(L);
		LOCOUT(true)];
	end;	\GENJ

begin	\GENJPC
LOP:= LASTOP;
COMMENT($08);
\If immediate = SENSE (usually false) then unconditionaly jump
\If immediate = SENSE (usually true) then gen no instruction
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	[if (PSTKLEV(PSTKPTR-1)#0) = SENSE then [CRLF(BINDEV); DOJUMP(L)]]
else	begin
	if LOP>=$12 & LOP<=$17 then	\OPTIMIZE COMPARISON
		begin
		TTXT("	ORG	$-6|");		\BACK OVER MOV, Jcc, INC
		AXIMM:= SAXIMM; AXLEV:= SAXLEV;	\PREVIOUS CMP DIDN'T DESTROY AX
		AHZERO:= SAHZERO;
		case LOP of
		  $12:	GENJ("JNE");
		  $13:	GENJ("JE");
		  $14:	GENJ("JL");
		  $15:	GENJ("JLE");
		  $16:	GENJ("JG");
		  $17:	GENJ("JGE")
		other;
		end
	else if LOP=\LDX\$02 ! LOP=\LDSB\$41 ! LOP=\PIN\$4E then
		begin
		TTXT("	ORG	$-2|	TEST	AL,AL|");  \REPLACE XOR AH,AH
		AHZERO:= false;
		GENJ("JE");
		end
	else if HAVESTAT & (LOP=\OR\$1A ! LOP=\AND\$1B) then
		GENJ("JE")
	else if LOP=\NOT\$1C & PSTKTYP(PSTKPTR-1)=REGTYP then
		begin
		TTXT("	ORG	$-2|	XOR	AX,-1|");  \REPLACE NOT AX
		AHZERO:= false;
		AXLEV:= -1; AXIMM:= false;	\(AXVAL # ~AXVAL because of ORG)
		GENJ("JE")
		\BEWARE: replacing NOT JE with JNE does not work if AX = 1, etc.
		end
	else if PSTKTYP(PSTKPTR-1)=ADDTYP then
		begin		\Replace MOV AX,mem TEST AX,AX with CMP mem,0
		OPSTRING("	CMP	&,0|", ^A, PSTKLEV(PSTKPTR-1),
			PSTKOFF(PSTKPTR-1), 0);
		GENJ("JE");
		end
	else	begin				\NORMAL JPC
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	TEST	AX,AX|");
		GENJ("JE");
		if SENSE \=true i.e. JNE\ then
			[AXIMM:= true; AXVAL:= 0; AHZERO:= true];
		end;
	end;
PDROP(1);
end;	\GENJPC



proc	GENHPI(V);	\$09
int	V;
begin
COMMENT($09);
if V # 0 then	\(V can be larger than 32767 because of array declarations)
	begin
	TTXT("	ADD	DI,"); INTOUT(BINDEV, V);
	CRLF(BINDEV);
	end;
end;	\GENHPI



proc	GENBASE(L,V);	\$09-1/2  GEN START OF PROCEDURE
int	L, V;
begin
COMMENT($09);
OLDLEV:= L;
if L = 0 then [GENHPI(V); return];

\This isn't necessary at level 0 because RET does an EXIT and BASE0 is not used.
\ 1	PUSH	SI		;preserve SI across procedure call
\ 2	MOV	SI,DI		;set SI to base of procedure's variables
\ 4	XCHG	BASEn,DI	;set BASE and get its old value
\ 1	PUSH	DI		;save old value of BASE (in case of recursion)
\ 3	LEA	DI,[SI]+	;restore DI and add space for local variables

AXLEV:= -1; AXIMM:= false; AHZERO:= false;
TTXT("	PUSH	SI|	MOV	SI,DI|");
if HAVENEST then
	[TTXT("	XCHG	BASE"); INTOUT(BINDEV, L/2); TTXT(",DI|")];
TTXT("	PUSH	DI|	LEA	DI,[SI]+"); INTOUT(BINDEV,V); TTXT("|");
end;	\GENBASE



\OLD - BECAUSE OF REALS
proc	GENARG0(BYTES);	\$0A MOVE PROCEDURE ARGUMENTS FROM PSEUDO STACK TO HEAP
int	BYTES;
int	P, I, L;

	proc	HEAPOP(S, A);	\PRODUCE HEAP ARGUMENT OPERAND
	int	S, A;
	begin
	TTXT(S); TTXT("WP [DI]+"); INTOUT(BINDEV, A);
	end;	\HEAPOP


	func	LOADREAL(P);	\LOAD A REAL ARGUMENT TO HEAP
	int	P;
	begin
	for P:= P, P+3 do
		begin
		HEAPOP("	POP	", BYTES-(2*P));
		CRLF(BINDEV);
		end;
	return P-1;
	end;	\LOADREAL

begin	\GENARG0
COMMENT($0A);

\If all the arguments are reals then...
P:= 1;
for I:= 1, BYTES/2 do	\for all the words on the real stack...
	begin
	if PSTKTYP(PSTKPTR-P) = REALTYP then I:= I + 3	\skip rest of real
	else I:= 30000;					\not a real--abort
	P:= P + 1;
	end;
if I < 30000 then	\all args are real
	begin
	TTXT("	MOV	BX,"); INTOUT(BINDEV,BYTES);
	\CRLF(BINDEV);
	L:= NEWLAB;
	CLABEL(L);
	TTXT("	DEC	BX
	DEC	BX
	POP	[BX+DI]
	JNE	L"); INTOUT(BINDEV, L);
	CRLF(BINDEV);

	PDROP(BYTES/RLSIZE);
	end
else
    begin		\args are mixed real and integer
    for P:= 1, BYTES/2 do
	begin
	case PSTKTYP(PSTKPTR-1) of
	REGTYP: [HEAPOP("	MOV	", BYTES-(2*P)); TTXT(",AX|"); ];
	IMMTYP: begin
		HEAPOP("	MOV	", BYTES-(2*P));
		OPSTRING(",&|", ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		end;
	ADDTYP: begin
		OPSTRING("	MOV	CX,&|",
				^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		HEAPOP("	MOV	", BYTES-(2*P)); TTXT(",CX|");
		end;
	STKTYP: [HEAPOP("	POP	", BYTES-(2*P)); CRLF(BINDEV)];
	REALTYP: P:= LOADREAL(P)
	other BUGMSG("GENARG");
	PDROP(1);
	end;
    end;
end;	\GENARG0


\NEW
proc	GENARG1(BYTES);	\$0A MOVE PROCEDURE ARGUMENTS FROM PSEUDO STACK TO HEAP
int	BYTES;
int	P, Q,	\WORDS OF ARGUMENTS
	DUP;	\HAVE DUPLICATE ARGS

	proc	HEAPOP(S, I);	\PRODUCE HEAP ARGUMENT OPERAND
	int	S, I;
	begin
	TTXT(S);   TTXT("WP [DI]+");   INTOUT(BINDEV, BYTES-(2*I));
	PSTKTYP(PSTKPTR-I):= -1;	\MARK IT OFF
	end;	\HEAPOP

begin	\GENARG1
COMMENT($0A);
for P:= 1, BYTES/2 do
	begin
	case PSTKTYP(PSTKPTR-P) of
	REGTYP: [HEAPOP("	MOV	", P);   TTXT(",AX|")];
	STKTYP: [HEAPOP("	POP	", P);   CRLF(BINDEV)]
	other;
	end;
for P:= 1, BYTES/2 do
	begin
	if PSTKTYP(PSTKPTR-P) = IMMTYP then
	    begin
	    DUP:= false;
	    for Q:= P+1, BYTES/2 do		\SCAN FOR DUPLICATES
		begin
		if PSTKTYP(PSTKPTR-Q) = IMMTYP then
		   if PSTKLEV(PSTKPTR-Q) = PSTKLEV(PSTKPTR-P) &
		      PSTKOFF(PSTKPTR-Q) = PSTKOFF(PSTKPTR-P) then
			begin			\DUPLICATE FOUND
			if ~DUP then
			    [DUP:= true;
			    GENAX(PSTKLEV(PSTKPTR-P), PSTKOFF(PSTKPTR-P));
			    HEAPOP("	MOV	", P);   TTXT(",AX|")];
			HEAPOP("	MOV	", Q);   TTXT(",AX|");
			end;
		end;
	    if ~DUP then
		begin	\"AND [DI]+n,0" is a byte shorter than "MOV [DI]+n,0"
		if PSTKLEV(PSTKPTR-P)=0 & PSTKOFF(PSTKPTR-P)=^C &
			~(AXVAL=0 & AXIMM) \not already in AX\ then
		  [HEAPOP("	AND	", P);   TTXT(",0|")]
		else if PSTKLEV(PSTKPTR-P)=-1 & PSTKOFF(PSTKPTR-P)=^C &
			~(AXVAL=-1 & AXIMM) \not already in AX\ then
		  [HEAPOP("	OR	", P);   TTXT(",-1|")]
		else
		  [HEAPOP("	MOV	", P);
		  OPSTRING(",&|", ^I, PSTKLEV(PSTKPTR-P), PSTKOFF(PSTKPTR-P), 0)];
		end;
	    end;
	end;
for P:= 1, BYTES/2 do
	begin
	if PSTKTYP(PSTKPTR-P) = ADDTYP then
	    begin
	    DUP:= false;
	    for Q:= P+1, BYTES/2 do		\SCAN FOR DUPLICATES
		begin
		if PSTKTYP(PSTKPTR-Q) = ADDTYP &
		   PSTKLEV(PSTKPTR-Q) = PSTKLEV(PSTKPTR-P) &
		   PSTKOFF(PSTKPTR-Q) = PSTKOFF(PSTKPTR-P) then
			begin			\DUPLICATE FOUND
			if ~DUP then
			    [DUP:= true;
			    OPSTRING("	MOV	AX,&|", ^A, PSTKLEV(PSTKPTR-P),
				PSTKOFF(PSTKPTR-P), 0);
			    AXLEV:= PSTKLEV(PSTKPTR-P); AXOFF:= PSTKOFF(PSTKPTR-P);
			    AXIMM:= false; AHZERO:= false;

			    HEAPOP("	MOV	", P);   TTXT(",AX|")];
			HEAPOP("	MOV	", Q);   TTXT(",AX|");
			end;
		end;
	    if ~DUP then
		[OPSTRING("	MOV	AX,&|", ^A, PSTKLEV(PSTKPTR-P),
			PSTKOFF(PSTKPTR-P), 0);
		AXLEV:= PSTKLEV(PSTKPTR-P); AXOFF:= PSTKOFF(PSTKPTR-P);
		AXIMM:= false; AHZERO:= false;
		HEAPOP("	MOV	", P);   TTXT(",AX|")];
	    end;
	end;
for P:= 1, BYTES/2 do PDROP(1);
end;	\GENARG1



proc	GENARG(BYTES);	\$0A MOVE PROCEDURE ARGUMENTS FROM PSEUDO STACK TO HEAP
int	BYTES;
int	P;
begin
\If there is a real argument then handle the old way, else there is a
\ one-to-one correspondance between arguments and words passed.
for P:= 1, BYTES/2 do
	if PSTKTYP(PSTKPTR-P)=REALTYP then P:= 30000;
if P>=30000 then GENARG0(BYTES)
else GENARG1(BYTES);
end;	\GENARG



proc	GENIMM(F, V);	\$0B & $24
int	F,	\FLAG: ^L=LABEL, ^C=CONSTANT
	V;	\VALUE
begin
COMMENT($0B);
\if F = ^L then [AXIMM:= false; AHZERO:= false];	\\DON'T USE VALUE IN AX AS A LABEL
PPUSH(IMMTYP, V, F);
\if F = ^L then TOS2HARD;	\\(HANDLE A:= "STR"+2; ETC.)
end;	\GENIMM



proc	GENADD;		\$0D
int	TOSTYP, NOSTYP;
begin
COMMENT($0D);
if ~IDENTITY(0,true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=1 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin			\OPTIMIZE A+1
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	INC	AX|");
		AXLEV:= -1; AXVAL:= AXVAL+1; AHZERO:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else if NOSTYP=IMMTYP & PSTKLEV(PSTKPTR-2)=1 & PSTKOFF(PSTKPTR-2)=^C &
	    TOSTYP#IMMTYP then
		begin			\OPTIMIZE 1+A
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	INC	AX|");
		AXLEV:= -1; AXVAL:= AXVAL+1; AHZERO:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	ADD	AX,&|", false, false, "+");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
			[AXLEV:= -1; AXIMM:= false; AHZERO:= false];
		end;
	end;
end;	\GENADD



proc	GENSTXADD;		\USED TO OPTIMIZE STX OPERATION
begin
STXFLAG:= false;
if PSTKTYP(PSTKPTR-2)=ADDTYP then STXFLAG:= true else GENADD;
end;	\GENSTXADD



proc	GENSUB;		\$0E
int	TOSTYP, NOSTYP;
begin
COMMENT($0E);
if ~IDENTITY(0,false) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=1 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin			\OPTIMIZE A-1
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	DEC	AX|");
		AXLEV:= -1; AXVAL:= AXVAL-1; AHZERO:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	SUB	AX,&|", true, false, "-");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
			[AXLEV:= -1; AXIMM:= false; AHZERO:= false];
		end;
	end;
end;	\GENSUB



proc	GENMUL;		\$0F
int	TOSTYP, NOSTYP;
begin
COMMENT($0F);
if not IDENTITY(1,true) then
    if not ISZERO(true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=2 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin			\OPTIMIZE A*2
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	ADD	AX,AX|");
		AXLEV:= -1; AXVAL:= AXVAL+AXVAL; AHZERO:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else if NOSTYP=IMMTYP & PSTKLEV(PSTKPTR-2)=2 & PSTKOFF(PSTKPTR-2)=^C &
	    TOSTYP#IMMTYP then
		begin			\OPTIMIZE 2*A
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	ADD	AX,AX|");
		AXLEV:= -1; AXVAL:= AXVAL+AXVAL; AHZERO:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	IMUL	&|", false, true, "*");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
			[DXLEV:= -1; AXLEV:= -1; AXIMM:= false; AHZERO:= false];
		end;
	end;
end;	\GENMUL



proc	GENDIV;		\$10
int	TOSTYP, NOSTYP;
begin
COMMENT($10);
\WARNING: Do not call both IDENTITY and ISZERO because they can alter PSTK.
if IDENTITY(1,false) then
	begin						\ A/1=A; rem=0
	TTXT("	MOV	REMAIN,");
	TTXT(if AXIMM & AXVAL=0 then "AX|" else "0|");
	end
else if ISZERO(false) then
	begin						\ 0/A=0; rem=0
	TTXT("	MOV	REMAIN,");
	TTXT(if AXIMM & AXVAL=0 then "AX|" else "0|");
	end
else	begin
	\WARNING: If this code is changed then DVZHAN in Native.asm may need
	\ to be changed too else divide-by-zero won't be trapped properly.
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=0 & PSTKOFF(PSTKPTR-1)=^C then
		ERROR(73);				\div by 0
	DXLEV:= -1;	\CWD destroys DX
	GENOP2("	CWD|	IDIV	&|	MOV	REMAIN,DX|",
		true, true, "/");
	if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
		[DXLEV:= -1; AXLEV:= -1; AXIMM:= false; AHZERO:= false];
	end;
end;	\GENDIV



proc	GENNEG;		\$11
begin
COMMENT($11);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= -PSTKLEV(PSTKPTR-1)
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	NEG	AX|");
	AXLEV:= -1; AXVAL:= -AXVAL; AHZERO:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENNEG



proc	FCMP(T);	\$32-$37
int	T;
int	CMPT;
begin
CMPT:= ["FEQDO|", "FNEDO|", "FGEDO|", "FGTDO|", "FLEDO|", "FLTDO|"];
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT(CMPT(T-$32));
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
PDROP(2);
PPUSH(STKTYP, 0, 0);
end;	\FCMP



proc	ICMP(OPCODE);	\$12-$17 INTEGER COMPARES:  TOS := NOS > TOS
int	OPCODE;
int	TOS, NOS, CMPSTR;


	proc	COMPLEFT(OP);	\OPTIMIZE COMPARES WHERE OPERAND CAN BE ON LEFT
	int	OP;	\STRING CONTAINING OPERATOR, I.E. ">="
	begin
	case of
	NOS=STKTYP & TOS=REGTYP: GENOP2("	CMP	&,AX|", false, true, OP);
	NOS=ADDTYP & TOS=REGTYP: GENOP2("	CMP	&,AX|", false, true, OP);
	NOS=IMMTYP & TOS=REGTYP: GENOP2("	CMP	&,AX|", false, true, OP);
	NOS=ADDTYP & TOS=STKTYP: GENOP2("	CMP	&,AX|", false, true, OP);

	NOS=ADDTYP & TOS=IMMTYP:
		begin
		CLEANREG(2);
		if ABS(PSTKLEV(PSTKPTR-1))>127 & PSTKLEV(PSTKPTR-2)=0 then
		  begin		\2-BYTE IMMEDIATE VALUE AND LEVEL 0
		  OPSTRING("	MOV	AX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		  AXLEV:= PSTKLEV(PSTKPTR-2); AXOFF:= PSTKOFF(PSTKPTR-2);
		  AXIMM:= false; AHZERO:= false;
		  OPSTRING("	CMP	AX,&|",
				^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		  end
		else
		  begin
		  OPSTRING("	CMP	&,",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		  OPSTRING("&|",	^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		  end;
		PDROP(2);
		PPUSH(REGTYP, 0, 0);
		end;

	NOS=REGTYP & TOS=IMMTYP & AHZERO & PSTKLEV(PSTKPTR-1)>>8=0 &
	    (OPCODE=$12\=\ ! OPCODE=$13\#\): \Must use UNsigned compares for others
		begin
		CLEANREG(2);
		TTXT("	CMP	AL,"); INTOUT(BINDEV, PSTKLEV(PSTKPTR-1));
		CRLF(BINDEV);
		PDROP(2);
		PPUSH(REGTYP, 0, 0);
		end

	other GENOP2("	CMP	AX,&|", true, false, OP);
	end;	\COMPLEFT


begin	\ICMP
CMPSTR:= [
	"	JE	$+3|",
	"	JNE	$+3|",
	"	JGE	$+3|",
	"	JG	$+3|",
	"	JLE	$+3|",
	"	JL	$+3|" ];

if PSTKPTR<2 then BUGMSG("ICMP");
TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);

if TOS=IMMTYP & PSTKLEV(PSTKPTR-1)=0 & NOS=REGTYP then
	begin				\OPTIMIZE REGISTER COMPARISON to 0
	PDROP(1);
	TTXT("	TEST	AX,AX|");
	end
else	begin
	case OPCODE of
	  $12:	COMPLEFT("=");
	  $13:	COMPLEFT("#");
	  $14:	COMPLEFT(">=");
	  $15:	COMPLEFT(">");
	  $16:	COMPLEFT("<=");
	  $17:	COMPLEFT("<")
	other;
	end;

if TOS=IMMTYP & NOS=IMMTYP then		\IF THEY'RE BOTH IMMEDIATES THEN
	LASTOP:= -1			\ DON'T OPTIMIZE NEXT JPC
else	begin
	SAXIMM:= AXIMM; SAXLEV:= AXLEV;	\SAVE AX INFO FOR GENJPC OPTIMIZATION
	SAHZERO:= AHZERO;
	TTXT("	MOV	AX,-1|");	\(DOES NOT AFFECT STATUS)
	TTXT(CMPSTR(OPCODE-$12));	\GENJPC OPTIMIZATION DEPENDS ON THESE
	TTXT("	INC	AX|");		\ THREE INSTRUCTIONS TAKING 6 BYTES
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end;
end;	\ICMP



proc	GENCMP(T);	\SELECT INTEGER OR REAL COMPARES
int	T;
begin
COMMENT(T);
if T>$17 then FCMP(T) else ICMP(T);
end;	\GENCMP



proc	GENFOR(LEV, OFF, LAB, TYP, IVAL, DOWNTO);\$18,$49 COMPARE FOR 'FOR' LOOP
int	LEV, OFF, LAB, TYP, IVAL, DOWNTO;
begin
COMMENT(if DOWNTO then $49 else $18);
if TYP=IMMTYP then
	begin
	if IVAL # 0 then
		[TTXT("	CMP	DX,"); INTOUT(BINDEV, IVAL); CRLF(BINDEV)];
	\Zero case assumes status is set by GENINP or TEST DX,DX at top of loop
	end
else	[if POSTGENTYPE\#0\ then POSTGEN;
	TTXT("	MOV	BX,SP|	CMP	DX,[BX]|")];	\(SS = DS)

if POSTGENTYPE\#0\ then POSTGEN;
if OPTJPC then		\FORJMP doesn't reach quite as far (for some reason)
	[TTXT(if DOWNTO then "	JGE	L" else "	JLE	L");
	INTOUT(BINDEV, LAB); CRLF(BINDEV)]
else	[TTXT(if DOWNTO then "	FORDJMP	<L" else "	FORJMP	<L");
	INTOUT(BINDEV, LAB); TTXT(">|")];

if TYP#IMMTYP then TTXT("	POP	CX|");	\DISCARD TOS

\MAKE SURE CONTROL VARIABLE IN MEMORY IS CORRECT WHEN EXITING THE LOOP
if LEV=DXLEV & OFF=DXOFF then
	[DXLEV:= -1;		\PREVENT MOV DX,DX
	if LEV=AXLEV & OFF=AXOFF then AXLEV:= -1;	\AVOID MOV AX,DX
	OPSTRING("	MOV	&,DX|", ^A, LEV, OFF, 0)];
PDROP(1);
CRLF(BINDEV);
DXLEV:= -1;			\DO NOT BE TEMPTED TO SAY DX IS VALID HERE.
\The way labels are handled depends on this. A register must be considered
\ bombed at the end of its 'for' loop since the overall effect of the 'for'
\ loop is a store into the control variable. (There might be a surrounding
\ 'for' loop.) The AX register is different; it is not bombed.
end;	\GENFOR



proc	GENINP(L, O, DOWNTO);	\$19,$4A INCREMENT/DECREMENT FOR 'FOR' LOOP
int	L, O, DOWNTO;
begin
if DOWNTO then
   begin
   COMMENT($4A);
   if L#DXLEV ! O#DXOFF then
	begin
	if L=AXLEV & O=AXOFF then AXLEV:= -1;		\AVOID DEC AX
	OPSTRING("	DEC	&|", ^A, L, O, 0);
	OPSTRING("	MOV	DX,&|", ^A, L, O, 0);
	end
   else	TTXT("	DEC	DX|");
   end
else begin
   COMMENT($19);
   if L#DXLEV ! O#DXOFF then
	begin
	if L=AXLEV & O=AXOFF then AXLEV:= -1;		\AVOID INC AX
	OPSTRING("	INC	&|", ^A, L, O, 0);
	OPSTRING("	MOV	DX,&|", ^A, L, O, 0);
	end
   else	TTXT("	INC	DX|");
   end;
\GENFOR assumes status is set correctly for DX (for case when limit = 0)
end;	\GENINP



proc	GENOR;		\$1A
int	TOSTYP, TOSVAL, NOSTYP;
begin
COMMENT($1A);
HAVESTAT:= false;
if ~IDENTITY(0,true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	TOSVAL:= PSTKLEV(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & (TOSVAL&$FF00)=0 & NOSTYP#IMMTYP then
		begin		\AL := NOS ! TOS
		CLEANREG(2);
		PDROP(1);
		TOS2AX;		\NOS INTO AX
		PDROP(1);
		TTXT("	OR	AL,"); INTOUT(BINDEV,TOSVAL); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else	GENOP2("	OR	AX,&|", false, false, "!");
		\OPTIMIZED JPC DEPENDS ON GENOP2 SETTING STATUS
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end;
end;	\GENOR



proc	GENAND;		\$1B
int	TOSTYP, TOSVAL, NOSTYP;
begin
COMMENT($1B);
HAVESTAT:= false;
if not IDENTITY($FFFF,true) then
    if not ISZERO(true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	TOSVAL:= PSTKLEV(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & TOSVAL>>8=$FF & NOSTYP#IMMTYP then
		begin		\AL := NOS & TOS
		CLEANREG(2);
		PDROP(1);
		TOS2AX;		\NOS INTO AX
		PDROP(1);
		TTXT("	AND	AL,"); INTOUT(BINDEV,TOSVAL&$FF); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else if TOSTYP=IMMTYP & NOSTYP=REGTYP & AHZERO then
		begin		\AL := NOS & TOS
		CLEANREG(2);
		PDROP(2);
		if (TOSVAL&$FF) # $FF then
			begin
			TTXT("	AND	AL,"); INTOUT(BINDEV,TOSVAL&$FF);
			TTXT("|");
			end;
		PPUSH(REGTYP, 0, 0);
		end
	else if TOSTYP=IMMTYP & TOSVAL=$00FF & NOSTYP#IMMTYP then
		begin
		CLEANREG(2);
		PDROP(1);
		TOS2AX;		\NOS INTO AX
		PDROP(1);
		TTXT("	XOR	AH,AH|");
		PPUSH(REGTYP, 0, 0);
		end
	else	GENOP2("	AND	AX,&|", false, false, "&");
		\OPTIMIZED JPC DEPENDS ON GENOP2 SETTING STATUS
	AXLEV:= -1; AXIMM:= false; \AHZERO is not set false
	if TOSTYP=IMMTYP & TOSVAL>>8=0 then AHZERO:= true;
	end;
end;	\GENAND



proc	GENNOT;		\$1C
begin
COMMENT($1C);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= ~ PSTKLEV(PSTKPTR-1)
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	NOT	AX|");
	\OPTIMIZED JPC DEPENDS ON THIS
	AXLEV:= -1; AXVAL:= ~AXVAL; AHZERO:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENNOT



proc	GENEOR;		\$1D
begin
COMMENT($1D);
if ~IDENTITY(0,true) then
	[GENOP2("	XOR	AX,&|", false, false, "|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false];
end;	\GENEOR



proc	DOINDEX2(PWR);	\GENERATE INDEX FOR DBA AND TRA. TOS <- TOS*2^PWR + NOS
int	PWR;	\POWER OF TWO
int	TOS, NOS, C;
begin
CLEANREG(2);
TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
if NOS=REGTYP & TOS=ADDTYP then
	begin
	TOS2REG(^B); PDROP(1);
	for C:= 1, PWR do TTXT("	ADD	BX,BX|");
	TTXT("	ADD	AX,BX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	PDROP(1);
	PPUSH(REGTYP, 0, 0);
	return;
	end;

if TOS=IMMTYP then
	begin
	if ~IDENTITY(0,false) then
		begin
		PSTKLEV(PSTKPTR-1):= PSTKLEV(PSTKPTR-1) << PWR;
		GENOP2("	ADD	AX,&|", false, false, "+");
		AXLEV:= -1; AXIMM:= false; AHZERO:= false;
		end;
	end
else	begin
	TOS2REG(^A);
	for C:= 1, PWR do TTXT("	ADD	AX,AX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	GENOP2("	ADD	AX,&|", false, false, "+");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end;
end;	\DOINDEX2



proc	GENDBA;		\$1E TOS <- TOS*2 + NOS
int	TOS, NOS;
begin
COMMENT($1E);
DOINDEX2(1);
end;	\GENDBA



proc	GENSTD;		\$1F @(NOS) <- TOS
int	LEV, OFF, TOS, NOS;
begin
COMMENT($1F);
TOS:= PSTKTYP(PSTKPTR-1);
OFF:= PSTKOFF(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
LEV:= PSTKLEV(PSTKPTR-1);

if TOS=IMMTYP & OFF=^C then
	begin
	PDROP(1);
	TOS2REG(^B);
	\OPSTRING("	MOV	WP [BX],&|", ^I, LEV, OFF, 0);
	POSTGENOFF:= 0; POSTGENVAL:= LEV; POSTGENTYPE:= 2;
	PDROP(1);
	end
else	begin
	if NOS=REGTYP then
		begin
		TTXT("	MOV	BX,AX|");
		TOS2REG(^A); PDROP(2);
		end
	else	begin
		TOS2REG(^A); PDROP(1);
		TOS2REG(^B); PDROP(1);
		end;
	TTXT("	MOV	[BX],AX|");
	end;
end;	\GENSTD



proc	DOINDEX1(PWR);	\HANDLE INDEX GENERATED FOR DBX AND TRX
			\TOS <- @(TOS*2^PWR + NOS)
int	PWR;	\POWER OF TWO
int	C;
begin
CLEANREG(2);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin
	C:= PSTKLEV(PSTKPTR-1);
	PDROP(1);
	TOS2REG(^B); PDROP(1);
	TTXT("	MOV	AX,[BX]+"); INTOUT(BINDEV,C<<PWR); CRLF(BINDEV);
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end
else	begin
	TOS2REG(^B);
	for C:= 1, PWR do TTXT("	ADD	BX,BX|");
	PDROP(1);
	ADDTOS2BX; PDROP(1);
	TTXT("	MOV	AX,[BX]|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end;
PPUSH(REGTYP, 0, 0);
end;	\DOINDEX1



proc	GENDBX;		\$20 TOS <- @(TOS*2 + NOS)
begin
COMMENT($20);
DOINDEX1(1);
end;	\GENDBX



proc	GENADR(L, O);	\$21
int	L, O;
begin
COMMENT($21);
CLEANREG(0);
NEWLEVEL(L);
if L = 0 then
	TTXT("	MOV	AX,OFFSET HEAPLO+")
else	begin
	if L = LEVEL then
		TTXT("	LEA	AX,[SI]+")
	else	TTXT("	LEA	AX,[BP]+");
	end;
AXLEV:= -1; AXIMM:= false; AHZERO:= false;
INTOUT(BINDEV, O); CRLF(BINDEV);
PPUSH(REGTYP, 0, 0);
end;	\GENADR



proc	GENCJP(L,SENSE);	\$25 CASE JUMP
int	L,SENSE;
int	TOSTYP, TOSVAL, TOSOFF, NOSTYP;
begin
COMMENT($25);
\NOS IS NORMALLY IN AX AND EQUALS VALUE BETWEEN 'CASE' & 'OF'; TOS = THE LABEL:
TOSTYP:= PSTKTYP(PSTKPTR-1);
TOSVAL:= PSTKLEV(PSTKPTR-1);
TOSOFF:= PSTKOFF(PSTKPTR-1);
NOSTYP:= PSTKTYP(PSTKPTR-2);

case TOSTYP of
  REGTYP,STKTYP:
	  begin
	  TOS2REG(^C); PDROP(1);
	  TOS2AX;
	  TTXT("	CMP	AX,CX|");
	  end;
  ADDTYP: [OPSTRING("	CMP	AX,&|", ^A, TOSVAL, TOSOFF, 0);
	  PDROP(1)];
  IMMTYP:
	begin
	if (TOSVAL&$FF00)=0 & NOSTYP=REGTYP & AHZERO then
		begin		\CMP NOS,TOS
		CLEANREG(2);
		PDROP(2);
		TTXT("	CMP	AL,"); INTOUT(BINDEV,TOSVAL); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else	[OPSTRING("	CMP	AX,&|", ^I, TOSVAL, TOSOFF, 0);
		PDROP(1)];
	end
other	  BUGMSG("GENCJP");

if OPTJPC then
	[if SENSE then TTXT("	JE	L")
		  else TTXT("	JNE	L");
	INTOUT(BINDEV, L); CRLF(BINDEV)]
else	[if SENSE then TTXT("	JNE	")
		  else TTXT("	JE	");
	LOCOUT(false); CRLF(BINDEV);
	DOJUMP(L);
	LOCOUT(true)];
end;	\GENCJP



proc	GENDRP(N);	\$28 DROP "N" VALUES FROM STACK
int	N;
int	I\,J\;
begin
COMMENT($28);
for I:= 1, N do
    if PSTKTYP(PSTKPTR-I)=STKTYP then
	TTXT("	POP	CX|");
end;	\GENDRP



proc	GENFLOD(L, O);	\$2A
int	L, O;
begin
COMMENT($2A);
CLEANREG(0);
OPSTRING("	PUSH	&|", ^A, L, O+0, 0);
OPSTRING("	PUSH	&|", ^A, L, O+2, 0);
OPSTRING("	PUSH	&|", ^A, L, O+4, 0);
OPSTRING("	PUSH	&|", ^A, L, O+6, 0);
PPUSH(REALTYP, 0, 0);
end;	\GENFLOD



proc	GENFSTO(L, O);	\$2B
int	L, O;
begin
COMMENT($2B);
OPSTRING("	POP	&|", ^A, L, O+6, 0);
OPSTRING("	POP	&|", ^A, L, O+4, 0);
OPSTRING("	POP	&|", ^A, L, O+2, 0);
OPSTRING("	POP	&|", ^A, L, O+0, 0);
PDROP(1);
end;	\GENFSTO



proc	GENFIMM(T, V);	\$2C
int	T, V;
int	W, P;
begin
COMMENT($2C);
CLEANREG(0);
if T = ^C then
	begin
	P:= addr RLATOM;
	for W:= 0, RLSIZE/2-1 do
		begin
		GENAX(P(W),^C);
		TTXT("	PUSH	AX|");
		end
	end
else if T = ^L then
	begin
	TTXT("	MOV	AX,OFFSET L"); INTOUT(BINDEV, V);
	TTXT("|	PUSH	AX|");
	TTXT("	PUSH	AX|
	PUSH	AX|
	PUSH	AX|");
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	end
else	BUGMSG("GENFIMM");
PPUSH(REALTYP, 0, 0);
end;	\GENFIMM



proc	FMATH(T);	\$2D-$30
int	T;
int	OSTR;
begin
OSTR:= ["FADDDO|", "FSUBDO|", "FMULDO|", "FDIVDO|"];
COMMENT(T);
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT(OSTR(T-$2D));
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
PDROP(1);
end;	\FMATH



proc	GENMTH(T);	\SELECT REAL OR INTEGER MATH OPS
int	T;
begin
if T > $10 then FMATH(T) else
	case T of
	  $0D:	GENADD;
	  $0E:	GENSUB;
	  $0F:	GENMUL;
	  $10:	GENDIV
	other;
end;	\GENMTH



proc	GENFNEG;	\$31
begin
COMMENT($31);
TTXT("	MOV	BX,SP|	XOR	BYTE PTR [BX+7],80H|");
end;	\GENFNEG



proc	GENTRA;		\$38 TOS <- TOS*8 + NOS
begin
COMMENT($38);
DOINDEX2(3);
TOS2HARD;	\MUST HAVE TOS IN HARD VALUE FOR FOLLOWING CALL TO STTDO  ??
end;	\GENTRA



proc	GENTRX;		\$39 TOS <- @(TOS*8 + NOS)
begin
COMMENT($39);
DOINDEX1(3);
end;	\GENTRX



proc	GENTRI;		\$3A REAL TOS <- @(TOS*8 + REAL NOS)
begin
COMMENT($3A);
TOS2AX;
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("TRIDO|");
PDROP(2);
PPUSH(REALTYP, 0, 0);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENTRI



proc	GENSTT;		\$3B @(NOS) <- REAL TOS
begin
COMMENT($3B);
TOS2STACK;
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("STTDO|");
PDROP(2);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENSTT



proc	GENMARK;	\$3C (FOR PROCEDURE ARGUMENTS)
begin
COMMENT($3C);
end;	\GENMARK



proc	SHIFT(LEFT, LOP);
int	LEFT, LOP;
int	TOSTYP, NOSTYP, TOSVAL, NOSVAL;
\(GENOP2 WON'T WORK HERE BECAUSE CL MUST BE USED.
\ ALSO NOTE DIV CAN USE ANY REGISTER FOR DIVISOR)
begin
if not IDENTITY(0,false) then
    if not ISZERO(false) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	TOSVAL:= PSTKLEV(PSTKPTR-1) & $00FF;
	NOSVAL:= PSTKLEV(PSTKPTR-2);
	if TOSTYP=IMMTYP & NOSTYP=IMMTYP then
		begin
		TOSVAL:= if LEFT then NOSVAL<<TOSVAL else NOSVAL>>TOSVAL;
		PDROP(2);
		PPUSH(IMMTYP, TOSVAL, ^C);
		end
	else if TOSTYP=IMMTYP then		\TOS = AMOUNT TO SHIFT
		begin
		if LEFT & (TOSVAL&$1F)>=8 &
		    (LOP=\LDX\$02 ! LOP=\LDSB\$41 ! LOP=\PIN\$4E) then
			[TTXT("	ORG	$-2|"); AHZERO:= false]; \REPLACE XOR AH,AH
		CLEANREG(2);
		PDROP(1);
		TOS2AX;		\NOS INTO AX
		PDROP(1);
		if TOSVAL#1 & TOSVAL#8 then	\(OPSTRING MIGHT USE AX FOR IMM VAL)
			[TTXT("	MOV	CL,"); INTOUT(BINDEV,TOSVAL); TTXT("|")];
		if LEFT & TOSVAL=1 then TTXT("	ADD	AX,AX|") \3x faster
		else	begin
			if TOSVAL = 8 then
				begin
				if LEFT then
					TTXT("	MOV	AH,AL|	XOR	AL,AL|")
				else	TTXT("	MOV	AL,AH|	XOR	AH,AH|");
				end
			else	begin
				TTXT(if LEFT then "	SHL	AX,"
					     else "	SHR	AX,");
				TTXT(if TOSVAL=1 then "1|" else "CL|");
				end;
			end;
		PPUSH(REGTYP, 0, 0);
		AXLEV:= -1;
		AXIMM:= false; \(BEWARE: 8088 USES 8 BITS TO SHIFT; OTHERS USE 5)
		if LEFT then AHZERO:= false
		else \RIGHT\ if (TOSVAL&$1F)>=8 then AHZERO:= true;
		end
	else	begin
		CLEANREG(2);
		TOS2REG(^C); PDROP(1);
		TOS2REG(^A); PDROP(1);
		TTXT(if LEFT then "	SHL" else "	SHR");
		TTXT("	AX,CL|");
		PPUSH(REGTYP, 0, 0);
		AXLEV:= -1; AXIMM:= false;
		if LEFT then AHZERO:= false;
		end;
	end;
end;	\SHIFT



proc	GENASR;		\$3D   NOS ->> TOS
begin
COMMENT($3D);
CLEANREG(2);
TOS2REG(^C); PDROP(1);
TOS2REG(^A); PDROP(1);
TTXT("	SAR");
TTXT("	AX,CL|");
PPUSH(REGTYP, 0, 0);
AXLEV:= -1; AXIMM:= false;
end;	\GENASR



proc	GENLSL;		\$3E   NOS << TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($3E);		   \(GENOP2 WON'T WORK BECAUSE CL MUST BE USED
SHIFT(true,LOP);
end;	\GENLSL



proc	GENLSR;		\$3F   NOS >> TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($3F);
SHIFT(false,LOP);
end;	\GENLSR



proc	GENLDSI;	\$40  TOS <- @((TOS*2) SEG(NOS))
begin
COMMENT($40);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin
	PSTKLEV(PSTKPTR-1):= PSTKLEV(PSTKPTR-1) <<1;
	TOS2REG(^B);
	end
else	begin
	TOS2REG(^B);
	TTXT("	ADD	BX,BX|");
	end;
PDROP(1);
TOS2ES; PDROP(1);
TTXT("	MOV	AX,ES:[BX]|");
PPUSH(REGTYP, 0, 0);
AXLEV:= -1; AXIMM:= false; AHZERO:= false;
end;	\GENLDSI



proc	GENLDSB;	\$41 TOS <- @(TOS SEG(NOS))
begin
COMMENT($41);
TOS2REG(^B); PDROP(1);
TOS2ES; PDROP(1);
TTXT("	MOV	AL,ES:[BX]|");
if AHZERO then LASTOP:= -1 else TTXT("	XOR	AH,AH|");
\Optimized GENSTX, GENJPC and SHIFT depends on this XOR instruction
PPUSH(REGTYP, 0, 0);
AXLEV:= -1; AXIMM:= false; AHZERO:= true;
end;	\GENLDSB



proc	GENLDSR;	\$42
begin
COMMENT($42);
TOS2AX;
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("LDSRDO|");
PDROP(2);
PPUSH(REALTYP, 0, 0);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENLDSR



proc	GENSTSI;	\$43 @((NOS1*2) SEG(NOS2)) <- TOS
int	TOS, OFF, NOS1, TEMP;
begin
COMMENT($43);
CLEANREG(3);
TOS:= PSTKTYP(PSTKPTR-1);
OFF:= PSTKOFF(PSTKPTR-1);
NOS1:= PSTKTYP(PSTKPTR-2);

if TOS=IMMTYP & OFF=^C then TEMP:= PSTKLEV(PSTKPTR-1) else TOS2REG(^C);
PDROP(1);
if NOS1=IMMTYP then PSTKLEV(PSTKPTR-1):= PSTKLEV(PSTKPTR-1)<<1;
TOS2REG(^B);
if NOS1#IMMTYP then TTXT("	ADD	BX,BX|");
PDROP(1);
TOS2ES; PDROP(1);
if TOS=IMMTYP & OFF=^C then
	[TTXT("	MOV	WP ES:[BX],"); INTOUT(BINDEV, TEMP); CRLF(BINDEV)]
else	TTXT("	MOV	ES:[BX],CX|");
end;	\GENSTSI



proc	GENSTSB;	\$44 @(NOS1 SEG(NOS2)) <- TOS
int	TOS, TEMP;
begin
COMMENT($44);
CLEANREG(3);
TOS:= PSTKTYP(PSTKPTR-1);
if TOS=IMMTYP then 
	[if PSTKOFF(PSTKPTR-1)#^C then ERROR(6);   TEMP:= PSTKLEV(PSTKPTR-1)]
else TOS2REG(^C);
PDROP(1);
TOS2REG(^B); PDROP(1);
TOS2ES; PDROP(1);
if TOS=IMMTYP then
	[TTXT("	MOV	BYTE PTR ES:[BX],"); INTOUT(BINDEV, TEMP&$FF);
	CRLF(BINDEV)]
else	TTXT("	MOV	ES:[BX],CL|");
end;	\GENSTSB



proc	GENSTSR;	\$45
begin
COMMENT($45);
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("STSRDO|");
PDROP(3);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENSTSR



proc	GENLSHORT;	\$46
begin
COMMENT($46);
TOS2AX;
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("LSHORT|");
PDROP(2);
PPUSH(REALTYP, 0, 0);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENSHORT



proc	GENSSHORT;	\$47
begin
COMMENT($47);
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("SSHORT|");
PDROP(3);
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENSSHORT



proc	GENARY;		\$48, ARRAY DECLARATION
begin
COMMENT($48);
if OPTCALL then 
	TTXT("	PUSH	CS|	CALL	NEAR PTR ")
else	TTXT("	CALL	");
TTXT("MKARRAY|");
OLDLEV:= -1;		\SUBROUTINE MIGHT HAVE DESTROYED REGISTERS
DXLEV:= -1;
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
end;	\GENARY



proc	GENABS;		\$49, ABSOLUTE VALUE FUNCTION
begin
COMMENT($49);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= ABS(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);		\(MASM 6.11 does not assmeble JL $-2 optimally)
	TTXT("	NEG	AX|	DB	07CH, 0FCH|");	\BEWARE OF JS AND $8000
	AXLEV:= -1; AXVAL:= ABS(AXVAL); AHZERO:= false;	\(THANKS! RUUD)
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENABS



proc	GENFABS;	\$4A, ABSOLUTE VALUE FUNCTION OF A REAL
begin
COMMENT($4A);
TTXT("	MOV	BX,SP|	AND	BYTE PTR [BX+7],7FH|");
end;	\GENFABS



proc	GENREM;		\$4B, REMAINDER OF LAST DIVIDE
begin
COMMENT($4B);
PDROP(1);		\DISCARD TOS
CLEANREG(0);
TTXT("	MOV	AX,REMAIN|");
AXLEV:= -1; AXIMM:= false; AHZERO:= false;
PPUSH(REGTYP, 0, 0);
end;	\GENREM



proc	GENSWAP;	\$4C, SWAP BYTES FUNCTION
begin
COMMENT($4C);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= SWAP(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	XCHG	AH,AL|");
	AXLEV:= -1; AXVAL:= SWAP(AXVAL); AHZERO:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENSWAP



proc	GENEXT;		\$4D, SIGN EXTEND FUNCTION
begin
COMMENT($4D);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= EXTEND(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	CBW|");		\AX:= EXTEND(AL)
	AXLEV:= -1; AXVAL:= EXTEND(AXVAL); AHZERO:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENEXT



proc	GENPIN;		\$4E, FUNCTION TO READ A BYTE FROM A PORT
begin			\TOS:= port(TOS);
COMMENT($4E);
CLEANREG(1);
\if TOS is immediate <= $00FF then: IN AL,imm
if PSTKTYP(PSTKPTR-1)=IMMTYP & (PSTKLEV(PSTKPTR-1)&$FF00)=0 then
	begin
	TTXT("	IN	AL,");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-1));
	TTXT("|");
	end
else	begin
	TOS2REG(^D);
	TTXT("	IN	AL,DX|");
	DXLEV:= -1;
	end;
if AHZERO then LASTOP:= -1 else TTXT("	XOR	AH,AH|");
\Optimized GENSTX, GENJPC, SHIFT and GENPOUT depends on this XOR instruction
AXLEV:= -1;
AXIMM:= false;
AHZERO:= true;
PDROP(1); PPUSH(REGTYP, 0, 0);
end;	\GENPIN



proc	GENPOUT;	\$4F, FUNCTION TO WRITE A BYTE TO A PORT
int	LOP;		\port(NOS):= TOS;
begin
LOP:= LASTOP;
COMMENT($4F);
if LOP=\LDX\$02 ! LOP=\LDSB\$41 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-2|"); AHZERO:= false];	\REPLACE XOR AH,AH
CLEANREG(1);
\if NOS is immediate <= $00FF then: OUT imm,AL
if PSTKTYP(PSTKPTR-2)=IMMTYP & (PSTKLEV(PSTKPTR-2)&$FF00)=0 then
	begin
	TOS2REG(^A);
	TTXT("	OUT	");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-2));
	TTXT(",AL|");
	PDROP(2);
	end
else if PSTKTYP(PSTKPTR-2) = REGTYP then
	begin
	TTXT("	XCHG	DX,AX|");	\MOV DX,AX
	AXLEV:= -1; AXIMM:= false; AHZERO:= false;
	TOS2REG(^A);
	PDROP(2);
	TTXT("	OUT	DX,AL|");
	DXLEV:= -1;
	end
else	begin
	TOS2REG(^A); PDROP(1);
	TOS2REG(^D); PDROP(1);
	TTXT("	OUT	DX,AL|");
	DXLEV:= -1;
	end;
end;	\GENPOUT



proc	GENEND;		\$FE
begin
COMMENT($FE);
TTXT("CSEG	ENDS|	END|");
end;	\GENEND

\===========================================================================

proc	LOOKUP;		\LOOKUP IDENTIFIER IN SYMBOL TABLE
\INPUTS: IDENT, HASH
\OUTPUTS: IDTYPE, VAL, LEV, SYMNUM.
\IF TWO IDENTIFIERS OF THE SAME NAME ARE IN THE SYMBOL TABLE
\ THEN THE MOST RECENT ENTRY IS USED.
int	I, K, PNTR;
begin
PNTR:= BOX(HASH);
loop	begin
	if PNTR=EMTPNT then [IDTYPE:= UNDEF; quit];
	I:= 0; K:= PNTR;
	while IDENT(I)=SYMBOL(K) & I<SIGCHAR do
		[I:= I+1; K:= K+SYMAX];
	if I=SIGCHAR then		\FOUND
		[IDTYPE:= SYMTYP(PNTR);
		VAL:= SYMVAL(PNTR);
		LEV:= SYMLEV(PNTR);
		SYMNUM:= PNTR;		\(FOR FORWARD PROC)
		quit];
	PNTR:= SYMPNT(PNTR);
	end;
end;	\LOOKUP



proc	INSERT(STYP, SLEV, SVAL);
\INSERT THE CURRENT IDENTIFIER INTO THE SYMBOL TABLE
\INPUTS:  STYP, SLEV, SVAL, IDENT, HASH, NOSYM, SYMBOL, & BOX.
int	STYP, SLEV, SVAL;
int	I, K;
begin
LOOKUP;
if IDTYPE # UNDEF then if LEV=LEVEL then \COLLISION\ ERROR(11);
if NOSYM >= SYMAX then \TABLE FULL\ [ERROR(3); NOSYM:= SYMAX-1];
K:= NOSYM;
for I:= 0, SIGCHAR-1 do [SYMBOL(K):= IDENT(I); K:= K+SYMAX];
SYMTYP(NOSYM):= STYP;
SYMLEV(NOSYM):= SLEV;
SYMVAL(NOSYM):= SVAL;
SYMPNT(NOSYM):= BOX(HASH);		\LINK BACK
BOX(HASH):= NOSYM;
NOSYM:= NOSYM+1;
end;	\INSERT



proc	GETCON;		\GET A CONSTANT--EITHER BY VALUE OR BY NAME
int	NEG;
begin
if ATOM=^+ then RATOM;
if ATOM=^- then [NEG:= true; RATOM] else NEG:= false;
case ATYPE of
  INTCON:
	[if NEG then IATOM:= -IATOM;
	FACTYP:= INTEGER];
  REALCON:
	[if NEG then RLATOM:= -RLATOM;
	FACTYP:= REAL];
  IDENTIFIER:
	begin
	LOOKUP;
	case IDTYPE of
	 INCON:	[IATOM:= if NEG then -VAL else VAL;
		FACTYP:= INTEGER];
	 RLCON:	[RLATOM:= if NEG then-RLTBL(VAL) else RLTBL(VAL);
		FACTYP:= REAL]
	other	ERROR(42);
	end
other	ERROR(42);
end;	\GETCON

\-------------------------------------------------------------------------------

proc	CONEXPRESS;	\EVALUATE CONSTANT EXPRESSIONS
\OUTPUTS FACTYP, IATOM, RLATOM
int	SFACTYP, ITEMP, IFVAR;
real	RTEMP;


	proc INTTEST;		\TEST FOR INTEGER ERRORS
	if FACTYP # INTEGER then ERROR(47);


	proc MIXTEST(TYPE);	\TEST FOR MIXED MODE ERRORS
	int TYPE;
	if TYPE#FACTYP then ERROR(46);


	proc	CFACTOR;
	begin
	if ATOM=^( then
		begin
		RATOM;
		CONEXPRESS;
		if ATOM#^) then ERROR(44);		
		end
	else GETCON;
	RATOM;
	end;	\CFACTOR


	proc	CSHIFTEXP;
	int	ITEMP;
	begin
	CFACTOR;
	ITEMP:=IATOM;
	case ATOM of
	LSLSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP << IATOM;
		end;	
	LSRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP >> IATOM;
		end;
	ASRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP ->> IATOM;
		end
	other;
	end;	\CSHIFTEXP


	proc	CTERM;
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CSHIFTEXP;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^*:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP * IATOM
				else RLATOM:=RTEMP * RLATOM;
			end;
		  ^/:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if IATOM=0 ! RLATOM=0.0 then ERROR(73) \Divide by zero
			else if FACTYP=INTEGER then IATOM:=ITEMP / IATOM
				else RLATOM:=RTEMP / RLATOM;
			end
		other	quit;
		end;
	end;	\CTERM


	proc	CALGEXP;	\ALGEBRIAC EXPRESSION
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CTERM;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^+:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP + IATOM
			else RLATOM:=RTEMP + RLATOM;
			end;
		  ^-:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP - IATOM
				else RLATOM:=RTEMP - RLATOM;
			end
		other	quit;
		end;
	end;	\CALGEXP


	proc	CLOGEXP;	\'NOT' AND COMPARISONS
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	if ATOM=NOTSYM ! ATOM=^~ then	\UNARY 'NOT' OPERATOR
		begin
		RATOM;
		CLOGEXP;
		INTTEST;
		IATOM:= ~IATOM;
		end
	else	begin
		CALGEXP;
		SFACTYP:=FACTYP;
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		 ^=:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP = IATOM
			else IATOM:= RTEMP = RLATOM;
			FACTYP:=INTEGER];
		 ^#:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP # IATOM
			else IATOM:= RTEMP # RLATOM;
			FACTYP:=INTEGER];
		 ^>:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP > IATOM
			else IATOM:= RTEMP > RLATOM;
			FACTYP:=INTEGER];
		 ^<:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP < IATOM
			else IATOM:= RTEMP < RLATOM;
			FACTYP:=INTEGER];
		 GESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP >= IATOM
			else IATOM:= RTEMP >= RLATOM;
			FACTYP:=INTEGER];
		 LESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP <= IATOM
			else IATOM:= RTEMP <= RLATOM;
			FACTYP:=INTEGER]
		other	[];
		end;
	end;	\CLOGEXP


	proc	CBOOLTERM;	\BOOLEAN "&" EXPRESSIONS
	int	ITEMP;
	begin
	CLOGEXP;
	loop	begin
		ITEMP:=IATOM;
		if ATOM=^& ! ATOM=ANDSYM then
			begin
			INTTEST;
			RATOM;
			CLOGEXP;
			INTTEST;
			IATOM:=ITEMP & IATOM;
			end
		else quit;
		INTTEST;
		end;
	end;	\CBOOLTERM


begin	\CONEXPRESS
TRAP(false);
if ATOM=IFSYM then		\'IF' EXPRESSION
	begin
	RATOM;
	CONEXPRESS;
	INTTEST;
	IFVAR:=IATOM;
	if ATOM#THENYM then ERROR(22);
	RATOM;
	CONEXPRESS;
	SFACTYP:=FACTYP;
	ITEMP:=IATOM; RTEMP:=RLATOM;
	if ATOM#ELSEYM then ERROR(30);
	RATOM;
	CONEXPRESS;
	MIXTEST(SFACTYP);
	if IFVAR then 
		if FACTYP=INTEGER then IATOM:=ITEMP
		else RLATOM:=RTEMP;
	end
else	begin
	CBOOLTERM;
	loop	begin
		ITEMP:=IATOM;
		case ATOM of
		  ^!, ORSYM:
		  	begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP ! IATOM;
			end;
		  ^|, XORSYM:
			begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP | IATOM;
			end
		other quit;
		end;
	end;
TRAP(true);
if GETERR#0 then ERROR(74);	\GENERAL MATH ERROR
end;	\CONEXPRESS

\-------------------------------------------------------------------------------

fproc	BOOLEXP;



proc	PROCAL(FUNC);
int	FUNC;	\TRUE IF FUNCTION VS. PROCEDURE
int	SVAL, SLEV, ARGCNT, BYTES, SID, CURSYM;
begin
SVAL:= VAL; SLEV:= LEV; SID:= IDTYPE; CURSYM:= SYMNUM;
RATOM;
ARGCNT:= 0;
BYTES:= 0;
CLEANREG(0);
if ATOM=^( then
	begin
	\MARK THE START OF ARGUMENT GENERATION
	if SID>=INPROC & SID<=RLFPROC then GENMARK;
	loop	begin
		RATOM;
		BOOLEXP;
		ARGCNT:= ARGCNT+1;
		BYTES:= BYTES + (if FACTYP=INTEGER then 2 else RLSIZE);
		if ATOM # ^, then quit;
		if SID>=INPROC & SID<=RLFPROC then []	\USE PSEUDO STACK FOR PROCS
		else if FACTYP=INTEGER then TOS2STACK;	\USE H/W STK FOR OTHERS
		end;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
case of
  SID>=INPROC & SID<=RLFPROC:	\NORMAL PROCEDURE CALL
	[if ARGCNT>0 then GENARG(BYTES);
	GENCAL(SVAL, false)]

other	case SID of
	  ININT, RLINT:	GENCML(SVAL,FACTYP,SID,FUNC,ARGCNT); \INTRINSIC PROCEDURE CALL
	  INOPT, RLOPT:					\OPTIMIZED PROCEDURE CALL
		[if ARGCNT>0 then ERROR(51);		\NO ARG DECLARED
		GENJSR(SVAL)];
	  INEXT, RLEXT:	GENCEXT(CURSYM,FACTYP,SID,FUNC,ARGCNT);	\EXTERNAL ASSEMBLY CALL
	  INEPRO, RLEPRO:					\EXTERNAL XPL CALL
		[if ARGCNT>0 then GENARG(BYTES);
		GENCAL(CURSYM, true)]
	other;
end;	\PROCAL



proc	FACTOR;



func	STRCON;	\Generate code for a string constant and return its address
int	SPC,	\label number of starting address of string
	ASC,	\flag: last output was in ASCII format (vs. BINARY)
	CTR,	\count of characters on current line of output
	NCHAR,	\next character (one character look ahead)
	DONE;	\flag: terminating quote mark has been read in


	proc	GETNEXTCH;	\Get next chararacter
	begin
	CHAR:= NCHAR; NCHAR:= CHIN(SRCDEV);
	if NCHAR=EOF then [ERROR(63); exit 1];
	CHOUT(LSTDEV, NCHAR);
	if NCHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		NCHAR:=CHIN(SRCDEV);
		if NCHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,NCHAR);
		if NCHAR>=^@ & NCHAR<=^_ & NCHAR#^^ then NCHAR:=NCHAR-^@;
		if NCHAR>=^` & NCHAR<=^~ then NCHAR:=NCHAR-^`;
		end
	else if NCHAR=^" then	\terminating quote mark
		begin
		if STRTERM \#0\ then CHAR:= CHAR!$80;	\terminate with MSB set
		DONE:= true;
		end;
	end;	\GETNEXTCH


	proc	BINMODE;	\Output character as a decimal (binary) value
	begin
	if CTR#0 & ASC then CHOUT(BINDEV, ^");	\terminate ASCII string, if any
	if CTR#0 then CHOUT(BINDEV, ^,);	\output separator, if necessary
	INTOUT(BINDEV, CHAR);
	ASC:= false;		\no longer in ASCII mode
	end;	\BINMODE


	proc	ASCMODE;	\Output character as an ASCII value
	begin
	if CTR=0 then CHOUT(BINDEV, ^")		\begin ASCII string else
	else if not ASC then TEXT(BINDEV, ",^""); \separate binary part first
	CHOUT(BINDEV, CHAR);
	ASC:= true;		\now in ASCII mode
	end;	\ASCMODE


begin	\STRCON		Enter with CHAR = first character in string (or close ")
COMMENT($FB);
SPC:= NEWLAB;		\make a label at the starting address of the string
DLABEL(SPC);

if CHAR#^" then		\in case of null string (i.e: ""; must be 0 terminated)
	begin
	if CHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		CHAR:=CHIN(SRCDEV);
		if CHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,CHAR);
		if CHAR>=^@ & CHAR<=^_ & CHAR#^^ then CHAR:=CHAR-^@;
		if CHAR>=^` & CHAR<=^~ then CHAR:=CHAR-^`;
		end;
	NCHAR:= CHAR;			\so GETNEXTCH restores CHAR
	ASC:= false;
	DONE:= false;
	CTR:= 0;
	loop	begin
		GETNEXTCH;
		if CTR=0 then TEXT(BINDEV, "	DB	");	\new output line

		case of
		  CHAR=^', CHAR=^":	\assembler uses these for delimiters
				BINMODE;
		  CHAR>=$20:	ASCMODE;\non-control characters
		  CHAR=$09:	ASCMODE	\accept tab in ASCII, for readability
		other	BINMODE;
		CTR:= CTR+1;

		if DONE then [if ASC then CHOUT(BINDEV, ^"); quit];

		if CTR >= 40 then
			begin
			if ASC then CHOUT(BINDEV, ^");
			CRLF(BINDEV);
			CTR:= 0;
			end;
		end;	\loop
	CRLF(BINDEV);
	end;

if STRTERM = 0 then TTXT("	DB	0|");	\terminate with null

GETCH;
FACTYP:= INTEGER;
return SPC;	\return label number for starting address of string
end;	\STRCON



func	ARRAYCON;	\CONSTANT ARRAYS
int	THISEL, NEXTEL, PNTR, SPC, I, INDIRECT, SFACTYP;
def	NULL=$FFFF;
char	ENTRY, R;

	proc	ARRAYX;	\(WARNING: THIS MUST BE AN OPTIMIZED PROCEDURE
	begin		\ FOR THE RESERVE TO WORK PROPERLY.)
	RATOM;
	INDIRECT:= true;
	case ATOM of
	  ^[:	[ENTRY:= ARRAYCON; RATOM];
	  ^":	[ENTRY:= STRCON; RATOM]
	other	begin
		INDIRECT:= false;
		CONEXPRESS;
		if FACTYP=INTEGER then ENTRY:= IATOM
		else	[ENTRY:= RESERVE(RLSIZE);  \FACTYP=REAL
			R:= addr RLATOM;
			for I:= 0, RLSIZE-1 do ENTRY(I):= R(I)];
		end;
	NEXTEL:= RESERVE(6);
	THISEL(1):= ENTRY;
	THISEL(2):= INDIRECT;
	THISEL(0):= NEXTEL;
	NEXTEL(0):= NULL;
	THISEL:= NEXTEL;
	end;	\ARRAYX


begin	\ARRAYCON
PNTR:= RESERVE(6);
THISEL:= PNTR;
THISEL(0):= NULL;
ARRAYX;
while ATOM=^, do
	[SFACTYP:= FACTYP;
	ARRAYX;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46)];
if ATOM#^] then ERROR(50);
COMMENT(if FACTYP=INTEGER then $FD else $FC);

SPC:= NEWLAB;
DLABEL(SPC);
while PNTR(0)#NULL do			\DUMP LIST
	begin
	ENTRY:= PNTR(1);
	if FACTYP=INTEGER then
		begin
		TTXT("	DW	");
		if PNTR(2) \INDIRECT\ then CHOUT(BINDEV, ^L);
		INTOUT(BINDEV, ENTRY);
		end
	else	begin			\(FACTYP=REAL)
		if PNTR(2) \INDIRECT\ then
			begin
			TTXT("	DW	L");
			INTOUT(BINDEV, ENTRY);
			TTXT("|	DW	0,0,0|" );
			end
		else	begin
			TTXT("	DQ	");
			CHOUT(BINDEV, ^0);
			for I:= 0, RLSIZE-1 do HEXB(ENTRY(RLSIZE-I-1));
			CHOUT(BINDEV, ^H);
			end;
		end;
	PNTR:= PNTR(0);
	CRLF(BINDEV);
	end;
return SPC;	\RETURN STARTING ADDRESS OF ARRAY
end;	\ARRAYCON



proc	SPECFAC;	\SPECIAL CHARACTER FACTOR
int	SVAL, SPC, R, SID, SATOM;
begin
case ATOM of
  ^(:	[RATOM;				\PARENTHESIZED EXPRESSION
	BOOLEXP;			\(FACTOR TYPE IS UNCHANGED)
	if ATOM#^) then ERROR(44);
	RATOM];
  ^":	[DSTART;			\STRING CONSTANT
	SVAL:= STRCON;
	DEND;
	GENIMM(^L, SVAL);
	RATOM];
  ^[:	[DSTART;			\CONSTANT ARRAY
	SVAL:= ARRAYCON;
	DEND;
	if FACTYP=INTEGER then GENIMM(^L, SVAL)
	else GENFIMM(^L, SVAL);		\FACTYP=REAL
	RATOM];
  ADRSYM, ^@:
	begin				\GET ABSOLUTE HEAP ADDRESS
	SATOM:=ATOM;
	RATOM;
	if ATYPE#IDENTIFIER then ERROR(45);
	LOOKUP;
	case IDTYPE of
	  INVAR, RLVAR, ADDRVAR:
		begin
		SID:= IDTYPE;
		RATOM;
		if ATOM=^( then			\INDEXED
			begin
			GENLOD(LEV, VAL);	\(EVEN FOR REALS)
			RATOM;
			BOOLEXP;		\1ST INDEX
			if FACTYP#INTEGER then ERROR(47);
			while ATOM=^, do	\MULTIPLE INDEXING
				begin
				case SID of
				  INVAR, ADDRVAR: GENDBX;
				  RLVAR: GENTRX
				other [];
				RATOM;
				BOOLEXP;
				if FACTYP#INTEGER then ERROR(47);
				end;
			case SID of
			  INVAR: GENDBA;
			  RLVAR: begin
				 GENTRA;
				 FACTYP:=INTEGER;
				 if SATOM=^@ then
					[FACTYP:=REAL; GENIMM(^C,0);
					 GENIMM(^C,0); GENIMM(^C,0)];
				 end;
			  ADDRVAR: GENADD
			other [];
			if ATOM#^) then ERROR(44) else RATOM;
			end
		else	begin
			GENADR(LEV, VAL);
			FACTYP:=INTEGER;
			if SID=RLVAR & SATOM=^@ then
				[FACTYP:=REAL;
				GENIMM(^C,0); GENIMM(^C,0); GENIMM(^C,0)];
			end;
		end;
	  UNDEF:ERROR(10)		\(UNDECLARED NAME)
	other	ERROR(43);		\(VARIABLE EXPECTED)
	end;
  ABSSYM:
	begin				\ABSOLUTE VALUE FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then GENABS else GENFABS;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  REMSYM:
	begin				\REMAINDER OF LAST DIVIDE
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENREM;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  SWAPYM:
	begin				\SWAP BYTES FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENSWAP;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  EXTSYM:
	begin				\SIGN EXTEND FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENEXT;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  PORTYM:
	begin				\READ BYTE FROM PORT
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENPIN;
	if ATOM#^) then ERROR(44) else RATOM;
	end
other	\ILLEGAL FACTOR\ ERROR(26);
end;	\SPECFAC



proc	IDFAC;		\IDENTIFIER FACTOR
int	SLEV, SVAL, SID, SINDX;
begin
LOOKUP;
SID:= IDTYPE;
case IDTYPE of
 UNDEF:	ERROR(10);

 INVAR, RLVAR, ADDRVAR:		\VARIABLE
	begin
	if SID=RLVAR then GENFLOD(LEV,VAL) else GENLOD(LEV,VAL);
	RATOM;
	if ATOM=^( then				\IT IS INDEXED
		begin
		loop	begin
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^, then quit;
			if SID=RLVAR then GENTRI else GENDBX;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBX;
		 RLVAR:   GENTRI;
		 ADDRVAR: GENLDX
		other	[];
		end;
	end;

 INSEG, RLSEG, ADSEG, SHSEG:		\SEGMENT VARIABLE
	begin
	SINDX:= 0;			\WATCH INDEX LEVEL
	GENLOD(LEV, VAL);
	RATOM;
	if ATOM=^( then			\HANDLE FIRST INDEX
		begin
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		GENDBX;
		if ATOM=^, then		\HANDLE SECOND INDEX
			begin
			SINDX:= 2;	\FLAG TWO INDEXES
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			case SID of
				INSEG: GENLDSI;
				ADSEG: GENLDSB;
				RLSEG: GENLDSR;
				SHSEG: GENLSHORT
			other;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		end;
	\FORCE REAL TO BE INTEGER WHEN THERE ARE LESS THAN 2 INDEXES
	case SID of RLSEG, SHSEG: [if SINDX<2 then SID:= INSEG] other;
	end;

 INCON:	begin				\INTEGER CONSTANT IDENTIFIER
	GENIMM(^C, VAL);
	RATOM;
	end;

 RLCON:	begin				\REAL CONSTANT IDENTIFIER
	RLATOM:= RLTBL(VAL); GENFIMM(^C, 0);
	RATOM;
	end

other	begin				\PROCEDURES USED AS FUNCTIONS
	PROCAL(true);
	if SID<ININT then	\INTEGER FUNCTIONS RETURN VALUES IN AX
		if SID&1 then [PPUSH(REGTYP, 0, 0) \GENLOD(0, 0); TOS2HARD\]
		else GENFLOD(0, 0);
	end;

FACTYP:= if SID & 1 then INTEGER else REAL;	\ODD IDS ARE INTEGER
end;	\IDFAC



begin	\FACTOR
while ATOM=^+ do RATOM;			\IGNORE UNARY "+"
if ATOM=^- then				\UNARY "-"
	begin
	RATOM;
	FACTOR;
	if FACTYP=INTEGER then GENNEG else GENFNEG;
	end
else	case ATYPE of
	  SPECIAL:	SPECFAC;
	  INTCON:	[FACTYP:= INTEGER;	\INTEGER CONSTANT
			GENIMM(^C, IATOM);
			RATOM];
	  REALCON:	[FACTYP:= REAL;		\REAL CONSTANT
			GENFIMM(^C, 0);
			RATOM]
	other		IDFAC;			\ATYPE = IDENTIFIER (BY DEFAULT)
end;	\FACTOR



proc	SHIFTEXP;

	proc	SHIFTX(INOP);
	int	INOP;
	begin
	if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
	RATOM; FACTOR;
	if FACTYP # INTEGER then ERROR(47);
	end;	\SHIFTX

begin	\SHIFTEXP
FACTOR;
case ATOM of
  LSLSYM: [SHIFTX; GENLSL];	\<<
  LSRSYM: [SHIFTX; GENLSR];	\>>
  ASRSYM: [SHIFTX; GENASR]	\->>
other;
end;	\SHIFTEXP



proc	TERM;
int	SFACTYP;

	proc	TERMX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; SHIFTEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP);
	end;	\TERMX

begin	\TERM
SHIFTEXP;
SFACTYP:= FACTYP;
loop	case ATOM of
	  ^*:	TERMX(\MUL\$0F, \MULF\$2F);
	  ^/:	TERMX(\DIV\$10, \DIVF\$30)
	other	quit;
end;	\TERM



proc	ALGEXP;		\ALGEBRAIC EXPRESSION
int	SFACTYP;

	proc	ALGX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; TERM;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP);
	end;

begin	\ALGEXP
TERM;
SFACTYP:= FACTYP;
loop	case ATOM of
	  ^+:	ALGX(\ADD\$0D, \ADDF\$2D);
	  ^-:	ALGX(\SUB\$0E, \SUBF\$2E)
	other	quit;
end;	\ALGEXP



proc	LOGEXP;		\LOGICAL EXPRESSION
int	SFACTYP;

	proc	LOGX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; ALGEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENCMP(if FACTYP=INTEGER then INOP else RLOP);
	FACTYP:= INTEGER;
	end;

begin	\LOGEXP
if ATOM=NOTSYM ! ATOM=^~ then		\UNARY 'NOT' OPERATOR
	begin
	RATOM; LOGEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENNOT
	end
else	begin
	ALGEXP;
	SFACTYP:= FACTYP;
	case ATOM of
	  ^=:	LOGX(\EQ\$12, \EQF\$32);
	  ^#:	LOGX(\NE\$13, \NEF\$33);
	  ^>:	LOGX(\GT\$15, \GTF\$35);
	  ^<:	LOGX(\LT\$17, \LTF\$37);
	  GESYM:LOGX(\GE\$14, \GEF\$34);
	  LESYM:LOGX(\LE\$16, \LEF\$36)
	other;
	end;
end;	\LOGEXP



proc	BOOLTERM;	\Boolean "&" expressions
begin
LOGEXP;
loop	begin
	if ATOM=^& ! ATOM=ANDSYM then
		[if FACTYP#INTEGER then ERROR(47);
		RATOM; LOGEXP; GENAND]
	else	quit;
	if FACTYP#INTEGER then ERROR(47);
	end;
end;	\BOOLTERM



func	SHORTER(LT, LF); \SHORT-CIRCUIT EVALUATE BOOLEAN EXPRESSIONS
int	LT, LF;		\LABELS TO JUMP TO IF BOOLEAN EXPRESSION IS TRUE OR FALSE
int	LTUSED, LFUSED;	\FLAGS

\if LOGEXP then STATEMENT
\LABELS:       ^LT       ^LF
\EXAMPLE:
\if N=1  !  N=2  !  N=3 & N=4 & N=5  !  N=6  !  N=7 then ...
\
\		CMP	N,1
\		JE	LT
\		CMP	N,2
\		JE	LT
\
\		CMP	N,3
\		JNE	LF0
\		CMP	N,4
\		JNE	LF0
\		CMP	N,5
\		JE	LT
\	LF0:				;Initial false label
\		CMP	N,6
\		JE	LT
\		CMP	N,7
\		JNE	LF1
\	LT:				;There is only one true label
\		CALL	STATEMENT
\	LF1:				;Final false label is returned

begin
LTUSED:= false;
LFUSED:= false;
loop	begin
	RATOM;
	LOGEXP;
	loop	begin
		if ATOM=^& ! ATOM=ANDSYM then
			begin	\BEWARE OF MASKING, E.G: if F & 3 then ...
			if LASTOP>=$12 & LASTOP<=$17 then	\COMPARISON
				begin
				GENJPC(LF,false);	\JUMP TO FALSE LABEL
				LFUSED:= true;		\LABEL IS USED
				RATOM; LOGEXP;
				end
			else	[RATOM; LOGEXP; GENAND]; \OLD WAY
			end
		else quit;
		end;
	case ATOM of
	  ^!, ORSYM:
		begin
		GENJPC(LT,true);	\CONDITIONALLY JUMP TO TRUE LABEL
		LTUSED:= true;		\INDICATE THAT TRUE LABEL WAS USED
		if LFUSED then		\IF THERE IS A CONDITIONAL JUMP USING
			begin		\ THIS LABEL THEN...
			CLABEL(LF);	\MAKE LABEL FOR FALSE DESTINATION
			LF:= NEWLAB;	\MAKE ANOTHER FALSE LABEL
			LFUSED:= false;	\THIS ONE ISN'T USED YET
			end;
		end;
	  ^|, XORSYM, IFSYM:	\MUST USE PARENTHESES FOR XOR AND 'IF' EXPRESSIONS
		ERROR(75)
	other	quit;
	end;
GENJPC(LF,false);
if LTUSED then CLABEL(LT);		\ONLY MAKE LABEL IF IT IS ACTUALLY USED
return LF;				\RETURN (POSSIBLY NEW) FALSE LABEL
end;	\SHORTER



proc	BOOLEXP;	\BOOLEAN EXPRESSION. OUTPUTS FACTOR TYPE (FACTYP).
int	P1, P2, P3, SFACTYP;


	proc	IFEXP;
	begin				\if BOOLEXP then BOOLEXP else BOOLEXP
	CLEANREG(0);
	if SHORTBOOL then		\LABELS:      P1^     P2^          P3^
		begin
		P1:= NEWLAB;		\TRUE LABEL
		P2:= NEWLAB;		\FALSE LABEL
		P2:= SHORTER(P1, P2);	\RETURNS FALSE LABEL (MIGHT BE DIFFERENT)
		end
	else	begin
		RATOM;
		BOOLEXP;
		P2:= NEWLAB;		\FALSE LABEL
		GENJPC(P2,false);	\SKIP STATEMENT IF BOOLEXP IS FALSE
		end;

	if ATOM # THENYM then ERROR(22);
	RATOM;
	BOOLEXP;
	SFACTYP:= FACTYP;
	if FACTYP = INTEGER then TOS2AX;
	PDROP(1);			\A LIE, BUT IT GETS FIXED BELOW
	if ATOM # ELSEYM then ERROR(30);
	P3:= NEWLAB;
	GENJMP(P3);
	CLABEL(P2);

	RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then TOS2AX;
			\PSEUDO STACK MUST BE IN SAME STATE FOR EACH CODE PATH
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	CLABEL(P3);
	end;



	proc	BEXPX(INOP);
	int	INOP;
	begin
	if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
	RATOM; BOOLTERM;
	if FACTYP # INTEGER then ERROR(47);
	end;	\BEXPX


begin
if ATOM=IFSYM then IFEXP		\'IF' EXPRESSION
else	begin				\BOOLEAN "!" (OR) EXPRESSIONS
	BOOLTERM;
	loop	case ATOM of
		  ^!, ORSYM:	[BEXPX; GENOR];
		  ^|, XORSYM:	[BEXPX; GENEOR]
		other quit;
	end;
end;	\BOOLEXP

\-------------------------------------------------------------------------------

proc	SSTATEMENT(SSTK);	\(FOR 'QUIT'S IN 'CASE' STMNTS)
int	SSTK;



proc	STATEMENT;
int	P1, P2, P3, SFIXS, SLEV, SVAL, SFACTYP, SDXLEV, I,
	LOPARAMS, HIPARAMS, FLAG, DOWNTO;



proc	ASSIGN;		\ASSIGNMENT STATEMENT (ALSO INCLUDES PROCEDURE CALLS)
int	SID;

	proc	ASSX;
	begin
	if ATOM#GETSYM then ERROR(21);
	RATOM;
	BOOLEXP;	\RIGHT-HAND SIDE OF ASSIGNMENT
	end;

begin	\ASSIGN
if ATOM=PORTYM then	\port($123):= boolexp
	begin
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#^) then ERROR(44) else RATOM;
	ASSX;
	GENPOUT;
	if FACTYP#INTEGER then ERROR(47);
	return;
	end;

if ATYPE#IDENTIFIER then		\ILLEGAL START OF A STATEMENT
	[ERROR(20); SKIPIT; return];
LOOKUP; if IDTYPE=UNDEF then [ERROR(10); SKIPIT; return];
SLEV:= LEV; SVAL:= VAL;			\SAVE THESE FOR "GEN". AN INTERIM
SID:= IDTYPE;				\ BOOLEXP IN ASSX CHANGES LEV & VAL

case of
  IDTYPE>=INPROC & IDTYPE<=RLEXT:
	PROCAL(false);

  IDTYPE=INVAR ! IDTYPE=RLVAR ! IDTYPE=ADDRVAR:
	begin
	SFACTYP:=if IDTYPE=RLVAR then REAL else INTEGER;
	RATOM;
	if ATOM=^( then			\INDEXED
		begin
		GENLOD(SLEV, SVAL);	\(EVEN FOR REALS)
		RATOM;
		BOOLEXP;		\1ST INDEX
		if FACTYP#INTEGER then ERROR(47);

		while ATOM=^, do	\MULTIPLE INDEXING
			begin
			if SFACTYP=INTEGER then GENDBX else GENTRX;
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBA;
		 RLVAR:   GENTRA;
		 ADDRVAR: GENSTXADD
		other	[];

		ASSX;			\TOS NOW POINTS TO ARRAY ELEMENT
		if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
		case SID of
		 INVAR:   GENSTD;
		 RLVAR:   GENSTT;
		 ADDRVAR: if STXFLAG then GENSTX2 else GENSTX
		other	[];
		end

	else	[ASSX;
		if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
		if SFACTYP=INTEGER then GENSTO(SLEV, SVAL)
		else GENFSTO(SLEV, SVAL)];
	end;

  IDTYPE=INSEG ! IDTYPE=RLSEG ! IDTYPE=ADSEG ! IDTYPE=SHSEG:	\SEGMENT VARIABLES
	begin
	SFACTYP:= INTEGER;
	RATOM;
	if ATOM#^( then	[ASSX; GENSTO(SLEV, SVAL)]
	else	begin			\1ST INDEX
		GENLOD(SLEV, SVAL);
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM=^, then		\2ND INDEX
			begin
			GENDBX;
			case SID of RLSEG, SHSEG: TOS2HARD other;
			RATOM; BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^) then ERROR(44) else RATOM;
			case SID of RLSEG, SHSEG: TOS2HARD other;
			ASSX;		\GET RIGHT SIDE OF ASSIGNMENT
			case SID of
			 INSEG:	GENSTSI;
			 RLSEG:	[GENSTSR; SFACTYP:= REAL];
			 ADSEG:	GENSTSB;
			 SHSEG:	[GENSSHORT; SFACTYP:= REAL]
			other;
			end
		else	begin
			GENDBA;
			if ATOM#^) then ERROR(44) else RATOM;
			ASSX;		\GET RIGHT SIDE OF ASSIGNMENT
			GENSTD;
			end;
		end;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
	end

other	\STATEMENT STARTING WITH A CONSTANT\ [ERROR(27); SKIPIT];
end;	\ASSIGN



proc	CASER(TYPE);
int	TYPE;
int	SPC1, SPC2, SPC3, MULTILABEL, SAHZERO;
begin
if TYPE = $25\CJP\ then TOS2AX;
SPC2:= NEWLAB;
repeat	MULTILABEL:= false;
	loop	begin
		RATOM;			\CASE LABEL:
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#^, then quit;
		if ~MULTILABEL then
			[SPC3:= NEWLAB;
			MULTILABEL:= true];
		if TYPE=$08 then GENJPC(SPC3,true) else GENCJP(SPC3,true);
		end;
	SPC1:= NEWLAB;
	if TYPE=$08 then GENJPC(SPC1,false) else GENCJP(SPC1,false);
	SAHZERO:= AHZERO;		\PRESERVE AHZERO TO ENABLE "CMP AL,IMM"
	if MULTILABEL then CLABEL(SPC3);
	if ATOM#^: then [ERROR(49); SKIPIT; return];

	if TYPE = $25\CJP\ then PDROP(1);		\DON'T SAVE AX
	RATOM;
	STATEMENT;
	if TYPE = $25\CJP\ then PPUSH(REGTYP, 0, 0);	\AX HOLDS CASE VALUE

	GENJMP(SPC2);			\JUMP OUT OF CASE STATEMENT
	CLABEL(SPC1);
	AHZERO:= SAHZERO;
until ATOM#^;;

if ATOM#ELSEYM & ATOM#OTHSYM then ERROR(29);
if TYPE = $25\CJP\ then PDROP(1);		\DON'T SAVE AX
RATOM;
STATEMENT;
if TYPE = $25\CJP\ then PPUSH(REGTYP, 0, 0);	\AX HOLDS CASE VALUE
CLABEL(SPC2);
end;	\CASER



begin	\STATEMENT
case ATOM of
BEGSYM, ^[:
	begin
	RATOM;
	loop	begin
		if ATOM=ELSEYM then [ERROR(52); RATOM];
		if ATOM=OTHSYM then [ERROR(53); RATOM];
		STATEMENT;
		case ATOM of
		  ^;:	RATOM;
		  ENDSYM, ^]:
			quit;
		  EOF:	[ERROR(62); exit 1]
		other	\SEMI EXPECTED\ ERROR(41);
		end;
	RATOM;		\READ PAST THE 'END'
	end;

CASEYM:	begin				\CASE STATEMENT
	RATOM;
	if ATOM=OFSYM then CASER(\JPC\$08)
	else	begin
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#OFSYM then [ERROR(48); SKIPIT; return];
		STKLOD:= STKLOD+1;
		CASER(\CJP\$25);
		GENDRP(1);
		PDROP(1);
		STKLOD:= STKLOD-1;
		end;
	end;

QUITYM:	begin
	GENDRP(STKLOD-SSTK);
	if FIXCNT>=QUITMAX then [ERROR(4); FIXCNT:= QUITMAX-1];
	FIXES(FIXCNT):= NEWLAB;		\QUIT STATEMENT
	GENJMP(FIXES(FIXCNT));   	\(WILL BE "FIXED" AT END OF 'LOOP')
	DXLEV:= -1;			\MIGHT BE JUMPING OUT OF A FOR LOOP AND
	FIXCNT:= FIXCNT+1;		\ DX IS NOT = TO ITS MEMORY LOC HERE
	RATOM;
	end;

IFSYM:	begin				\if BOOLEXP then STATEMENT
	if SHORTBOOL then		\LABELS:      P1^       P2^
		begin
		P1:= NEWLAB;		\TRUE LABEL
		P2:= NEWLAB;		\FALSE LABEL
		P2:= SHORTER(P1, P2);	\RETURNS FALSE LABEL (MIGHT BE DIFFERENT)
		end
	else	begin
		RATOM;
		BOOLEXP;
		P2:= NEWLAB;		\FALSE LABEL
		GENJPC(P2,false);	\SKIP STATEMENT IF BOOLEXP IS FALSE
		end;
	if ATOM # THENYM then [ERROR(22); SKIPIT; return];
	RATOM;
	STATEMENT;
	if ATOM = ELSEYM then
		begin			\if BOOLEXP then STATEMENT else STATEMENT
		P3:= NEWLAB;		\LABELS:      P1^       P2^            P3^
		GENJMP(P3);
		CLABEL(P2);
		P2:= P3;		\CHANGE NAME OF P2 EXIT LABEL TO BE P3
		RATOM;
		STATEMENT;
		end;
	CLABEL(P2);
	end;

REPSYM:	begin
	DOALIGN;
	P2:= NEWLAB;			\REPEAT STATEMENT
	CLABEL(P2);
	SDXLEV:= DXLEV; DXPEND:= true;	\MARK REG VAR PENDING
	repeat RATOM; STATEMENT until ATOM#^;;
	if ATOM#UNTSYM then [ERROR(28); SKIPIT; return];
	RATOM;
	BOOLEXP;
	GENJPC(P2,false);
	if DXPEND & DXLEV>=0 then
	\RESTORE REG VAR (DX) IF IT'S STILL PENDING & NOTHING ELSE BOMBED IT
		[DXLEV:= SDXLEV; DXPEND:= false];
	end;

WHILYM:	begin				\     while BOOLEXP do STATEMENT
	DOALIGN;			\LABELS: P1^        P2^       P3^
	P1:= NEWLAB;
	CLABEL(P1);
	SDXLEV:= DXLEV; DXPEND:= true;	\MARK REG VAR PENDING
\The 'for' loop control variable is shadowed by the register DX. When DX is
\ 'pending' because of the while loop, the actual memory value that DX shadows
\ must be fetched, rather than fetching DX, because DX could be bombed later
\ in the while loop. But if the actual memory value is fetched, DX must be
\ bombed, otherwise the actual memory value will not be incremented at end of
\ the for loop. This complication is endured only because it shaves 10% off the
\ time for the Sieve benchmark; it is rarely encountered anywhere else. The
\ straightforward thing would be to simply say that DX is bombed because of the
\ label at the top of the while loop, i.e. say: DXLEV:= -1 at this point.

	if SHORTBOOL then
		begin
		P2:= NEWLAB;		\TRUE LABEL
		P3:= NEWLAB;		\FALSE LABEL
		P3:= SHORTER(P2, P3);	\RETURNS FALSE LABEL
		end
	else	begin
		RATOM;
		BOOLEXP;
		P3:= NEWLAB;
		GENJPC(P3,false);
		end;
	if ATOM # DOSYM then [ERROR(23); SKIPIT; return];
	RATOM;
	STATEMENT;
	GENJMP(P1);
	CLABEL(P3);
	if DXPEND & DXLEV>=0 then
	\RESTORE REG VAR (DX) IF IT'S STILL PENDING & NOTHING ELSE BOMBED IT
		[DXLEV:= SDXLEV; DXPEND:= false];
	end;

RETSYM:	begin				\RETURN STATEMENT
	RATOM;
	GENDRP(STKLOD);
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;			\ VALUE IN AX OR GLOBAL #0
		if FACTYP=INTEGER then
			[if LEVEL=0 & ~OPTPROC then GENSTO(0, 0)
			else [TOS2AX; PDROP(1)]]
		else GENFSTO(0, 0)];
	if OPTPROC then GENRTS(LEVEL)
	else GENRET(LEVEL);
	DXLEV:= -1;			\MIGHT BE JUMPING OUT OF A FOR LOOP AND
	end;				\ DX IS NOT = TO ITS MEMORY LOC HERE
					\ AND IT MIGHT BE GLOBAL
LOOPYM:	begin				\LOOP STATEMENT
	SFIXS:= FIXCNT;
	RATOM;
	DOALIGN;
	P2:= NEWLAB;
	CLABEL(P2);
	SDXLEV:= DXLEV; DXPEND:= true;	\MARK REG VAR PENDING
	SSTATEMENT(STKLOD);
	GENJMP(P2);
	while FIXCNT>SFIXS do		\FIX THE JUMPS FOR THE 'QUIT'S
		[FIXCNT:= FIXCNT-1; CLABEL(FIXES(FIXCNT))];
	if DXPEND & DXLEV>=0 then	\QUIT BOMBS DX, SO DXLEV IS NOT RESTORED
	\RESTORE REG VAR (DX) IF IT'S STILL PENDING & NOTHING ELSE BOMBED IT
		[DXLEV:= SDXLEV; DXPEND:= false];
	end;

FORSYM:	begin				\FOR STATEMENT
	LOPARAMS:= RESERVE(3*2);	\OPTIMIZE WHEN LIMITS ARE IMMEDIATE
	HIPARAMS:= RESERVE(3*2);
	RATOM;
	if ATYPE#IDENTIFIER then [ERROR(33); SKIPIT; return];
	LOOKUP;
	if IDTYPE=UNDEF then ERROR(10)
	else if IDTYPE#INVAR & IDTYPE#ADDRVAR then ERROR(33);
	SLEV:= LEV; SVAL:= VAL;
	RATOM;
	if ATOM#GETSYM then [ERROR(21); SKIPIT; return];
	RATOM;
	BOOLEXP;
	LOPARAMS(0):= PSTKTYP(PSTKPTR-1);
	LOPARAMS(1):= PSTKLEV(PSTKPTR-1);
	LOPARAMS(2):= PSTKOFF(PSTKPTR-1);

	if FACTYP#INTEGER then ERROR(47);
	GENSTO(SLEV, SVAL);

	DOWNTO:= false;
	if ATOM=TOSYM ! ATOM=^, then []
	else if ATOM=DOWNYM then DOWNTO:= true
	else [ERROR(24); SKIPIT; return];

	RATOM;
	BOOLEXP;
	HIPARAMS(0):= PSTKTYP(PSTKPTR-1);
	HIPARAMS(1):= PSTKLEV(PSTKPTR-1);
	HIPARAMS(2):= PSTKOFF(PSTKPTR-1);

	if HIPARAMS(0)#IMMTYP then TOS2STACK;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];

	\PUT COPY OF CONTROL VARIABLE INTO DX
	if SLEV=AXLEV & SVAL=AXOFF then
		[TTXT("	XCHG	DX,AX|");	\OPTIMIZE - ONE BYTE
		AXLEV:= -1; AXIMM:= false; AHZERO:= false] \(IS DESTROYED ANYWAY)
	else	OPSTRING("	MOV	DX,&|", ^A, SLEV, SVAL, 0);
	DXLEV:= SLEV; DXOFF:= SVAL; DXPEND:= false;

	\WE DON'T NEED TO JMP TO FOR OP IF LOOP LIMITS ARE IMMEDIATE VALUES (AND
	\ LOW LIMIT <= HI LIMIT) BECAUSE THE LOOP WILL BE EXECUTED AT LEAST ONCE
	FLAG:= LOPARAMS(0)=IMMTYP & HIPARAMS(0)=IMMTYP &
		(if DOWNTO then LOPARAMS(1)>=HIPARAMS(1)
		else LOPARAMS(1)<=HIPARAMS(1));
	if ~FLAG then		\OPTIMIZE JMP
		begin
		if HIPARAMS(0)=IMMTYP & HIPARAMS(1)=0 then
			TTXT("	TEST	DX,DX|");	\CMP DX,0 OUTSIDE LOOP
		P2:= NEWLAB;
		GENJMP(P2);
		end;
	DOALIGN;
	P3:= NEWLAB;
	CLABEL(P3);

	RATOM;
	STKLOD:= STKLOD+1;
	STATEMENT;
	STKLOD:= STKLOD-1;
	GENINP(SLEV, SVAL, DOWNTO);
	if ~FLAG then CLABEL(P2);
	GENFOR(SLEV, SVAL, P3, HIPARAMS(0), HIPARAMS(1), DOWNTO);
	end;

EXITYM:	[RATOM;				\EXIT STATEMENT
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;			\ VALUE IN GLOBAL #0
		if FACTYP=INTEGER then GENSTO(0, 0) else GENFSTO(0, 0)];
	GENEXIT];

ELSEYM, OTHSYM, ^;, ^], ENDSYM, UNTSYM:	[];

EOF:	[]				\(THIS IS MOSTLY AN ACADEMIC POINT)
other	ASSIGN;
end;	\STATEMENT



begin	\SSTATEMENT
\TRICK TO ADJUST STACK (WITH DRP'S) WHEN A 'QUIT' IS IN A 'CASE' STATEMENT.
STATEMENT;
end;	\SSTATEMENT

\-------------------------------------------------------------------------------

proc	PROCEDURE; int SSNOX;	\"SSNO" FROM "PROCDEC" FOR OPTIMIZED PROCEDURES
int	SLEVEL,		\SAVE LEVEL (COMPLICATED BY OPTIMIZED PROCEDURES)
	K, I, P1,
	HEAPSP,		\HEAP SPACE REQUIREMENT COUNTER (FORMERLY CALLED DX)
	HEAPSPOFF,	\VARIABLE'S OFFSET FROM BASE (=HEAPSP IF NO ARRAYS)
	HAVEGENBASE,	\FLAG: HAVE GENERATED BASE CODE FOR PROCEDURE
	HAVESTART,	\FLAG: HAVE GENERATED START-UP CODE FOR PROGRAM
	OLDCNT,		\OLD SEGMENT COUNT
	OLDCOD,		\OLDCODCNT TO SEE IF THERE IS CODE IN MAIN PROC
	FPBASE,		\PC AT END OF DECLARATIONS
	FPROCNT;	\COUNT OF PENDING FORWARD PROCEDURES



proc	EATARGS;	\SKIP ARGUMENTS IN PARENTHESES
begin
if ATOM=^( then
	begin
	loop	[if CHAR=^) then quit;
		if CHAR=$0D\CR\ then [ERROR(44); quit];
		GETCH];
	GETCH; RATOM;
	end;
end;	\EATARGS



proc	CODDEC;		\DECLARE INTRINSIC NAMES
int	SID;
begin
SID:= ININT;		\DEFAULT IS INTEGER INTRINSIC
RATOM;
if ATOM=REALYM then [SID:= RLINT; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[RATOM;
	EATARGS;
	if ATOM#^= then ERROR(40);
	RATOM;
	GETCON; if FACTYP#INTEGER then ERROR(47);
	if IATOM<0 ! IATOM>127 then ERROR(7);
	INSERT(SID, LEVEL, IATOM);
	RATOM;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\CODDEC



proc	CONDEC;		\DECLARE CONSTANT NAMES
int	CNTR, SSNO;
begin
RATOM;
CNTR:= 0;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	if ATOM#^= then [INSERT(INCON, LEVEL, CNTR); CNTR:= CNTR+1]
	else	begin
		SSNO:= NOSYM;
		INSERT(INCON, LEVEL, NORLSY);	\INSERT ID NOW
		RATOM;				\ FIX UP PARMS LATER
		CONEXPRESS;
		if FACTYP=INTEGER then [SYMVAL(SSNO):= IATOM; CNTR:= IATOM+1]
		else	[SYMTYP(SSNO):= RLCON;	\FACTYP=REAL
			if NORLSY>=RLMAX then
				[ERROR(2); NORLSY:= RLMAX-1];
			RLTBL(NORLSY):= RLATOM;
			NORLSY:= NORLSY+1];
		end;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\CONDEC



proc	CHECKBASE;	\GENERATE BASE INIT CODE FOR PROCEDURE IF NOT DONE
begin
if not HAVEGENBASE then
	begin
	if not HAVESTART then
		if LEVEL=0 then [GENSTART; HAVESTART:=true];
		\BEWARE OF MORE THAN 64K OF EPROCs
	HAVENEST:= true;		\ASSUME WORST CASE
	GENBASE(LEVEL,HEAPSP);
	HEAPSP:= 0;			\it's been reserved (don't do it again)
	OPTPROC:= false;
	HAVEGENBASE:= true;
	end;
end;	\CHECKBASE



proc	VARDEC(TYPE);	\DECLARE VARIABLES--INT, REAL & ADDR
int	TYPE;
int	SHEAPSP,DIMS,T,ST;
begin
RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	INSERT(TYPE,LEVEL,HEAPSPOFF);
	SHEAPSP:=HEAPSPOFF;
	HEAPSPOFF:=HEAPSPOFF +(if TYPE=RLVAR then RLSIZE else 2);
	T:=if TYPE=RLVAR then RLSIZE else 2;
	ST:= T;
	if TYPE=ADDRVAR then ST:=1;
	RATOM;
	if ATOM=^( then		\GET DIMENSIONS OF AN ARRAY
		begin
		CHECKBASE;
		if HEAPSP#0 then [GENHPI(HEAPSP); HEAPSP:=0];
		DIMS:= 0;
		loop	begin
			RATOM;
			CONEXPRESS;
			if FACTYP#INTEGER then ERROR(47);
			\PUSH SIZES OF EACH DIMENSION ON STACK
			GENIMM(^C,IATOM);
			TOS2STACK; PDROP(1);
			DIMS:= DIMS +1;		\COUNT NUMBER OF DIMENSIONS
			if ATOM # ^, then	\last dimension of char array is
				begin		\ only a single byte per entry
				if ST=1 then T:=T>>1;
				T:=T*IATOM;
				HEAPSPOFF:=HEAPSPOFF+T;
				quit;
				end;
			T:=T*IATOM;    \ACCUMULATE BYTE COUNT FOR EACH DIMENSION
			HEAPSPOFF:=HEAPSPOFF+T;	\OFFSET FROM BASE
			end;
		\if ST=1 then
		\	HEAPSPOFF:=(HEAPSPOFF+1) & $FFFE; \\ALIGN EVEN	***BUG
		if ATOM#^) then ERROR(44) else RATOM;

		\GEN CODE TO SET UP ARRAY AT RUN TIME, FOR EXAMPLE:
		\GEN CALL MakeArray( (3, 5, 7, 11), 4, 2);
		GENIMM(^C,DIMS);	\NUMBER OF DIMENSIONS (4)
		TOS2STACK; PDROP(1);
		GENIMM(^C,ST);		\NUMBER OF BYTES IN EACH ELEMENT (2)
		TOS2AX; PDROP(1);
		GENARY;
		end
	else	HEAPSP:= HEAPSP + (if TYPE=RLVAR then RLSIZE else 2);
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\VARDEC



proc	SEGDEC;		\DECLARE SEGMENT VARIABLES
begin
RATOM;
case ATOM of
	INTSYM: VARDEC(INSEG);
	REALYM: VARDEC(RLSEG);
	ADRSYM, CHARYM: VARDEC(ADSEG);
	SHTSYM: VARDEC(SHSEG)
else ERROR(72);
end;	\SEGDEC



proc	EXTDEC(XPL);	\DECLARE EXTERNAL PROCEDURES
int	XPL;		\XPL-TYPE EXTERNAL (EPROC) RATHER THAN ASSEMBLY (EXT)
int	SID, D;
begin
\HANDLE XPL VS. ASSEMBLY TYPE EXTERNAL. THE DEFAULT IS INTEGER EXTERNAL.
SID:= if XPL then INEPRO else INEXT;

RATOM;					\HANDLE REAL VS INTEGER PROCEDURE
if ATOM=REALYM then [SID:= if XPL then RLEPRO else RLEXT; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);

D:= 0;
while ATYPE=IDENTIFIER do
	begin
	INSERT(SID, LEVEL, IATOM);
	RATOM;
	EATARGS;
	if ATOM=^, then RATOM;
	TTXT("	EXTRN	");
	if XPL then CHOUT(BINDEV, ^_); 
	SYMOUT(NOSYM-1);
	if ~XPL ! ~OPTCALL then TTXT(":FAR")  \ASSEMBLY EXTERNALS ARE ALWAYS FAR
	else TTXT(":NEAR");
	D:= D+1;
	CRLF(BINDEV);
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\EXTDEC



proc	FPRDEC;		\DECLARE FORWARD REFERENCED PROCEDURES
int	SID, I;
begin
SID:= INFPROC;		\DEFAULT TYPE
RATOM;
if ATOM=REALYM then [SID:= RLFPROC; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	I:= NEWLAB;
	INSERT(SID, LEVEL, I);
	FLABEL(I);
	GENFJMP(NEWLAB);
	FPROCNT:= FPROCNT+1;
	EATARGS;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\FPRDEC



proc	PROCDEC(CANOPT, PUBLIC);	\DECLARE PROCEDURE NAMES
int	CANOPT, PUBLIC;
int	SNOSYM, HASH, I, K, SID, SSNO, SNORL;
begin
SID:= INPROC;				\TYPED PROCEDURE (FOR FUNCTIONS)
RATOM;
if ATOM=REALYM then [SID:= RLPROC; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45) else LOOKUP;

if DEEPER then OLDCNT:= SEGCNT;		\SET UP NEXT NESTED SEGMENT
DEEPER:= true;
SEGCNT:= SEGCNT+1;
STARTSEG(LEVEL+2, SEGCNT);

if IDTYPE=INFPROC ! IDTYPE=RLFPROC then
	\PROCEDURE HAS BEEN PREVIOUSLY DECLARED BY A 'FPROC' OR 'FFUNCT'
	begin
	if LEVEL#LEV then ERROR(65);	\('FPROC' & 'PROC' MUST BE SAME SCOPE)
	if PUBLIC then			\HANDLE PUBLIC PROCEDURES
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(SYMNUM);
		TTXT("|_");
		SYMOUT(SYMNUM);
		TTXT(":|");
		end;
	FLABEL(VAL+1);
	SYMVAL(SYMNUM):= VAL+1;
	SYMTYP(SYMNUM):= if IDTYPE=INFPROC then INPROC else RLPROC;
	if SID#SYMTYP(SYMNUM) then \MIXED MODE\ ERROR(46);
	if VAL>=FPBASE then FPROCNT:= FPROCNT-1;
	OPTPROC:= false;
	end
else	begin
	SSNO:= NOSYM;
	I:= NEWLAB;
	INSERT(SID, LEVEL, I);
	if PUBLIC then			\HANDLE PUBLIC PROCEDURES
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(NOSYM-1);
		TTXT("|_");
		SYMOUT(NOSYM-1);
		TTXT(":|");
		end;
	FLABEL(I);
	OPTPROC:= CANOPT;
	end;

\ASSUME FOR NOW THAT PROCEDURE IS NOT OPTIMIZED AND MOVE DOWN A LEVEL
SLEVEL:=LEVEL;
LEVEL:= LEVEL+2; if LEVEL >= LEVELMAX*2 then ERROR(5);
\EAT THE ARGUMENT LIST AS A COMMENT. SPECIAL COMMENT STOPS ON CR.
while CHAR#^; & CHAR#\CR\$0D do GETCH;
if CHAR#^; then ERROR(41);
GETCH; RATOM;

SNOSYM:= NOSYM; SNORL:= NORLSY;
PROCEDURE(SSNO);	\PASS LOCATION OF PROC NAME IN CASE IT'S OPTIMIZED
if ATOM#^; then ERROR(41) else RATOM;
while NOSYM>SNOSYM do	\RESTORE SYMBOL TABLE TO PREVIOUS LEVEL
	begin		\I.E. REMOVE IDENTIFIERS WHICH WERE LOCAL TO THIS PROCEDURE
	NOSYM:= NOSYM-1;
	HASH:= 0; K:= NOSYM;
	for I:= 0, SIGCHAR-1 do
		[HASH:= HASH+SYMBOL(K); K:= K+SYMAX];
	BOX(HASH&HASHMSK):= SYMPNT(NOSYM);
	end;
NORLSY:= SNORL;
LEVEL:= SLEVEL;

STARTSEG(LEVEL, OLDCNT);		\END CURRENT SEGMENT
DEEPER:= false;
HAVENEST:= true;
end;	\PROCDEC



begin	\PROCEDURE
DXLEV:= -1;				\WE DON'T KNOW WHAT'S IN DX
AXLEV:= -1;
AXIMM:= false;
AHZERO:= false;
STXFLAG:= false;
POSTGENTYPE:= 0;
HAVENEST:= false;

HEAPSPOFF:= if LEVEL=0 then RLSIZE else 0;	\SAVE HEAP SPACE FOR RETURN
HEAPSP:= HEAPSPOFF;
HAVEGENBASE:= false;
HAVESTART:= false;

FPROCNT:= 0;
FPBASE:= LABCNT;

repeat
  loop	begin
	case ATOM of
	  INTSYM: VARDEC(INVAR);
	  ADRSYM: VARDEC(ADDRVAR);
	  CHARYM: VARDEC(ADDRVAR);
	  REALYM: VARDEC(RLVAR);
	  SEGSYM: SEGDEC;
	  CODSYM: CODDEC;
	  EXTNYM: EXTDEC(false);
	  DEFSYM: CONDEC;
	  EPRSYM, EFUNYM:
		  if LEVEL=0 then EXTDEC(true) else [ERROR(68); SKIPIT]
	other	quit;
	end;

  if not HAVESTART then
	if LEVEL=0 then [GENSTART; HAVESTART:=true];
	\BEWARE OF MORE THAN 64K OF EPROCs

  \SEE IF THERE ARE ANY NESTED PROCEDURES WE NEED TO JUMP OVER
  case ATOM of
    PUBSYM, PROCYM, FUNSYM, FPRSYM, FFUNYM:
	begin
	P1:= NEWLAB;
	GENJMP(P1);
	end
  other P1:= 0 \NULL\;

  loop	begin
	case ATOM of
	  PUBSYM:
		[if LEVEL#0 then ERROR(68);
		RATOM;
		case ATOM of PROCYM, FUNSYM: PROCDEC(false, true)
		other ERROR(67)];
	  PROCYM, FUNSYM:
		PROCDEC(true, false);
	  FPRSYM, FFUNYM:
		FPRDEC
	other	quit;
	end;

  if P1#0 then CLABEL(P1);

until	ATOM#INTSYM & ATOM#ADRSYM & ATOM#CHARYM & ATOM#REALYM & ATOM#SEGSYM &
	ATOM#CODSYM & ATOM#EXTNYM & ATOM#DEFSYM & ATOM#EPRSYM & ATOM#EFUNYM;

if HEAPSPOFF#0 then OPTPROC:=false;
if OPTPROC then
	begin
	SYMTYP(SSNOX):= if SYMTYP(SSNOX)=INPROC then INOPT else RLOPT;
	LEVEL:=LEVEL-2;	\SAME LEVEL AS NESTING PROCEDURE (TRICKY!)
	OPTNEWLEVEL(LEVEL);
	end
else	begin		\RESERVE SPACE FOR LOCAL VARIABLES (IF NOT ALREADY DONE)
	if not HAVEGENBASE then GENBASE(LEVEL,HEAPSP)
	else GENHPI(HEAPSP);
	end;

OLDCOD:= CODCTR;			\IS THERE CODE IN THE MAIN PROCEDURE?
SSTATEMENT(STKLOD);			\(STKLOD WILL ALWAYS BE ZERO HERE)
HASMAIN:= CODCTR # OLDCOD;

if OPTPROC then GENRTS(LEVEL) else GENRET(LEVEL);

if FIXCNT#0 then \SOME 'QUIT'S NOT IN A 'LOOP'\ ERROR(60);
if FPROCNT#0 then \UNRESOLVED FWD REFERENCES\ ERROR(66);
end;	\PROCEDURE

\------------------------ ROUTINES TO OPEN DOS FILES ---------------------------

proc	DOSOPEN;
int	CPUREG, PSPSEG, DATASEG, T;
char	CMDTAIL;

	func	GETSWT;		\FIND, REMOVE AND RETURN A SWITCH
	int	P, T;
	begin
	for P:= 1, CMDTAIL(0) do
	    if CMDTAIL(P)=^/ then
		begin
		CMDTAIL(P):= $20;
		if P < CMDTAIL(0) then
			begin
			T:= CMDTAIL(P+1);
			if T>=^a & T<=^z then T:= T-$20; \MAKE UPPERCASE
			CMDTAIL(P+1):= $20;
			return T;
			end;
		end;
	return 0;
	end;	\GETSWT


	proc	PARSE;		\PARSE COMMAND TAIL AND SET I/O HANDLES
	char	EXTIN, EXTOUT;
	int	P, P0, EXTFLG, I;
	begin
	EXTIN:= ".XPL";   EXTOUT:= ".ASM";
	P:= 1;
	EXTFLG:= false;
	loop	begin			\PARSE COMMAND TAIL FOR EXTENSION
		if CMDTAIL(P) = ^. then
			begin
			EXTFLG:= true;
			quit;
			end;
		if CMDTAIL(P) = ^; then quit;	\IGNORE SEMICOLON
		if P > CMDTAIL(0) then quit;	\if quit then P points to CR
		P:= P + 1;
		end;

	\Back up over any trailing spaces (caused by switches)
	repeat P:= P - 1 until CMDTAIL(P) # ^ ;
	P:= P + 1;

	if not EXTFLG then			\SET EXTENSION AND INPUT HANDLE
		for I:= 0, 3 do CMDTAIL(P+I):= EXTIN(I);
	INHAND:= FOPEN(CMDTAIL+1, 0);

	for I:= 0, 3 do CMDTAIL(P+I):= EXTOUT(I); \SET EXTENSION & OUTPUT HANDLE
	OUTHAND:= FOPEN(CMDTAIL+1, 1);

	\COPY FILE NAME INTO FNAME
	P0:= P - 1;			\P0 points to last character in file name
	repeat	P:= P - 1;
	until	CMDTAIL(P)=^  ! CMDTAIL(P)=^\ ! CMDTAIL(P)=^:;

	P:= P + 1;			\point to first character of file name
	for I:= 0, 7 do
		begin
		FNAME(I):= CMDTAIL(P+I);
		if P+I=P0 ! I=7 then
			begin
			FNAME(I):= FNAME(I) ! $80;
			I:= 7;
			end;
		end;
	end;	\PARSE


begin	\DOSOPEN
CMDTAIL:= RESERVE($80+4);	\GET COMMAND TAIL FROM PSP
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

loop	begin				\HANDLE SWITCHES
	T:= GETSWT;
	case T of
	  ^2:	OPTIMIZE:= OPT286;
	  ^3:	OPTIMIZE:= OPT386;
	  ^J:	OPTJPC:= true;		\OPTIMIZED JUMPS (USE MASM 6)
	  ^S:	OPTCALL:= true;		\SMALL MODEL
	  ^B:	SHORTBOOL:= true;	\SHORT-CIRCUIT BOOLEAN EVALUATION
	  ^D:	DEBUG:= true;
	  ^L:	LSTDEV:= 0;
	  ^C:	COMFLG:= true;
	  ^A:	[BINDEV:= 0; LSTDEV:= 7];
	   0:	quit			\NO MORE SWITCHES ON COMMAND LINE
	other	begin
		TEXT(TV,"UNRECOGNIZED SWITCH: /"); CHOUT(TV, T); CRLF(TV);
		TEXT(0, "Usage: XPLX [options] source
   /A: Display Assembly code
   /B: Short circuit Boolean evaluations
   /C: Include I2L Comments in output
   /D: Include XPL source in output (Debug)
   /J: Generate short conditional Jumps (handled by MASM 6)
   /L: Display source code Listing
   /S: Generate Small (<64K) code
   /2: Align loops on word boundaries
   /3: Align loops on dword boundaries
");
		exit 1;
		end;
	end;
PARSE;					\PARSE COMMAND LINE AND SET HANDLES
FSET(INHAND, ^I);
FSET(OUTHAND, ^O);
end;	\DOSOPEN

\-------------------------------------------------------------------------------

begin	\MAIN
IDENT:= RESERVE(SIGCHAR);
PROCRETS:= RESERVE(LEVELMAX*2);
FIXES:= RESERVE(2*QUITMAX);
SYMBOL:= RESERVE(SIGCHAR*SYMAX);	\SYMBOL TABLE
SYMTYP:= RESERVE(SYMAX);
SYMVAL:= RESERVE(SYMAX*2);
SYMLEV:= RESERVE(SYMAX);
SYMPNT:= RESERVE(SYMAX*2);
BOX:= RESERVE(BOXNUM*2);		\HASH TABLE
RLTBL:= RLRES(RLMAX);
HEXDIGIT:= "0123456789ABCDEF ";

PSTKTYP:= RESERVE(STKMAX*2);		\INTERNAL OPTIMIZING (PSEUDO) STACK
PSTKLEV:= RESERVE(STKMAX*2);
PSTKOFF:= RESERVE(STKMAX*2);

FNAME:= RESERVE(8);
OLDHAN:= RESERVE(HANMAX*2);		\SET INCLUDE ARRAYS

TEXT(TV, "
-- XPL0 NATIVE OPTIMIZING COMPILER, VER O3.0 --
          COPYRIGHT 2012 P.J.R. BOYLE

XPL0 comes with ABSOLUTELY NO WARRANTY.
This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.TXT.

");
OPTIMIZE:= OPT88;			\DEFAULT OPTIMIZATION IS 8088
OPTJPC:= false;
OPTCALL:= false;
SHORTBOOL:= false;
DEBUG:= false;
COMFLG:= false;
BINDEV:= 3; LSTDEV:= 8; SRCDEV:= 3;
DOSOPEN;
OPENO(BINDEV); OPENO(LSTDEV); OPENI(SRCDEV);

LABCNT:= 0; LEVEL:= 0;			\INITIALIZE SOME STUFF
for II:= 0, LEVELMAX-1 do PROCRETS(II):= 0;
STKLOD:= 0; NOSYM:= 0; NORLSY:= 0; FIXCNT:= 0;
for II:= 0, BOXNUM do BOX(II):= EMTPNT;	\ZERO THE SYMBOL TABLE
ERRCNT:= 0;
LASTOP:= -1\NUL\;
HAVESTAT:= false;
PSTKPTR:= 0; HANPTR:= 0;
SEGCNT:= 0; DEEPER:= true;		\INITIALIZE SEGMENT STUFF
LOCAL:= 0;
OLDLEV:= -1;
CODCTR:= 0;
OLDCODCTR:= CODCTR;
CONDITIONAL:= true;
STRTERM:= -1;	\default to MSB string termination (nonzero)

TTXT("	PAGE	240,132|");		\MINIMIZE USELESS HEADERS (TASM LIMIT)
GETCH; RATOM;
OPTPROC:= false;			\(FOR 2 REASONS)
PROCEDURE(0);				\COMPILE MAIN PROCEDURE, I.E. THE PROGRAM
while ATOM=^; do RATOM;
if ATOM#EOF then \MORE CODE AFTER END\ [ERROR(61); PROCEDURE(0)];

\IF PROGRAM HAS A 'MAIN', MAKE IT PUBLIC
if HASMAIN then TTXT("	PUBLIC	PROGRM|");
GENEND;

CHOUT(BINDEV, EOF);
CLOSE(BINDEV);

CRLF(LSTDEV);
TEXT(LSTDEV, "ERRORS DETECTED: "); INTOUT(LSTDEV, ERRCNT); CRLF(LSTDEV);
CLOSE(LSTDEV);
CRLF(TV);

FCLOSE(OUTHAND);
FCLOSE(INHAND);
return if ERRCNT#0 then 1 else 0;
end;	\MAIN
