	PAGE

;**************************************
;***** TRANSCENDENTAL FUNCTIONS *******
;**************************************

SQRERR	EQU	10	;SQUARE ROOT ERROR
LNERR	EQU	11	;LOGARITHM ERROR
EXPERR	EQU	12	;EXPONENTIAL ERROR
AT2ERR	EQU	14	;ATAN2(0.0,0.0) IS UNDEFINED


;DO SQUARE ROOT ON UNPACKED TEMPORARY REAL IN FACT1

FSQRTE:	MOV	AX,FACT1+10	;GET TAG AND SIGN BYTES
	OR	AH,AH		;ZERO OR SPECIAL VALUE?
	JNZ	FSQEXT		;EXIT IF SO
	OR	AL,AL		;NEGATIVE?
	JZ	FSQRT1		;SKIP IF NOT

	MOV	AL,SQRERR	;FLAG THE ERROR
	CALL	ERROR		;HANDLE THE ERROR

;SETUP PROPER VALUE TO RETURN FOR THIS TYPE OF ERROR

	MOV	SI,OFFSET SPECTR	;USE SPECIAL CONSTANT
	MOV	DI,OFFSET FACT1		;REPLACE FACT1
	JMP	FCOPY			;COPY IT

;GENERATE FIRST GUESS BY DIVIDING EXPONENT BY TWO

FSQRT1:	MOV SI,OFFSET FACT1	;COPY FACT1 INTO FACT3
	MOV DI,OFFSET FACT3
	CALL	FCOPY
	SAR	FACT1+8,1	;DIVIDE EXPONENT BY 2

;NOW DO 6 INTERATION OF NEWTONS ALGORITHM

	MOV	CX,6		;SET FOR SIX
FSQRT2:	PUSH	CX		;SAVE COUNTER
	CALL	NEWTON		;DO NEWTON
	POP	CX		;GET COUNTER
	LOOP	FSQRT2		;LOOP TIL DONE
FSQEXT:	RET
	PAGE

;DO A SINGLE ITERATION USING NEWTON-RAPHSON METHOD

NEWTON:	MOV DI,OFFSET FACT3	;FACT2:=FACT3/FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,OFFSET FACT2
	CALL	FDIVE

	MOV DI,OFFSET FACT1	;FACT1:=FACT1+FACT2
	MOV SI,OFFSET FACT2
	MOV RESLTP,OFFSET FACT1
	CALL	FADDE

	DEC	FACT1+8		;FACT1:=FACT1/2
	RET


;ROUTINE TO GENERATE THE MODULO FUNCTION
;OF VALUES IN FACT1 AND FACT2
;FACT1 := FRACTION(FACT1/FACT2) * FACT2

FMOD:	CALL	SETFAG		;FACT1:=FACT1/FACT2
	CALL	FDIVE
	CALL	FRACTN		;FACT1:=FRACTION(FACT1)
	CALL	SETFAG		;FACT1:=FACT1*FACT2
	JMP	FMULE
	PAGE

;ROUTINE TO RETURN THE FRACTIONAL PART OF THE TEMPORARY
;REAL IN FACT1

FRACTN:	CMP BYTE PTR FACT1+11,0	;TEST TAG BYTE
	JNE	FRACTX		;EXIT IF ZERO OR SPECIAL

	MOV	SI,FACT1+8	;GET EXPONENT
	CMP	SI,0		;EXP<0 THEN N<1
	JL	FRACTX		;EXIT IF ALREADY FRACTION
	CMP	SI,63		;EXP>=63, NO FRACTION
	JL	FRACT0		;SKIP IF NOT
	MOV RESLTP,OFFSET FACT1	;ZERO FACT1
	JMP	ZFACT

;SHIFT LEFT UNTIL INTEGER PART IS GONE

FRACT0:	MOV	AX,FACT1+6	;LOAD MANTISSA
	MOV	BX,FACT1+4
	MOV	CX,FACT1+2
	MOV	DX,FACT1

FRACT1:	CMP	SI,16		;EXP>=16?
	JL	FRACT2		;SKIP IF NOT
	MOV	AX,BX		;DO 16 BIT SHIFT
	MOV	BX,CX
	MOV	CX,DX
	XOR	DX,DX
	SUB	SI,16
	JMP	FRACT1		;LOOP
	PAGE

FRACT2:	CMP	SI,8		;EXP>=8
	JL	FRACT3		;SKIP IF NOT
	MOV	AH,AL		;DO 8 BIT SHIFT
	MOV	AL,BH
	MOV	BH,BL
	MOV	BL,CH
	MOV	CH,CL
	MOV	CL,DH
	MOV	DH,DL
	XOR	DL,DL
	SUB	SI,8
	JMP	FRACT2

FRACT3:	CMP	SI,0		;EXP<0
	JL	FRACT4		;EXIT IF SO
	SHL	DX,1		;DO ONE BIT SHIFTS
	RCL	CX,1
	RCL	BX,1
	RCL	AX,1
	DEC	SI		;DECREMENT EXP
	JMP	FRACT3

;NOW SETUP AND TAKE NORMIZE EXIT

FRACT4:	PUSH	BP		;SAVE BP
	MOV	DI,AX		;PUT M3 IN DI
	XOR	BP,BP		;ZERO EXTRA MANTISSA
	MOV AX,FACT1+10		;GET SIGN
	XCHG AL,AH		;SWAP BYTES
	PUSH	AX		;SET SIGN
	MOV RESLTP,OFFSET FACT1	;PUT RESULT HERE
	JMP	FNOR
FRACTX:	RET
	PAGE

;THIS ROUTINE RETURNS THE SINE OF THE UNPACKED TEMPORARY
;REAL IN FACT1

FSINE:	CMP WORD PTR FACT1+8,-16	;FACT1 <= 2^-16
	JLE	FSIN1			;THEN EXIT
	MOV	DI,OFFSET HALFPI	;FACT1:=PI/2-FACT1
	MOV	SI,OFFSET FACT1
	MOV	RESLTP,SI
	CALL	FSUBE
	JMP SHORT FCOSINE
FSIN1:	RET


;THIS ROUTINE RETURN THE TANGENT OF THE UNPACKED TEMPORARY
;REAL IN FACT1

FTAN:	MOV	SI,OFFSET FACT1	;FACT3:=FACT1
	MOV	DI,OFFSET FACT3
	CALL	FCOPY
	CALL	FSINE		;FACT1:=SIN(FACT1)
	MOV	SI,OFFSET FACT1	;SWAP FACT1 AND FACT3
	MOV	DI,OFFSET FACT3
	CALL	FSWAP
	CALL	FCOSINE		;FACT1:=COS(FACT1)
	MOV	DI,OFFSET FACT3	;FACT1:=FACT3/FACT1
	MOV	SI,OFFSET FACT1
	MOV RESLTP,OFFSET FACT1
	JMP	FDIVE
	PAGE

;THIS ROUTINE RETURNS THE COSINE OF THE UNPACKED TEMPORARY
;REAL IN FACT1

FCOSINE:MOV BYTE PTR FACT1+10,0	;FORCE POSITIVE
	MOV	SI,OFFSET FACT1	;TEST FACT1 > 2*PI
	MOV	DI,OFFSET PI2
	CALL	FCMPT		;COMPARE
	JBE	FCOS1		;SKIP IF <= 2*PI

	MOV	SI,OFFSET PI2	;TAKE MODULO 2*PI
	MOV	DI,OFFSET FACT2
	CALL	FCOPY
	CALL	FMOD

;WHICH QUADRANT ARE WE IN?

FCOS1:	MOV	SI,OFFSET FACT1	;FACT1 < PI/2?
	MOV	DI,OFFSET HALFPI
	CALL	FCMPT
	JAE	FCOS2		;SKIP IF NOT
	JMP SHORT COSQD1	;DO 1ST QUADRANT

FCOS2:	MOV	SI,OFFSET FACT1	;FACT1 < PI*3/2
	MOV DI,OFFSET HALFPI3
	CALL	FCMPT
	JAE	COSQD4		;DO QUAD 4
	JMP SHORT COSQD2	;DO QUAD 2
	PAGE

;HANDLE FIRST QUADRANT

COSQD1:	CMP WORD PTR FACT1+8,-19;FACT1 <=  2^-19?
	JLE	GETONE		;THEN RESULT IS ONE

COSQ11:	MOV	PTERMS,9	;SET 9 TERMS
	MOV POLPTR,OFFSET COSP	;POINT TO COEFFICIENTS
	JMP	POLLY		;DO THE POLYNOMIAL

;HANDLE SECOND AND THIRD QUADRANT

COSQD2:	MOV	SI,OFFSET FACT1	;FACT1-PI
	MOV	DI,OFFSET PI
	MOV	RESLTP,SI
	CALL	COSQ41		;SUBTRACT AND POLLY
	XOR BYTE PTR FACT1+10,80H;COMPLIMENT SIGN
	RET

;HANDLE FOURTH QUADRANT

COSQD4:	MOV SI,OFFSET PI2	;PI2-FACT1
	MOV DI,OFFSET FACT1
	MOV	RESLTP,DI
COSQ41:	CALL	FSUBE
	JMP	COSQ11		;DO POLLY

;SET FACT1=1.0

GETONE:	MOV	DI,OFFSET FACT1
	MOV	SI,OFFSET CON1
	JMP	FCOPY
	PAGE

;ARC-COSINE FUNCTION, TAKES ACOS OF FACT1
;RESULT IN FACT1

ACOS:	CALL	ASIN		;FACT1:=ASIN(FACT1)
	XOR BYTE PTR FACT1+10,80H ;FACT1:=-FACT1
	MOV DI,OFFSET FACT1	;FACT1:=FACT1+PI/2
	MOV SI,OFFSET HALFPI
	MOV RESLTP,DI
	JMP	FADDE


;ARC-SINE FUNCTION, TAKES ASIN OF FACT1
;RESULT IN FACT1

ASIN:	MOV SI,OFFSET FACT1	;FACT1=-1.0 ?
	MOV DI,OFFSET CON1M
	CALL	FCMPT
	JNE	ASIN1

	CALL	ASIN2		;FACT1:=PI/2
	MOV WORD PTR FACT1+10,80H;FACT1:=-FACT1
	RET
	PAGE

ASIN1:	MOV SI,OFFSET FACT1	;FACT1=-1.0 ?
	MOV DI,OFFSET CON1
	CALL	FCMPT
	JNE	ASIN3

ASIN2:	MOV SI,OFFSET HALFPI	;FACT1:=PI/2
	MOV DI,OFFSET FACT1
	JMP	FCOPY

ASIN3:	MOV DI,OFFSET FACT4	;FACT4:=FACT1
	MOV SI,OFFSET FACT1
	CALL	FCOPY

	MOV DI,OFFSET FACT1	;FACT1:=FACT1^2
	MOV SI,DI
	MOV RESLTP,DI
	CALL	FMULE

	MOV DI,OFFSET CON1	;FACT1:=1-FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	CALL	FSUBE

	CALL	FSQRTE		;FACT1:=SQRT(FACT1)

	MOV DI,OFFSET FACT4	;FACT1:=FACT4/FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	CALL	FDIVE
	JMP SHORT ATAN		;FACT1:=ATAN(FACT1)

	PAGE

;ARC-TANGENT FUNCTION FOR TWO PARAMETERS
; RANGE OF THE RESULT IS: BETWEEN  -PI AND PI
; FACT1:=ATAN(Y / X)
; FACT1:=ATAN(FACT1/FACT2)
;
; Y X QUADRANT  ATAN(Y/X)    USE:
; + +    1         +         ATAN
; + -    2         -         ATAN:=ATAN + PI
; - +    4         -         ATAN:=ATAN
; - -    3         +         ATAN:=ATAN - PI


ATAN2:	CMP BYTE PTR FACT2+11,1	;FACT2=0?
	JNE	ATAN21		;SKIP IF NOT
	CMP BYTE PTR FACT1+11,1 ;FACT1=0?
	JE	ATAN0		;THEN HANDLE ERROR

;FACT1:=PI/2 * SIGN(FACT1)

	MOV AL,BYTE PTR FACT1+10;GET SIGN
	MOV SI,OFFSET HALFPI	;COPY PI/2
	MOV DI,OFFSET FACT1
	CALL	FCOPY
	XOR BYTE PTR FACT1+10,AL;FIX SIGN
	RET
	PAGE

ATAN21:	TEST BYTE PTR FACT2+10,80H ;FACT2>0?
	JZ	ATANXY		;SKIP IF SO

	PUSH	 FACT1+10	;SAVE SIGN AND TAG
	CALL	ATANXY		;GET TANGENT
	MOV DI,OFFSET FACT1	;FACT1:=FACT1 +/- PI
	MOV SI,OFFSET PI
	MOV RESLTP,DI

	POP	AX		;RESTORE SIGN, TAG
	CMP	AH,01H		;TEST ZERO
	JE	ATAN22		;SKIP IF ZERO
	AND	AL,80H		;TEST POSITIVE
	JZ	ATAN22		;SKIP IF POSITIVE
	JMP	FSUBE		;FACT1:=FACT1-PI

ATAN22:	JMP	FADDE		;FACT1:=FACT1+PI

;FACT1:=ATAN(FACT1/FACT2)

ATANXY:	CALL	SETFAG
	CALL	FDIVE
	JMP SHORT ATAN

;HERE IF ATAN2(0,0) ERRRO

ATAN0:	MOV	AL,AT2ERR	;SET ERROR CODE
	JMP	ERROR
	PAGE

;ARC-TANGENT FUNCTION

ATAN:	TEST BYTE PTR FACT1+10,80H ;FACT1<0?
	JZ	ATANX		   ;SKIP IF POSITIVE
	XOR BYTE PTR FACT1+10,80H  ;FACT1:=-FACT1
	CALL	ATANX		   ;FACT1:=ATANX(FACT1)
	XOR BYTE PTR FACT1+10,80H  ;FACT1:=-FACT1
ATANXT:	RET

;FIND ARC-TANGENT FUNCTION OF A POSITIVE NUMBER

ATANX:	CMP WORD PTR FACT1+8,-19;EXP<-19 THEN FACT1<1.9E-6
	JL	ATANXT		;RETURN FACT1 IF <1.9E-6

	CMP WORD PTR FACT1+8,0	;EXP>=0 THEN FACT1>=1
	JL	ATANY		;SKIP FACT1<1
	MOV DI,OFFSET CON1	;FACT1:=1/FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	CALL	FDIVE
	CALL	ATANY		;FACT1:=ATAN(FACT1)
	MOV DI,OFFSET HALFPI	;FACT1:=PI/2-FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	JMP	FSUBE


;FIND ARC TAN OF A POSITIVE NUMBER <=1.0

ATANY:	CMP WORD PTR FACT1+8,-1	;EXP>=-1 THEN FACT1>.5
	JL	ATANY1		;SKIP IF FACT1<.5
	MOV SI,OFFSET CON75	;(X-.75)/(1+X+.75)
	CALL	ATANZ
	MOV SI,OFFSET ATAN75	;POLLY(Z,P,9)*Z+ATAN75
	JMP SHORT ATANZZ

ATANY1:	MOV SI,OFFSET CON25	;(X-.25)/(1+X+.25)
	CALL	ATANZ
	MOV SI,OFFSET ATAN25	;POLLY(Z,P,9)*Z+ATAN25
	JMP SHORT ATANZZ
	PAGE

;DO (FACT1-K)/(1+X*K)
;K = [SI]

ATANZ:	PUSH	SI		;SAVE POINT TO K
	MOV DI,OFFSET FACT1	;FACT2:=FACT1*K
	MOV RESLTP,OFFSET FACT2
	CALL	FMULE

	MOV DI,OFFSET FACT2	;FACT2:=FACT2+1
	MOV SI,OFFSET CON1
	MOV RESLTP,DI
	CALL	FADDE

	POP	SI		;FACT1:=FACT1-K
	MOV DI,OFFSET FACT1
	MOV RESLTP,DI
	CALL	FSUBE

	CALL	SETFAG		;FACT1:=FACT1/FACT2
	JMP	FDIVE


;DO FACT1:=POLLY(FACT1,ATANP,9) * FACT1 + K

ATANZZ:	PUSH	SI		;SAVE K POINTER
	MOV DI,OFFSET FACT3	;FACT3:=FACT1
	MOV SI,OFFSET FACT1
	CALL	FCOPY

	MOV	PTERMS,9	;FACT1:=POLLY(FACT1,ATANP,9)
	MOV POLPTR,OFFSET ATANP
	CALL	POLLY

	MOV DI,OFFSET FACT1	;FACT1:=FACT1*FACT3
	MOV SI,OFFSET FACT3
	MOV RESLTP,DI
	CALL	FMULE

	POP	SI		;GET K POINTER
	MOV DI,OFFSET FACT1	;FACT1:=FACT1+K
	MOV RESLTP,DI
	JMP	FADDE
	PAGE

;BASE 10 LOGARITHM FUNCTION
; FACT1:=LOG(FACT1)

LOGTEN:	CALL	LOGN		;FACT1:=LN(FACT1)
	MOV DI,OFFSET FACT1 	;FACT1:=FACT1*LN(10)
	MOV SI,OFFSET LOGE10
	MOV RESLTP,DI
	JMP	FDIVE


;NATURAL-LOGARITHM FUNCTION
; FACT1:=LN(FACT1)

;HANDLE ZERO ARGUMENT

LOGN:	CMP BYTE PTR FACT1+11,1	;FACT1=0?
	JNE	LOGN1		;SKIP IF NOT

	MOV	AL,LNERR	;HANDLE ERROR
	CALL	ERROR
	MOV SI,OFFSET BIGCTR	;RETURN INFINITY
	MOV DI,OFFSET FACT1
	JMP	FCOPY

;HANDLE NEGATIVE ARGUMENT

LOGN1:	TEST BYTE PTR FACT1+10,80H;FACT1<0 ?
	JZ	LOGN2		;SKIP IF NOT

	MOV	AL,LNERR	;HANDLE ERROR
	CALL	ERROR
	MOV BYTE PTR FACT1+10,0	;FORCE POSITIVE
	RET

;HANDLE ARGUMENT CLOSE TO 1

LOGN2:	MOV DI,OFFSET FACT1	;FACT2:=FACT1-1
	MOV SI,OFFSET CON1
	MOV RESLTP,OFFSET FACT2
	CALL	FSUBE

	CMP FACT2+8,-26		;EXP<=-26
	JG	LOGN3		;USE POOLY IF NOT

;HERE IF ABS(X)<=1E-8, JUST USE FACT1-1

	MOV DI,OFFSET FACT1	;FACT1:=FACT2
	MOV SI,OFFSET FACT2
	JMP	FCOPY
	PAGE
;DO POLYNOMIAL APPROXIMATION

LOGN3:	PUSH FACT1+8		;TEMP:=EXP
	MOV FACT1+8,-1		;SET TO .5 <FACT1< 1

	MOV SI,OFFSET FACT1	;FACT1:=FACT1 * SQRT(2)
	MOV DI,OFFSET SQRT2
	MOV RESLTP,SI
	CALL	FMULE

	MOV DI,OFFSET FACT1	;FACT2:=FACT1-1
	MOV SI,OFFSET CON1
	MOV RESLTP,OFFSET FACT2
	CALL	FSUBE

	MOV DI,OFFSET FACT1	;FACT3:=FACT1+1
	MOV SI,OFFSET CON1
	MOV RESLTP,OFFSET FACT3
	CALL	FADDE

	MOV DI,OFFSET FACT2	;FACT1:=FACT2/FACT3
	MOV SI,OFFSET FACT3
	MOV RESLTP,OFFSET FACT1
	CALL	FDIVE

	MOV DI,OFFSET FACT4	;FACT4:=FACT1
	MOV SI,OFFSET FACT1
	CALL	FCOPY
	PAGE

	MOV PTERMS,7		;FACT1:=POLLY(FACT1,LNP,7)
	MOV POLPTR,OFFSET LNP
	CALL	POLLY

	MOV DI,OFFSET FACT1	;FACT1:=FACT1*FACT4
	MOV SI,OFFSET FACT4
	MOV RESLTP,DI
	CALL	FMULE

	POP	AX		;FACT2:=FLOAT(EXP+1)
	INC	AX
	MOV DI,OFFSET FACT2
	CALL	FLTWRD

	MOV DI,OFFSET FACT2	;FACT2:=FACT2-.5
	MOV SI,OFFSET CON5
	MOV RESLTP,DI
	CALL	FSUBE

	MOV DI,OFFSET FACT2	;FACT2:=FACT2 * LN(2)
	MOV SI,OFFSET LOGE2
	MOV RESLTP,DI
	CALL	FMULE

	MOV DI,OFFSET FACT2	;FACT1:=FACT2+FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	JMP	FADDE
	PAGE

ARGRAN	DB	0		;FLAGS ARGUMENT RANGE

;EXPONENTIAL FUNCTION
; FACT1:=EXP(FACT1)

;HANDLE POSITIVE VS NEGATIVE VALUES

FEXP:	TEST BYTE PTR FACT1+10,80H;NEGATIVE?
	JZ	EXPX		;SKIP POSITIVE
	MOV BYTE PTR FACT1+10,0	;FORCE POSITIVE
	CALL	EXPX		;FACT1:=EXPX(FACT1)

	MOV DI,OFFSET CON1	;FACT1:=1/FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,SI
	JMP	FDIVE


;REDUCE RANGE OF ARGUMENTS TO 0 < X <.25

EXPX:	MOV DI,OFFSET FACT1	;FACT1:=FACT1/LN(2)
	MOV SI,OFFSET LOGE2
	MOV RESLTP,DI
	CALL	FDIVE

;NUMBER TOO LARGE?

	MOV SI,OFFSET FACT1	;AX:=FIX(FACT1)
	CALL	FIXNIB
	JC	EXPX0		;SKIP NUMBER TOO BIG TO FIX
	CMP	AX,1022		;AX > 709 ?
	JLE	EXPX1		;SKIP IF OK

EXPX0:	MOV	FSTAT,0		;ZERO ANY OVERIDING STATUS ERRORS
	MOV	AL,EXPERR	;FLAG THE ERROR
	CALL	ERROR
	MOV SI,OFFSET BIGCTR	;FACT1:=INFINITY
	MOV DI,OFFSET FACT1
	JMP	FCOPY
	PAGE

;REDUCE RANGE TO 0 - .25, BY SUBTRACTING .25
;ARGRAN KEEPS TRACK OF THE ORIGINAL RANGE

EXPX1:	PUSH	AX		;TEMP:=FIX(X)
	CALL	FRACTN		;FACT1:=FRACT(FACT1)

	MOV	ARGRAN,0	;ZERO SUBTRACT COUNTER
EXPX2:	CALL	EXPT25		;FACT1 < .25 ?
	JLE	EXPX3		;THEN EXIT
	CALL	EXPS25		;FACT1:=FACT1 - .25
	INC	ARGRAN		;COUNT SUBTRACTS
	JMP	EXPX2		;LOOP

;HANDLE DIFFERENT ORIGINAL RANGES BY TESTING NUMBER OF SUBTRACTS

EXPX3:	CALL	EXPZ		;FACT1:=EXPZ(FACT1)
	CMP	ARGRAN,0	;WAS 0<X<.25
	JE	EXPX9		;THEN EXIT

	CMP	ARGRAN,1	;WAS .25<X<.5
	JE	EXPX4		;THEN SKIP SQRT(2)
	CALL	EXPMS2		;FACT1:=FACT1*SQRT(2)

EXPX4:	CMP	ARGRAN,2	;WAS .5 <X .75
	JE	EXPX9		;THEN EXIT
	CALL	EXPM22		;FACT1:=FACT1*SQRT(SQRT(2))

EXPX9:	POP	AX		;RESTORE INTEGER PART
	ADD FACT1+8,AX		;ADD TO EXPONENT
	RET
	PAGE

;DO EXP(FACT1) FOR 0 < X < 25

EXPZ:	MOV DI,OFFSET FACT1	;FACT2:=FACT1^2
	MOV SI,DI
	MOV RESLTP,OFFSET FACT2
	CALL	FMULE

	MOV DI,OFFSET FACT2	;FACT3:=FACT2+Q1
	MOV SI,OFFSET CEXPQ1
	MOV RESLTP,OFFSET FACT3
	CALL	FADDE

	MOV DI,OFFSET FACT3	;FACT3:=FACT3*FACT2
	MOV SI,OFFSET FACT2
	MOV RESLTP,DI
	CALL	FMULE

	MOV DI,OFFSET FACT3	;FACT3:=FACT3 + Q0
	MOV SI,OFFSET CEXPQ0
	MOV RESLTP,DI
	CALL	FADDE

	MOV DI,OFFSET FACT2	;FACT4:=FACT2 * P1
	MOV SI,OFFSET CEXPP1
	MOV RESLTP,OFFSET FACT4
	CALL	FMULE

	MOV DI,OFFSET FACT4	;FACT4:=FACT4 + P0
	MOV SI,OFFSET CEXPP0
	MOV RESLTP,DI
	CALL	FADDE

	MOV DI,OFFSET FACT4	;FACT4:=FACT4 * FACT1
	MOV SI,OFFSET FACT1
	MOV RESLTP,DI
	CALL	FMULE

	MOV DI,OFFSET FACT3	;FACT1:=FACT3 + FACT4
	MOV SI,OFFSET FACT4
	MOV RESLTP,OFFSET FACT1
	CALL	FADDE

	MOV DI,OFFSET FACT3	;FACT2:=FACT3 - FACT4
	MOV SI,OFFSET FACT4
	MOV RESLTP,OFFSET FACT2
	CALL	FSUBE

	MOV DI,OFFSET FACT1	;FACT1:=FACT1/FACT2
	MOV SI,OFFSET FACT2
	MOV RESLTP,DI
	JMP	FDIVE
	PAGE

;COMPARE FACT1 TO .25

EXPT25:	MOV SI,OFFSET FACT1
	MOV DI,OFFSET CON25
	JMP	FCMPT


;FACT1:=FACT1 - .25

EXPS25:	MOV DI,OFFSET FACT1
	MOV SI,OFFSET CON25
	MOV RESLTP,DI
	JMP	FSUBE


;FACT1:=FACT1*SQRT(2)

EXPMS2:	MOV SI,OFFSET SQRT2
	JMP SHORT EXPM20


;FACT1:=FACT1*SQRT(SQRT(2))

EXPM22:	MOV SI,OFFSET SSQRT2
EXPM20:	MOV DI,OFFSET FACT1
	MOV RESLTP,DI
	JMP	FMULE

	PAGE
;THIS ROUTINE SOLVES POLYNOMIAL EQUATIONS OF THE FORM
;P0 + P1*X^2 + P2*X^4 + P3*X^6
;FACT1=X, PTERMS=NUMBER OF TERMS, POLPTR=POINTS TO A
;TABLE OF COEFFICIENTS

PTERMS	DW	0		;DEFINES # OF TERMS
POLPTR	DW	0		;POINTS TO COEFFICIENT

POLLY:	MOV SI,OFFSET FACT1	;FACT2:=FACT1^2
	MOV DI,SI
	MOV RESLTP,OFFSET FACT2	
	CALL	FMULE

;CALUCULTATE OFFSET TO END OF COEFFICIENT TABLE

	DEC	PTERMS		;N-1
	MOV	AX,PTERMS	;GET THE NUMBER OF TERMS
	MOV	BX,AX		;SAVE A COPY
	MOV	CL,3		;TIMES 8
	SHL	AX,CL
	MOV	CL,2		;TIMES 4
	SHL	BX,CL
	ADD	AX,BX		;MAKE TIMES 12
	ADD	POLPTR,AX	;ADD TO BASE OF TABLE

;COPY FIRST TERM INTO FACT1

	MOV	SI,POLPTR	;POINT TO TABLE
	MOV DI,OFFSET FACT1	;POINT TO FACT1
	CALL	FCOPY		;COPY IT

;DO EACH TERMS

	MOV	CX,PTERMS	;GET NUMBER OF TERMS
POLLY1:	PUSH	CX		;SAVE COUNTER
	SUB	POLPTR,12	;POINT TO NEXT ENTRY
	CALL	PTERM		;DO THE TERM
	POP	CX		;GET COUNTER
	LOOP	POLLY1		;LOOP
	RET


;DO ONE TERM OF THE POLYNOMIAL

PTERM:	CALL	SETFAG		;FACT1:=FACT1*FACT2
	CALL	FMULE

	MOV SI,OFFSET FACT1	;FATC1:=FACT1+P(I)
	MOV	RESLTP,SI
	MOV	DI,POLPTR
	JMP	FADDE
	PAGE

;****************************************************
;********* CONSTANTS FOR TRANSCENDENTALS ************
;****************************************************

COSP	DW	0FFB8H	;0.9999999999999999960897E+00
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	00000H

	DW	0DAF8H	;-0.49999999999999974308584E+00
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFEH
	DW	00080H

	DW	01CA8H	;0.4166666666666387895916E-01
	DW	0AA9EH
	DW	0AAAAH
	DW	0AAAAH
	DW	0FFFBH
	DW	00000H

	DW	00E80H	;-0.138888888887731721151E-02
	DW	004DDH
	DW	060B6H
	DW	0B60BH
	DW	0FFF6H
	DW	00080H

	DW	0980AH	;0.24801587277443938629E-04
	DW	0A725H
	DW	000CCH
	DW	0D00DH
	DW	0FFF0H
	DW	00000H

	DW	09C72H	;-0.275573163935346178E-06
	DW	0D337H
	DW	07CBCH
	DW	093F2H
	DW	0FFEAH
	DW	00080H

	DW	0D7BEH	;0.20876561960112253E-08
	DW	09B68H
	DW	06FAAH
	DW	08F76H
	DW	0FFE3H
	DW	00000H

	DW	034A5H	;-0.114629048993344E-10
	DW	04F06H
	DW	05590H
	DW	0C9A8H
	DW	0FFDBH
	DW	00080H

	DW	0BD5AH	;0.46090073769E-13
	DW	0F497H
	DW	03CB8H
	DW	0CF92H
	DW	0FFD3H
	DW	00000H

ATANP	DW	0FEEAH	;0.9999999999999999849899E+00
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	00000H

	DW	08336H	;-0.333333333333299308717E+00
	DW	0AA97H
	DW	0AAAAH
	DW	0AAAAH
	DW	0FFFEH
	DW	00080H

	DW	0A7C4H	;0.1999999999872944792E+00
	DW	094EBH
	DW	0CCCCH
	DW	0CCCCH
	DW	0FFFDH
	DW	00000H

	DW	0698FH	;-0.142857141028255452E+00
	DW	0DD9CH
	DW	02472H
	DW	09249H
	DW	0FFFDH
	DW	00080H

	DW	00173H	;0.11111097898051048E+00
	DW	0952BH
	DW	02727H
	DW	0E38EH
	DW	0FFFCH
	DW	00000H

	DW	0982BH	;-0.909037114191074E-01
	DW	00A6BH
	DW	0B99DH
	DW	0BA2BH
	DW	0FFFCH
	DW	00080H

	DW	0261AH	;0.767936869066E-01
	DW	06CC5H
	DW	0022EH
	DW	09D46H
	DW	0FFFCH
	DW	00000H

	DW	00B2AH	;-0.6483193510303E-01
	DW	00801H
	DW	09B08H
	DW	084C6H
	DW	0FFFCH
	DW	00080H

	DW	0184EH	;0.443895157187E-01
	DW	0C0E6H
	DW	0C7E4H
	DW	0B5D1H
	DW	0FFFBH
	DW	00000H

LNP	DW	02F05H	;2.00000000000000261007
	DW	00000H
	DW	00000H
	DW	08000H
	DW	00001H
	DW	00000H

	DW	0A302H	;0.6666666666633660894
	DW	0A709H
	DW	0AAAAH
	DW	0AAAAH
	DW	0FFFFH
	DW	00000H

	DW	0FB6AH	;0.400000001206045365
	DW	028EBH
	DW	0CCD7H
	DW	0CCCCH
	DW	0FFFEH
	DW	00000H

	DW	03265H	;0.2857140915904889
	DW	0C666H
	DW	01E0EH
	DW	09249H
	DW	0FFFEH
	DW	00000H

	DW	0348DH	;0.22223823332791
	DW	041BBH
	DW	06B60H
	DW	0E392H
	DW	0FFFDH
	DW	00000H

	DW	04CBEH	;0.1811136267967
	DW	0CE9EH
	DW	0D9BFH
	DW	0B975H
	DW	0FFFDH
	DW	00000H

	DW	0F7A0H	;0.16948212488
	DW	076F9H
	DW	0B8DEH
	DW	0AD8CH
	DW	0FFFDH
	DW	00000H

ATAN25	DW	0EB08H	;0.244978663126864154
	DW	06406H
	DW	0AFC9H
	DW	0FADBH
	DW	0FFFDH
	DW	00000H

ATAN75	DW	00916H	;0.643501108793284386
	DW	034F7H
	DW	07D19H
	DW	0A4BCH
	DW	0FFFFH
	DW	00000H

PI	DW	0C182H	;3.1415926535897932
	DW	02168H
	DW	0DAA2H
	DW	0C90FH
	DW	00001H
	DW	00000H

PI2	DW	0C182H	;6.2831853071795864
	DW	02168H
	DW	0DAA2H
	DW	0C90FH
	DW	00002H
	DW	00000H

HALFPI	DW	0C182H	;1.5707963267948966
	DW	02168H
	DW	0DAA2H
	DW	0C90FH
	DW	00000H
	DW	00000H


HALFPI3	DW	09121H	;4.7123889803846898
	DW	0990EH
	DW	0E3F9H
	DW	096CBH
	DW	00002H
	DW	00000H

LOGE2	DW	079A9H	;0.69314718055994530941
	DW	0D1CFH
	DW	017F7H
	DW	0B172H
	DW	0FFFFH
	DW	00000H

SSQRT2	DW	0A96FH	;1.18920711500272106671
	DW	08DB8H
	DW	0F051H
	DW	09837H
	DW	00000H
	DW	00000H

SQRT2	DW	06482H	;1.41421356237309504880
	DW	0F9DEH
	DW	0F333H
	DW	0B504H
	DW	00000H
	DW	00000H

LOGE10	DW	0AC16H	;2.30258509299404568401
	DW	0AAA8H
	DW	08DDDH
	DW	0935DH
	DW	00001H
	DW	00000H

CEXPP1	DW	0B850H	;28.859316162566724409385
	DW	0F92FH
	DW	0E126H
	DW	0E6DFH
	DW	00004H
	DW	00000H

CEXPQ1	DW	0D29BH	;374.740181442215221417719
	DW	0F7B5H
	DW	0BE43H
	DW	0BB5EH
	DW	00008H
	DW	00000H

CEXPP0	DW	04858H	;2523.012182660608706903086
	DW	0720EH
	DW	031E6H
	DW	09DB0H
	DW	0000BH
	DW	00000H

CEXPQ0	DW	0A182H	;7279.8743280538075742719867
	DW	0B4E8H
	DW	0FE9FH
	DW	0E37EH
	DW	0000CH
	DW	00000H

CON1	DW	00000H	;1.0
	DW	00000H
	DW	00000H
	DW	08000H
	DW	00000H
	DW	00000H

CON1M	DW	00000H	;-1.0
	DW	00000H
	DW	00000H
	DW	08000H
	DW	00000H
	DW	00080H

CON75	DW	00000H	;0.75
	DW	00000H
	DW	00000H
	DW	0C000H
	DW	0FFFFH
	DW	00000H


CON5	DW	00000H	;0.5
	DW	00000H
	DW	00000H
	DW	08000H
	DW	0FFFFH
	DW	00000H


CON25	DW	00000H	;0.25
	DW	00000H
	DW	00000H
	DW	08000H
	DW	0FFFEH
	DW	00000H

