

	PAGE
;***********************************************
;** FLOATING POINT INPUT AND OUTPUT ROUTINES ***
;***********************************************
	.386
	.387

;VARIABLES

DSEG	SEGMENT WORD PUBLIC 'DATA'
FSIGN	DB	0	;SIGN OF THE NUMBER
ESIGN	DB	0	;SIGN OF EXPONENT
EXP	DW	0	;EXPONENT
DSEG	ENDS

;INPUT A FLOATING-POINT NUMBER IN LONG REAL FORMAT
;RESULT STORED AT DI

FINP:	MOV BYTE PTR NOWFUN,INPFUN	;SET FOR INPUT
	PUSH	DI			;SAVE DI
	MOV	FSIGN,0			;SET SIGN +
	MOV	ESIGN,0
	MOV	EXP,0			;ZERO EXPONENTS
	FLDZ				;ZERO ST(0)

;LOOP TO GET LEADING CHARACTERS

FINLED:	CALL	GETDIG		;GET A CHARACTER
	JC	FININT		;NUMBER, SO GET THE INTEGER

	CMP	AL,'-'		;MINUS SIGN?
	JNE	FINLD1		;SKIP IF NOT
	INC	FSIGN		;FLAG NEGATIVE NUMBER
	JMP	FINLED		;LOOP


FINLD1:	CMP	AL,EOF		;END OF FILE?
	JNE	FINLD2		;SKIP IF NOT
	JMP	FINXT1		;ABORT ON EOF
FINLD2:	CMP	AL,'.'		;IS IT A DECIMAL POINT?
	JNE	FINLED		;LOOP IF NOT
	JMP SHORT  FINFRC	;GOT GET FRACTIONAL PART

;READ THE INTEGER PART

FININT:	CALL	ADDIN		;ADD IN THE DIGIT
	CALL	GETDIG		;GET NEXT CHARACTER
	JC	FININT		;LOOP IF NUMBER

	CMP	AL,'.'		;DP?
	JNE	FINEND		;NO, END OF #
	PAGE

;READ THE FRACTIONAL PART

FINFRC:	CALL	GETDIG		;GET A DIGIT
	JNC	FINEND		;EXIT IF NOT
	CALL	ADDIN		;ADD IN THE DIGIT
	DEC	EXP		;DECREMNENT EXPONENT
	JMP	FINFRC		;LOOP

;HERE ON END OF NUMBER

FINEND:	CMP	AL,'E'		;EXPONENT?
	JE	FINEXP		;THEN HANDLE IT
	CMP	AL,'e'		;OR LOW CASE E
	JNE	FINFIN		;NO, THEN FINISH UP

;NOW HANDLE EXPONENT

FINEXP:	CALL	GETDIG		;GET A DIGIT
	JC	FINEX0		;SKIP IF NUMBER
	CMP	AL,EOF		;END OF FILE?
	JE	FINXT1		;ABORT ON EOF
	CMP	AL,'-'		;NEGATIVE?
	JNE	FINEXP		;LOOP IF NOT
	INC	ESIGN		;FLAG NEGATIVE
	JMP	FINEXP		;LOOP FOR NEXT CHAR

;HERE WHEN WE'VE GOT A DIGIT

FINEX0:	MOV	CX,0		;START WITH ZERO
FINEX1:	XCHG	AX,CX		;GET ACCUMULATED VALUE
	MUL	TENBYT		;MULTIPLY BY TEN
	ADD	CX,AX		;ADD IN DIGIT
	PUSH	CX		;SAVE INTEGER
	CALL	GETDIG		;GET A DIGIT
	POP	CX		;RESTORE INTEGER
	JC	FINEX1		;LOOP WHILE NUMERIC

	TEST	ESIGN,0FFH	;NEGATIVE?
	JZ	FINEX2		;SKIP IF NOT
	NEG	CX		;NEGATE NUMBER

FINEX2:	ADD	CX,EXP		;COMBINE EXPONENTS
	MOV	EXP,CX
	PAGE

;NOW ADJUST NUMBER BASED ON OUR EXPONENT

FINFIN:	MOV	AX,EXP		;GET THE EXPONENT
	OR	AX,AX		;TEST IT
	JZ	FINEXT		;ZERO, THEN EXIT
	JS	FEXNEG		;HANDLE NEGATIVE EXP

;HERE IF EXPONENT IS POSITIVE

	MOV	CX,AX		;SET COUNTER
FEXPS1:	FMUL	TENCON		;MULTIPLY BY TEN
	LOOP	FEXPS1		;LOOP
	JMP SHORT FINEXT	;FINISH UP


;HERE IF EXPONENT IS NEGATIVE

FEXNEG:	NEG	AX		;CHANGE SIGN
	MOV	CX,AX		;SET COUNTER
FEXNG1:	FDIV	TENCON		;DIVIDE BY 10
	LOOP	FEXNG1		;LOOP

;CONVERT FROM TEMPORARY REAL TO LONG REAL AND STORE

FINEXT:	TEST	FSIGN,0FFH	;NEGATIVE?
	JZ	FINXT1		;SKIP IF NOT
	FCHS			;MAKE NEGATIVE
FINXT1:	POP	DI		;GET DESTINATION
	FSTP QWORD PTR [DI]
	RET
	PAGE

;GET A CHARATER, IF ITS A NUMBER SET CARRY
;AND CONVERT TO BINARY

GETDIG:	CALL	KHAND		;GET A CHARACTER
	CMP	AL,"0"		;TEST FOR NUMBER
	JB	NOTDIG		;SKIP IF NOT
	CMP	AL,"9"		;TEST AGAIN
	JA	NOTDIG		;SKIP IF NOT
	AND	AX,0FH		;MAKE BINARY NUMBER
	STC			;FLAG ITS A NUMBER
	RET

NOTDIG:	CLC			;FLAG NOT A NUMBER
	RET
	PAGE
;VARIBLES FOR FLOATING OUTPUT

SIGFIG	EQU	15		;NUMBER DIGITS PRECISION

DSEG	SEGMENT WORD PUBLIC 'DATA'
DISDIG	DW	0		;MAXIUM DIGITS WE CAN DISPLAY
INTDIG	DW	0		;NUMBER OF INTEGER DIGITS
STATMP	DW	0		;TEMPORARY FOR COPROCESSOR STATUS OF NUMBER
SIGTMP	DB	0		;TEMPORARY FOR SIGN
OEXP	DW	0		;HOLDS EXPONENT FOR FLOATING OUTPUTS
DIGTMP	DW	0		;HOLD DIGIT TEMPORARILY

FORM1	DW	5		;ARGUMENTS FOR XPL FORMAT INTRINSIC
FORM2	DW	5

PREDEC	DW	0		;NUMBER OF DIGITS BEFORE DECIMAL
AFTDEC	DW	0		;NUMBER OF DIGITS AFTER DECIMAL
DSEG	ENDS


;MAIN FLOATING POINT OUTPUT ROUTINE, OUTPUT NUMBER POINTED
;TO BY SI. FORM1 AND FORM2 CONTROL OUTPUT FORMAT

FOUT:	MOV BYTE PTR NOWFUN,OUTFUN	;SET FOR OUTPUT
	FLD QWORD PTR [SI]		;GET REAL TO OUTPUT
	CALL	FPTEST			;TEST THE NUMBER
	JC	FOTSPC			;HANDLE SPECIAL NUMBERS
	FTST				;TEST THE SIGN
	FSTSW	AX			;GET THE STATUS
	MOV	BX,AX			;SAVE FOR LATER
	AND	AH,1			;C0 = SIGN
	MOV	SIGTMP,AH	;SAVE A COPY
	FABS			;FORCE NUMBER POSITIVE
	MOV	AX,FORM2	;GET DIGITS AFTER DECIMAL
	MOV	AFTDEC,AX	;SET THE ARGUMENT

	MOV	AX,FORM1	;FORMAT ARGUMENT
	CMP	AX,1		;TEST IT
	JL	FOUT1		;SKIP IF ZERO OR NEGATIVE

;HANDLE STANDARD FIXED POINT OUTPUT

	MOV	PREDEC,AX	;SET DIGITS BEFORE DECIMAL
	JMP	FIXPNT		;DO FIXED POINT OUTPUT
	PAGE

;HANDLE FLOATING POINT OR SCIENTIFIC NOTATION

FOUT1:	CMP	AX,0		;TEST ZERO OR NEGATIVE
	JNZ	FOUT2		;SKIP IF NOT ZERO
	JMP SHORT SCINOT	;DO SCIENTIFIC NOTATION

FOUT2:	JMP SHORT ENGNOT	;DO ENGINEERING NOTATION

;HERE TO HANDLE SPECIAL VALUES, LIKE INFINITY, NAN, ETC

FOTSPC:	MOV	CX,3		;JUST DISPLAY '???'
FOTSP1:	PUSH	CX
	MOV	AL,'?'
	CALL	KHAND
	POP	CX
	LOOP	FOTSP1
	FSTP	ST(0)
	RET
	PAGE

;OUTPUT THE NUMBER IN SCIENTIFIC NOTATION

SCINOT:	MOV	OEXP,0		;ZERO EXPONENT
	MOV	AX,BX		;RESTORE STATUS
	SAHF			;AND SET CPU FLAG WITH IT
	JZ	SCINT4		;SKIP IF YES

;MULTIPLY NUMBER BY TEN UNTIL IT'S NOT A FRACTION

SCINT1:	FCOM	ONECON		;IS NUMBER < ONE ?
	FSTSW	AX
	SAHF
	JAE	SCINT2		;EXIT >= ONE
	FMUL	TENCON		;MULTIPLY BY TEN
	DEC	OEXP		;DECREMENT EXPONENT
	JMP	SCINT1		;LOOP

;DIVIDE BY TEN UNTIL IT'S LESS THAN TEN

SCINT2:	FCOM	TENCON		;IS NUMBER >= 10 ?
	FSTSW	AX
	SAHF
	JB	SCINT4		;EXIT < 10
	FDIV	TENCON		;DIVIDE BY TEN
	INC	OEXP		;INCREMENT EXPONENT
	JMP	SCINT2		;LOOP

SCINT4:	MOV	PREDEC,2	;SET 2 BEFORE DECIMAL
	JMP SHORT EXPOUT	;OUTPUT EXPONENT
	PAGE


;OUTPUT THE NUMBER IN ENGINEERING NOTATION

ENGNOT:	MOV	OEXP,0		;ZERO EXPONENT
	MOV	AX,BX		;RESTORE STATUS
	SAHF			;AND SET CPU FLAG WITH IT
	JZ	ENGNT4		;SKIP IF YES

;MULTIPLY NUMBER BY THOUSAND UNTIL IT'S NOT A FRACTION

ENGNT1:	FCOM	ONECON		;IS NUMBER < ONE ?
	FSTSW	AX
	SAHF
	JAE	ENGNT2		;EXIT >= ONE
	FMUL	KILCON		;MULTIPLY BY ONE THOUSAND
	SUB	OEXP,3		;COUNT SHIFTS
	JMP	ENGNT1		;LOOP

;DIVIDE BY THOUSAND UNTIL IT'S LESS THAN THOUSAND

ENGNT2:	FCOM	KILCON		;IS NUMBER >= 1000 ?
	FSTSW	AX
	SAHF
	JB	ENGNT4		;EXIT < 1000
	FDIV	KILCON		;DIVIDE BY 1000
	ADD	OEXP,3		;COUNT SHIFTS
	JMP	ENGNT2		;LOOP

ENGNT4:	MOV	PREDEC,4	;SET 4 BEFORE DECIMAL
	JMP SHORT EXPOUT	;OUTPUT EXPONENT
	PAGE

;OUTPUT FIXED POINT PART OF THE NUMBER FOLLOWED BY
;THE EXPONENT CREATED BY FLOATING POINT ADJUSTMENTS

EXPOUT:	CALL	FIXPNT		;OUTPUT FIX POINT PART
	MOV	AL,'E'		;OUTPUT THE E
	CALL	KHAND

;DEAL WITH SIGN

	MOV	AL,'+'		;GET A PLUS SIGN
	CMP	OEXP,0		;NEGATIVE EXPONENT?
	JGE	EXPOT1		;SKIP IF NOT

	NEG	OEXP		;MAKE POSITIVE
	MOV	AL,'-'		;SO GET A MINUS
EXPOT1:	CALL	KHAND		;OUTPUT SIGN

;DO LEADING ZEROS

	CMP	OEXP,100	;NO LEADIN IF OVER 100
	JGE	EXPOT3
	CMP	OEXP,10		;ONE ZERO IF OVER 10
	JGE	EXPOT2
	MOV	AL,'0'		;DO LEADING ZEROS
	CALL	KHAND
EXPOT2:	MOV	AL,'0'
	CALL	KHAND

EXPOT3:	MOV	AX,OEXP		;OUTPUT EXPONENT
	JMP	PUTNMB
	PAGE

;ROUTINE TO OUTPUT A FLOATING POINT NUMBER IN FIXED POINT FORMAT
;NUMBER IS A TEMPORARY REAL IN ST(0)
;DIGITS BEFORE DECIMAL IS SPECIFIED IN "PREDEC" AND
;NUMBER AFTER IS IN "AFTDEC"

FIXPNT:	FCOM	ONECON		;TEST FOR FRACTION
	FSTSW	AX		;AND SAVE RESULTING FLAGS
	MOV	STATMP,AX
	FTST			;TEST THE NUMBER
	FSTSW	AX		;GET THE STATUS
	SAHF			;IS NUMBER ZERO?
	JNZ	FIXPT0		;SKIP IF NOT
	MOV	INTDIG,0	;NO INTEGER DIGITS
	JMP	FIXPT1		;NOW OUTPUT THE ZERO

FIXPT0:	CALL	FRACIZ		;CONVERT TO A FRACTION
	CALL	FROUND		;ROUND THE NUMBER

FIXPT1:	CALL	LBLANK		;HANDLE LEADING BLANKS
	CALL	FIXNUM		;OUTPUT THE NUMBER
	FSTP	ST(0)		;POP STACK
FIXPT2:	RET

;OUTPUT THE ACTUAL DIGITS OF THE NUMBER

FIXNUM:	MOV	DISDIG,SIGFIG	;SET MAXIMUM TO OUTPUT
	MOV	CX,INTDIG	;SET INTEGER PART
	CALL	DIGOUT		;OUTPUT INTEGER PART
	CMP	AFTDEC,0	;ANY AFTER DECIMAL?
	JLE	FIXPT2		;THEN JUST EXIT

	MOV	AL,'.'		;OUTPUT DECIMAL POINT
	CALL	KHAND
	MOV	CX,AFTDEC	;SET NUMBER AFTER DECIMAL
	JMP	DIGOUT		;DISPLAY FRACTIONAL PART
	PAGE

;CALCULATE AND HANDLE THE NUMBER OF LEADING BLANKS
;AND OUTPUT THE CORRECT SIGN 

LBLANK:	MOV	CX,PREDEC	;PREDEC-INTDIG
	SUB	CX,INTDIG
	MOV	AX,STATMP	;GET NUMBER STATUS
	SAHF			;IS NUMBER <1
	JAE	LBLNK1		;SKIP IF NOT
	DEC	CX		;COUNT THE LEADING ZERO
LBLNK1:	TEST	SIGTMP,1	;TEST THE SIGN
	JZ	LBLNK2		;SKIP IF POSITIVE
	DEC	CX		;COUNT THE SIGN

LBLNK2:	CMP	CX,0		;DEAL ZERO OR NEGATIVE
	JLE	LBLNK4		;SKIP NO BLANKS
LBLNK3:	PUSH	CX		;SAVE COUNTER
	MOV	AL,' '		;OUTPUT A BLANK
	CALL	KHAND
	POP	CX
	LOOP	LBLNK3		;LOOP TIL DONE

;NOW TEST AND HANDLE THE SIGN

LBLNK4:	TEST	SIGTMP,1	;TEST THE SIGN
	JZ	LBLNK5		;SKIP IF POSITIVE
	MOV	AL,'-'		;GET MINUS SIGN
	CALL	KHAND		;OUTPUT IT

;NOW OUTPUT LEADING ZERO IF NUMBER A FRACTION

LBLNK5:	MOV	AX,STATMP	;GET NUMBER STATUS
	SAHF			;IS NUMBER < 1
	JAE	LBLNK6		;SKIP IF NOT
	MOV	AL,'0'		;OUTPUT LEADING ZERO
	CALL	KHAND
LBLNK6:	RET
	PAGE

;ROUND THE NUMBER BY ADDING 0.5 * 10 ^ -(INTDIG+AFTDEC)

FROUND:	MOV	SI,AFTDEC	;CALCULATE TOTAL DIGITS TO DISPLAY
	ADD	SI,INTDIG	;BY AFTDEC+INTDIG
	CMP	SI,SIGFIG	;OUT OF RANGE?
	JBE	FROND1		;SKIP IF NOT
	MOV	SI,SIGFIG	;OUT,THEN USE MAX SIGFIGS
FROND1:	MOV	CL,3		;TIME 8 FOR INDEXING
	SHL	SI,CL
	ADD SI,OFFSET RNDTAB	;POINT TO TABLE
	FADD QWORD PTR [SI]	;ADD IN ROUNDING FACTOR
	FCOM	ONECON		;OVERFLOW? (ST(0)>=1)
	FSTSW	AX
	SAHF
	JAE	FROND2		;SKIP IF SO
	RET

;HANDLE ROUNDING OVERFLOW, BY ELIMINATING THE LEADING ZERO
;AND ADJUST THE NUMBER BACK TO A FRACTION

FROND2:	MOV	STATMP,0	;FLAG NO LEADING ZERO
	JMP SHORT FRACZ2	;ADJUST BACK BELOW 1
	PAGE
DSEG	SEGMENT WORD PUBLIC 'DATA'
RNDTAB	DQ	5.0E-1		;ROUNDING CONSTANTS
	DQ	5.0E-2
	DQ	5.0E-3
	DQ	5.0E-4
	DQ	5.0E-5
	DQ	5.0E-6
	DQ	5.0E-7
	DQ	5.0E-8
	DQ	5.0E-9
	DQ	5.0E-10
	DQ	5.0E-11
	DQ	5.0E-12
	DQ	5.0E-13
	DQ	5.0E-14
	DQ	5.0E-15
	DQ	5.0E-16
DSEG	ENDS
	PAGE

;ROUTINE TO DIVIDE ST(0) BY TEN UNTIL IT IS A FRACTION

FRACIZ:	MOV	INTDIG,0	;ZERO COUNTER
FRACZ1:	FCOM	ONECON		;ST(0) <= ONE?
	FSTSW	AX
	SAHF
	JB	FRAZXT		;THEN EXIT
FRACZ2:	FDIV	TENCON		;DIVIDE BY 10
	INC	INTDIG		;COUNT INTEGER DIGITS
	JMP	FRACZ1		;LOOP
FRAZXT:	RET



;OUTPUT A STRING OF FLOATING POINT DIGITS
;NUMBER TO OUTPUT IN CX

DIGOUT:	JCXZ	DIGOT1		;EXIT IF CX=0
	PUSH	CX		;SAVE COUNTER
	CALL	ONEDIG		;OUTPUT A DIGIT
	POP	CX		;RESTORE COUNTER
	LOOP	DIGOUT		;LOOP
DIGOT1:	RET


;ROUTINE TO OUTPUT ONE FLOATING POINT DIGIT
;IF PRECISION IS EXCEEDED, OUTPUT A ZERO

ONEDIG:	CMP	DISDIG,0	;MORE DISPLAYABLE DIGITS
	JZ	ZEROUT
	FMUL	TENCON		;MULTIPLY ST(0) BY 10
	FLD	ST(0)		;FIX TO A NIBBLE, DUPICATE ST(0)
	FSUB	HLFCON		;SUBTRACT .5
	FISTP	DIGTMP		;STORE RESULT
	MOV	AX,DIGTMP	;SAVE DIGIT
	ADD	AL,'0'		;CONVERT TO ASCII
	CMP	AL,'9'		;BECAUSE OF ROUNDING ERRORS, AL CAN SOMETIMES
	JLE	OD10		; = ':' SO FORCE IT BACK DOWN TO '9'
	MOV	AL,'9'
OD10:	CALL	KHAND		;DISPLAY IT
	FILD	DIGTMP		;LOAD AND FLOAT THE NIBBLE
	FSUB			;SUBRTRACT OFF THIS NIBBLE
	DEC	DISDIG		;COUNT DIGITS TO DISPLAY
	RET

;HERE TO OUTPUT A ZERO

ZEROUT:	MOV	AL,'0'		;OUTPUT A ZERO
	JMP	KHAND


;TEST A LONG REAL FOR SPECIAL NUMBERS, CARRY SET IF SPECIAL

FPTEST:	FXAM				;TEST FOR STRANGE NUMBERS
	FSTSW	AX			;GET STATUS
	SAHF
	JC	FPTSPC			;CARRY = C0, IF SET NUMBER IS SPECIAL
	JNZ	FPTGDN			;ZERO = C3,IF SET NUMBER IS NOT SPECIAL
	JP	FPTSPC			;PARITY = C2, IF SET IS SPECIAL

FPTGDN:	CLC				;FLAG NOT SPECIAL
	RET

FPTSPC:	STC				;FLAG SPECIAL
	RET
	PAGE

;UNPACKED TEMPORARY REAL CONSTANTS

DSEG	SEGMENT WORD PUBLIC 'DATA'
TENCON	DQ	10.0		;10 CONSTANT
KILCON	DQ	1000.0		;1000 CONSTANT
HLFCON	DQ	0.5		;ONE HALF CONSTANT
ONECON	DQ	1.0		;ONE CONSTANT
DSEG	ENDS


;ADD A DIGIT INTO THE MANTISSA

ADDIN:	FMUL QWORD PTR TENCON	;MULTIPLY ST(0) BY TEN
	XOR	AH,AH		;MAKE SURE HIGH BYTE IS ZERO
	MOV	FPTEMP,AX	;PUT INTO TEMPORARY
	FILD WORD PTR FPTEMP	;LOAD AND FLOAT THE NIBBLE
	FADDP	ST(1),ST	;ADD IN NIBBLE
	RET
	.8086
	.8087

