	PAGE

;*********************************************************
;***** COMMON FLOATING POINT OPCODES AND INTRINSICS ******
;*********************************************************

;IMPLEMENTATION NOTE: All floating point variables are in
;the IEEE long real format, which is four word long (64 bits).
;Since all operations take place with reals on the stack,
;reals are stored in normal memory order on the stack and
;reverse order in memory. Normal order is in memory sequence,
;from low word to high word.

;DEFINE REAL SIZE, NOTE: If you change this value, there are
;a couple of places where I multply by 8 by shifting that
;you will have to modify

RELSIZ	EQU	8		;NUMBER OF BYTES IN A REAL
INTSIZ	EQU	2		;SIZE OF INTEGER

RETSIZ	EQU	4		;NUMBER OF BYTES OF RETURN ADDRESS
TOSOFF	EQU	RETSIZ		;OFFSET OF TOS
RLNOS	EQU	TOSOFF+RELSIZ	;OFFSET OF REAL NOS
INTNOS	EQU	TOSOFF+INTSIZ	;OFFSET OF INTEGER NOS
LSTWRD	EQU	RLNOS+RELSIZ-2	;OFFSET TO LAST WORD OF REAL NOS

;I2L ERROR NUMBERS (TO BE PASSED TO ERROR HANDLER):

DIVZER	EQU	6	;DIVIDE BY ZERO
FOVFL	EQU	7	;FLOATING OVERFLOW
FUNFL	EQU	8	;FLOATING UNDERFLOW
INOVFL	EQU	9	;FIXED-POINT OVERFLOW

SQRERR	EQU	10	;SQUARE ROOT ERROR
LNERR	EQU	11	;LOGARITHM ERROR
EXPERR	EQU	12	;EXPONENTIAL ERROR
AT2ERR	EQU	14	;ATAN2(0.0,0.0) IS UNDEFINED

;ROUTINE TO RETRIVE A FLOATING POINT VARIABLE'S VALUE AND
;PUSH IT ON THE STACK. CALLED WITH DISPLAY VECTOR IN SI
;AND OFFSET IN BX

FLODDO	PROC	FAR
	IF	FLAGOPT
	ELSE
	POP	DX		;SAVE RETURN ADDRESS
	POP	CX
	PUSH	[BX+SI]		;PUSH ON STACK
	PUSH	[BX+SI]+2
	PUSH	[BX+SI]+4
	PUSH	[BX+SI]+6
	PUSH	CX		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
	ENDIF
FLODDO	ENDP
	PAGE

;ROUTINE TO STORE TOP OF STACK (TOS) INTO A VARIABLE

FSTODO	PROC	FAR
	IF	FLAGOPT
	ELSE
	POP	DX		;SAVE RETURN ADDRESS
	POP	CX
	POP	[BX+SI]+6	;PUT INTO THE VARIABLE
	POP	[BX+SI]+4
	POP	[BX+SI]+2
	POP	[BX+SI]
	PUSH	CX		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
	ENDIF
FSTODO	ENDP

;THIS ROUTINE ADDS 8*TOS + NOS, AND USES THE SUM AS AN
; ABSOLUTE ADDRESS FROM WHICH TO FETCH A VALUE.
; PUSH(8) @(8*TOS(2) + NOS(8))
;NOTE: NOS IS INTEGER PACKED INTO A REAL

TRIDO	PROC	FAR
	POP	DX		;SAVE RETURN ADDRESS
	POP	BP

	MOV	CL,3		;MULTIPLY TOS BY 8
	SHL	AX,CL
	ADD	SP,6		;DUMP PART OF REAL

	POP	BX		;GET NOS
	ADD	BX,AX
	PUSH	[BX]		;PUSH ON STACK
	PUSH	[BX]+2
	PUSH	[BX]+4
	PUSH	[BX]+6

	PUSH	BP		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
TRIDO	ENDP
	PAGE

;STORE THE 8 BYTES IN TOS INTO THE ABSOLUTE ADDRESS
; POINTED TO BY NOS. THIS OPCODE IS USED TO STORE
; INDEXED REAL NUMBERS.
; PULL(8) @(NOS)

STTDO	PROC	FAR
	POP	DX		;GET RETURN ADDRESS
	POP	CX

	MOV	BP,SP		;GET STACKPOINTER
	MOV	BX,[BP]+RELSIZ	;GET PLACE TO STORE
	POP	[BX]+6
	POP	[BX]+4
	POP	[BX]+2
	POP	[BX]
	ADD	SP,2		;ADJUST STACK

	PUSH	CX		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
STTDO	ENDP


;ROUTINES TO DO CANONICAL ADDRESSING FOR REALS

;ROUTINE TO LOAD A REAL FROM SEGMENT TYPE VARIABLE
;OFFSET IS IN AX (TOS) AND SEGMENT IS IN NOS

LDSRDO	PROC	FAR
	POP	DX		;SAVE RETURN ADDRESS
	POP	BP
	POP	CX		;GET THE SEGMENT

;MULTIPLY SEGMENT BY 8 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*8)/16   OFF= 8 if ODD, 0 if EVEN;

	SUB	BX,BX		;START WITH ZERO
	SHR	AX,1		;DIVIDE OFFSET BY TWO
	SBB	BX,0		;OFFSET WILL BE 0 OR 8 
	AND	BX,08H		;MASK FOR 8 OR 0
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	PUSH	[BX]		;LOAD THE REAL
	PUSH	[BX]+2
	PUSH	[BX]+4
	PUSH	[BX]+6
	MOV	AX,SS		;RESTORE DS
	MOV	DS,AX
	PUSH	BP		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
LDSRDO	ENDP

;ROUTINE TO STORE A REAL INTO A SEGMENT TYPE VARIABLE
;VALUE IS IN TOS, OFFSET IS IN NOS AND SEGMENT IS IN NOS
;CALLED FROM XPL CODE

STSRDO	PROC	FAR
	MOV	DISAVE,DI		;SAVE CRITICAL REGISTER
	POP	DX			;SAVE RETURN ADDRESS
	POP	DI

	MOV	BP,SP			;GET STACK FRAME
	MOV	AX,[BP]+RELSIZ		;GET OFFSET
	MOV	CX,[BP]+RELSIZ+INTSIZ	;GET SEGMENT

;MULTIPLY SEGMENT BY 8 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*8)/16   OFF= 8 if ODD, 0 if EVEN;

	SUB	BX,BX		;START WITH ZERO
	SHR	AX,1		;DIVIDE OFFSET BY TWO
	SBB	BX,0		;OFFSET WILL BE 0 OR 8 
	AND	BX,08H		;MASK FOR 8 OR 0
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	POP	[BX]+6			;STORE REAL
	POP	[BX]+4
	POP	[BX]+2
	POP	[BX]
	MOV	AX,SS		;RESTORE DS
	MOV	DS,AX
	ADD	SP,4		;ADJUST STACK

	PUSH	DI		;RESTORE RETURN ADDRESS
	PUSH	DX
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTER
	RET
STSRDO	ENDP
	PAGE

;ROUTINE TO LOAD A SHORT REAL FROM SEGMENT TYPE VARIABLE
;SHORT IS CONVERTED TO LONG AND PLACED ON THE STACK
;OFFSET IS IN AX (TOS) AND SEGMENT IS IN NOS
;CALLED FROM XPL CODE

LSHORT	PROC	FAR
	MOV	DISAVE,DI	;SAVE CRITICAL REGISTER
	POP	DI		;SAVE RETURN ADDRESS
	POP	BP

	POP	CX		;GET THE SEGMENT

;MULTIPLY SEGMENT BY 4 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*4)/16

	MOV	BX,AX		;GET OFFSET
	AND	BX,3		;ISOLATE 0-3 PART OF OFFSET
	SHL	BX,1		;TIMES FOUR
	SHL	BX,1
	SHR	AX,1		;DIVIDE BY 4 (4/16 = 1/4 = .25)
	SHR	AX,1
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	MOV	AX,[BX]		;LOAD THE REAL
	MOV	BX,[BX]+2

;CONVERT SHORT IN AX, BX TO LONG IN AX, BX, CX, DX

	MOV	DH,AH		;SAVE SIGN BIT
	AND	DH,80H		;ISOLATE SIGN BIT
	AND	AH,7FH		;STIP SIGN BIT
	SUB	CX,CX		;ZERO CX

	SHR	AX,1		;SHIFT WHOLE THING THREE BITS RIGHT
	RCR	BX,1
	RCR	CX,1
	SHR	AX,1
	RCR	BX,1
	RCR	CX,1
	SHR	AX,1
	RCR	BX,1
	RCR	CX,1

	TEST	AX,0FF0H	;ZERO EXPONENT
	JZ	LSHRT1		;THEN EXIT
	CMP	AX,0FF0H	;MAXIMUM EXPONENT
	JAE	LSHINF		;THEN SET SPECIAL EXPONENT

	SUB	AX,07F0H	;UNBIAS EXPONENT
	ADD	AX,03FF0H	;BIAS EXPONENT
LSHRT1:	OR	AH,DH		;RESTORE SIGN
	PUSH	AX		;PUT LONG REAL ON STACK
	PUSH	BX
	PUSH	CX
	SUB	DX,DX		;M3=0
	PUSH	DX

	MOV	AX,SS		;RESTORE DS
	MOV	DS,AX

	PUSH	BP		;RESTORE STACK
	PUSH	DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTER
	RET
LSHORT	ENDP

;HANDLE SPECIAL EXPONENT

LSHINF:	OR	AX,7FF0H	;CONVERT TO MAX EXPONENT FOR LONG REAL
	JMP SHORT LSHRT1	;AND EXIT


	PAGE

;ROUTINE TO STORE A SHORT REAL INTO A SEGMENT TYPE VARIABLE
;VALUE IS IN TOS, OFFSET IS IN NOS AND SEGMENT IS IN NOS

SSHORT	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	MOV	DX,[BP]+6	;GET REAL FROM STACK
	MOV	CX,[BP]+8
	MOV	AX,[BP]+10

;ROUTINE TO CONVERT A LONG REAL TO A SHORT REAL

	MOV	DL,AH		;SAVE SIGN BIT
	AND	DL,80H		;ISOLATE SIGN BIT

	AND	AX,7FFFH	;STRIP SIGN BIT
	CMP	AX,7FF0H	;SPECIAL NUMBER TYPE?
	JAE	SSHRT1		;EXIT IF SPECIAL
	TEST	AX,7FF0H	;TEST FOR ZERO EXPONENT
	JZ	SSHRT1		;THEN DON'T BIAS

	SUB	AX,3FF0H	;UNBIAS EXPONENT
	CMP	AX,0800H	;EXPONENT OVERFLOW?
	JGE	SSOVER		;HANDLE OVERFLOW
	CMP	AX,0F810H	;EXPONENT UNDERFLOW?
	JLE	SSUNDR		;HANDLE UNDERFLOW
	ADD	AX,07F0H	;BIAS EXPONENT

SSHRT1:	SHL	DH,1		;SHIFT WHOLE THING THREE BITS LEFT
	RCL	CX,1
	RCL	AX,1
	SHL	DH,1
	RCL	CX,1
	RCL	AX,1
	SHL	DH,1
	RCL	CX,1
	RCL	AX,1
	OR	AH,DL		;RESTORE SIGN BIT

;MULTIPLY SEGMENT BY 4 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*4)/16

SSHRT2:	MOV	BX,[BP]+12	;GET OFFSET
	MOV	DX,BX		;SAVE OFFSET
	MOV	BP,[BP]+14	;GET SEGMENT
	AND	BX,3		;ISOLATE 0-3 PART OF OFFSET
	SHL	BX,1		;TIMES FOUR
	SHL	BX,1
	SHR	DX,1		;DIVIDE BY 4 (4/16 = 1/4 = .25)
	SHR	DX,1
	ADD	BP,DX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,BP		;PUT INTO SEGMENT REGISTER

	MOV	[BX],AX		;STORE SHORT REAL
	MOV	[BX]+2,CX

	MOV	AX,SS		;RESTORE DS
	MOV	DS,AX
	RET	12
SSHORT	ENDP

;HANDLE OVERFLOW

SSOVER:	MOV	AX,7F80H	;GET INFINITY
	OR	AH,DH		;OR IN THE CORRECT SIGN
	SUB	CX,CX		;ZERO MANTISSA
	JMP	SSHRT2		;ENTER COMMON CODE

;HANDLE UNDERFLOW

SSUNDR:	SUB	AX,AX		;ZERO EXPONENT AND MANTISSA
	MOV	CX,AX
	JMP	SSHRT2		;ENTER COMMON CODE
	PAGE

;*********************************************************
;************ FLOATING POINT INTRINSICS ******************
;*********************************************************
;46
;REAL:=RLRES(INTEGER)
;THE FLOATING-POINT RESERVE RESERVES TOS*8 BYTES OF HEAP
; SPACE, AND RETURNS THE STARTING 16 BIT ADDRESS PACKED INTO
; AN 8 BYTE REAL ON TOS

INTR46	LABEL	FAR
FLRES	PROC	FAR
	POP	DX		;SAVE RETURN
	POP	BP
	POP	AX		;REAL INTRINSIC-TOS ON STACK
	MOV	CL,3		;MULTIPLY BY 8
	SHL	AX,CL
	IF	FLAGOPT
	PUSH	DI		;PUSH ADDRESS OF RESERVE
	SUB	SP,6		;PUSH DUMMY VALUES
	ADD	DI,AX		;ADD TO HEAP
	JC	RLRES2		;ERROR IF HEAP WRAPS AROUND
	MOV	AX,DI		;HEAP OVERFLOW?
	ELSE
	PUSH	[HP]		;PUSH ADDRESS OF RESERVE
	SUB	SP,6		;PUSH DUMMY VALUES
	ADD	HP,AX		;ADD TO HEAP
	JC	RLRES2		;ERROR IF HEAP WRAPS AROUND
	MOV	AX,HP		;HEAP OVERFLOW?
	ENDIF
	CMP AX,WORD PTR HEAPHI
	JB	FLRES1		;SKIP IF NOT
RLRES2:	MOV	AL,2		;I2L ERROR # 2
	CALL	ERROR		;HANDLE ERROR
FLRES1:	PUSH	BP		;RESTORE RETURN ADDRESS
	PUSH	DX
	RET
FLRES	ENDP

;47
;REAL:=RLIN(DEVICE)
;INPUT A FLOATING-POINT NUMBER FROM THE DEVICE (TOS)
;RETURN AS 4 WORDS ON TOS

INTR47	LABEL	FAR
FLIN	PROC	FAR
	POP WORD PTR RETTMP	;SAVE RETURN
	POP WORD PTR RETTMP+2
	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI
	MOV	DI,DS		;SET UP ES FOR STRING OPS
	MOV	ES,DI

	POP	NOWDEV		;SET DEVICE CHANNEL
	SUB	SP,8		;MAKE STACK SPACE
	MOV	DI,SP		;POINT TO THE SPACE
	CALL	FINP		;INPUT A REAL

	XOR	DI,DI		;RESTORE ES = 0
	MOV	ES,DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTERS
	MOV	SI,SISAVE
	JMP	RETTMP		;RETURN
FLIN	ENDP
	PAGE

;48
;RLOUT(DEVICE, REAL)
;OUTPUT FLOATING POINT NUMBER ON TOS

INTR48	LABEL	FAR
FLOUT	PROC	FAR
	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI
	MOV	DI,DS		;SET UP ES FOR STRING OPS
	MOV	ES,DI

	MOV	SI,SP		;GET STACKPOINTER
	ADD	SI,4		;POINT TO REAL
	MOV	AX,[SI]+8	;GET DEVICE NUMBER
	MOV	NOWDEV,AX	;SET DEVICE NUMBER
	CALL	FOUT		;OUTPUT A REAL

	XOR	DI,DI		;RESTORE ES = 0
	MOV	ES,DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTERS
	MOV	SI,SISAVE
	RET	10		;DROP ARGS
FLOUT	ENDP

;51
;REAL:=RLABS(REAL)
;TAKE THE ABSOLUTE VALUE OF THE REAL NO. ON TOS.

INTR51	LABEL	FAR
FLABS	PROC	FAR
	MOV	BP,SP		;GET STACK POINTER
	AND	[BP]+10,7FFFH	;STRIP SIGN BIT
	RET
FLABS	ENDP

;52
;FORMAT(F1,F2)
;SET FORMAT OF FLOATING POINT NUMBER OUTPUT
;F1 >0  THEN FIXED POINT OUTPUT AND F1 SETS SPACE BEFORE DECIMAL
;F1 = 0 THEN SCIENTIFIC NOTATION
;F1 <0  THEN ENGINEERING NOTATION
;F2 = NUMBER OF DIGITS AFTER THE DECIMAL

INTR52	LABEL	FAR
FMTFUN	PROC	FAR
	MOV	BP,SP
	MOV	AX,[BP]+4
	MOV	FORM2,AX
	MOV	AX,[BP]+6
	MOV	FORM1,AX
	RET	4
FMTFUN	ENDP
