	TITLE	I2LIBM
	page	55,120

;I2LIBM.ASM	9-JUN-2012
;****** I2L MODULE FOR IBM PC TYPE COMPUTERS **********
;**           FOR IBM PC AND CLONES                  **
;**               VERSION 3.0                        **
;**    (also see XPLVER and LOADER in I2LLOD.ASM)    **
;** COPYRIGHT LARRY FISH 1988-2012                   **
;** CONTRIBUTIONS BY PETER BOYLE, LOREN BLANEY AND   **
;**    RICH OTTOSEN                                  **
;**  BASED ON APPLE VERSIONS WRITTEN BY PETER BOYLE  **
;******************************************************
;
;This program is free software; you can redistribute it and/or modify it under
; the terms of the GNU General Public License version 2 as published by the
; Free Software Foundation.
;This program is distributed in the hope that it will be useful, but WITHOUT
; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
; FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
; details.
;You should have received a copy of the GNU General Public License along with
; this program (in the file LICENSE.TXT); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;You can reach the authors at: loren.blaney@gmail.com
;
;REVISIONS:
;V2.4, 16-FEB-2001, Fix Clear intrinsic for mode $6A. Initialize device 6
; window to actual screen size (not necessarily 80x25). Add IRQ intrinsic
; (=80). Fix possible rounding error in Rlout. Equip intrinsic recognizes 586.
;V2.4.5, 15-SEP-2003, Modify Equip intrinsic (77) to work with Windows XP.
; Speed measurement changed by a factor of 10 (very rough). 5 = PC-XT.
;V2.4.6, 28-JUL-2004, Fix SetWin intrinsic (70) and device 6 to have correct
; background fill and scroll color when in a graphic video mode. Mode 13h has
; 256 foreground and background colors. Previously the background was always
; black (0). Point intrinsic is 0, 5 or 70 times faster depending on graphic
; mode. Horizontal line draw is up to 4 times faster for planar graphic modes
; (0Dh..12h). Compensate for nVidia bug that fills graphic screen with
; vertical bars.
;V2.5, 26-Dec-2006, Don't alter BX register when starting or restarting. Change
; label names to work with MASM 6.11 (FCOS -> FCOSINE; FSIN -> FSINE). Fix
; background colors for mode 13h on nVidia card.
;V2.6, 17-Mar-2008, Fix memory overflow detection in I2LLOD; set USRTOP=FF00h;
; ignore underlines in IntIn, HexIn, and RlIn.
;V2.7, 29-Jan-2010, 'downto' in 'for' loops. Added arithmetic shift right "->>".
; Added 'port' command.
;V2.7, 24-May-2010, conditional compile "SMALL" makes small version without
; floating point routines or high-speed line draw. Saves about 7K bytes.
;V2.8, 23-Feb-2011, Much faster ReadPix for mode 13h, and other minor speed-ups.
;V2.9, 31-Oct-2011, More random random number generator.
;V3.0, 09-Jun-2012, Faster, and even more random random number generator. Copy
; command tail into pseudo device 8. Fix10E+000 error in scientific notation due
; to rounding, and 1000E+000 error in engineering notation. Clear and SetVid
; intrinsics set pen to upper-left corner. Text intrinsic 81 for zero-terminated
; strings. Fix Sound intrinsic so date advances at midnight. Align heap to word.

SMALL	EQU	0	;0=GENERATE STANDARD VERSION; 1=GENERATE SMALL VERSION

;ALL THIS STUFF SETS THE PROGRAM UP AS A 'COM' FILE

CSEG	SEGMENT		;START CODE SEGMENT
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG

	ORG	0100H	;MAKE THIS A '.COM' FILE

;************ MAIN ENTRY POINT FOR I2L *************
; VECTORS TO LOADER WHEN FIRST EXECUTED
; VECTORS TO I2L AFTER PROGRAM IS LOADED

START:	JMP	WORD PTR [ENTVEC] ;JUMP TO IT
ENTVEC:	DW	LOADER		;VECTOR TO LOADER OR INTERPRETER

;SETUP PARAMETERS

USRTOP	EQU	0FF00H		;TOP USER AREA
	PAGE

;**************************************************************
;******* GLOBAL VARIABLE **************************************
;**************************************************************

;PUT THESE HERE SO ASSEMBLER KNOWS ABOUT THEM ON PASS ONE
;DEFINE SOME CHARACTERS

CR	EQU	0DH		;DEFINE RETURN
LF	EQU	0AH		;DEFINE LINE FEED
EOF	EQU	1AH		;END OF FILE
BEL	EQU	07H		;BELL CHARACTER

;EQUIPMENT LIST INFORMATION

XPLVER	EQU	30		;CURRENT VERSION NUMBER
XPLTYP	EQU	'I'		;XPL TYPE (ALSO CHANGE MESSAGE IN I2LLOD)

	EVEN
ENTSTK	DW	0		;STACK UPON PROGRAM ENTERY
STKPTR	DW	0		;STACK UPON MAIN PROCEDURE ENTRY

HP	DW	0		;HEAP POINTER
HEAPHI	DW	0		;END OF HEAP
TRAPS	DW	0		;ERROR TRAPS
RERUNF	DW	0		;RERUN FLAG
REMAIN	DW	0		;REMAINDER FROM LAST DIVIDE
ERRNUM	DB	0		;ERROR CODE
PCTMP	DW	0		;TEMPORARY FOR PC

;THESE LOCATIONS MUST BE SET BY THE LOADER

PROGLO	DW	0		;ADDRESS OF START OF .I2L CODE
HEAPLO	DW	0		;HEAP SPACE BEGINS HERE

;SET TRUE AND FALSE VALUES

TRUVAL	EQU	0FFFFH
FALVAL	EQU	0


;DISPLAY VECTOR:		LEVEL:
;	EVEN			;ALIGNING SLOWS SIEVE DOWN 20.0% ON DURON 850
DISPLY	DW	0		;0
	DW	0		;1
	DW	0		;2
	DW	0		;3
	DW	0		;4
	DW	0		;5
	DW	0		;6
	DW	0		;7
	PAGE
;ERROR MESSAGES

TSP	EQU	' '+80H		;DEFINE TERMINATING SPACE

EM0	DB	BEL,CR,LF,'ERROR',TSP
EMADD	DB	' @ ',TSP

ERRMSG	DW	EM1		;TABLE OF MESSAGE POINTERS
	DW	EM2
	DW	EM3
	DW	EM4
	DW	EM5
	DW	EM6
	DW	EM7
	DW	EM8
	DW	EM9
	DW	EM10
	DW	EM11
	DW	EM12
	DW	EM13
	DW	EM14
	DW	EM15

EM1	DB	': DIV BY 0',TSP
EM2	DB	': OUT OF MEMORY',TSP
EM3	DB	': I/O ERROR',TSP
EM4	DB	': BAD OPCODE',TSP
EM5	DB	': BAD INTRINSIC',TSP
EM6	DB	': DIV BY 0.0',TSP
EM7	DB	': OVERFLOW',TSP
EM8	DB	': UNDERFLOW',TSP
EM9	DB	': FIX OVERFLOW',TSP
EM10	DB	': SQRT < 0',TSP
EM11	DB	': LOG <= 0',TSP
EM12	DB	': EXP OVERFLOW',TSP
EM13	DB	': OVERFLOW',TSP
EM14	DB	': ATAN2(0.0,0.0)',TSP
EM15	DB	': ?',TSP
	PAGE

;I2LIBM IS DIVIDED INTO THE FOLLOWING FILES

;I2LIBM - MASTER MODULE, GLOBAL VARIABLES
;INTERP - INTERPRETER DISPATCH CODE AND TABLE
;I2LCOD - I2L OPCODES
;INTRIN1 - I2L INTRINSICS
;INTRIN2 - EXTENDED INTRINSICS
;I2LFLT - FLOATING POINT OPCODES, BASIC FP INTRINSICS
;FLTIO  - FLOATING POINT I/O ROUTINES
;FPACK  - BASIC FLOATING POINT ROUTINES
;TRANS  - TRANSCENDENTAL ROUTINES
;KHAND  - I/O DISPATCH CODE AND TABLES
;GRAPH  - GRAPHICS ROUTINES
;I2LDOS - MS-DOS ACCESS ROUTINES
;WINDOW - WINDOW ROUTINES
;LOWIO  - LOW LEVEL UNTILITY ROUTINES
;I2LLOD - I2L LOADER AND PROGRAM SAVER

	INCLUDE	INTERP.ASM
	INCLUDE	I2LCOD.ASM
	INCLUDE	INTRIN1.ASM
	INCLUDE INTRIN2.ASM

	IF SMALL		;ELIMINATE FLOATING POINT ROUTINES
	INCLUDE FLTNULL.ASM
	ELSE
	INCLUDE	I2LFLT.ASM
	INCLUDE	FLTIO.ASM
	INCLUDE	FPACK.ASM
	INCLUDE TRANS.ASM
	ENDIF

	INCLUDE	KHAND.ASM
	INCLUDE	GRAPH.ASM
	INCLUDE	I2LDOS.ASM
	INCLUDE WINDOW.ASM
	INCLUDE	LOWIO.ASM
	INCLUDE	I2LLOD.ASM

CSEG	ENDS

	END	START
