	PAGE

;*********************************************************
;************ I2L FLOATING POINT OPCODES *****************
;*********************************************************

;IMPLEMENTATION NOTE: All floating point variables are in
;the IEEE long real format, which is four word long (64 bits).
;Since all operations take place with reals on the stack,
;reals are stored in normal memory order on the stack and
;reverse order in memory. Normal order is in memory sequence,
;from low word to high word.

;DEFINE REAL SIZE, NOTE: If you change this value, there are
;a couple of places where I multply by 8 by shifting that
;you will have to modify

RELSIZ	EQU	8		;NUMBER OF BYTES IN A REAL

;I2L ERROR NUMBERS (TO BE PASSED TO ERROR HANDLER):

DIVZER	EQU	6	;DIVIDE BY ZERO
FOVFL	EQU	7	;FLOATING OVERFLOW
FUNFL	EQU	8	;FLOATING UNDERFLOW
INOVFL	EQU	9	;FIXED-POINT OVERFLOW


;$2A
;ROUTINE TO RETRIVE A FLOATING POINT VARIABLE'S VALUE
;AND PUSH IT ON THE STACK
;THREE-BYTE OPCODE:
;   THE OPCODE
;   THE LEVEL IN THE DISPLAY VECTOR OF THE BASE ADDRESS
;   THE OFFSET FROM THAT BASE ADDRESS OF THE ACTUAL VALUE

FLODDO:	MOV	BL,[DI]		;GET LEVEL NUMBER OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
	ADD	DI,2		;ADVANCE PC

	PUSH	[BX+SI]		;PUSH ON STACK
	PUSH	[BX+SI]+2
	PUSH	[BX+SI]+4
	PUSH	[BX+SI]+6
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)
	PAGE

;$2B
;ROUTINE TO STORE TOP OF STACK (TOS) INTO A VARIABLE

FSTODO:	MOV	BL,[DI]		;GET LEVEL OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET
	ADD	DI,2		;ADVANCE PC
	POP	[BX+SI]+6	;PUT INTO THE VARIABLE
	POP	[BX+SI]+4
	POP	[BX+SI]+2
	POP	[BX+SI]
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)


;$2C
;IMMEDIATE LOAD OF A 64-BIT REAL CONSTANT ONTO THE STACK

FIMMDO:	PUSH	[DI]		;PUSH CONSTANT IN REVERSE
	PUSH	[DI]+2
	PUSH	[DI]+4
	PUSH	[DI]+6

	ADD	DI,8		;ADVANCE PC
	JMP	OPGO		;GO GET NEXT OPCODE (BH=0)


;$2D
;TOS:=NOS + TOS

FADDDO:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FADDE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT



;$2E
;TOS:=NOS - TOS

FSUBDO:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FSUBE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
	PAGE


;$2F
;TOS:=NOS * TOS

FMULDO:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FMULE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT


;$30
;TOS:=NOS / TOS

FDIVDO:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FDIVE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
	PAGE

;FLOATING OPCODE EXIT FOR MATH
;STORE INTO STACK AND ADJUST IT
;TEST FOR ERRORS

FLTEXT:	ADD	SP,RELSIZ	;DROP TOS
FLTXTA:	MOV	DI,SP		;POINT TO NOS
	MOV SI,OFFSET FACT1	;POINT TO FACT1
	CALL	FSTORE
	MOV	DI,PCTMP	;RESTORE PC
	CMP	ERRNUM,0	;ALREADY GOT AN ERROR?
	JNZ	FLTXTX		;THEN JUST EXIT
	TEST BYTE PTR FSTAT,1CH	;ANY ERRORS WE CARE ABOUT?
	JZ	FLTXTX		;SKIP IF NOT

	TEST BYTE PTR FSTAT,04H	;DIVIDE BY ZERO?
	JZ	FLTXT1		;SKIP IF NOT
	MOV	AL,DIVZER	;FLAG IT
	JMP SHORT FLTXT3

FLTXT1:	TEST BYTE PTR FSTAT,08H	;OVERFLOW?
	JZ	FLTXT2		;SKIP IF NOT
	MOV	AL,FOVFL	;FLAG IT
	JMP SHORT FLTXT3

FLTXT2:	MOV	AL,FUNFL	;MUST BE UNDERFLOW
FLTXT3:	CALL	ERROR		;HANDLE THE ERROR

FLTXTX:	JMP	CMLRET


;SETUP FOR FLOATING POINT OPCODE

FLTSET:	MOV	PCTMP,DI	;SAVE PC
	MOV BYTE PTR FSTAT,0	;FLAG NO ERRORS
	MOV	SI,SP		;POINT TO TOS
	ADD	SI,2		;SKIP OVER RETURN ADDRESS

	MOV DI,OFFSET FACT2	;POINT TO FACT2
	CALL	FLOAD		;LOAD IT

	MOV	SI,SP		;POINT TO NOS
	ADD	SI,RELSIZ+2	;(SKIP RETURN ADDRESS)
	MOV DI,OFFSET FACT1	;POINT TO FACT1
	CALL	FLOAD		;LOAD IT

	JMP	SETFAG		;MAKE FACT1/FACT2 ARGUMENTS
	PAGE
;$31
;TOS:=-TOS

FNEGDO:	MOV	BX,SP		;GET STACK
	XOR	[BX+6],8000H	;COMPLIMENT SIGN
	JMP	CMLRET

;$32
;TOS:= NOS = TOS

FEQDO:	CALL	CMPSET
	JE	TRUEF
	JMP SHORT FLASEF

;$33
;TOS:= NOS # TOS

FNEDO:	CALL	CMPSET
	JNE	TRUEF
	JMP SHORT FLASEF

;$34
;TOS:= NOS >= TOS

FGEDO:	CALL	CMPSET
	JAE	TRUEF
	JMP SHORT FLASEF

;$35
;TOS:= NOS > TOS

FGTDO:	CALL	CMPSET
	JA	TRUEF
	JMP SHORT FLASEF
	PAGE

;$36
;TOS:= NOS <= TOS

FLEDO:	CALL	CMPSET
	JBE	TRUEF
	JMP SHORT FLASEF

;$37
;TOS:= NOS < TOS

FLTDO:	CALL	CMPSET
	JB	TRUEF
	JMP SHORT FLASEF


;HANDLE TRUE RESULT

TRUEF:	ADD	SP,RELSIZ*2	;TWO REALS OFF STACK
	MOV	AX,-1		;PUSH TRUE
	PUSH	AX
	MOV	DI,PCTMP	;RESTORE PC
	JMP	CMLRET


;HANDLE FALSE RESULT

FLASEF:	ADD	SP,RELSIZ*2	;TWO REALS OFF STACK
	XOR	AX,AX		;PUSH FALSE ON STACK
	PUSH	AX
	MOV	DI,PCTMP	;RESTORE PC
	JMP	CMLRET

;SETUP AND COMPARE TOS AND NOS

CMPSET:	MOV	PCTMP,DI	;SAVE PC
	MOV	DI,SP		;POINT TOS
	ADD	DI,2		;SKIP RETURN ADDRESS
	MOV	SI,DI		;POINT TO NOS
	ADD	SI,RELSIZ
	JMP	FCMP		;DO THE COMPARE
	PAGE

;$38
;MULTIPLY TOS (THE SUBSCRIPT) BY "REAL SIZE," AND ADD
; NOS (THE BASE ADDRESS) TO IT.
; TOS:=TOS*8 + NOS
; THIS OP IS USED TO STORE INDEXED REALS. IT IS THE
; FLOATING POINT COUNTERPART TO "DBA"

TRADO:	POP	AX		;GET TOS
	MOV	CL,3		;MULTIPLY BY 8
	SHL	AX,CL
	POP	CX		;GET NOS
	ADD	AX,CX		;ADD EM
	PUSH	AX
	JMP	OPGO


;$39
;MULTIPLY TOS (THE SUBSCRIPT) BY REAL SIZE AND ADD
; NOS (THE BASE ADDRESS) TO IT. PUSH THE CONTENTS OF
; THIS LOCATION WHICH A POINTER THE NEXT DIMENSION
; OF THE ARRAY.
; PUSH @(TOS*8 + NOS)
; THIS IS OP IS ALSO USED TO STORE INDEXED REALS.

TRXDO:	POP	BX		;GET TOS
	MOV	CL,3		;MULTIPLY BY 8
	SHL	BX,CL
	POP	SI		;GET NOS
	PUSH	[BX+SI]
	JMP	CMLRET

;$3A
;THIS ROUTINE ADDS 8*TOS + NOS, AND USES THE SUM AS AN
; ABSOLUTE ADDRESS FROM WHICH TO FETCH A VALUE.
; PUSH(8) @(8*TOS(2) + NOS(8))
;NOTE: NOS IS INTEGER PACKED INTO A REAL

TRIDO:	POP	BX		;GET TOS
	MOV	CL,3		;MULTIPLY BY 8
	SHL	BX,CL
	ADD	SP,6		;DUMP PART OF REAL
	POP	SI		;GET NOS
	PUSH	[BX+SI]		;PUSH ON STACK
	PUSH	[BX+SI]+2
	PUSH	[BX+SI]+4
	PUSH	[BX+SI]+6

	JMP	CMLRET
	PAGE

;$3B
;STORE THE 8 BYTES IN TOS INTO THE ABSOLUTE ADDRESS
; POINTED TO BY NOS. THIS OPCODE IS USED TO STORE
; INDEXED REAL NUMBERS.
; PULL(8) @(NOS)

STTDO:	MOV	BP,SP		;GET STACKPOINTER
	MOV	SI,[BP]+RELSIZ	;GET PLACE TO STORE
	POP	[SI]+6
	POP	[SI]+4
	POP	[SI]+2
	POP	[SI]

	ADD	SP,2		;ADJUST STACK
	JMP	OPGO
	PAGE

;*********************************************************
;************ FLOATING POINT INTRINSICS ******************
;*********************************************************


;REAL := RLRES(INTEGER)
;THE FLOATING-POINT RESERVE RESERVES TOS*8 BYTES OF HEAP
; SPACE, AND RETURNS THE STARTING 16 BIT ADDRESS PACKED INTO
; AN 8 BYTE REAL ON TOS

FLRES:	POP	AX		;GET RESERVE SIZE
	MOV	CL,3		;MULTIPLY BY 8
	SHL	AX,CL
	PUSH	[HP]		;PUSH ADDRESS OF RESERVE

	SUB	SP,6		;PUSH DUMMY VALUES

	ADD	HP,AX		;ADD TO HEAP
	JC	FLRES2		;ERROR IF IT WRAPS AROUND SEGMENT
	MOV	AX,HP		;HEAP OVERFLOW?
	CMP	AX,HEAPHI
	JB	FLRES1		;SKIP IF NOT
FLRES2:	MOV	AL,2		;I2L ERROR # 2
	CALL	ERROR		;HANDLE ERROR
FLRES1:	JMP	CMLRET		;DO NEXT OPCODE


;47
;REAL:=RLIN(DEVICE)
;INPUT A FLOATING-POINT NUMBER FROM THE DEVICE (TOS)
;RETURN AS 4 WORDS ON TOS

FLIN:	MOV	PCTMP,DI	;SAVE PC
	POP	NOWDEV		;SET DEVICE CHANNEL
	SUB	SP,8		;MAKE STACK SPACE
	MOV	DI,SP		;POINT TO THE SPACE
	CALL	FINP		;INPUT A REAL
	MOV	DI,PCTMP	;RESTORE PC
	JMP	CMLRET		;DO NEXT OP
	PAGE

;48
;RLOUT(DEVICE, REAL)
;OUTPUT FLOATING POINT NUMBER ON TOS

FLOUT:	MOV	PCTMP,DI	;SAVE DI
	MOV	SI,SP		;GET STACKPOINTER
	MOV	AX,[SI]+8	;GET DEVICE NUMBER
	MOV	NOWDEV,AX	;SET IT
	CALL	FOUT		;OUTPUT A REAL
	ADD	SP,10		;CLEAN STACK
	MOV	DI,PCTMP	;RESTORE PC
	JMP	CMLRET		;DO NEXT OP


;49
;REAL:=FLOAT(INTEGER)
;CONVERT THE INTEGER ON TOS TO A FLOATING POINT NUMBER

FLTFUN:	POP	BX		;GET THE NUMBER
	CALL	FLOAT		;FLOAT IT
	PUSH	AX		;PUSH SIGN, EXP, MANTISSA
	PUSH	BX		;PUSH MANTISSA
	XOR	CX,CX		;GET A ZERO
	PUSH	CX		;REST OF MANTISSA IS ZERO
	PUSH	CX
	JMP	CMLRET		;DO NEXT OP CODE


;50
;INTEGER:=FIX(REAL)
;CONVERT REAL ON TOS TO NEAREST INTEGER

FIXFUN:	POP	AX		;DISCARD M0 & M1
	POP	AX
	POP	BX		;GET M3
	POP	AX		;GET SIGN, EXP, MANTISSA
	CALL	FIX
	JNC	FIXFN1		;SKIP IF NO ERROR
	MOV	AL,INOVFL	;GET ERROR NUMBER
	CALL	ERROR		;HANDLE ERROR
	MOV	BX,7FFFH	;MAKE BIG INTEGER
FIXFN1:	PUSH	BX		;PUT RESULT IN TOS
	JMP	CMLRET		;DO NEXT OPCODE
	PAGE

;51
;REAL:=RLABS(REAL)
;TAKE THE ABSOLUTE VALUE OF THE REAL NO. ON TOS.

FLABS:	MOV	SI,SP		;GET STACK POINTER
	AND	[SI]+6,7FFFH	;STRIP SIGN BIT
	JMP	OPGO		;DO NEXT OPCODE


;52
;FORMAT(F1,F2)
;SET FORMAT OF FLOATING POINT NUMBER OUTPUT
;F1 >0  THEN FIXED POINT OUTPUT AND F1 SETS SPACE BEFORE DECIMAL
;F1 = 0 THEN SCIENTIFIC NOTATION
;F1 <0  THEN ENGINEERING NOTATION
;F2 = NUMBER OF DIGITS AFTER THE DECIMAL

FMTFUN:	POP	FORM2
	POP	FORM1
	JMP	OPGO
	PAGE

;*********************************************
;****** TRANSCENDENTAL INTRINSICS ************
;*********************************************

;53
;TOS:=SQRT(TOS)

FLSQRT:	CALL	STFONE		;DO SET UP
	CALL	FSQRTE		;DO SQUARE ROOT
	JMP	FLTXTA		;CLEAN UP AND EXIT

;54
;TOS:=LN(TOS)

FLLN:	CALL	STFONE		;DO SET UP
	CALL	LOGN		;DO NATURAL LOG
	JMP	FLTXTA		;CLEAN UP AND EXIT

;55
;TOS:=EXP(TOS)

FLEXP:	CALL	STFONE		;DO SET UP
	CALL	FEXP		;DO EXP
	JMP	FLTXTA		;CLEAN UP AND EXIT

;56
;TOS:=SIN(TOS)

FLSIN:	CALL	STFONE		;DO SET UP
	CALL	FSINE		;DO SINE
	JMP	FLTXTA		;CLEAN UP AND EXIT


;57
;TOS:=ATAN(NOS/TOS)

FLAT2:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	ATAN2		;DO ARC TAN
	JMP	FLTEXT		;CLEAN UP AND EXIT
	PAGE

;58
;TOS:=NOS MOD TOS

FLMOD:	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FMOD		;DO MODULO
	JMP	FLTEXT		;CLEAN UP AND EXIT


;59
;TOS:=LOG(TOS)

FLLOG:	CALL	STFONE		;DO SET UP
	CALL	LOGTEN		;DO LOG
	JMP	FLTXTA		;CLEAN UP AND EXIT


;60
;TOS:=COS(TOS)

FLCOS:	CALL	STFONE		;DO SET UP
	CALL	FCOSINE		;DO COSINE
	JMP	FLTXTA		;CLEAN UP AND EXIT


;61
;TOS:=TAN(TOS)

FLTAN:	CALL	STFONE		;DO SET UP
	CALL	FTAN		;DO TAN
	JMP	FLTXTA		;CLEAN UP AND EXIT


;62
;TOS:=ASIN(TOS)

FLASIN:	CALL	STFONE		;DO SET UP
	CALL	ASIN		;DO ASIN
	JMP	FLTXTA		;CLEAN UP AND EXIT
	PAGE

;63
;TOS:=ACOS(TOS)

FLACOS:	CALL	STFONE		;DO SET UP
	CALL	ACOS		;DO ACOS
	JMP	FLTXTA		;CLEAN UP AND EXIT


;ROUTINE TO SETUP FOR A SINGLE ARGUMENT FUNCTION

STFONE:	MOV	FSTAT,0		;ZERO STATUS
	MOV	PCTMP,DI	;SAVE PC
	MOV SI,SP		;POINT TOS
	ADD	SI,2		;SKIP OVER RETURN ADDRESS
	MOV DI,OFFSET FACT1	;POINT FACT1
	JMP	FLOAD		;LOAD IT
