\XPong.xpl	16-Jan-2005	Boreal/6502	loren_blaney@idcomm.com
\Rolling Ball Demo
\Compile with XPLPX (xpx.bat)

inc	c:\cxpl\codes;			\intrinsic definitions

def	Radius = 50;			\radius of ball (in horizontal pixels)
def	Radius2 =  50.0*50.0 - 38.0;	\radius squared & tweaked for highlight
def	PadWidth = 35;			\width of paddle (in pixels)
def	R1 = Radius/2,			\horz radius (/2 doubles rotation speed)
	R2 = 320-Radius-PadWidth,	\horizontal limit
	R3 = Radius*5/6,		\radius (in horizontal pixels)
	R4 = 200-R3;			\vertical limit
def	Aspect = 6./5.;			\correction factor for aspect ratio

int	CpuReg,		\address of CPU register array
	DSeg,		\segment address of our data
	X, Y,		\coordinates of center of ball (pixels)
	Vx, Vy,		\velocity of ball (pixels/video_blank)
	C,		\color
	I, J,		\coordinates of pixel to be plotted
	J320;		\J*320 (for efficiency)

real	Px, Py, Pz,	\3D coordinate of reference point relative to center of
			\ ball. Used to draw the green stripe
	Qx, Qy, Qz,	\coordinate of point about to be plotted relative to
			\ center of ball (horizontal pixels)
	A,		\angle of rotation (radians)
	T;		\temporary scratch

char	Image(64000);	\buffer for copy of video screen


begin	\Main
CpuReg:= GetReg;
DSeg:= CpuReg(12);
SetVid($13);				\320x200 graphics with 256 colors

\Set up VGA color registers with red, green, and blue gradients as follows:
\ blue	$00..$1D
\ varies $1E
\ white	$1F
\ red	$20..$3F and $40..$7F
\ green	$80..$BF and $C0..$FF
I:= $20;				\color register
port($3C8):= I;				\start right after bright white (=1Fh)
for J:= 0, 253 do
	begin
	port($3C9):= I;			\red
	port($3C9):= 0;			\green
	port($3C9):= 0;			\blue
	I:= I+1 & $7F;			\switch from red to green at I=$80
	if I = 0 then port($3C9):= I;	\ and from green to blue 2nd time around
	end;				\third time gives some blue up to $1E

X:= 150;   Y:= X;			\start ball in the middle somewhere
Vx:= 2;    Vy:= -1;			\initial velocity
Px:= 0.0;  Py:= 0.0;   Pz:= 1.0;	\unit vector: straight back into screen

repeat	begin
	\Draw ball with background
	for J:= 0, 200-1 do		\for all vertical screen pixels...
		begin
		Qy:= float(J-Y) * Aspect;
		J320:= J*320;
		for I:= 0, 320-1 do	\for all horizontal screen pixels...
			begin
			Qx:= float(I-X);
			T:= Radius2 - (Qx*Qx + Qy*Qy);

			\Display black paddle or horizontally scrolling plaid
			if abs(J-Y)<=Radius & I>=R2*2+Radius-X then C:= 0
			else C:= I+X | J;
			C:= C & $DC;	\darken background, eliminate white line

			if T >= 0.0 then	\Qx,Qy is inside ball
				begin
				Qz:= sqrt(T);	\height of point Qx,Qy
				C:= $1F;	\assume bright white highlight
				if fix(Qz) < Radius then
					begin
					C:= fix(Qz) + $40+14;	\redish
					\Dot product gives projection of Q
					\ vector along P vector
					if abs(Px*Qx + Py*Qy + Pz*Qz) <16.0 then
					     C:= C + $80-14; \greenish stripe
					end;
				end;
			Image(J320+I):= C;
			end;
		end;

	\Move ball and bounce it off the walls
	if X+Vx < R1  !  X+Vx >= R2 then Vx:= -Vx;
	X:= X + Vx;
	if Y+Vy < R3  !  Y+Vy >= R4 then Vy:= -Vy;
	Y:= Y + Vy;

	\Rotate vector P (difference equations accumulate too much error)
	A:= float(Vx) / float(R1);	\rotate about Y axis
	T:=  Px*Cos(A) + Pz*Sin(A);
	Pz:= Pz*Cos(A) - Px*Sin(A);
	Px:= T;
	A:= float(Vy) / float(R3);	\rotate about X axis
	T:=  Py*Cos(A) + Pz*Sin(A);
	Pz:= Pz*Cos(A) - Py*Sin(A);
	Py:= T;

	\Wait for vertical blank, to regulate speed
	repeat until port($3DA) & $08;	\test sync bit

	\Copy Image to screen (takes about 5ms--outruns video beam--no glitches)
	Blit(DSeg, Image, $A000, 0, 64000);
	end;
until ChkKey;				\exit program when a key is struck
OpenI(0);				\eat the keystroke
SetVid(3);				\restore normal text display
end;	\Main
