'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/canvas.n,v 1.19 93/08/06 11:11:03 ouster Exp $ SPRITE (Berkeley)
'/"
.so man.macros
.HS canvas tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
canvas \- Create and manipulate canvas widgets
.SH SYNOPSIS
\fBcanvas\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBinsertBorderWidth\fR	\fBrelief\fR	\fBxScrollCommand\fR
.VS
\fBborderWidth\fR	\fBinsertOffTime\fR	\fBselectBackground\fR	\fByScrollCommand\fR
\fBcursor\fR	\fBinsertOnTime\fR	\fBselectBorderWidth\fR
\fBinsertBackground\fR	\fBinsertWidth\fR	\fBselectForeground\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcloseEnough\fR
Class:	\fBCloseEnough\fR
Command-Line Switch:	\fB\-closeenough\fR
.fi
.IP
Specifies a floating-point value indicating how close the mouse cursor
must be to an item before it is considered to be ``inside'' the item.
Defaults to 1.0.
.LP
.nf
.VS
Name:	\fBconfine\fR
Class:	\fBConfine\fR
Command-Line Switch:	\fB\-confine\fR
.fi
.IP
Specifies a boolean value that indicates whether or not it should be
allowable to set the canvas's view outside the region defined by the
\fBscrollRegion\fR argument.
Defaults to true, which means that the view will
be constrained within the scroll region.
.VE
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies a desired window height that the canvas widget should request from
its geometry manager.  The value may be specified in any
of the forms described in the COORDINATES section below.
.LP
.nf
Name:	\fBscrollIncrement\fR
Class:	\fBScrollIncrement\fR
Command-Line Switch:	\fB\-scrollincrement\fR
.fi
.IP
Specifies a distance used as increment during scrolling:  when one of
the arrow buttons on an associated scrollbar is pressed, the picture
will shift by this distance.  The distance may be specified in any
of the forms described in the COORDINATES section below.
.LP
.nf
Name:	\fBscrollRegion\fR
Class:	\fBScrollRegion\fR
Command-Line Switch:	\fB\-scrollregion\fR
.fi
.IP
Specifies a list with four coordinates describing the left, top, right, and
bottom coordinates of a rectangular region.
This region is used for scrolling purposes and is considered to be
the boundary of the information in the canvas.
Each of the coordinates may be specified
in any of the forms given in the COORDINATES section below.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBwidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies a desired window width that the canvas widget should request from
its geometry manager.  The value may be specified in any
of the forms described in the COORDINATES section below.
.BE

.SH INTRODUCTION
.PP
The \fBcanvas\fR command creates a new window (given
by the \fIpathName\fR argument) and makes it into a canvas widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the canvas such as its colors and 3-D relief.
The \fBcanvas\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
Canvas widgets implement structured graphics.
A canvas displays any number of \fIitems\fR, which may be things like
rectangles, circles, lines, and text.
Items may be manipulated (e.g. moved or re-colored) and commands may
be associated with items in much the same way that the \fBbind\fR
command allows commands to be bound to widgets.  For example,
a particular command may be associated with the <Button-1> event
so that the command is invoked whenever button 1 is pressed with
the mouse cursor over an item.
This means that items in a canvas can have behaviors defined by
the Tcl scripts bound to them.

.SH "DISPLAY LIST"
.PP
The items in a canvas are ordered for purposes of display,
with the first item in the display list being displayed
first, followed by the next item in the list, and so on.
Items later in the display list obscure those that are
earlier in the display list and are sometimes referred to
as being ``on top'' of earlier items.
When a new item is created it is placed at the end of the
display list, on top of everything else.
Widget commands may be used to re-arrange the order of the
display list.

.SH "ITEM IDS AND TAGS"
.PP
Items in a canvas widget may be named in either of two ways:
by id or by tag.
Each item has a unique identifying number which is assigned to
that item when it is created.  The id of an item never changes
and id numbers are never re-used within the lifetime of a
canvas widget.
.PP
Each item may also have any number of \fItags\fR associated
with it.  A tag is just a string of characters, and it may
take any form except that of an integer.
For example, ``x123'' is OK but ``123'' isn't.
The same tag may be associated with many different items.
This is commonly done to group items in various interesting
ways;  for example, all selected items might be given the
tag ``selected''.
.PP
The tag \fBall\fR is implicitly associated with every item
in the canvas;  it may be used to invoke operations on
all the items in the canvas.
.PP
The tag \fBcurrent\fR is managed automatically by Tk;
it applies to the \fIcurrent item\fR, which is the
topmost item whose drawn area covers the position of
the mouse cursor.
If the mouse is not in the canvas widget or is not over
an item, then no item has the \fBcurrent\fR tag.
.PP
When specifying items in canvas widget commands, if the
specifier is an integer then it is assumed to refer to
the single item with that id.
If the specifier is not an integer, then it is assumed to
refer to all of the items in the canvas that have a tag
matching the specifier.
The symbol \fItagOrId\fR is used below to indicate that
an argument specifies either an id that selects a single
item or a tag that selects zero or more items.
Some widget commands only operate on a single item at a
time;  if \fItagOrId\fR is specified in a way that
names multiple items, then the normal behavior is for
the command to use the first (lowest) of these items in
the display list that is suitable for the command.
Exceptions are noted in the widget command descriptions
below.

.SH "COORDINATES"
.PP
All coordinates related to canvases are stored as floating-point
numbers.
Coordinates and distances are specified in screen units,
which are floating-point numbers optionally followed
by one of several letters.
If no letter is supplied then the distance is in pixels.
If the letter is \fBm\fR then the distance is in millimeters on
the screen;  if it is \fBc\fR then the distance is in centimeters;
\fBi\fR means inches, and \fBp\fR means printers points (1/72 inch).
Larger y-coordinates refer to points lower on the screen;  larger
x-coordinates refer to points farther to the right.

.SH TRANSFORMATIONS
.PP
Normally the origin of the canvas coordinate system is at the
upper-left corner of the window containing the canvas.
It is possible to adjust the origin of the canvas
coordinate system relative to the origin of the window using the
\fBxview\fR and \fByview\fR widget commands;  this is typically used
for scrolling.
Canvases do not support scaling or rotation of the canvas coordinate
system relative to the window coordinate system.
.PP
Indidividual items may be moved or scaled using widget commands
described below, but they may not be rotated.

.SH "INDICES"
.PP
Text items support the notion of an \fIindex\fR for identifying
particular positions within the item.
Indices are used for commands such as inserting text, deleting
a range of characters, and setting the insertion cursor position.
An index may be specified in any of a number of ways, and
different types of items may support different forms for
specifying indices.
Text items support the following forms for an index;  if you
define new types of text-like items, it would be advisable to
support as many of these forms as practical.
Note that it is possible to refer to the character just after
the last one in the text item;  this is necessary for such
tasks as inserting new text at the end of the item.
.TP 10
\fInumber\fR
A decimal number giving the position of the desired character
within the text item.
0 refers to the first character, 1 to the next character, and
so on.
A number less than 0 is treated as if it were zero, and a
number greater than the length of the text item is treated
as if it were equal to the length of the text item.
.TP 10
\fBend\fR
Refers to the character just after the last one in the item
(same as the number of characters in the item).
.TP 10
\fBinsert\fR
.VS
.VE
Refers to the character just before which the insertion cursor
is drawn in this item.
.TP 10
\fBsel.first\fR
Refers to the first selected character in the item.
If the selection isn't in this item then this form is illegal.
.TP 10
\fBsel.last\fR
Refers to the last selected character in the item.
If the selection isn't in this item then this form is illegal.
.TP 10
\fB@\fIx,y\fR
Refers to the character at the point given by \fIx\fR and
\fIy\fR, where \fIx\fR and \fIy\fR are specified in the coordinate
system of the canvas.
If \fIx\fR and \fIy\fR lie outside the coordinates covered by the
text item, then they refer to the first or last character in the
line that is closest to the given point.

.SH "WIDGET COMMAND"
.PP
The \fBcanvas\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
The following widget commands are possible for canvas widgets:
.TP
\fIpathName \fBaddtag \fItag searchSpec \fR?\fIarg arg ...\fR?
For each item that meets the constraints specified by
\fIsearchSpec\fR and the \fIarg\fRs, add
\fItag\fR to the list of tags associated with the item if it
isn't already present on that list.
It is possible that no items will satisfy the constraints
given by \fIsearchSpec and \fIarg\fRs, in which case the
command has no effect.
This command returns an empty string as result.
\fISearchSpec\fR and \fIarg\fR's may take any of the following
forms:
.RS
.TP
\fBabove \fItagOrId\fR
Selects the item just after (above) the one given by \fItagOrId\fR
in the display list.
If \fItagOrId\fR denotes more than one item, then the last (topmost)
of these items in the display list is used.
.TP
\fBall\fR
Selects all the items in the canvas.
.TP
\fBbelow \fItagOrId\fR
Selects the item just before (below) the one given by \fItagOrId\fR
in the display list.
If \fItagOrId\fR denotes more than one item, then the first (lowest)
of these items in the display list is used.
.TP
\fBclosest \fIx y \fR?\fIhalo\fR? ?\fIstart\fR?
Selects the item closest to the point given by \fIx\fR and \fIy\fR.
If more than one item is at the same closest distance (e.g. two
items overlap the point), then the top-most of these items (the
last one in the display list) is used.
If \fIhalo\fR is specified, then it must be a non-negative
value.
Any item closer than \fIhalo\fR to the point is considered to
overlap it.
The \fIstart\fR argument may be used to step circularly through
all the closest items.
If \fIstart\fR is specified, it names an item using a tag or id
(if by tag, it selects the first item in the display list with
the given tag).
Instead of selecting the topmost closest item, this form will
select the topmost closest item that is below \fIstart\fR in
the display list;  if no such item exists, then the selection
behaves as if the \fIstart\fR argument had not been specified.
.TP
\fBenclosed\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Selects all the items completely enclosed within the rectangular
region given by \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
\fIX1\fR must be no greater then \fIx2\fR and \fIy1\fR must be
no greater than \fIy2\fR.
.TP
\fBoverlapping\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Selects all the items that overlap or are enclosed within the
rectangular region given by \fIx1\fR, \fIy1\fR, \fIx2\fR,
and \fIy2\fR.
\fIX1\fR must be no greater then \fIx2\fR and \fIy1\fR must be
no greater than \fIy2\fR.
.TP
\fBwithtag \fItagOrId\fR
Selects all the items given by \fItagOrId\fR.
.RE
.TP
\fIpathName \fBbbox \fItagOrId\fR ?\fItagOrId tagOrId ...\fR?
.VS
Returns a list with four elements giving an approximate bounding box
for all the items named by the \fItagOrId\fR arguments.
The list has the form ``\fIx1 y1 x2 y2\fR'' such that the drawn
areas of all the named elements are within the region bounded by
\fIx1\fR on the left, \fIx2\fR on the right, \fIy1\fR on the top,
and \fIy2\fR on the bottom.
The return value may overestimate the actual bounding box by
a few pixels.
If no items match any of the \fItagOrId\fR arguments then an
empty string is returned.
.VE
.TP
\fIpathName \fBbind \fItagOrId\fR ?\fIsequence\fR? ?\fIcommand\fR?
This command associates \fIcommand\fR with all the items given by
\fItagOrId\fR such that whenever the event sequence given by
\fIsequence\fR occurs for one of the items the command will
be invoked.
This widget command is similar to the \fBbind\fR command except that
it operates on items in a canvas rather than entire widgets.
See the \fBbind\fR manual entry for complete details
on the syntax of \fIsequence\fR and the substitutions performed
on \fIcommand\fR before invoking it.
If all arguments are specified then a new binding is created, replacing
any existing binding for the same \fIsequence\fR and \fItagOrId\fR
(if the first character of \fIcommand\fR is ``+'' then \fIcommand\fR
augments an existing binding rather than replacing it).
In this case the return value is an empty string.
If \fIcommand\fR is omitted then the command returns the \fIcommand\fR
associated with \fItagOrId\fR and \fIsequence\fR (an error occurs
if there is no such binding).
If both \fIcommand\fR and \fIsequence\fR are omitted then the command
returns a list of all the sequences for which bindings have been
defined for \fItagOrId\fR.
.RS
.LP
The only events for which bindings may be specified are those related
to the mouse and keyboard, such as \fBEnter\fR, \fBLeave\fR,
\fBButtonPress\fR, \fBMotion\fR, and \fBKeyPress\fR.
The handling of events in canvases uses the current item defined
in ITEM IDS AND TAGS above.
\fBEnter\fR and \fBLeave\fR events trigger for an item when it
becomes the current item or ceases to be the current item;  note
that these events are different than \fBEnter\fR and \fBLeave\fR
events for windows.
Mouse-related events are directed to the current item, if any.
Keyboard-related events are directed to the focus item, if any
(see the \fBfocus\fR widget command below for more on this).
.LP
It is possible for multiple commands to be bound to a single
event sequence for a single object.
This occurs, for example, if one command is associated with the
item's id and another is associated with one of the item's tags.
When this occurs, the first matching binding is used.
A binding for the item's id has highest priority, followed by
the oldest tag for the item and proceeding through all of the
item's tags up through the most-recently-added one.
If a binding is associated with the tag \fBall\fR, the binding
will have lower priority than all other bindings associated
with the item.
.RE
.TP
\fIpathName \fBcanvasx \fIscreenx\fR ?\fIgridspacing\fR?
Given a screen x-coordinate \fIscreenx\fR this command returns
the canvas x-coordinate that is displayed at that location.
If \fIgridspacing\fR is specified, then the canvas coordinate is
rounded to the nearest multiple of \fIgridspacing\fR units.
.TP
\fIpathName \fBcanvasy \fIscreeny\fR ?\fIgridspacing\fR?
Given a screen y-coordinate \fIscreeny\fR this command returns
the canvas y-coordinate that is displayed at that location.
If \fIgridspacing\fR is specified, then the canvas coordinate is
rounded to the nearest multiple of \fIgridspacing\fR units.
.TP
\fIpathName \fBconfigure ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcanvas\fR
command.
.TP
\fIpathName\fR \fBcoords \fItagOrId \fR?\fIx0 y0 ...\fR?
.VS
Query or modify the coordinates that define an item.
If no coordinates are specified, this command returns a list
whose elements are the coordinates of the item named by
\fItagOrId\fR.
If coordinates are specified, then they replace the current
coordinates for the named item.
If \fItagOrId\fR refers to multiple items, then
the first one in the display list is used.
.VE
.TP
\fIpathName \fBcreate \fItype x y \fR?\fIx y ...\fR? ?\fIoption value ...\fR?
Create a new item in \fIpathName\fR of type \fItype\fR.
The exact format of the arguments after \fBtype\fR depends
on \fBtype\fR, but usually they consist of the coordinates for
one or more points, followed by specifications for zero or
more item options.
See the subsections on individual item types below for more
on the syntax of this command.
This command returns the id for the new item.
.TP
\fIpathName \fBdchars \fItagOrId first \fR?\fIlast\fR?
For each item given by \fItagOrId\fR, delete the characters
in the range given by \fIfirst\fR and \fIlast\fR,
inclusive.
If some of the items given by \fItagOrId\fR don't support
text operations, then they are ignored.
\fIFirst\fR and \fIlast\fR are indices of characters
within the item(s) as described in INDICES above.
If \fIlast\fR is omitted, it defaults to \fIfirst\fR.
This command returns an empty string.
.TP
\fIpathName \fBdelete \fR?\fItagOrId tagOrId ...\fR?
Delete each of the items given by each \fItagOrId\fR, and return
.VS
an empty string.
.VE
.TP
\fIpathName \fBdtag \fItagOrId \fR?tagToDelete\fR?
For each of the items given by \fItagOrId\fR, delete the
tag given by \fItagToDelete\fR from the list of those
associated with the item.
If an item doesn't have the tag \fItagToDelete\fR then
the item is unaffected by the command.
If \fItagToDelete\fR is omitted then it defaults to \fItagOrId\fR.
This command returns an empty string.
.TP
\fIpathName \fBfind \fIsearchCommand \fR?\fIarg arg ...\fR?
This command returns a list consisting of all the items that
meet the constraints specified by \fIsearchCommand\fR and
\fIarg\fR's.
\fISearchCommand\fR and \fIargs\fR have any of the forms
accepted by the \fBaddtag\fR command.
.TP
\fIpathName \fBfocus \fR?\fItagOrId\fR?
Set the keyboard focus for the canvas widget to the item given by
\fItagOrId\fR.
If \fItagOrId\fR refers to several items, then the focus is set
to the first such item in the display list that supports the
insertion cursor.
If \fItagOrId\fR doesn't refer to any items, or if none of them
support the insertion cursor, then the focus isn't changed.
If \fItagOrId\fR is an empty
string, then the focus item is reset so that no item has the focus.
If \fItagOrId\fR is not specified then the command returns the
id for the item that currently has the focus, or an empty string
if no item has the focus.
.RS
.LP
Once the focus has been set to an item, the item will display
the insertion cursor and all keyboard events will be directed
to that item.
The focus item within a canvas and the focus window on the
screen (set with the \fBfocus\fR command) are totally independent:
a given item doesn't actually have the input focus unless (a)
its canvas is the focus window and (b) the item is the focus item
within the canvas.
In most cases it is advisable to follow the \fBfocus\fR widget
command with the \fBfocus\fR command to set the focus window to
the canvas (if it wasn't there already).
.RE
.TP
\fIpathName \fBgettags\fR \fItagOrId\fR
Return a list whose elements are the tags associated with the
item given by \fItagOrId\fR.
If \fItagOrId\fR refers to more than one item, then the tags
are returned from the first such item in the display list.
If \fItagOrId\fR doesn't refer to any items, or if the item
contains no tags, then an empty string is returned.
.TP
\fIpathName \fBicursor \fItagOrId index\fR
.VS
Set the position of the insertion cursor for the item(s)
given by \fItagOrId\fR
to just before the character whose position is given by \fIindex\fR.
If some or all of the items given by \fItagOrId\fR don't support
an insertion cursor then this command has no effect on them.
See INDICES above for a description of the
legal forms for \fIindex\fR.
Note:  the insertion cursor is only displayed in an item if
that item currently has the keyboard focus (see the widget
command \fBfocus\fR, below), but the cursor position may
be set even when the item doesn't have the focus.
This command returns an empty string.
.VE
.TP
\fIpathName \fBindex \fItagOrId index\fR
This command returns a decimal string giving the numerical index
within \fItagOrId\fR corresponding to \fIindex\fR.
\fIIndex\fR gives a textual description of the desired position
as described in INDICES above.
The return value is guaranteed to lie between 0 and the number
of characters within the item, inclusive.
If \fItagOrId\fR refers to multiple items, then the index
is processed in the first of these items that supports indexing
operations (in display list order).
.TP
\fIpathName \fBinsert \fItagOrId beforeThis string\fR
For each of the items given by \fItagOrId\fR, if the item supports
text insertion then \fIstring\fR is inserted into the item's
text just before the character whose index is \fIbeforeThis\fR.
See INDICES above for information about the forms allowed
for \fIbeforeThis\fR.
This command returns an empty string.
.TP
\fIpathName \fBitemconfigure \fItagOrId\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies item-specific options for the items given by
\fItagOrId\fR instead of modifying options for the overall
canvas widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for the first item given by \fItagOrId\fR
(see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s) in
each of the items given by \fItagOrId\fR;  in
this case the command returns an empty string.
The \fIoption\fRs and \fIvalue\fRs are the same as those permissible
in the \fBcreate\fR widget command when the item(s) were created;
see the sections describing individual item types below for details
on the legal options.
.TP
\fIpathName \fBlower \fItagOrId \fR?\fIbelowThis\fR?
Move all of the items given by \fItagOrId\fR to a new position
in the display list just before the item given by \fIbelowThis\fR.
If \fItagOrId\fR refers to more than one item then all are moved
but the relative order of the moved items will not be changed.
\fIBelowThis\fR is a tag or id;  if it refers to more than one
item then the first (lowest) of these items in the display list is used
as the destination location for the moved items.
This command returns an empty string.
.TP
\fIpathName \fBmove \fItagOrId xAmount yAmount\fR
Move each of the items given by \fItagOrId\fR in the canvas coordinate
space by adding \fIxAmount\fR to the x-coordinate of each point
associated with the item and \fIyAmount\fR to the y-coordinate of
each point associated with the item.
This command returns an empty string.
.TP
\fIpathName \fBpostscript \fR?\fIoption value option value ...\fR?
.VS
Generate a Postscript representation for part or all of the canvas.
If the \fB\-file\fR option is specified then the Postscript is written
to a file and an empty string is returned;  otherwise the Postscript
is returned as the result of the command.
The Postscript is created in Encapsulated Postscript form using
version 3.0 of the Document Structuring Conventions.
The \fIoption\fR\-\fIvalue\fR argument pairs provide additional
information to control the generation of Postscript.  The following
options are supported:
.RS
.TP
\fB\-colormap \fIvarName\fR
\fIVarName\fR must be the name of a global array variable
that specifies a color mapping to use in the Postscript.
Each element of \fIvarName\fR must consist of Postscript
code to set a particular color value (e.g. ``\fB1.0 1.0 0.0 setrgbcolor\fR'').
When outputting color information in the Postscript, Tk checks
to see if there is an element of \fIvarName\fR with the same
name as the color.
If so, Tk uses the value of the element as the Postscript command
to set the color.
If this option hasn't been specified, or if there isn't an entry
in \fIvarName\fR for a given color, then Tk uses the red, green,
and blue intensities from the X color.
.TP
\fB\-colormode \fImode\fR
Specifies how to output color information.  \fIMode\fR must be either
\fBcolor\fR (for full color output), \fBgray\fR (convert all colors
to their gray-scale equivalents) or \fBmono\fR (convert all colors
to black or white).
.TP
\fB\-file \fIfileName\fR
Specifies the name of the file in which to write the Postscript.
If this option isn't specified then the Postscript is returned as the
result of the command instead of being written to a file.
.TP
\fB\-fontmap \fIvarName\fR
\fIVarName\fR must be the name of a global array variable
that specifies a font mapping to use in the Postscript.
Each element of \fIvarName\fR must consist of a Tcl list with
two elements, which are the name and point size of a Postscript font.
When outputting Postscript commands for a particular font, Tk
checks to see if \fIvarName\fR contains an element with the same
name as the font.
If there is such an element, then the font information contained in
that element is used in the Postscript.
Otherwise Tk attempts to guess what Postscript font to use.
Tk's guesses generally only work for well-known fonts such as
Times and Helvetica and Courier, and only if the X font name does not
omit any dashes up through the point size.
For example, \fB\-*\-Courier\-Bold\-R\-Normal\-\-*\-120\-*\fR will work but
\fB*Courier\-Bold\-R\-Normal*120*\fR will not;  Tk needs the dashes to
parse the font name).
.TP
\fB\-height \fIsize\fR
Specifies the height of the area of the canvas to print.
Defaults to the height of the canvas window.
.TP
\fB\-pageanchor \fIanchor\fR
Specifies which point of the printed area should be appear over
the positioning point on the page (which is given by the \fB\-pagex\fR
and \fB\-pagey\fR options).
For example, \fB\-pageanchor n\fR means that the top center of the
printed area should be over the positioning point.
Defaults to \fBcenter\fR.
.TP
\fB\-pageheight \fIsize\fR
Specifies that the Postscript should be scaled in both x and y so
that the printed area is \fIsize\fR high on the Postscript page.
\fISize\fR consists of a floating-point number followed by
\fBc\fR for centimeters, \fBi\fR for inches, \fBm\fR for millimeters,
or \fBp\fR or nothing for printer's points (1/72 inch).
Defaults to the height of the printed area on the screen.
If both \fB\-pageheight\fR and \fB\-pagewidth\fR are specified then
the scale factor from the later option is used (non-uniform scaling
is not implemented).
.TP
\fB\-pagewidth \fIsize\fR
Specifies that the Postscript should be scaled in both x and y so
that the printed area is \fIsize\fR wide on the Postscript page.
\fISize\fR has the same form as for \fB\-pageheight\fR.
Defaults to the width of the printed area on the screen.
If both \fB\-pageheight\fR and \fB\-pagewidth\fR are specified then
the scale factor from the later option is used (non-uniform scaling
is not implemented).
.TP
\fB\-pagex \fIposition\fR
\fIPosition\fR gives the x-coordinate of the positioning point on
the Postscript page, using any of the forms allowed for \fB\-pageheight\fR.
Used in conjunction with the \fB\-pagey\fR and \fB\-pageanchor\fR options
to determine where the printed area appears on the Postscript page.
Defaults to the center of the page.
.TP
\fB\-pagey \fIposition\fR
\fIPosition\fR gives the y-coordinate of the positioning point on
the Postscript page, using any of the forms allowed for \fB\-pageheight\fR.
Used in conjunction with the \fB\-pagex\fR and \fB\-pageanchor\fR options
to determine where the printed area appears on the Postscript page.
Defaults to the center of the page.
.TP
\fB\-rotate \fIboolean\fR
\fIBoolean\fR specifies whether the printed area is to be rotated 90
degrees.
In non-rotated output the x-axis of the printed area runs along
the short dimension of the page (``portrait'' orientation);
in rotated output the x-axis runs along the long dimension of the
page (``landscape'' orientation).
Defaults to non-rotated.
.TP
\fB\-width \fIsize\fR
Specifies the width of the area of the canvas to print.
Defaults to the width of the canvas window.
.TP
\fB\-x \fIposition\fR
Specifies the x-coordinate of the left edge of the area of the
canvas that is to be printed, in canvas coordinates, not window
coordinates.
Defaults to the coordinate of the left edge of the window.
.TP
\fB\-y \fIposition\fR
Specifies the y-coordinate of the top edge of the area of the
canvas that is to be printed, in canvas coordinates, not window
coordinates.
Defaults to the coordinate of the top edge of the window.
.RE
.VE
.TP
\fIpathName \fBraise \fItagOrId \fR?\fIaboveThis\fR?
Move all of the items given by \fItagOrId\fR to a new position
in the display list just after the item given by \fIaboveThis\fR.
If \fItagOrId\fR refers to more than one item then all are moved
but the relative order of the moved items will not be changed.
\fIAboveThis\fR is a tag or id;  if it refers to more than one
item then the last (topmost) of these items in the display list is used
as the destination location for the moved items.
This command returns an empty string.
.TP
\fIpathName \fBscale \fItagOrId xOrigin yOrigin xScale yScale\fR
Rescale all of the items given by \fItagOrId\fR in canvas coordinate
space.
\fIXOrigin\fR and \fIyOrigin\fR identify the origin for the scaling
operation and \fIxScale\fR and \fIyScale\fR identify the scale
factors for x- and y-coordinates, respectively (a scale factor of
1.0 implies no change to that coordinate).
For each of the points defining each item, the x-coordinate is
adjusted to change the distance from \fIxOrigin\fR by a factor
of \fIxScale\fR.
Similarly, each y-coordinate is adjusted to change the distance
from \fIyOrigin\fR by a factor of \fIyScale\fR.
This command returns an empty string.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on canvases.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the canvas's current view;  used
in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget and \fIx\fR and \fIy\fR are the coordinates of the
mouse.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
This command computes the difference between its \fIx\fR and \fIy\fR
arguments (which are typically mouse coordinates) and the \fIx\fR and
\fIy\fR arguments to the last \fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the canvas at high speed through its window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBselect \fIoption\fR ?\fItagOrId arg\fR?
Manipulates the selection in one of several ways, depending on
\fIoption\fR.
The command may take any of the forms described below.
In all of the descriptions below, \fItagOrId\fR must refer to
an item that supports indexing and selection;  if it refers to
multiple items then the first of
these that supports indexing and the selection is used.
\fIIndex\fR gives a textual description of a position
within \fItagOrId\fR, as described in INDICES above.
.RS
.TP
\fIpathName \fBselect adjust \fItagOrId index\fR
Locate the end of the selection in \fItagOrId\fR nearest
to the character given by \fIindex\fR, and adjust that
end of the selection to be at \fIindex\fR (i.e. including
but not going beyond \fIindex\fR).
The other end of the selection is made the anchor point
for future \fBselect to\fR commands.
If the selection isn't currently in \fItagOrId\fR then
this command behaves the same as the \fBselect to\fR widget
command.
Returns an empty string.
.TP
\fIpathName \fBselect clear\fR
Clear the selection if it is in this widget.
If the selection isn't in this widget then the command
has no effect.
Returns an empty string.
.TP
\fIpathName \fBselect from \fItagOrId index\fR
Set the selection anchor point for the widget to be just
before the character
given by \fIindex\fR in the item given by \fItagOrId\fR.
This command doesn't change the selection;  it just sets
the fixed end of the selection for future \fBselect to\fR
commands.
Returns an empty string.
.TP
\fIpathName \fBselect item\fR
Returns the id of the selected item, if the selection is in an
item in this canvas.
If the selection is not in this canvas then an empty string
is returned.
.TP
\fIpathName \fBselect to \fItagOrId index\fR
Set the selection to consist of those characters of \fItagOrId\fR
between the selection anchor point and
\fIindex\fR.
The new selection will include the character given by \fIindex\fR;
it will include the character given by the anchor point only if
\fIindex\fR is greater than or equal to the anchor point.
The anchor point is determined by the most recent \fBselect adjust\fR
or \fBselect from\fR command for this widget.
If the selection anchor point for the widget isn't currently in
\fItagOrId\fR, then it is set to the same character given
by \fIindex\fR.
Returns an empty string.
.RE
.TP
\fIpathName \fBtype\fI tagOrId\fR
Returns the type of the item given by \fItagOrId\fR, such as
\fBrectangle\fR or \fBtext\fR.
If \fItagOrId\fR refers to more than one item, then the type
of the first item in the display list is returned.
If \fItagOrId\fR doesn't refer to any items at all then
an empty string is returned.
.TP
\fIpathName \fBxview\fI index\fR
Change the view in the canvas so that the canvas position given by
\fIindex\fR appears at the left edge of the window.
This command is typically used by scrollbars to scroll the
canvas.
\fIIndex\fR counts in units of scroll increments (the value of the
\fBscrollIncrement\fR option):  a value of 0 corresponds to the left
edge of the scroll region (as defined by the \fBscrollRegion\fR
option),  a value of 1 means one scroll unit to the right of this,
and so on.  The return value is an empty string.
.TP
\fIpathName \fByview\fI index\fR
Change the view in the canvas so that the canvas position given by
\fIindex\fR appears at the top edge of the window.
This command is typically used by scrollbars to scroll the
canvas.
\fIIndex\fR counts in units of scroll increments (the value of the
\fBscrollIncrement\fR option):  a value of 0 corresponds to the top
edge of the scroll region (as defined by the \fBscrollRegion\fR
option),  a value of 1 means one scroll unit below this,
and so on.  The return value is an empty string.

.SH "OVERVIEW OF ITEM TYPES"
.PP
The sections below describe the various types of items supported
by canvas widgets.  Each item type is characterized by two things:
first, the form of the \fBcreate\fR command used to create
instances of the type;  and second, a set of configuration options
for items of that type, which may be used in the
\fBcreate\fR and \fBitemconfigure\fR widget commands.
Most items don't support indexing or selection or the commands
related to them, such as \fBindex\fR and \fBinsert\fR.
Where items do support these facilities, it is noted explicitly
in the descriptions below (at present, only text items provide
this support).

.SH "ARC ITEMS"
.PP
.VS
Items of type \fBarc\fR appear on the display as arc-shaped regions.
An arc is a section of an oval delimited by two angles (specified
by the \fB\-start\fR and \fB\-extent\fR options) and displayed in
one of several ways (specified by the \fB\-style\fR option).
Arcs are created with widget commands of the following form:
.DS
\fIpathName \fBcreate arc \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of a
rectangular region enclosing the oval that defines the arc.
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for arcs:
.TP
\fB\-extent \fIdegrees\fR
Specifies the size of the angular range occupied by the arc.
The arc's range extends for \fIdegrees\fR degrees counter-clockwise
from the starting angle given by the \fB\-start\fR option.
\fIDegrees\fR may be negative.
.TP
\fB\-fill \fIcolor\fR
Fill the region of the arc with \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default), then
then the arc will not be filled.
.TP
\fB\-outline \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the arc's
outline;  it may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.  If the arc's style is
\fBarc\fR then this option is ignored (the section of perimeter is
filled using the \fB\-fill\fR option).  If \fIcolor\fR is specified
as an empty string then no outline is drawn for the arc.
.TP
\fB\-start \fIdegrees\fR
Specifies the beginning of the angular range occupied by the
arc.
\fIDegrees\fR is given in units of degrees measured counter-clockwise
from the 3-o'clock position;  it may be either positive or negative.
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the arc should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB\-fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling is done
in a solid fashion.
.TP
\fB\-style \fItype\fR
Specifies how to draw the arc.  If \fItype\fR is \fBpieslice\fR
(the default) then the arc's region is defined by a section
of the oval's perimeter plus two line segments, one between the center
of the oval and each end of the perimeter section.
If \fItype\fR is \fBchord\fR then the arc's region is defined
by a section of the oval's perimeter plus a single line segment
connecting the two end points of the perimeter section.
If \fItype\fR is \fBarc\fR then the arc's region consists of
a section of the perimeter alone.  In this last case there is
no outline for the arc and the \fB\-outline\fR option is ignored.
.TP
\fB\-tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB\-width \fIoutlineWidth\fR
Specifies the width of the outline to be drawn around
the arc's region, in any of the forms described in the COORDINATES
section above.
If the \fB\-outline\fR option has been specified as an empty string
then this option has no effect.
Wide outlines will be drawn centered on the edges of the arc's region.
This option defaults to 1.0.

.SH "BITMAP ITEMS"
.PP
Items of type \fBbitmap\fR appear on the display as images with
two colors, foreground and background.
Bitmaps are created with widget commands of the following form:
.DS
\fIpathName \fBcreate bitmap \fIx y \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the bitmap on the display (see the \fB\-anchor\fR
option below for more information on how bitmaps are displayed).
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for bitmaps:
.TP
\fB\-anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the bitmap relative to the
positioning point for the item;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the bitmap is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the bitmap will be drawn so that
its top center point is at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB\-background \fIcolor\fR
Specifies a color to use for each of the bitmap pixels
whose value is 0.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If this option isn't specified, or if it is specified as an empty
string, then the background color for the canvas is used.
.TP
\fB\-bitmap \fIbitmap\fR
Specifies the bitmap to display in the item.
\fIBitmap\fR may have any of the forms accepted by \fBTk_GetBitmap\fR.
.TP
\fB\-foreground \fIcolor\fR
Specifies a color to use for each of the bitmap pixels
whose value is 1.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR and
defaults to \fBblack\fR.
.TP
\fB\-tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE

.SH "LINE ITEMS"
.PP
Items of type \fBline\fR appear on the display as one or more connected
line segments or curves.
Lines are created with widget commands of the following form:
.DS
\fIpathName \fBcreate line \fIx1 y1... xn yn \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR through \fIyn\fR give
the coordinates for a series of two or more points that describe
a series of connected line segments.
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for lines:
.TP
\fB\-arrow \fIwhere\fR
Indicates whether or not arrowheads are to be drawn at one or both
ends of the line.
\fIWhere\fR must have one of the values \fBnone\fR (for no arrowheads),
\fBfirst\fR (for an arrowhead at the first point of the line),
\fBlast\fR (for an arrowhead at the last point of the line), or
\fBboth\fR (for arrowheads at both ends).
This option defaults to \fBnone\fR.
.TP
\fB\-arrowshape \fIshape\fR
This option indicates how to draw arrowheads.
The \fIshape\fR argument must be a list with three elements, each
specifying a distance in any of the forms described in
the COORDINATES section above.
The first element of the list gives the distance along the line
from the neck of the arrowhead to its tip.
The second element gives the distance along the line from the
trailing points of the arrowhead to the tip, and the third
element gives the distance from the outside edge of the line to the
trailing points.
If this option isn't specified then Tk picks a ``reasonable'' shape.
.TP
\fB\-capstyle \fIstyle\fR
Specifies the ways in which caps are to be drawn at the endpoints
of the line.
\fIStyle\fR may have any of the forms accepted by \fBTk_GetCapStyle\fR
(\fBbutt\fR, \fBprojecting\fR, or \fBround\fR).
If this option isn't specified then it defaults to \fBbutt\fR.
Where arrowheads are drawn the cap style is ignored.
.TP
\fB\-fill \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the line; it may have
any of the forms acceptable to \fBTk_GetColor\fR.  It may also be an
empty string, in which case the line will be transparent.
This option defaults to \fBblack\fR.
.TP
\fB\-joinstyle \fIstyle\fR
Specifies the ways in which joints are to be drawn at the vertices
of the line.
\fIStyle\fR may have any of the forms accepted by \fBTk_GetCapStyle\fR
(\fBbevel\fR, \fBmiter\fR, or \fBround\fR).
If this option isn't specified then it defaults to \fBmiter\fR.
If the line only contains two points then this option is
irrelevant.
.TP
\fB\-smooth \fIboolean\fR
.VS
\fIBoolean\fR must have one of the forms accepted by \fBTk_GetBoolean\fR.
It indicates whether or not the line should be drawn as a curve.
If so, the line is rendered as a set of Bezier splines: one spline
is drawn for the first and second line segments, one for the second
and third, and so on.  Straight-line segments can be generated within
a curve by duplicating the end-points of the desired line segment.
.TP
\fB\-splinesteps \fInumber\fR
Specifies the degree of smoothness desired for curves:  each spline
will be approximated with \fInumber\fR line segments.  This
option is ignored unless the \fB\-smooth\fR option is true.
.VE
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the line should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default), then filling is
done in a solid fashion.
.TP
\fB\-tags \fItagList\fR
.VS
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE
.TP
\fB\-width \fIlineWidth\fR
\fILineWidth\fR specifies the width of the line, in any of the forms
described in the COORDINATES section above.
Wide lines will be drawn centered on the path specified by the
points.
If this option isn't specified then it defaults to 1.0.

.SH "OVAL ITEMS"
.PP
Items of type \fBoval\fR appear as circular or oval regions on
the display.  Each oval may have an outline, a fill, or
both.  Ovals are created with widget commands of the
following form:
.DS
\fIpathName \fBcreate oval \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of a
rectangular region enclosing the oval.
The oval will include the top and left edges of the rectangle
not the lower or right edges.
If the region is square then the resulting oval is circular;
otherwise it is elongated in shape.
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for ovals:
.TP
\fB\-fill \fIcolor\fR
Fill the area of the oval with \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default), then
then the oval will not be filled.
.TP
\fB\-outline \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the oval's
outline;  it may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.
If \fIcolor\fR is an empty string then no outline will be
drawn for the oval.
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the oval should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB\-fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling is done
in a solid fashion.
.TP
\fB\-tags \fItagList\fR
.VS
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE
.TP
\fB\-width \fIoutlineWidth\fR
\fIoutlineWidth\fR specifies the width of the outline to be drawn around
the oval, in any of the forms described in the COORDINATES section above.
If the \fB\-outline\fR option hasn't been specified then this option
has no effect.
.VS
Wide outlines are drawn centered on the oval path defined by
\fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
.VE
This option defaults to 1.0.

.SH "POLYGON ITEMS"
.PP
Items of type \fBpolygon\fR appear as polygonal or curved filled regions
on the display.
Polygons are created with widget commands of the following form:
.DS
\fIpathName \fBcreate polygon \fIx1 y1 ... xn yn \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR through \fIyn\fR specify the coordinates for
three or more points that define a closed polygon.
The first and last points may be the same;  whether they are or not,
Tk will draw the polygon as a closed polygon.
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for polygons:
.TP
\fB\-fill \fIcolor\fR
\fIColor\fR specifies a color to use for filling the area of the
polygon; it may have any of the forms acceptable to \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string then the polygon will be
transparent.
This option defaults to \fBblack\fR.
.TP
\fB\-smooth \fIboolean\fR
.VS
\fIBoolean\fR must have one of the forms accepted by \fBTk_GetBoolean\fR
It indicates whether or not the polygon should be drawn with a
curved perimeter.
If so, the outline of the polygon becomes a set of Bezier splines,
one spline for the first and second line segments, one for the second
and third, and so on.  Straight-line segments can be generated in a
smoothed polygon by duplicating the end-points of the desired line segment.
.TP
\fB\-splinesteps \fInumber\fR
Specifies the degree of smoothness desired for curves:  each spline
will be approximated with \fInumber\fR line segments.  This
option is ignored unless the \fB\-smooth\fR option is true.
.VE
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the polygon should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default), then filling is
done in a solid fashion.
.TP
\fB\-tags \fItagList\fR
.VS
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE

.SH "RECTANGLE ITEMS"
.PP
Items of type \fBrectangle\fR appear as rectangular regions on
the display.  Each rectangle may have an outline, a fill, or
both.  Rectangles are created with widget commands of the
following form:
.DS
\fIpathName \fBcreate rectangle \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of the rectangle
(the rectangle will include its upper and left edges but not
its lower or right edges).
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for rectangles:
.TP
\fB\-fill \fIcolor\fR
Fill the area of the rectangle with \fIcolor\fR, which may be
specified in any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default), then
then the rectangle will not be filled.
.TP
\fB\-outline \fIcolor\fR
Draw an outline around the edge of the rectangle in \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.
If \fIcolor\fR is an empty string then no outline will be
drawn for the rectangle.
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the rectangle should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB\-fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling
is done in a solid fashion.
.TP
\fB\-tags \fItagList\fR
.VS
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE
.TP
\fB\-width \fIoutlineWidth\fR
\fIOutlineWidth\fR specifies the width of the outline to be drawn around
the rectangle, in any of the forms described in the COORDINATES section above.
If the \fB\-outline\fR option hasn't been specified then this option
has no effect.
.VS
Wide outlines are drawn centered on the rectangular path
defined by \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
.VE
This option defaults to 1.0.

.SH "TEXT ITEMS"
.PP
A text item displays a string of characters on the screen in one
or more lines.
Text items support indexing and selection, along with the
following text-related canvas widget commands:  \fBdchars\fR,
\fBfocus\fR, \fBicursor\fR, \fBindex\fR, \fBinsert\fR,
.VS
.VE
\fBselect\fR.
Text items are created with widget commands of the following
form:
.DS
\fIpathName \fBcreate text \fIx y \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the text on the display (see the options
below for more information on how text is displayed).
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for text items:
.TP
\fB\-anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the text relative to the
positioning point for the text;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the text is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the text will be drawn such that
the top center point of the rectangular region occupied by the
text will be at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB\-fill \fIcolor\fR
\fIColor\fR specifies a color to use for filling the text characters;
it may have any of the forms accepted by \fBTk_GetColor\fR.
If this option isn't specified then it defaults to \fBblack\fR.
.TP
\fB\-font \fIfontName\fR
Specifies the font to use for the text item.
\fIFontName\fR may be any string acceptable to \fBTk_GetFontStruct\fR.
If this option isn't specified, it defaults to a system-dependent
font.
.TP
\fB\-justify \fIhow\fR
Specifies how to justify the text within its bounding region.
\fIHow\fR must be one of the values \fBleft\fR, \fBright\fR,
or \fBcenter\fR.
This option will only matter if the text is displayed as multiple
lines.
If the option is omitted, it defaults to \fBleft\fR.
.TP
\fB\-stipple \fIbitmap\fR
Indicates that the text should be drawn in a stippled pattern
rather than solid;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default) then the text
is drawn in a solid fashion.
.TP
\fB\-tags \fItagList\fR
.VS
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.VE
.TP
\fB\-text \fIstring\fR
\fIString\fR specifies the characters to be displayed in the text item.
Newline characters cause line breaks.
The characters in the item may also be changed with the
\fBinsert\fR and \fBdelete\fR widget commands.
This option defaults to an empty string.
.TP
\fB\-width \fIlineLength\fR
Specifies a maximum line length for the text, in any of the forms
described in the COORDINATES section abov.
If this option is zero (the default) the text is broken into
lines only at newline characters.
However, if this option is non-zero then any line that would
be longer than \fIlineLength\fR is broken just before a space
character to make the line shorter than \fIlineLength\fR;  the
space character is treated as if it were a newline
character.

.SH "WINDOW ITEMS"
.PP
.VS
Items of type \fBwindow\fR cause a particular window to be displayed
at a given position on the canvas.
Window items are created with widget commands of the following form:
.DS
\fIpathName \fBcreate window \fIx y \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the window on the display (see the \fB\-anchor\fR
option below for more information on how bitmaps are displayed).
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.
The following options are supported for window items:
.TP
\fB\-anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the window relative to the
positioning point for the item;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the window is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the window will be drawn so that
its top center point is at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the height to assign to the item's window.
\fIPixels\fR may have any of the
forms described in the COORDINATES section above.
If this option isn't specified, or if it is specified as an empty
string, then the window is given whatever height it requests internally.
.TP
\fB\-tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB\-width \fIpixels\fR
Specifies the width to assign to the item's window.
\fIPixels\fR may have any of the
forms described in the COORDINATES section above.
If this option isn't specified, or if it is specified as an empty
string, then the window is given whatever width it requests internally.
.TP
\fB\-window \fIpathName\fR
Specifies the window to associate with this item.
The window specified by \fIpathName\fR must either be a child of
the canvas widget or a child of some ancestor of the canvas widget.
\fIPathName\fR may not refer to a top-level window.
.VE

.SH "APPLICATION-DEFINED ITEM TYPES"
.PP
It is possible for individual applications to define new item
types for canvas widgets using C code.
The interfaces for this mechanism are not presently documented,
and it's possible they may change, but you should be able to
see how they work by examining the code for some of the existing
item types.

.SH BINDINGS
.PP
In the current implementation, new canvases are not given any
default behavior:  you'll have to execute explicit Tcl commands
to give the canvas its behavior.

.SH CREDITS
.PP
Tk's canvas widget is a blatant ripoff of ideas from Joel Bartlett's
\fIezd\fR program.  \fIEzd\fR provides structured graphics in a Scheme
environment and preceded canvases by a year or two.  Its simple
mechanisms for placing and animating graphical objects inspired the
functions of canvases.

.SH KEYWORDS
canvas, widget
