/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSGAPP.C $
   $Locker: ska $	$Name:  $	$State: Rel $

   Save/return the application's name

*/

#ifndef _MICROC_
#include <string.h>
#endif /*#	!defined(_MICROC_) */
#include <portable.h>
#include "yerror.h"


#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSGAPP.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */



/*
 * The application's name
 */
#ifdef MAXFILE
	static char XappName[MAXFILE] = "";
#define maxName MAXFILE
#else /*#	!(defined(MAXFILE)) */
	static char XappName[9] = "";
#define maxName 9
#endif /*#	defined(MAXFILE) */

/*
 *	Return the application's name
 */
char *appName(void)
{	return XappName;	}



/*
 *	Save the application's name
 */
void appNameSave(void)
{	char *p;
	int i;

/*	Retrieve the application's name */
	if((p = strrchr(G_ARGV[0], '\\')) == NULL
	  && (p = strrchr(G_ARGV[0], ':')) == NULL)
	  	p = G_ARGV[0] - 1;

	for(i = 0; i < (maxName-1) && *++p != '.' && *p;)
		XappName[i++] = *p;
	XappName[i] = NUL;
}
