/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2INIT.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	void msg2Init(void)

	Initialize the binary message library

	Processed steps:
	+ Retrieving currently active codepage (== charset) and country
		code (== language code) from DOS NLS API
	+ Add the default catalogue to the list of catalogue files

*/

#ifdef MSG_MR_STANDALONE
#include <stdio.h>
#ifndef _MICROC_
#include <process.h>
#endif
#endif
#include <portable.h>
#include "cntry.h"
#include "msg2.h"
#include <msglib.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2INIT.C 1.4 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

void msg2InitX(void)
{	static int recurs = 0;

	if(recurs) return;		/* Never call this function twice */
	recurs = 1;

	/* initialize the current NLS environment */
	msg_CurLngcode = msgCountry()->country;
	msg_CurCharset = msgCountry()->charset;

#ifndef MSG_MULTIPLE_CATALOGUES
	msg_initCatBuf(aS(msg_glbCat));
#endif

}

void msg2Init(void)
{	msg2InitX();
	/* Add the standard catalogues to the file chain */
	msg2StdCats();
}
