/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG0INIT.C $
   $Locker: ska $	$Name:  $	$State: Rel $

   Initialization of the message interpreter.

*/

#include <portable.h>
#include "yerror.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG0INIT.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

/*
 *	Initialize the message interpreter.
 *
 *	It performs the following steps:
 *	1) Disable the VT100 capabilities if no ANSI.SYS has been loaded
 *		its extension);
 */
void msgInitMI(void)
{
/*	Check for ANSI;; very simple, will fail before ANSI v4 */
	if(msgGetAnsiFlag() == ANSI_TEST && !checkANSI())
		msgSetAnsiFlag(ANSI_DENY);
}
