/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: CNTRY.H 1.3 1998/10/07 04:42:53 ska Rel ska $
   $Locker: ska $	$Name:  $	$State: Rel $

	DOS NLS implementation -- "Country" information DOS-65-XX

*/

#ifndef __CNTRY_H
#define __CNTRY_H

#include <portable.h>

/* All information from Ralf Brown's interrupt list v5.6 */
struct Country_ {		/* local copy of country information */
	/* pointers to tables */
	char far *uppercaseTbl;	/* uppercase for "normal" characters */
	char far *lowercaseTbl;	/* lowercase for "normal" chars (maybe NULL) */
	char far *fupcaseTbl;	/* uppercase for filename characters */
	char far *collateTbl;	/* collating table */

	char far *illegalChars;		/* illegal characters in filenames */
	int illegalLen;			/* illegal characters in filenames */

	/* length of the tables
		If length <= 0x80 the table does not contain values for
		the indexs 0..0x7F, but the pointers are adjusted that index 0x80
		really points to the first entry of the table. */
	int uppercaseLen;	/* uppercase for "normal" characters */
	int lowercaseLen;	/* lowercase for "normal" chars (maybe NULL) */
	int fupcaseLen;		/* uppercase for filename characters */
	int collateLen;		/* collating table */

	/* Extended country information */
	word country;		/* currently active DOS country code */
	word charset;		/* currently active DOS codepage */
	word datefmt;		/* format of date: 0/1/2 == USA/Europe/Japan */
	char curSymbol[6];	/* ASCIZ currency symbol */
	char thousendsSep[3];	/* ASCIZ decimal separator */
	char decimalSep[3];	/* ASCIZ decimal separator */
	char dateSep[3];	/* ASCIZ date separator */
	char timeSep[3];	/* ASCIZ time separator */
	char listSep[3];	/* ASCIZ list separator */
	byte curFormat;		/*	bit 0: 0/1 == preceed/follow value
							bit 1: separate cur sym from value by one space
							bit 2: cur sym replaces decimal point */
	byte precision;		/* number of digits after decimal point */
	byte timefmt;		/* bit 0: 0/1 == 12/24 hour clock */

	/* valid filename characters */
	char inclFirst, inclLast;	/* permissible character range */
	char exclFirst, exclLast;	/* excluded character range */

	byte initialized;
};

#ifdef _MICROC_
#define Country struct Country_
#else /*#	!(defined(_MICROC_)) */
typedef struct Country_ Country;
#endif /*#	defined(_MICROC_) */

Country *msgCountry(void);
/*
 *	Return a pointer to a filled copy of above structure
 *
 *	During the life-time of a program the information is retrieved once.
 *
 *	Return: Always != NULL, but maybe ome fields are NULL.
 */

Country *msgNewCountry(void);
/*
 *	As msgcountry(), but causes to reread the information cached by
 *	msgCountry().
 */

#endif /*#	!defined(__CNTRY_H) */
