/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    TMPFILE - Management of temporary files
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: TMPFILE.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Handling of temporary files, based on "fileIO".

	TempFile *tmpFile(int mode)
		Create a temporary file with the given mode (TF_??).

	void clTempFile(TempFile *f)
		Close & remove the temporary file.

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#ifndef __TMPFILE__H_
#define __TMPFILE__H_

struct TempFile_ {
	FILE *fp;
	char *fn;			/* name of that file */
};
#ifdef _MICROC_
#define TempFile struct TempFile_
#else /*#	!(defined(_MICROC_)) */
typedef struct TempFile_ TempFile;
#endif /*#	defined(_MICROC_) */

extern TempFile *tmpFile(int mode);
#define clTempFile(f) clTempFile_(&(f))
extern void clTempFile_(TempFile **f);

#endif /*#	!defined(__TMPFILE__H_) */ 
