/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    TMPFILE - Management of temporary files
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: TMPFILE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Handling of temporary files, based on "fileIO".

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#include <assert.h>
#include <stdio.h>
#ifndef _MICROC_
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#endif /*#	!defined(_MICROC_) */
#include <portable.h>

#include "savemem.h"
#include "fileIO.h"
#include "shStr.h"
#include "tmpFile.h"

#ifdef __TURBOC__
#pragma hdrstop
#endif /*#	defined(__TURBOC__) */

#include "yerror.h"


#ifndef NUL
#define NUL '\0'
#endif /*#	!defined(NUL) */


/* BUF: temporary (dynamical) buffer to generate the name of the
	temporary file */
#ifdef _POSIX_PATH_MAX
#define BUF _POSIX_PATH_MAX
#else /*#	!(defined(_POSIX_PATH_MAX)) */
#ifdef PATH_MAX
#define BUF PATH_MAX
#else /*#	!(defined(PATH_MAX)) */
#define BUF 512
#endif /*#	defined(PATH_MAX) */
#endif /*#	defined(_POSIX_PATH_MAX) */


#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: TMPFILE.C 2.4 1998/10/04 05:17:36 ska Exp ska $";
#endif /*#	defined(RCS_Version) */



/*
 *	Open/create a temporary file
 */
TempFile *tmpFile(int mode)
{	char *buf, *p;
	unsigned cnt;
	TempFile *f;

	if(mode != TF_WR && mode != TF_RW)
		fatal(E_invldTempMode);

	buf = getmem(BUF);
	f = getmem(sizeof(TempFile));

	*buf = '\0';
#ifdef _MICROC_
	(getenv("TEMP", buf) || getenv("TMP", buf)
	 || getenv("TEMPDIR", buf) || getenv("TMPDIR", buf));
#else /*#	!(defined(_MICROC_)) */
	if((p = getenv("TEMP")) != NULL
	 || (p = getenv("TMP")) != NULL
	 || (p = getenv("TEMPDIR")) != NULL
	 || (p = getenv("TMPDIR")) != NULL)
	 	strcpy(buf, p);
#endif /*#	defined(_MICROC_) */
	if(!*buf)
		strcpy(buf, ".");
	p = strchr(buf, '\0');
	if(p[-1] != '\\' && p[-1] != '/')
		*p++ = '\\';
	strcpy(p, "MSG$0000.TMP");
	p += 4;
	cnt = 0;
	while(fileExists(buf)) {
		if(++cnt == 0)
			fatal(E_mkTmpFile);
		sprintf(p, "%04x.TMP", cnt);
	}
	f->fp = Efopen(buf, mode == TF_RW? inM("rwb", "w+b"): "wb");
	f->fn = makeString(buf);
	free(buf);
	return f;
}

/*
 *	Close & remove temorary file
 */
void clTempFile_(TempFile **Xf)
{	TempFile *f;

	assert(Xf);

	if((f = *Xf) != NULL) {
		Efclose(f->fp, f->fn);
		remove(f->fn);
		disposeString(f->fn);
		free(f);
		*Xf = NULL;
	}
}
