/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: NL_TYPES.H 1.3 1998/10/07 04:42:53 ska Rel ska $
   $Locker: ska $	$Name:  $	$State: Rel $

	This holds configuration options for the HP-style cat*() functions

*/

#ifndef __NL_TYPES_H
#define __NL_TYPES_H

#ifndef _MICROC_
typedef void *nl_catd;
#else
#define nl_catd void *
#endif

#define NL_MSGMAX	0xffe	/* Maximum message number; MSGLB's subindex */
#define NL_SETMAX	0x10		/* Maximum set number; MSGLIB's group */
#define NL_TEXTMAX	0x7fff	/* Maximum length of one message text */

/* Possible values for catopen()'s flag parameter */
#define MCLoadBySet 0
#define MCLoadAll 1

nl_catd catopen(char *name, int flag);
/* Opens a new catalogue.
	'flag' is ignored.
	'name' is first tried as an external file.
	_Currently_ the catalogue files are not searched for.

	Return:
		-1: error
		else: catalogue descriptor
*/

void catclose(nl_catd cat);
/* Close the catalogue
*/

char *catgets(nl_catd catalog, int set_number, int message_number
	, char *message);
/* Reads message number 'message_number' of set number 'set_number'
	from the opened catalogue.

	Note: catgets() will return 'message' in every case, the
		message could not be retrieved.

	Return:
		message: If catalogue or message is not available
		else: internal buffer of loaded message
*/

#endif /*#	!defined(__MSGCONF2_H) */
