/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: MSGCONF1.H 1.4 1998/10/07 04:42:53 ska Rel ska $
   $Locker: ska $	$Name:  $	$State: Rel $

	Global message handling definitions.
		- part to initialize access method #1

*/

#ifndef __MSGCONF1_H
#define __MSGCONF1_H

#ifndef MSG_METHOD
	/* Assume the user wants the access method #1 */
#define MSG_METHOD	1
#endif /*#	!defined(MSG_METHOD) */


/*
 *	MSGID is the black-box type to hold the identifier of a message
 */
#ifdef _MICROC_	/* does not support typedef's */
#define MSGID1 unsigned char*
#else /*#	!(defined(_MICROC_)) */
typedef const unsigned char *MSGID1;
#endif /*#	defined(_MICROC_) */


/*
 *	DCL_MSG declares one MeSsaGe IDentifier;
 */
#define DCL_MSG(msg) extern const unsigned char msg[];

/*
 *	Macros mapping the global names into access method #1 conform
 *	names.
 *	Because all access method exist in parallel to each other within the
 *	archive MSGLIB.LIB, the identifiers must differ from each other.
 *
 *	Because all the messages are available in the process's data segment
 *	there is no physical locking mechanism and no catalogue mechanism as well
 *	and no language/character set adjustment
 */
#define MSGID MSGID1

#define msgLock(msg) ((char*)msg)
#define msgRetrieve(msg) ((char*)msg)
#define msgUnlock(msg)
#define msgUnlockString(msg)
	/* this needs the one-byte alignment within the error definition files */
#define msgExitCode(msg) ((msg)[-1]) 

#define MSGFILE MSG1FILE
#define MSGNOFILE MSG1NOFILE
#define msgLanguage(lngcode)
#define msgCharset(cset)
#define msgRereadCats()	(0)
#define msgCatalogue(fnam) (0)
#define msgDatabase(fnam,start,limit) (0)
#define msgIdentCat(fnam,start,limit) (MSGNOFILE)

	/* Even if these would be calculatable in method #1 they have no
		substantial meaning to MSGLIB */
#define msgMatchLngcode(lng) (0)
#define msgValidMagicNumber(mnum) (0)
#define msgMatchCharset(cset) (0)

/* These are simple mapper into the access method #1 name space */
	/* From msgemit.c */
#define msgErrFct msg1ErrFct
#define interactive msg1interactive
#define message msg1message
#define error msg1error
#define fatal msg1fatal
#define warning msg1warning
#define informative msg1informative
#define smessage msg1smessage
#define setNoiseLevel msg1setNoiseLevel
#define getNoiseLevel msg1getNoiseLevel
#define msgInitMV msg1InitMV
	/* From msgprntf.c */
#define msgGetAnsiFlag msg1GetAnsiFlag
#define msgSetAnsiFlag msg1SetAnsiFlag
#define checkAnsi msg1checkAnsi
#define skprintf msg1skprintf
#define fd_sprintf msg1fd_sprintf
#define fd_fprintf msg1fd_fprintf
	/* From msghlpsc.c */
#define hlpScreen msg1hlpScreen
	/* From getopt */
#define getopt msg1getopt
#define getopt1 msg1getopt1
#define getopt2 msg1getopt2
#define getoptG msg1getoptG

int getopt(int argc, char **argv, char *opt, char *argopt);
int getopt1(int argc, char **argv, char *opt, char *argopt);
int getopt2(int argc, char **argv, char *opt, char *argopt, char *specopt);
int getoptG(int argc, char **argv);

/*
 *	For compatibly with the msgIdentCat() function
 */
#define MSG1FILE int
#define MSG1NOFILE (-1)

/*
 *	Functions for the access method #1
 */

#define msg1Init()
/* Initialize the message system for method #1.

	--> nothing
*/

#define msg1Exit()
/* Shutdown the message system for method #1.

	--> nothing
*/

#define msgInit() msgInitMI(); msgInitMV(); msg1Init()
/* Initialize the message system for method #1.
	Call the appropriate initialization functions of the various
	subsystems:
	+ messager interpreter
	+ messager visulator
	+ access method #1
*/

#endif /*#	!defined(__MSGCONF1_H) */
