#include <dos.h>

#define i86r union REGS

int ems_installed(void)
{
   i86r r;

   r.h.ah = 0x40;

   int86( 0x67, &r, &r );

   return( r.h.ah );
}

int ems_page_frame(void)
{
   i86r r;

   r.x.ax = 0x4100;

   int86( 0x67, &r, &r );

   return( r.x.bx );
}


int ems_total_pages(void)
{
   i86r r;

   r.x.ax = 0x4200;

   int86( 0x67, &r, &r );

   return( r.x.dx );
}

int ems_pages_free(void)
{
   i86r r;

   r.x.ax = 0x4200;

   int86( 0x67, &r, &r );

   return( r.x.bx );
}

int ems_alloc( int size )
{
   i86r r;

   r.x.bx = size;

   r.h.ah = 0x43;

   int86( 0x67, &r, &r );

   if( r.h.ah == 0 )
   {
      return( r.x.dx );
   }

   return( 0 );
}

int ems_map_memory( int physical_page, int logical_page, int emm_handle )
{
   i86r r;

   r.x.ax = emm_handle;

   r.h.ah = 0x44;

   r.x.bx = logical_page;

   r.x.dx = physical_page;

   int86( 0x67, &r, &r );

   return( r.h.ah );
}

int ems_free( int emm_handle )
{
   i86r r;

   r.h.ah = 0x45;

   r.x.dx = emm_handle;

   int86( 0x67, &r, &r );

   return( r.h.ah );
}

int ems_save_map( int emm_handle )
{
   i86r r;

   r.h.ah = 0x47;

   r.x.dx = emm_handle;

   int86( 0x67, &r, &r );

   return( r.h.ah );
}

int ems_restore_map( int emm_handle )
{
   i86r r;

   r.h.ah = 0x48;

   r.x.dx = emm_handle;

   int86( 0x67, &r, &r );

   return( r.h.ah );
}