/*      DRAW.C - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <graphics.h>
#include <dapi.h>
#include <mouse.h>

void DrawButton(HBUTTON but)
{
 HideMouse();
 setcolor(0);
 rectangle(but.x,but.y,but.x1,but.y1);
 rectangle(but.x+1,but.y+1,but.x1-1,but.y1-1);
 setfillstyle(1,7);
 bar(but.x+2,but.y+2,but.x1-2,but.y1-2);
 setcolor(15);
 line(but.x+2,but.y+2,but.x1-2,but.y+2);
 line(but.x+2,but.y+2,but.x+2,but.y1-2);
 setcolor(0);
 outtextxy(but.x+4,but.y+4,but.txt);
 ShowMouse();
}

void DrawText(HTXT Text)
{
 outtextxy(Text.x,Text.y,Text.txt);
}

void DrawWindow(HWND win)
{
 HideMouse();
 setfillstyle(1,7);
 bar(win->x,win->y,win->x1,win->y1);
 if(win->active)
  setcolor(1);
 else
  setcolor(7);
 if(win->type==SIZEABLE)
 {
  setcolor(0);
  rectangle(win->x,win->y,win->x1,win->y1);
  rectangle(win->x+3,win->y+3,win->x1-3,win->y1-3);
  setcolor(7);
  rectangle(win->x+1,win->y+1,win->x1-1,win->y1-1);
  rectangle(win->x+2,win->y+2,win->x1-2,win->y1-2);
 }
 else
 {
  setcolor(7);
  line(win->x,win->y,win->x,win->y1-1);
  line(win->x,win->y,win->x1-1,win->y);
  setcolor(0);
  line(win->x1,win->y,win->x1,win->y1);
  line(win->x1,win->y1,win->x,win->y1);
  setcolor(15);
  line(win->x+1,win->y+1,win->x1-2,win->y+1);
  line(win->x+1,win->y+1,win->x+1,win->y1-2);
  setcolor(8);
  line(win->x1-1,win->y+1,win->x1-1,win->y1-1);
  line(win->x+1,win->y1-1,win->x1-1,win->y1-1);
 }
 if(win->active)
  setfillstyle(1,1);
 else
  setfillstyle(1,7);
 bar(win->x+4,win->y+4,win->x1-4,win->y+TXTHIGH+10);
 setcolor(15);
 outtextxy(win->x+7,win->y+7,win->title);
 ShowMouse();
}

void DrawCheck(HCHECK Check)
{
 setcolor(0);
 outtextxy(Check.x,Check.y,"[ ]");
 outtextxy(Check.x+25,Check.y,Check.txt);
}

void DrawRadio(HRADIO Radio)
{
 setcolor(0);
 outtextxy(Radio.x,Radio.y,"( )");
 outtextxy(Radio.x+25,Radio.y,Radio.txt);
}

