#include <io.h>
#include <libgen.h>
#include <dos.h>
#include <string.h>

void writeout( const char *s )
{
    _write( 1, s, strlen( s ) );
}

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

char *basename_util( char *s )
{
    int i = 0;
    char *p = s;

    /* If only slash characters, return one slash */
    while( *p++ ) {
        if( *p != '\\' && *p != '/' && *p != '\0' ) i = 1;
    }
    if( i == 0 ) return( "\\" );

    return( basename( s ) );
}

int main( int argc, char **argv )
{
    char *string, *s;

    if( argc < 1 || argv[ 1 ][ 0 ] == _getswitch() || argv[ 1 ][ 0 ] == '-' ) {
        writeerr( "FreeDOS BASENAME 1.0 - Get filename only of a pathname\n" );
        writeerr( "Syntax: BASENAME <path>\n" );

        return( 1 );
    }

    string = basename_util( argv[ 1 ] );
    s = string + strlen( string ) - 1;

    if( argc > 1 ) while( s > string ) {
        if( strcmpi( s, argv[ 2 ] ) == 0 ) {
            *s = '\0';
            break;
        }
        s--;
    }

    writeout( string );
    writeout( "\n" );

    return( 0 );
}

